/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.ant;

import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.ivy.ant.IvyPostResolveTask;
import org.apache.ivy.core.cache.ResolutionCacheManager;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.core.report.ArtifactDownloadReport;
import org.apache.ivy.core.report.ConfigurationResolveReport;
import org.apache.ivy.core.report.ResolveReport;
import org.apache.ivy.core.resolve.ResolveOptions;
import org.apache.ivy.plugins.report.XmlReportParser;
import org.apache.ivy.util.Message;
import org.apache.tools.ant.BuildException;

public abstract class IvyCacheTask
extends IvyPostResolveTask {
    protected List getArtifactReports() throws BuildException, ParseException, IOException {
        Collection collection = this.getAllArtifactReports();
        ArrayList<ArtifactDownloadReport> arrayList = new ArrayList<ArtifactDownloadReport>();
        for (ArtifactDownloadReport artifactDownloadReport : collection) {
            if (!this.getArtifactFilter().accept(artifactDownloadReport.getArtifact())) continue;
            arrayList.add(artifactDownloadReport);
        }
        return arrayList;
    }

    private Collection getAllArtifactReports() throws ParseException, IOException {
        String[] stringArray = this.splitConfs(this.getConf());
        LinkedHashSet<ArtifactDownloadReport> linkedHashSet = new LinkedHashSet<ArtifactDownloadReport>();
        ResolveReport resolveReport = this.getResolvedReport();
        if (resolveReport != null) {
            Message.debug("using internal report instance to get artifacts list");
            for (int i = 0; i < stringArray.length; ++i) {
                ConfigurationResolveReport configurationResolveReport = resolveReport.getConfigurationReport(stringArray[i]);
                if (configurationResolveReport == null) {
                    throw new BuildException("bad confs provided: " + stringArray[i] + " not found among " + Arrays.asList(resolveReport.getConfigurations()));
                }
                Set set = configurationResolveReport.getModuleRevisionIds();
                for (ModuleRevisionId moduleRevisionId : set) {
                    ArtifactDownloadReport[] artifactDownloadReportArray = configurationResolveReport.getDownloadReports(moduleRevisionId);
                    linkedHashSet.addAll(Arrays.asList(artifactDownloadReportArray));
                }
            }
        } else {
            Message.debug("using stored report to get artifacts list");
            XmlReportParser xmlReportParser = new XmlReportParser();
            ResolutionCacheManager resolutionCacheManager = this.getIvyInstance().getResolutionCacheManager();
            String string = this.getResolveId();
            if (string == null) {
                string = ResolveOptions.getDefaultResolveId(this.getResolvedModuleId());
            }
            for (int i = 0; i < stringArray.length; ++i) {
                File file = resolutionCacheManager.getConfigurationResolveReportInCache(string, stringArray[i]);
                xmlReportParser.parse(file);
                ArtifactDownloadReport[] artifactDownloadReportArray = xmlReportParser.getArtifactReports();
                linkedHashSet.addAll(Arrays.asList(artifactDownloadReportArray));
            }
        }
        return linkedHashSet;
    }
}

