/*
 * Decompiled with CFR 0.152.
 */
package com.typesafe.sbt.osgi;

import aQute.bnd.osgi.Builder;
import aQute.bnd.osgi.Jar;
import com.typesafe.sbt.osgi.OsgiManifestHeaders;
import java.io.File;
import java.io.Serializable;
import java.net.URL;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.util.Properties;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import sbt.internal.util.Attributed;
import sbt.internal.util.Init;
import sbt.internal.util.ManagedLogger;
import sbt.io.RichFile$;
import sbt.package$;
import sbt.std.TaskStreams;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.JavaConversions$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class Osgi$ {
    public static Osgi$ MODULE$;

    static {
        new Osgi$();
    }

    public File bundleTask(OsgiManifestHeaders headers, Map<String, String> additionalHeaders, Seq<Attributed<File>> fullClasspath, File artifactPath, Seq<File> resourceDirectories, Seq<File> embeddedJars, Seq<File> explodedJars, boolean failOnUndecidedPackage, Seq<File> sourceDirectories, TaskStreams<Init.ScopedKey<?>> streams) {
        Jar jar;
        Builder builder = new Builder();
        if (failOnUndecidedPackage) {
            streams.log().info((Function0 & Serializable & scala.Serializable)() -> "Validating all packages are set private or exported for OSGi explicitly...");
            Seq<String> internal = headers.privatePackage();
            Seq<String> exported = headers.exportPackage();
            this.validateAllPackagesDecidedAbout(internal, exported, sourceDirectories);
        }
        builder.setClasspath((File[])((TraversableOnce)fullClasspath.map((Function1 & Serializable & scala.Serializable)x$1 -> (File)x$1.data(), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(File.class)));
        builder.setProperties(this.headersToProperties(headers, additionalHeaders));
        this.includeResourceProperty((Seq<File>)((Seq)resourceDirectories.filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.exists()))), embeddedJars, explodedJars).foreach((Function1 & Serializable & scala.Serializable)dirs -> {
            builder.setProperty("-includeresource", dirs);
            return BoxedUnit.UNIT;
        });
        this.bundleClasspathProperty(embeddedJars).foreach((Function1 & Serializable & scala.Serializable)jars -> {
            builder.setProperty("Bundle-ClassPath", jars);
            return BoxedUnit.UNIT;
        });
        File tmpArtifactPath = package$.MODULE$.file(RichFile$.MODULE$.absolutePath$extension(package$.MODULE$.fileToRichFile(artifactPath)) + ".tmp");
        Osgi$ osgi$ = this;
        synchronized (osgi$) {
            jar = builder.build();
        }
        Jar jar2 = jar;
        ManagedLogger log = streams.log();
        JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(builder.getWarnings()).foreach((Function1 & Serializable & scala.Serializable)s -> {
            log.warn((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"bnd: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{s})));
            return BoxedUnit.UNIT;
        });
        JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(builder.getErrors()).foreach((Function1 & Serializable & scala.Serializable)s -> {
            log.error((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"bnd: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{s})));
            return BoxedUnit.UNIT;
        });
        jar2.write(tmpArtifactPath);
        package$.MODULE$.IO().move(tmpArtifactPath, artifactPath);
        return artifactPath;
    }

    public void validateAllPackagesDecidedAbout(Seq<String> internal, Seq<String> exported, Seq<File> sourceDirectories) {
        scala.collection.immutable.Set allPackages = ((TraversableOnce)sourceDirectories.flatMap((Function1 & Serializable & scala.Serializable)baseFile -> {
            Nil$ nil$;
            if (!baseFile.exists()) {
                nil$ = Nil$.MODULE$;
            } else {
                Set packages = Files.walk(baseFile.toPath(), FileVisitOption.FOLLOW_LINKS).filter(p -> p.toFile().isDirectory()).filter(p -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])p.toFile().listFiles())).exists((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)f.isFile()))).map(p -> {
                    void var2_2;
                    String pack = ((Object)p).toString().replace(baseFile.toString(), "").replaceAll("/", ".");
                    return pack.startsWith(".") ? pack.substring(1) : var2_2;
                }).collect(Collectors.toSet());
                nil$ = (Iterable)JavaConverters$.MODULE$.asScalaSetConverter(packages).asScala();
            }
            return nil$;
        }, Seq$.MODULE$.canBuildFrom())).toSet();
        Seq i = (Seq)internal.map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.replaceAll(".*", ""), Seq$.MODULE$.canBuildFrom());
        Seq e = (Seq)exported.map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.replaceAll(".*", ""), Seq$.MODULE$.canBuildFrom());
        this.validateAllPackagesDecidedAbout$1(i, e, allPackages.toList());
    }

    public String requireCapabilityTask() {
        String version = System.getProperty("java.version");
        return new StringOps(Predef$.MODULE$.augmentString("osgi.ee;filter:=\"(&(osgi.ee=JavaSE)(version=%s))\"")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{version}));
    }

    /*
     * WARNING - void declaration
     */
    public Properties headersToProperties(OsgiManifestHeaders headers, Map<String, String> additionalHeaders) {
        void var3_3;
        Properties properties = new Properties();
        properties.put("Bundle-SymbolicName", headers.bundleSymbolicName());
        properties.put("Bundle-Version", headers.bundleVersion());
        headers.bundleActivator().foreach((Function1 & Serializable & scala.Serializable)x$5 -> properties.put("Bundle-Activator", x$5));
        this.strToStrOpt(headers.bundleDescription()).foreach((Function1 & Serializable & scala.Serializable)x$6 -> properties.put("Bundle-Description", x$6));
        headers.bundleDocURL().foreach((Function1 & Serializable & scala.Serializable)u -> properties.put("Bundle-DocURL", u.toString()));
        headers.bundleLicense().headOption().foreach((Function1 & Serializable & scala.Serializable)l -> properties.put("Bundle-License", new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ";description=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((URL)l._2()).toString(), l._1()}))));
        this.strToStrOpt(headers.bundleName()).foreach((Function1 & Serializable & scala.Serializable)x$7 -> properties.put("Bundle-Name", x$7));
        this.seqToStrOpt(headers.bundleRequiredExecutionEnvironment(), (Function1 & Serializable & scala.Serializable)s -> MODULE$.id((String)s)).foreach((Function1 & Serializable & scala.Serializable)x$8 -> properties.put("Bundle-RequiredExecutionEnvironment", x$8));
        this.strToStrOpt(headers.bundleVendor()).foreach((Function1 & Serializable & scala.Serializable)x$9 -> properties.put("Bundle-Vendor", x$9));
        this.seqToStrOpt(headers.dynamicImportPackage(), (Function1 & Serializable & scala.Serializable)s -> MODULE$.id((String)s)).foreach((Function1 & Serializable & scala.Serializable)x$10 -> properties.put("DynamicImport-Package", x$10));
        this.seqToStrOpt(headers.exportPackage(), (Function1 & Serializable & scala.Serializable)s -> MODULE$.id((String)s)).foreach((Function1 & Serializable & scala.Serializable)x$11 -> properties.put("Export-Package", x$11));
        this.seqToStrOpt(headers.importPackage(), (Function1 & Serializable & scala.Serializable)s -> MODULE$.id((String)s)).foreach((Function1 & Serializable & scala.Serializable)x$12 -> properties.put("Import-Package", x$12));
        headers.fragmentHost().foreach((Function1 & Serializable & scala.Serializable)x$13 -> properties.put("Fragment-Host", x$13));
        this.seqToStrOpt(headers.privatePackage(), (Function1 & Serializable & scala.Serializable)s -> MODULE$.id((String)s)).foreach((Function1 & Serializable & scala.Serializable)x$14 -> properties.put("Private-Package", x$14));
        this.seqToStrOpt(headers.requireBundle(), (Function1 & Serializable & scala.Serializable)s -> MODULE$.id((String)s)).foreach((Function1 & Serializable & scala.Serializable)x$15 -> properties.put("Require-Bundle", x$15));
        this.strToStrOpt(headers.requireCapability()).foreach((Function1 & Serializable & scala.Serializable)x$16 -> properties.put("Require-Capability", x$16));
        additionalHeaders.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String k = (String)tuple2._1();
            String v = (String)tuple2._2();
            Object object = properties.put(k, v);
            return object;
        });
        return var3_3;
    }

    public <A> Option<String> seqToStrOpt(Seq<A> seq, Function1<A, String> f) {
        return seq.isEmpty() ? None$.MODULE$ : new Some((Object)((TraversableOnce)seq.map(f, Seq$.MODULE$.canBuildFrom())).mkString(","));
    }

    public Option<String> strToStrOpt(String s) {
        return Option$.MODULE$.apply((Object)s).filter((Function1 & Serializable & scala.Serializable)x$17 -> BoxesRunTime.boxToBoolean((boolean)Osgi$.$anonfun$strToStrOpt$1(x$17)));
    }

    public Option<String> includeResourceProperty(Seq<File> resourceDirectories, Seq<File> embeddedJars, Seq<File> explodedJars) {
        Seq paths = (Seq)((TraversableLike)((TraversableLike)resourceDirectories.$plus$plus(embeddedJars, Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$18 -> x$18.getAbsolutePath(), Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)explodedJars.map((Function1 & Serializable & scala.Serializable)f -> "@" + f.getAbsolutePath(), Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom());
        return this.seqToStrOpt(paths, (Function1 & Serializable & scala.Serializable)x -> (String)Predef$.MODULE$.identity(x));
    }

    public Option<String> bundleClasspathProperty(Seq<File> embeddedJars) {
        return this.seqToStrOpt(embeddedJars, (Function1 & Serializable & scala.Serializable)x$19 -> x$19.getName()).map((Function1 & Serializable & scala.Serializable)x$20 -> ".," + x$20);
    }

    /*
     * Unable to fully structure code
     */
    public String defaultBundleSymbolicName(String organization, String name) {
        organizationParts = this.parts(organization);
        nameParts = this.parts(name);
        var7_5 = new Tuple2((Object)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])organizationParts)).lastOption(), (Object)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])nameParts)).headOption());
        if (var7_5 == null) ** GOTO lbl-1000
        var8_6 = (Option)var7_5._1();
        var9_7 = (Option)var7_5._2();
        if (!(var8_6 instanceof Some)) ** GOTO lbl-1000
        var10_8 = (Some)var8_6;
        last = (String)var10_8.value();
        if (!(var9_7 instanceof Some)) ** GOTO lbl-1000
        var12_10 = (Some)var9_7;
        head = (String)var12_10.value();
        v0 = last;
        var14_12 = head;
        if (!(v0 != null ? v0.equals(var14_12) == false : var14_12 != null)) {
            var3_13 = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])organizationParts)).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])nameParts)).tail())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        } else lbl-1000:
        // 4 sources

        {
            var3_13 = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])organizationParts)).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])nameParts)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        }
        partsWithoutOverlap = var3_13;
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])partsWithoutOverlap)).mkString(".");
    }

    public String id(String s) {
        return s;
    }

    public String[] parts(String s) {
        return (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])s.split("[.-]"))).filterNot((Function1 & Serializable & scala.Serializable)x$21 -> BoxesRunTime.boxToBoolean((boolean)x$21.isEmpty()));
    }

    public <T> Predicate<T> asPredicate(Function1<T, Object> f) {
        return new Predicate<T>(f){
            private final Function1 f$2;

            public Predicate<T> and(Predicate<? super T> x$1) {
                return Predicate.super.and(x$1);
            }

            public Predicate<T> negate() {
                return Predicate.super.negate();
            }

            public Predicate<T> or(Predicate<? super T> x$1) {
                return Predicate.super.or(x$1);
            }

            public boolean test(T t) {
                return BoxesRunTime.unboxToBoolean((Object)this.f$2.apply(t));
            }
            {
                this.f$2 = f$2;
            }
        };
    }

    public <A, B> Function<A, B> asFunction(Function1<A, B> f) {
        return new Function<A, B>(f){
            private final Function1 f$1;

            public <V> Function<V, B> compose(Function<? super V, ? extends A> x$1) {
                return Function.super.compose(x$1);
            }

            public <V> Function<A, V> andThen(Function<? super B, ? extends V> x$1) {
                return Function.super.andThen(x$1);
            }

            public B apply(A a) {
                return (B)this.f$1.apply(a);
            }
            {
                this.f$1 = f$1;
            }
        };
    }

    private static final boolean startsWith$1(String it, Seq prefixes) {
        return prefixes.exists((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)it.startsWith(x$1)));
    }

    private final void validateAllPackagesDecidedAbout$1(Seq internal, Seq exported, List realPackages) {
        block2: {
            List list;
            block3: {
                String pack;
                while (true) {
                    if (internal.isEmpty() && exported.isEmpty() && realPackages.nonEmpty()) {
                        throw new RuntimeException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Remaining packages are undecided about (private or exported) for OSGi (this is rather dangerous!): ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{realPackages})));
                    }
                    list = realPackages;
                    if (Nil$.MODULE$.equals(list)) break block2;
                    if (!(list instanceof .colon.colon)) break block3;
                    .colon.colon colon2 = (.colon.colon)list;
                    pack = (String)colon2.head();
                    List remainingPackages = colon2.tl$access$1();
                    if (!Osgi$.startsWith$1(pack, internal) && !Osgi$.startsWith$1(pack, exported)) break;
                    realPackages = remainingPackages;
                }
                throw new RuntimeException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unable to determine if [", "] package is meant to be private or exported! "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{pack})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Please define what to do with this package for OSGi explicitly! \\n"})).s((Seq)Nil$.MODULE$) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"  Private packages : ", "\\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{internal})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"  Exported packages: ", "\\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{exported})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"  Offending package: ", "\\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{pack})));
            }
            throw new MatchError((Object)list);
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$strToStrOpt$1(String x$17) {
        return new StringOps(Predef$.MODULE$.augmentString(x$17.trim())).nonEmpty();
    }

    private Osgi$() {
        MODULE$ = this;
    }
}

