/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.subtree;

import java.util.Collections;
import java.util.Set;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.model.filter.ExprNode;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.ldap.model.subtree.BaseSubtreeSpecification;
import org.apache.directory.api.ldap.model.subtree.SubtreeSpecification;

public class SubtreeSpecificationModifier {
    private Dn base = new Dn();
    private Set<Dn> chopBefore = Collections.emptySet();
    private Set<Dn> chopAfter = Collections.emptySet();
    private int minBaseDistance = 0;
    private int maxBaseDistance = -1;
    private ExprNode filter;

    public SubtreeSpecification getSubtreeSpecification() {
        return new BaseSubtreeSpecification(this.base, this.minBaseDistance, this.maxBaseDistance, this.chopAfter, this.chopBefore, this.filter);
    }

    public void setBase(Dn base) {
        this.base = base;
    }

    public void setChopBeforeExclusions(Set<Dn> chopBeforeExclusions) {
        this.chopBefore = chopBeforeExclusions;
    }

    public void setChopAfterExclusions(Set<Dn> chopAfterExclusions) {
        this.chopAfter = chopAfterExclusions;
    }

    public void setMinBaseDistance(int minBaseDistance) {
        if (minBaseDistance < 0) {
            throw new IllegalArgumentException(I18n.err(I18n.ERR_04330, new Object[0]));
        }
        this.minBaseDistance = minBaseDistance;
    }

    public void setMaxBaseDistance(int maxBaseDistance) {
        this.maxBaseDistance = maxBaseDistance < 0 ? -1 : maxBaseDistance;
    }

    public void setRefinement(ExprNode refinement) {
        this.filter = refinement;
    }

    public void setFilter(ExprNode filter) {
        this.filter = filter;
    }
}

