/*
 * Decompiled with CFR 0.152.
 */
package jdiff;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.StringTokenizer;
import jdiff.APIComparator;
import jdiff.APIDiff;
import jdiff.ClassAPI;
import jdiff.ClassDiff;
import jdiff.Comments;
import jdiff.ConstructorAPI;
import jdiff.Diff;
import jdiff.FieldAPI;
import jdiff.HTMLFiles;
import jdiff.HTMLIndexes;
import jdiff.HTMLStatistics;
import jdiff.JDiff;
import jdiff.MemberDiff;
import jdiff.MethodAPI;
import jdiff.PackageAPI;
import jdiff.PackageDiff;
import jdiff.RootDocToXML;
import jdiff.SingleComment;

public class HTMLReportGenerator {
    private Comments existingComments_ = null;
    private Comments newComments_ = null;
    static String reportFileName = "changes";
    static String reportFileExt = ".html";
    static PrintWriter reportFile = null;
    static APIDiff apiDiff = null;
    public static boolean noCommentsOnRemovals = false;
    public static boolean noCommentsOnAdditions = false;
    public static boolean noCommentsOnChanges = false;
    public static boolean reportDocChanges = false;
    public static String newDocPrefix = "../";
    public static String oldDocPrefix = null;
    public static boolean doStats = false;
    public static String outputDir = null;
    public static String docTitle = null;
    public static String windowTitle = null;
    static final String bgcolor = "#FFFFFF";
    private static final boolean trace = false;

    public Comments getNewComments() {
        Collections.sort(this.newComments_.commentsList_);
        return this.newComments_;
    }

    public void generate(APIComparator comp, Comments existingComments) {
        String fullReportFileName = reportFileName;
        if (outputDir != null) {
            fullReportFileName = outputDir + JDiff.DIR_SEP + reportFileName;
        }
        System.out.println("JDiff: generating HTML report into the file '" + fullReportFileName + reportFileExt + "' and the subdirectory '" + fullReportFileName + "'");
        this.existingComments_ = existingComments;
        this.newComments_ = new Comments();
        File opdir = new File(fullReportFileName);
        if (!opdir.mkdir() && !opdir.exists()) {
            System.out.println("Error: could not create the subdirectory '" + fullReportFileName + "'");
            System.exit(3);
        }
        if (!Diff.noDocDiffs) {
            Diff.emitDocDiffs(fullReportFileName);
        }
        String changesSummaryName = fullReportFileName + JDiff.DIR_SEP + reportFileName + "-summary" + reportFileExt;
        apiDiff = comp.apiDiff;
        try {
            FileOutputStream fos = new FileOutputStream(changesSummaryName);
            reportFile = new PrintWriter(fos);
            this.writeStartHTMLHeader();
            String oldAPIName = "Old API";
            if (APIDiff.oldAPIName_ != null) {
                oldAPIName = APIDiff.oldAPIName_;
            }
            String newAPIName = "New API";
            if (APIDiff.newAPIName_ != null) {
                newAPIName = APIDiff.newAPIName_;
            }
            if (windowTitle == null) {
                this.writeHTMLTitle("API Differences between " + oldAPIName + " and " + newAPIName);
            } else {
                this.writeHTMLTitle(windowTitle);
            }
            this.writeStyleSheetRef();
            this.writeText("</HEAD>");
            this.writeText("<BODY>");
            this.writeNavigationBar(reportFileName + "-summary", null, null, null, 0, true, HTMLReportGenerator.apiDiff.packagesRemoved.size() != 0, HTMLReportGenerator.apiDiff.packagesAdded.size() != 0, HTMLReportGenerator.apiDiff.packagesChanged.size() != 0);
            if (docTitle == null) {
                this.writeText("<center>");
                this.writeText("<H1>API Differences</H1>");
                this.writeText("</center>");
                this.writeText("<center>");
                this.writeText("<H2>Between " + oldAPIName + " and " + newAPIName + "</H2>");
                this.writeText("</center>");
            } else {
                this.writeText(docTitle);
            }
            this.writeReport(apiDiff);
            this.writeHTMLFooter();
            reportFile.close();
        }
        catch (IOException e) {
            System.out.println("IO Error while attempting to create " + changesSummaryName);
            System.out.println("Error: " + e.getMessage());
            System.exit(1);
        }
        String tln = fullReportFileName + reportFileExt;
        String tlf = fullReportFileName + JDiff.DIR_SEP + "jdiff_topleftframe" + reportFileExt;
        String allDiffsIndexName = fullReportFileName + JDiff.DIR_SEP + "alldiffs_index";
        String packagesIndexName = fullReportFileName + JDiff.DIR_SEP + "packages_index";
        String classesIndexName = fullReportFileName + JDiff.DIR_SEP + "classes_index";
        String constructorsIndexName = fullReportFileName + JDiff.DIR_SEP + "constructors_index";
        String methodsIndexName = fullReportFileName + JDiff.DIR_SEP + "methods_index";
        String fieldsIndexName = fullReportFileName + JDiff.DIR_SEP + "fields_index";
        HTMLFiles hf = new HTMLFiles(this);
        hf.emitTopLevelFile(tln, apiDiff);
        hf.emitTopLeftFile(tlf);
        hf.emitHelp(fullReportFileName, apiDiff);
        hf.emitStylesheet();
        HTMLIndexes h = new HTMLIndexes(this);
        h.emitAllBottomLeftFiles(packagesIndexName, classesIndexName, constructorsIndexName, methodsIndexName, fieldsIndexName, allDiffsIndexName, apiDiff);
        if (doStats) {
            String sf = fullReportFileName + JDiff.DIR_SEP + "jdiff_statistics" + reportFileExt;
            HTMLStatistics stats = new HTMLStatistics(this);
            stats.emitStatistics(sf, apiDiff);
        }
    }

    public void writeReport(APIDiff apiDiff) {
        String pkgName;
        PackageAPI pkgAPI;
        Iterator iter;
        if (apiDiff.packagesRemoved.size() != 0) {
            this.writeTableStart("Removed Packages", 2);
            iter = apiDiff.packagesRemoved.iterator();
            while (iter.hasNext()) {
                pkgAPI = (PackageAPI)iter.next();
                pkgName = pkgAPI.name_;
                this.writePackageTableEntry(pkgName, 0, pkgAPI.doc_, false);
            }
            this.writeTableEnd();
        }
        if (apiDiff.packagesAdded.size() != 0) {
            this.writeTableStart("Added Packages", 2);
            iter = apiDiff.packagesAdded.iterator();
            while (iter.hasNext()) {
                pkgAPI = (PackageAPI)iter.next();
                pkgName = pkgAPI.name_;
                this.writePackageTableEntry(pkgName, 1, pkgAPI.doc_, false);
            }
            this.writeTableEnd();
        }
        if (apiDiff.packagesChanged.size() != 0) {
            this.writeTableStart("Changed Packages", 3);
            iter = apiDiff.packagesChanged.iterator();
            while (iter.hasNext()) {
                PackageDiff pkgDiff = (PackageDiff)iter.next();
                pkgName = pkgDiff.name_;
                this.writePackageTableEntry(pkgName, 2, null, false);
            }
            this.writeTableEnd();
            this.writeText("<!-- End of API section -->");
            this.writeText("<!-- Start of packages section -->");
            PackageDiff[] pkgDiffs = new PackageDiff[apiDiff.packagesChanged.size()];
            pkgDiffs = apiDiff.packagesChanged.toArray(pkgDiffs);
            int i = 0;
            while (i < pkgDiffs.length) {
                this.reportChangedPackage(pkgDiffs, i);
                ++i;
            }
        }
    }

    public void reportChangedPackage(PackageDiff[] pkgDiffs, int pkgIndex) {
        String className;
        ClassAPI classAPI;
        Iterator iter;
        PackageDiff pkgDiff = pkgDiffs[pkgIndex];
        String pkgName = pkgDiff.name_;
        PrintWriter oldReportFile = null;
        oldReportFile = reportFile;
        String localReportFileName = null;
        try {
            localReportFileName = reportFileName + JDiff.DIR_SEP + "pkg_" + pkgName + reportFileExt;
            if (outputDir != null) {
                localReportFileName = outputDir + JDiff.DIR_SEP + localReportFileName;
            }
            FileOutputStream fos = new FileOutputStream(localReportFileName);
            reportFile = new PrintWriter(fos);
            this.writeStartHTMLHeader();
            this.writeHTMLTitle(pkgName);
            this.writeStyleSheetRef();
            this.writeText("</HEAD>");
            this.writeText("<BODY>");
        }
        catch (IOException e) {
            System.out.println("IO Error while attempting to create " + localReportFileName);
            System.out.println("Error: " + e.getMessage());
            System.exit(1);
        }
        String pkgRef = pkgName;
        pkgRef = pkgRef.replace('.', '/');
        pkgRef = newDocPrefix + pkgRef + "/package-summary";
        String linkedPkgName = "<A HREF=\"" + pkgRef + ".html\" target=\"_top\"><tt>" + pkgName + "</tt></A>";
        String prevPkgRef = null;
        if (pkgIndex != 0) {
            prevPkgRef = "pkg_" + pkgDiffs[pkgIndex - 1].name_ + reportFileExt;
        }
        String nextPkgRef = null;
        if (pkgIndex < pkgDiffs.length - 1) {
            nextPkgRef = "pkg_" + pkgDiffs[pkgIndex + 1].name_ + reportFileExt;
        }
        this.writeSectionHeader("Package " + linkedPkgName, pkgName, prevPkgRef, nextPkgRef, null, 1, pkgDiff.classesRemoved.size() != 0, pkgDiff.classesAdded.size() != 0, pkgDiff.classesChanged.size() != 0);
        if (reportDocChanges && pkgDiff.documentationChange_ != null) {
            String pkgDocRef = pkgName + "/package-summary";
            String oldPkgRef = pkgDocRef = pkgDocRef.replace('.', '/');
            String newPkgRef = pkgDocRef;
            oldPkgRef = oldDocPrefix != null ? oldDocPrefix + oldPkgRef : null;
            newPkgRef = newDocPrefix + newPkgRef;
            pkgDiff.documentationChange_ = oldPkgRef != null ? pkgDiff.documentationChange_ + "<A HREF=\"" + oldPkgRef + ".html#package_description\" target=\"_self\"><tt>old</tt></A> to " : pkgDiff.documentationChange_ + "<tt>old</tt> to ";
            pkgDiff.documentationChange_ = pkgDiff.documentationChange_ + "<A HREF=\"" + newPkgRef + ".html#package_description\" target=\"_self\"><tt>new</tt></A>. ";
            this.writeText(pkgDiff.documentationChange_);
        }
        if (pkgDiff.classesRemoved.size() != 0) {
            boolean hasClasses = false;
            boolean hasInterfaces = false;
            iter = pkgDiff.classesRemoved.iterator();
            while (iter.hasNext()) {
                classAPI = (ClassAPI)iter.next();
                if (classAPI.isInterface_) {
                    hasInterfaces = true;
                    continue;
                }
                hasClasses = true;
            }
            if (hasInterfaces && hasClasses) {
                this.writeTableStart("Removed Classes and Interfaces", 2);
            } else if (!hasInterfaces && hasClasses) {
                this.writeTableStart("Removed Classes", 2);
            } else if (hasInterfaces && !hasClasses) {
                this.writeTableStart("Removed Interfaces", 2);
            }
            iter = pkgDiff.classesRemoved.iterator();
            while (iter.hasNext()) {
                classAPI = (ClassAPI)iter.next();
                className = classAPI.name_;
                this.writeClassTableEntry(pkgName, className, 0, classAPI.isInterface_, classAPI.doc_, false);
            }
            this.writeTableEnd();
        }
        if (pkgDiff.classesAdded.size() != 0) {
            boolean hasClasses = false;
            boolean hasInterfaces = false;
            iter = pkgDiff.classesAdded.iterator();
            while (iter.hasNext()) {
                classAPI = (ClassAPI)iter.next();
                if (classAPI.isInterface_) {
                    hasInterfaces = true;
                    continue;
                }
                hasClasses = true;
            }
            if (hasInterfaces && hasClasses) {
                this.writeTableStart("Added Classes and Interfaces", 2);
            } else if (!hasInterfaces && hasClasses) {
                this.writeTableStart("Added Classes", 2);
            } else if (hasInterfaces && !hasClasses) {
                this.writeTableStart("Added Interfaces", 2);
            }
            iter = pkgDiff.classesAdded.iterator();
            while (iter.hasNext()) {
                classAPI = (ClassAPI)iter.next();
                className = classAPI.name_;
                this.writeClassTableEntry(pkgName, className, 1, classAPI.isInterface_, classAPI.doc_, false);
            }
            this.writeTableEnd();
        }
        if (pkgDiff.classesChanged.size() != 0) {
            ClassDiff classDiff;
            boolean hasClasses = false;
            boolean hasInterfaces = false;
            iter = pkgDiff.classesChanged.iterator();
            while (iter.hasNext()) {
                classDiff = (ClassDiff)iter.next();
                if (classDiff.isInterface_) {
                    hasInterfaces = true;
                    continue;
                }
                hasClasses = true;
            }
            if (hasInterfaces && hasClasses) {
                this.writeTableStart("Changed Classes and Interfaces", 2);
            } else if (!hasInterfaces && hasClasses) {
                this.writeTableStart("Changed Classes", 2);
            } else if (hasInterfaces && !hasClasses) {
                this.writeTableStart("Changed Interfaces", 2);
            }
            iter = pkgDiff.classesChanged.iterator();
            while (iter.hasNext()) {
                classDiff = (ClassDiff)iter.next();
                className = classDiff.name_;
                this.writeClassTableEntry(pkgName, className, 2, classDiff.isInterface_, null, false);
            }
            this.writeTableEnd();
            ClassDiff[] classDiffs = new ClassDiff[pkgDiff.classesChanged.size()];
            classDiffs = pkgDiff.classesChanged.toArray(classDiffs);
            int k = 0;
            while (k < classDiffs.length) {
                this.reportChangedClass(pkgName, classDiffs, k);
                ++k;
            }
        }
        this.writeSectionFooter(pkgName, prevPkgRef, nextPkgRef, null, 1);
        this.writeHTMLFooter();
        reportFile.close();
        reportFile = oldReportFile;
    }

    public void reportChangedClass(String pkgName, ClassDiff[] classDiffs, int classIndex) {
        ClassDiff classDiff = classDiffs[classIndex];
        String className = classDiff.name_;
        PrintWriter oldReportFile = null;
        oldReportFile = reportFile;
        String localReportFileName = null;
        try {
            localReportFileName = reportFileName + JDiff.DIR_SEP + pkgName + "." + className + reportFileExt;
            if (outputDir != null) {
                localReportFileName = outputDir + JDiff.DIR_SEP + localReportFileName;
            }
            FileOutputStream fos = new FileOutputStream(localReportFileName);
            reportFile = new PrintWriter(fos);
            this.writeStartHTMLHeader();
            this.writeHTMLTitle(pkgName + "." + className);
            this.writeStyleSheetRef();
            this.writeText("</HEAD>");
            this.writeText("<BODY>");
        }
        catch (IOException e) {
            System.out.println("IO Error while attempting to create " + localReportFileName);
            System.out.println("Error: " + e.getMessage());
            System.exit(1);
        }
        String classRef = pkgName + "." + className;
        classRef = classRef.replace('.', '/');
        if (className.indexOf(46) != -1) {
            classRef = pkgName + ".";
            classRef = classRef.replace('.', '/');
            classRef = newDocPrefix + classRef + className;
        } else {
            classRef = newDocPrefix + classRef;
        }
        String linkedClassName = "<A HREF=\"" + classRef + ".html\" target=\"_top\"><tt>" + className + "</tt></A>";
        String lcn = pkgName + "." + linkedClassName;
        String prevClassRef = null;
        if (classIndex != 0) {
            prevClassRef = pkgName + "." + classDiffs[classIndex - 1].name_ + reportFileExt;
        }
        String nextClassRef = null;
        if (classIndex < classDiffs.length - 1) {
            nextClassRef = pkgName + "." + classDiffs[classIndex + 1].name_ + reportFileExt;
        }
        lcn = classDiff.isInterface_ ? "Interface " + lcn : "Class " + lcn;
        boolean hasCtors = classDiff.ctorsRemoved.size() != 0 || classDiff.ctorsAdded.size() != 0 || classDiff.ctorsChanged.size() != 0;
        boolean hasMethods = classDiff.methodsRemoved.size() != 0 || classDiff.methodsAdded.size() != 0 || classDiff.methodsChanged.size() != 0;
        boolean hasFields = classDiff.fieldsRemoved.size() != 0 || classDiff.fieldsAdded.size() != 0 || classDiff.fieldsChanged.size() != 0;
        this.writeSectionHeader(lcn, pkgName, prevClassRef, nextClassRef, className, 2, hasCtors, hasMethods, hasFields);
        if (classDiff.inheritanceChange_ != null) {
            this.writeText("<p><font size=\"+1\">" + classDiff.inheritanceChange_ + "</font>");
        }
        if (reportDocChanges && classDiff.documentationChange_ != null) {
            String oldClassRef = null;
            if (oldDocPrefix != null) {
                oldClassRef = pkgName + "." + className;
                oldClassRef = oldClassRef.replace('.', '/');
                if (className.indexOf(46) != -1) {
                    oldClassRef = pkgName + ".";
                    oldClassRef = oldClassRef.replace('.', '/');
                    oldClassRef = oldDocPrefix + oldClassRef + className;
                } else {
                    oldClassRef = oldDocPrefix + oldClassRef;
                }
            }
            classDiff.documentationChange_ = oldDocPrefix != null ? classDiff.documentationChange_ + "<A HREF=\"" + oldClassRef + ".html\" target=\"_self\"><tt>old</tt></A> to " : classDiff.documentationChange_ + "<tt>old</tt> to ";
            classDiff.documentationChange_ = classDiff.documentationChange_ + "<A HREF=\"" + classRef + ".html\" target=\"_self\"><tt>new</tt></A>. ";
            this.writeText(classDiff.documentationChange_);
        }
        if (classDiff.modifiersChange_ != null) {
            this.writeText("<p><font size=\"+1\">" + classDiff.modifiersChange_ + "</font>");
        }
        this.reportAllCtors(pkgName, classDiff);
        this.reportAllMethods(pkgName, classDiff);
        this.reportAllFields(pkgName, classDiff);
        this.writeSectionFooter(pkgName, prevClassRef, nextClassRef, className, 2);
        this.writeHTMLFooter();
        reportFile.close();
        reportFile = oldReportFile;
    }

    public void reportAllCtors(String pkgName, ClassDiff classDiff) {
        String id;
        String ctorType;
        ConstructorAPI ctorAPI;
        Iterator iter;
        String className = classDiff.name_;
        this.writeText("<a NAME=\"constructors\"></a>");
        if (classDiff.ctorsRemoved.size() != 0) {
            this.writeTableStart("Removed Constructors", 2);
            iter = classDiff.ctorsRemoved.iterator();
            while (iter.hasNext()) {
                ctorAPI = (ConstructorAPI)iter.next();
                ctorType = ctorAPI.type_;
                if (ctorType.compareTo("void") == 0) {
                    ctorType = "";
                }
                id = className + "(" + ctorType + ")";
                this.writeCtorTableEntry(pkgName, className, ctorType, 0, ctorAPI.doc_, false);
            }
            this.writeTableEnd();
        }
        if (classDiff.ctorsAdded.size() != 0) {
            this.writeTableStart("Added Constructors", 2);
            iter = classDiff.ctorsAdded.iterator();
            while (iter.hasNext()) {
                ctorAPI = (ConstructorAPI)iter.next();
                ctorType = ctorAPI.type_;
                if (ctorType.compareTo("void") == 0) {
                    ctorType = "";
                }
                id = className + "(" + ctorType + ")";
                this.writeCtorTableEntry(pkgName, className, ctorType, 1, ctorAPI.doc_, false);
            }
            this.writeTableEnd();
        }
        if (classDiff.ctorsChanged.size() != 0) {
            this.writeTableStart("Changed Constructors", 3);
            iter = classDiff.ctorsChanged.iterator();
            while (iter.hasNext()) {
                MemberDiff memberDiff = (MemberDiff)iter.next();
                this.writeCtorChangedTableEntry(pkgName, className, memberDiff);
            }
            this.writeTableEnd();
        }
    }

    public void reportAllMethods(String pkgName, ClassDiff classDiff) {
        String methodName;
        MethodAPI methodAPI;
        Iterator iter;
        this.writeText("<a NAME=\"methods\"></a>");
        String className = classDiff.name_;
        if (classDiff.methodsRemoved.size() != 0) {
            this.writeTableStart("Removed Methods", 2);
            iter = classDiff.methodsRemoved.iterator();
            while (iter.hasNext()) {
                methodAPI = (MethodAPI)iter.next();
                methodName = methodAPI.name_ + "(" + methodAPI.getSignature() + ")";
                this.writeMethodTableEntry(pkgName, className, methodAPI, 0, methodAPI.doc_, false);
            }
            this.writeTableEnd();
        }
        if (classDiff.methodsAdded.size() != 0) {
            this.writeTableStart("Added Methods", 2);
            iter = classDiff.methodsAdded.iterator();
            while (iter.hasNext()) {
                methodAPI = (MethodAPI)iter.next();
                methodName = methodAPI.name_ + "(" + methodAPI.getSignature() + ")";
                this.writeMethodTableEntry(pkgName, className, methodAPI, 1, methodAPI.doc_, false);
            }
            this.writeTableEnd();
        }
        if (classDiff.methodsChanged.size() != 0) {
            this.writeTableStart("Changed Methods", 3);
            iter = classDiff.methodsChanged.iterator();
            while (iter.hasNext()) {
                MemberDiff memberDiff = (MemberDiff)iter.next();
                this.writeMethodChangedTableEntry(pkgName, className, memberDiff);
            }
            this.writeTableEnd();
        }
    }

    public void reportAllFields(String pkgName, ClassDiff classDiff) {
        String fieldName;
        FieldAPI fieldAPI;
        Iterator iter;
        this.writeText("<a NAME=\"fields\"></a>");
        String className = classDiff.name_;
        if (classDiff.fieldsRemoved.size() != 0) {
            this.writeTableStart("Removed Fields", 2);
            iter = classDiff.fieldsRemoved.iterator();
            while (iter.hasNext()) {
                fieldAPI = (FieldAPI)iter.next();
                fieldName = fieldAPI.name_;
                this.writeFieldTableEntry(pkgName, className, fieldAPI, 0, fieldAPI.doc_, false);
            }
            this.writeTableEnd();
        }
        if (classDiff.fieldsAdded.size() != 0) {
            this.writeTableStart("Added Fields", 2);
            iter = classDiff.fieldsAdded.iterator();
            while (iter.hasNext()) {
                fieldAPI = (FieldAPI)iter.next();
                fieldName = fieldAPI.name_;
                this.writeFieldTableEntry(pkgName, className, fieldAPI, 1, fieldAPI.doc_, false);
            }
            this.writeTableEnd();
        }
        if (classDiff.fieldsChanged.size() != 0) {
            this.writeTableStart("Changed Fields", 3);
            iter = classDiff.fieldsChanged.iterator();
            while (iter.hasNext()) {
                MemberDiff memberDiff = (MemberDiff)iter.next();
                this.writeFieldChangedTableEntry(pkgName, className, memberDiff);
            }
            this.writeTableEnd();
        }
    }

    public void writeStartHTMLHeaderWithDate() {
        this.writeStartHTMLHeader(true);
    }

    public void writeStartHTMLHeader() {
        this.writeStartHTMLHeader(false);
    }

    public void writeStartHTMLHeader(boolean addDate) {
        this.writeText("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0 Frameset//EN\"\"" + RootDocToXML.baseURI + "/TR/REC-html40/frameset.dtd\">");
        this.writeText("<HTML>");
        this.writeText("<HEAD>");
        this.writeText("<meta name=\"generator\" content=\"JDiff v1.0.9\">");
        this.writeText("<!-- Generated by the JDiff Javadoc doclet -->");
        this.writeText("<!-- (http://www.jdiff.org) -->");
        if (addDate) {
            this.writeText("<!-- on " + new Date() + " -->");
        }
        this.writeText("<meta name=\"description\" content=\"JDiff is a Javadoc doclet which generates an HTML report of all the packages, classes, constructors, methods, and fields which have been removed, added or changed in any way, including their documentation, when two APIs are compared.\">");
        this.writeText("<meta name=\"keywords\" content=\"diff, jdiff, javadiff, java diff, java difference, API difference, difference between two APIs, API diff, Javadoc, doclet\">");
    }

    public void writeHTMLTitle(String title) {
        this.writeText("<TITLE>");
        this.writeText(title);
        this.writeText("</TITLE>");
    }

    public void writeStyleSheetRef() {
        this.writeStyleSheetRef(false);
    }

    public void writeStyleSheetRef(boolean inSameDir) {
        if (inSameDir) {
            this.writeText("<LINK REL=\"stylesheet\" TYPE=\"text/css\" HREF=\"stylesheet-jdiff.css\" TITLE=\"Style\">");
        } else {
            this.writeText("<LINK REL=\"stylesheet\" TYPE=\"text/css\" HREF=\"../stylesheet-jdiff.css\" TITLE=\"Style\">");
        }
    }

    public void writeHTMLFooter() {
        this.writeText("</BODY>");
        this.writeText("</HTML>");
    }

    public void writeSectionHeader(String title, String packageName, String prevElemLink, String nextElemLink, String className, int level, boolean hasRemovals, boolean hasAdditions, boolean hasChanges) {
        this.writeNavigationBar(packageName, prevElemLink, nextElemLink, className, level, true, hasRemovals, hasAdditions, hasChanges);
        if (level != 0) {
            reportFile.println("<H2>");
            reportFile.println(title);
            reportFile.println("</H2>");
        }
    }

    public void writeSectionFooter(String packageName, String prevElemLink, String nextElemLink, String className, int level) {
        reportFile.println("<HR>");
        this.writeNavigationBar(packageName, prevElemLink, nextElemLink, className, level, false, false, false, false);
    }

    public void writeNavigationBar(String pkgName, String prevElemLink, String nextElemLink, String className, int level, boolean upperNavigationBar, boolean hasRemovals, boolean hasAdditions, boolean hasChanges) {
        boolean atClass;
        reportFile.println("<!-- Start of nav bar -->");
        reportFile.println("<TABLE summary=\"Navigation bar\" BORDER=\"0\" WIDTH=\"100%\" CELLPADDING=\"1\" CELLSPACING=\"0\">");
        reportFile.println("  <TR>");
        reportFile.println("    <TD COLSPAN=2 BGCOLOR=\"#EEEEFF\" CLASS=\"NavBarCell1\">");
        reportFile.println("    <TABLE summary=\"Navigation bar\" BORDER=\"0\" CELLPADDING=\"0\" CELLSPACING=\"3\">");
        reportFile.println("    <TR ALIGN=\"center\" VALIGN=\"top\">");
        boolean atOverview = level == 0;
        boolean atPackage = level == 1;
        boolean bl = atClass = level == 2;
        if (atOverview) {
            reportFile.println("      <TD BGCOLOR=\"#EEEEFF\" CLASS=\"NavBarCell1\"> <A HREF=\"" + newDocPrefix + "index.html\" target=\"_top\"><FONT CLASS=\"NavBarFont1\"><B><tt>" + APIDiff.newAPIName_ + "</tt></B></FONT></A>&nbsp;</TD>");
        } else if (atPackage) {
            String pkgRef = pkgName;
            pkgRef = pkgRef.replace('.', '/');
            pkgRef = newDocPrefix + pkgRef + "/package-summary";
            reportFile.println("      <TD BGCOLOR=\"#EEEEFF\" CLASS=\"NavBarCell1\"> <A HREF=\"" + pkgRef + ".html\" target=\"_top\"><FONT CLASS=\"NavBarFont1\"><B><tt>" + APIDiff.newAPIName_ + "</tt></B></FONT></A>&nbsp;</TD>");
        } else if (atClass) {
            String classRef = pkgName + "." + className;
            classRef = classRef.replace('.', '/');
            if (className.indexOf(46) != -1) {
                classRef = pkgName + ".";
                classRef = classRef.replace('.', '/');
                classRef = newDocPrefix + classRef + className;
            } else {
                classRef = newDocPrefix + classRef;
            }
            reportFile.println("      <TD BGCOLOR=\"#EEEEFF\" CLASS=\"NavBarCell1\"> <A HREF=\"" + classRef + ".html\" target=\"_top\"><FONT CLASS=\"NavBarFont1\"><B><tt>" + APIDiff.newAPIName_ + "</tt></B></FONT></A>&nbsp;</TD>");
        }
        if (atOverview) {
            reportFile.println("      <TD BGCOLOR=\"#EEEEFF\" CLASS=\"NavBarCell1Rev\"> &nbsp;<FONT CLASS=\"NavBarFont1Rev\"><B>Overview</B></FONT>&nbsp;</TD>");
            reportFile.println("      <TD BGCOLOR=\"#EEEEFF\" CLASS=\"NavBarCell1\"> &nbsp;<FONT CLASS=\"NavBarFont1\">Package</FONT>&nbsp;</TD>");
            reportFile.println("      <TD BGCOLOR=\"#FFFFFF\" CLASS=\"NavBarCell1\"> &nbsp;<FONT CLASS=\"NavBarFont1\">Class</FONT>&nbsp;</TD>");
        }
        String changesSummaryName = reportFileName + "-summary" + reportFileExt;
        if (atPackage) {
            reportFile.println("      <TD BGCOLOR=\"#EEEEFF\" CLASS=\"NavBarCell1\"> <A HREF=\"" + changesSummaryName + "\"><FONT CLASS=\"NavBarFont1\"><B>Overview</B></FONT></A>&nbsp;</TD>");
            reportFile.println("      <TD BGCOLOR=\"#EEEEFF\" CLASS=\"NavBarCell1Rev\"> &nbsp;<FONT CLASS=\"NavBarFont1Rev\"><B>Package</B></FONT>&nbsp;</TD>");
            reportFile.println("      <TD BGCOLOR=\"#FFFFFF\" CLASS=\"NavBarCell1\"> &nbsp;<FONT CLASS=\"NavBarFont1\">Class</FONT>&nbsp;</TD>");
        }
        if (atClass) {
            reportFile.println("      <TD BGCOLOR=\"#EEEEFF\" CLASS=\"NavBarCell1\"> <A HREF=\"" + changesSummaryName + "\"><FONT CLASS=\"NavBarFont1\"><B>Overview</B></FONT></A>&nbsp;</TD>");
            reportFile.println("      <TD BGCOLOR=\"#EEEEFF\" CLASS=\"NavBarCell1\"> <A HREF=\"pkg_" + pkgName + reportFileExt + "\"><FONT CLASS=\"NavBarFont1\"><B>Package</B></FONT></A>&nbsp;</TD>");
            reportFile.println("      <TD BGCOLOR=\"#FFFFFF\" CLASS=\"NavBarCell1Rev\"> &nbsp;<FONT CLASS=\"NavBarFont1Rev\"><B>Class</B></FONT>&nbsp;</TD>");
        }
        if (!Diff.noDocDiffs) {
            String id;
            if (atPackage) {
                id = (String)Diff.firstDiffOutput.get(pkgName + "!package");
                if (id != null) {
                    reportFile.println("      <TD BGCOLOR=\"#EEEEFF\" CLASS=\"NavBarCell1\"> <A HREF=\"" + Diff.diffFileName + "index" + reportFileExt + "#" + id + "\"><FONT CLASS=\"NavBarFont1\"><B>Text Changes</B></FONT></A>&nbsp;</TD>");
                } else {
                    reportFile.println("      <TD BGCOLOR=\"#EEEEFF\" CLASS=\"NavBarCell1\"> <FONT CLASS=\"NavBarFont1\">Text Changes</FONT>&nbsp;</TD>");
                }
            } else if (atClass) {
                id = (String)Diff.firstDiffOutput.get(pkgName + "." + className + "!class");
                if (id != null) {
                    reportFile.println("      <TD BGCOLOR=\"#EEEEFF\" CLASS=\"NavBarCell1\"> <A HREF=\"" + Diff.diffFileName + "index" + reportFileExt + "#" + id + "\"><FONT CLASS=\"NavBarFont1\"><B>Text Changes</B></FONT></A>&nbsp;</TD>");
                } else {
                    reportFile.println("      <TD BGCOLOR=\"#EEEEFF\" CLASS=\"NavBarCell1\"> <FONT CLASS=\"NavBarFont1\">Text Changes</FONT>&nbsp;</TD>");
                }
            } else {
                reportFile.println("      <TD BGCOLOR=\"#EEEEFF\" CLASS=\"NavBarCell1\"> <A HREF=\"" + Diff.diffFileName + "index" + reportFileExt + "\"><FONT CLASS=\"NavBarFont1\"><B>Text Changes</B></FONT></A>&nbsp;</TD>");
            }
        }
        if (doStats) {
            reportFile.println("      <TD BGCOLOR=\"#EEEEFF\" CLASS=\"NavBarCell1\"> <A HREF=\"jdiff_statistics" + reportFileExt + "\"><FONT CLASS=\"NavBarFont1\"><B>Statistics</B></FONT></A>&nbsp;</TD>");
        }
        reportFile.println("      <TD BGCOLOR=\"#EEEEFF\" CLASS=\"NavBarCell1\"> <A HREF=\"jdiff_help" + reportFileExt + "\"><FONT CLASS=\"NavBarFont1\"><B>Help</B></FONT></A>&nbsp;</TD>");
        reportFile.println("    </TR>");
        reportFile.println("    </TABLE>");
        reportFile.println("  </TD>");
        if (upperNavigationBar) {
            reportFile.println("  <TD ALIGN=\"right\" VALIGN=\"top\" ROWSPAN=3><EM><b>Generated by<br><a href=\"http://www.jdiff.org\" class=\"staysblack\" target=\"_top\">JDiff</a></b></EM></TD>");
        } else {
            reportFile.println("  <TD ALIGN=\"right\" VALIGN=\"top\" ROWSPAN=3></TD>");
        }
        reportFile.println("</TR>");
        reportFile.println("<TR>");
        reportFile.println("  <TD BGCOLOR=\"#FFFFFF\" CLASS=\"NavBarCell2\"><FONT SIZE=\"-2\">");
        if (atPackage || atClass) {
            String elemName = "CLASS";
            if (className == null) {
                elemName = "PACKAGE";
            }
            if (prevElemLink == null) {
                reportFile.println("&nbsp;<B>PREV " + elemName + "</B>&nbsp;");
            } else {
                reportFile.println("&nbsp;<A HREF=\"" + prevElemLink + "\"><B>PREV " + elemName + "</B></A>");
            }
            if (nextElemLink == null) {
                reportFile.println("&nbsp;<B>NEXT " + elemName + "</B>&nbsp;");
            } else {
                reportFile.println("&nbsp;<A HREF=\"" + nextElemLink + "\"><B>NEXT " + elemName + "</B></A>");
            }
            reportFile.println("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
        } else {
            reportFile.println("  &nbsp;&nbsp;");
        }
        reportFile.println("  <A HREF=\"../" + reportFileName + reportFileExt + "\" TARGET=\"_top\"><B>FRAMES</B></A>  &nbsp;");
        if (className == null) {
            if (level == 0) {
                reportFile.println("  &nbsp;<A HREF=\"" + pkgName + reportFileExt + "\" TARGET=\"_top\"><B>NO FRAMES</B></A></FONT></TD>");
            } else {
                reportFile.println("  &nbsp;<A HREF=\"pkg_" + pkgName + reportFileExt + "\" TARGET=\"_top\"><B>NO FRAMES</B></A></FONT></TD>");
            }
        } else {
            reportFile.println("  &nbsp;<A HREF=\"" + pkgName + "." + className + reportFileExt + "\" TARGET=\"_top\"><B>NO FRAMES</B></A></FONT></TD>");
        }
        if (atClass) {
            boolean hasCtors = hasRemovals;
            boolean hasMethods = hasAdditions;
            boolean hasFields = hasChanges;
            if (hasCtors || hasMethods || hasFields) {
                reportFile.println("  <TD BGCOLOR=\"#FFFFFF\" CLASS=\"NavBarCell3\"><FONT SIZE=\"-2\"> DETAIL: &nbsp;");
                if (hasCtors) {
                    reportFile.println("<a href=\"#constructors\">CONSTRUCTORS</a>&nbsp;|&nbsp;");
                } else {
                    reportFile.println("CONSTRUCTORS&nbsp;|&nbsp;");
                }
                if (hasMethods) {
                    reportFile.println("<a href=\"#methods\">METHODS</a>&nbsp;|&nbsp;");
                } else {
                    reportFile.println("METHODS&nbsp;|&nbsp;");
                }
                if (hasFields) {
                    reportFile.println("<a href=\"#fields\">FIELDS</a>");
                } else {
                    reportFile.println("FIELDS");
                }
                reportFile.println("  </FONT></TD>");
            } else {
                reportFile.println("<TD BGCOLOR=\"0xFFFFFF\" CLASS=\"NavBarCell3\"></TD>");
            }
        } else if (hasRemovals || hasAdditions || hasChanges) {
            reportFile.println("  <TD BGCOLOR=\"#FFFFFF\" CLASS=\"NavBarCell3\"><FONT SIZE=\"-2\"> DETAIL: &nbsp;");
            if (hasRemovals) {
                reportFile.println("<a href=\"#Removed\">REMOVED</a>&nbsp;|&nbsp;");
            } else {
                reportFile.println("REMOVED&nbsp;|&nbsp;");
            }
            if (hasAdditions) {
                reportFile.println("<a href=\"#Added\">ADDED</a>&nbsp;|&nbsp;");
            } else {
                reportFile.println("ADDED&nbsp;|&nbsp;");
            }
            if (hasChanges) {
                reportFile.println("<a href=\"#Changed\">CHANGED</a>");
            } else {
                reportFile.println("CHANGED");
            }
            reportFile.println("  </FONT></TD>");
        } else {
            reportFile.println("<TD BGCOLOR=\"0xFFFFFF\" CLASS=\"NavBarCell3\"></TD>");
        }
        reportFile.println("</TR>");
        reportFile.println("</TABLE>");
        reportFile.println("<HR>");
        reportFile.println("<!-- End of nav bar -->");
    }

    public void writeTableStart(String title, int colSpan) {
        reportFile.println("<p>");
        int idx = title.indexOf(32);
        String namedAnchor = title.substring(0, idx);
        reportFile.println("<a NAME=\"" + namedAnchor + "\"></a>");
        reportFile.println("<TABLE summary=\"" + title + "\" BORDER=\"1\" CELLPADDING=\"3\" CELLSPACING=\"0\" WIDTH=\"100%\">");
        reportFile.println("<TR BGCOLOR=\"#CCCCFF\" CLASS=\"TableHeadingColor\">");
        reportFile.print("  <TD VALIGN=\"TOP\" COLSPAN=" + colSpan + "><FONT SIZE=\"+1\">");
        reportFile.println("<B>" + title + "</B></FONT></TD>");
        reportFile.println("</TR>");
    }

    public String makeTwoRows(String name) {
        if (name.length() < 30) {
            return name;
        }
        int idx = name.indexOf(".", 20);
        if (idx == -1) {
            return name;
        }
        int len = name.length();
        String res = name.substring(0, idx + 1) + "<br>" + name.substring(idx + 1, len);
        return res;
    }

    public void writePackageTableEntry(String pkgName, int linkType, String possibleComment, boolean useOld) {
        if (!useOld) {
            reportFile.println("<TR BGCOLOR=\"#FFFFFF\" CLASS=\"TableRowColor\">");
            reportFile.println("  <TD VALIGN=\"TOP\" WIDTH=\"25%\">");
            reportFile.println("  <A NAME=\"" + pkgName + "\"></A>");
        }
        String shownPkgName = this.makeTwoRows(pkgName);
        if (linkType == 0) {
            if (oldDocPrefix == null) {
                reportFile.print("  " + shownPkgName);
            } else {
                this.writePackageTableEntry(pkgName, 1, possibleComment, true);
            }
        } else if (linkType == 1) {
            String pkgRef = pkgName;
            pkgRef = pkgRef.replace('.', '/');
            pkgRef = useOld ? oldDocPrefix + pkgRef + "/package-summary" : newDocPrefix + pkgRef + "/package-summary";
            reportFile.println("  <nobr><A HREF=\"" + pkgRef + ".html\" target=\"_top\"><tt>" + shownPkgName + "</tt></A></nobr>");
        } else if (linkType == 2) {
            reportFile.println("  <nobr><A HREF=\"pkg_" + pkgName + reportFileExt + "\">" + shownPkgName + "</A></nobr>");
        }
        if (!useOld) {
            reportFile.println("  </TD>");
            this.emitComment(pkgName, possibleComment, linkType);
            reportFile.println("</TR>");
        }
    }

    public void writeClassTableEntry(String pkgName, String className, int linkType, boolean isInterface, String possibleComment, boolean useOld) {
        if (!useOld) {
            reportFile.println("<TR BGCOLOR=\"#FFFFFF\" CLASS=\"TableRowColor\">");
            reportFile.println("  <TD VALIGN=\"TOP\" WIDTH=\"25%\">");
            reportFile.println("  <A NAME=\"" + className + "\"></A>");
        }
        String fqName = pkgName + "." + className;
        String shownClassName = this.makeTwoRows(className);
        if (linkType == 0) {
            if (oldDocPrefix == null) {
                if (isInterface) {
                    reportFile.println("  <I>" + shownClassName + "</I>");
                } else {
                    reportFile.println("  " + shownClassName);
                }
            } else {
                this.writeClassTableEntry(pkgName, className, 1, isInterface, possibleComment, true);
            }
        } else if (linkType == 1) {
            String classRef = fqName;
            if (className.indexOf(46) != -1) {
                classRef = pkgName + ".";
                classRef = classRef.replace('.', '/');
                classRef = useOld ? oldDocPrefix + classRef + className : newDocPrefix + classRef + className;
            } else {
                classRef = classRef.replace('.', '/');
                classRef = useOld ? oldDocPrefix + classRef : newDocPrefix + classRef;
            }
            reportFile.print("  <nobr><A HREF=\"" + classRef + ".html\" target=\"_top\"><tt>");
            if (isInterface) {
                reportFile.print("<I>" + shownClassName + "</I>");
            } else {
                reportFile.print(shownClassName);
            }
            reportFile.println("</tt></A></nobr>");
        } else if (linkType == 2) {
            reportFile.print("  <nobr><A HREF=\"" + fqName + reportFileExt + "\">");
            if (isInterface) {
                reportFile.print("<I>" + shownClassName + "</I>");
            } else {
                reportFile.print(shownClassName);
            }
            reportFile.println("</A></nobr>");
        }
        if (!useOld) {
            reportFile.println("  </TD>");
            this.emitComment(fqName, possibleComment, linkType);
            reportFile.println("</TR>");
        }
    }

    public void writeCtorTableEntry(String pkgName, String className, String type, int linkType, String possibleComment, boolean useOld) {
        String fqName = pkgName + "." + className;
        String shownClassName = this.makeTwoRows(className);
        String lt = "removed";
        if (linkType == 1) {
            lt = "added";
        }
        String commentID = fqName + ".ctor_" + lt + "(" + type + ")";
        if (!useOld) {
            reportFile.println("<TR BGCOLOR=\"#FFFFFF\" CLASS=\"TableRowColor\">");
            reportFile.println("  <TD VALIGN=\"TOP\" WIDTH=\"25%\">");
            reportFile.println("  <A NAME=\"" + commentID + "\"></A>");
        }
        String shortType = HTMLReportGenerator.simpleName(type);
        if (linkType == 0) {
            if (oldDocPrefix == null) {
                reportFile.print("  <nobr>" + shownClassName);
                HTMLReportGenerator.emitTypeWithParens(shortType);
                reportFile.println("</nobr>");
            } else {
                this.writeCtorTableEntry(pkgName, className, type, 1, possibleComment, true);
            }
        } else if (linkType == 1) {
            String memberRef = fqName.replace('.', '/');
            if (className.indexOf(46) != -1) {
                memberRef = pkgName + ".";
                memberRef = memberRef.replace('.', '/');
                memberRef = useOld ? oldDocPrefix + memberRef + className : newDocPrefix + memberRef + className;
            } else {
                memberRef = useOld ? oldDocPrefix + memberRef : newDocPrefix + memberRef;
            }
            reportFile.print("  <nobr><A HREF=\"" + memberRef + ".html#" + className + "(" + type + ")\" target=\"_top\"><tt>" + shownClassName + "</tt></A>");
            HTMLReportGenerator.emitTypeWithParens(shortType);
            reportFile.println("</nobr>");
        }
        if (!useOld) {
            reportFile.println("  </TD>");
            this.emitComment(commentID, possibleComment, linkType);
            reportFile.println("</TR>");
        }
    }

    public void writeCtorChangedTableEntry(String pkgName, String className, MemberDiff memberDiff) {
        String fqName = pkgName + "." + className;
        String newSignature = memberDiff.newType_;
        if (newSignature.compareTo("void") == 0) {
            newSignature = "";
        }
        String commentID = fqName + ".ctor_changed(" + newSignature + ")";
        reportFile.println("<TR BGCOLOR=\"#FFFFFF\" CLASS=\"TableRowColor\">");
        reportFile.println("  <TD VALIGN=\"TOP\" WIDTH=\"25%\">");
        reportFile.println("  <A NAME=\"" + commentID + "\"></A>");
        String memberRef = fqName.replace('.', '/');
        String shownClassName = this.makeTwoRows(className);
        if (className.indexOf(46) != -1) {
            memberRef = pkgName + ".";
            memberRef = memberRef.replace('.', '/');
            memberRef = newDocPrefix + memberRef + className;
        } else {
            memberRef = newDocPrefix + memberRef;
        }
        String newType = memberDiff.newType_;
        if (newType.compareTo("void") == 0) {
            newType = "";
        }
        String shortNewType = HTMLReportGenerator.simpleName(memberDiff.newType_);
        reportFile.print("  <nobr><A HREF=\"" + memberRef + ".html#" + className + "(" + newType + ")\" target=\"_top\"><tt>");
        reportFile.print(shownClassName);
        reportFile.print("</tt></A>");
        HTMLReportGenerator.emitTypeWithParens(shortNewType);
        reportFile.println("  </nobr>");
        reportFile.println("  </TD>");
        if (reportDocChanges && memberDiff.documentationChange_ != null) {
            String oldMemberRef = null;
            String oldType = null;
            if (oldDocPrefix != null) {
                oldMemberRef = pkgName + "." + className;
                oldMemberRef = oldMemberRef.replace('.', '/');
                if (className.indexOf(46) != -1) {
                    oldMemberRef = pkgName + ".";
                    oldMemberRef = oldMemberRef.replace('.', '/');
                    oldMemberRef = oldDocPrefix + oldMemberRef + className;
                } else {
                    oldMemberRef = oldDocPrefix + oldMemberRef;
                }
                oldType = memberDiff.oldType_;
                if (oldType.compareTo("void") == 0) {
                    oldType = "";
                }
            }
            memberDiff.documentationChange_ = oldDocPrefix != null ? memberDiff.documentationChange_ + "<A HREF=\"" + oldMemberRef + ".html#" + className + "(" + oldType + ")\" target=\"_self\"><tt>old</tt></A> to " : memberDiff.documentationChange_ + "<tt>old</tt> to ";
            memberDiff.documentationChange_ = memberDiff.documentationChange_ + "<A HREF=\"" + memberRef + ".html#" + className + "(" + newType + ")\" target=\"_self\"><tt>new</tt></A>.<br>";
        }
        this.emitChanges(memberDiff, 0);
        this.emitComment(commentID, null, 2);
        reportFile.println("</TR>");
    }

    public void writeMethodTableEntry(String pkgName, String className, MethodAPI methodAPI, int linkType, String possibleComment, boolean useOld) {
        String fqName = pkgName + "." + className;
        String signature = methodAPI.getSignature();
        String methodName = methodAPI.name_;
        String lt = "removed";
        if (linkType == 1) {
            lt = "added";
        }
        String commentID = fqName + "." + methodName + "_" + lt + "(" + signature + ")";
        if (!useOld) {
            reportFile.println("<TR BGCOLOR=\"#FFFFFF\" CLASS=\"TableRowColor\">");
            reportFile.println("  <TD VALIGN=\"TOP\" WIDTH=\"25%\">");
            reportFile.println("  <A NAME=\"" + commentID + "\"></A>");
        }
        if (signature.compareTo("void") == 0) {
            signature = "";
        }
        String shortSignature = HTMLReportGenerator.simpleName(signature);
        String returnType = methodAPI.returnType_;
        String shortReturnType = HTMLReportGenerator.simpleName(returnType);
        if (linkType == 0) {
            if (oldDocPrefix == null) {
                reportFile.print("  <nobr>");
                this.emitType(shortReturnType);
                reportFile.print("&nbsp;" + methodName);
                HTMLReportGenerator.emitTypeWithParens(shortSignature);
                reportFile.println("</nobr>");
            } else {
                this.writeMethodTableEntry(pkgName, className, methodAPI, 1, possibleComment, true);
            }
        } else if (linkType == 1) {
            String memberRef = fqName.replace('.', '/');
            if (className.indexOf(46) != -1) {
                memberRef = pkgName + ".";
                memberRef = memberRef.replace('.', '/');
                memberRef = useOld ? oldDocPrefix + memberRef + className : newDocPrefix + memberRef + className;
            } else {
                memberRef = useOld ? oldDocPrefix + memberRef : newDocPrefix + memberRef;
            }
            reportFile.print("  <nobr>");
            this.emitType(shortReturnType);
            reportFile.print("&nbsp;<A HREF=\"" + memberRef + ".html#" + methodName + "(" + signature + ")\" target=\"_top\"><tt>" + methodName + "</tt></A>");
            HTMLReportGenerator.emitTypeWithParens(shortSignature);
            reportFile.println("</nobr>");
        }
        if (!useOld) {
            reportFile.println("  </TD>");
            this.emitComment(commentID, possibleComment, linkType);
            reportFile.println("</TR>");
        }
    }

    public void writeMethodChangedTableEntry(String pkgName, String className, MemberDiff memberDiff) {
        int parentIdx;
        String memberName = memberDiff.name_;
        String fqName = pkgName + "." + className;
        String newSignature = memberDiff.newSignature_;
        String commentID = fqName + "." + memberName + "_changed(" + newSignature + ")";
        reportFile.println("<TR BGCOLOR=\"#FFFFFF\" CLASS=\"TableRowColor\">");
        reportFile.println("  <TD VALIGN=\"TOP\" WIDTH=\"25%\">");
        reportFile.println("  <A NAME=\"" + commentID + "\"></A>");
        String memberRef = fqName.replace('.', '/');
        if (className.indexOf(46) != -1) {
            memberRef = pkgName + ".";
            memberRef = memberRef.replace('.', '/');
            memberRef = newDocPrefix + memberRef + className;
        } else {
            memberRef = newDocPrefix + memberRef;
        }
        if (className.indexOf(46) == -1 && memberDiff.modifiersChange_ != null && memberDiff.modifiersChange_.indexOf("but is now inherited from") != -1) {
            memberRef = memberDiff.inheritedFrom_;
            memberRef = memberRef.replace('.', '/');
            memberRef = newDocPrefix + memberRef;
        }
        String newReturnType = memberDiff.newType_;
        String shortReturnType = HTMLReportGenerator.simpleName(newReturnType);
        String shortSignature = HTMLReportGenerator.simpleName(newSignature);
        reportFile.print("  <nobr>");
        HTMLReportGenerator.emitTypeWithNoParens(shortReturnType);
        reportFile.print("&nbsp;<A HREF=\"" + memberRef + ".html#" + memberName + "(" + newSignature + ")\" target=\"_top\"><tt>");
        reportFile.print(memberName);
        reportFile.print("</tt></A>");
        HTMLReportGenerator.emitTypeWithParens(shortSignature);
        reportFile.println("  </nobr>");
        reportFile.println("  </TD>");
        if (reportDocChanges && memberDiff.documentationChange_ != null) {
            String oldMemberRef = null;
            String oldSignature = null;
            if (oldDocPrefix != null) {
                oldMemberRef = pkgName + "." + className;
                oldMemberRef = oldMemberRef.replace('.', '/');
                if (className.indexOf(46) != -1) {
                    oldMemberRef = pkgName + ".";
                    oldMemberRef = oldMemberRef.replace('.', '/');
                    oldMemberRef = oldDocPrefix + oldMemberRef + className;
                } else {
                    oldMemberRef = oldDocPrefix + oldMemberRef;
                }
                oldSignature = memberDiff.oldSignature_;
            }
            memberDiff.documentationChange_ = oldDocPrefix != null ? memberDiff.documentationChange_ + "<A HREF=\"" + oldMemberRef + ".html#" + memberName + "(" + oldSignature + ")\" target=\"_self\"><tt>old</tt></A> to " : memberDiff.documentationChange_ + "<tt>old</tt> to ";
            memberDiff.documentationChange_ = memberDiff.documentationChange_ + "<A HREF=\"" + memberRef + ".html#" + memberName + "(" + newSignature + ")\" target=\"_self\"><tt>new</tt></A>.<br>";
        }
        this.emitChanges(memberDiff, 1);
        if (memberDiff.modifiersChange_ != null && (parentIdx = memberDiff.modifiersChange_.indexOf("now inherited from")) != -1) {
            commentID = memberDiff.inheritedFrom_ + "." + memberName + "_changed(" + newSignature + ")";
        }
        this.emitComment(commentID, null, 2);
        reportFile.println("</TR>");
    }

    public void writeFieldTableEntry(String pkgName, String className, FieldAPI fieldAPI, int linkType, String possibleComment, boolean useOld) {
        String fieldType;
        String fqName = pkgName + "." + className;
        String fieldName = fieldAPI.name_;
        String commentID = fqName + "." + fieldName;
        if (!useOld) {
            reportFile.println("<TR BGCOLOR=\"#FFFFFF\" CLASS=\"TableRowColor\">");
            reportFile.println("  <TD VALIGN=\"TOP\" WIDTH=\"25%\">");
            reportFile.println("  <A NAME=\"" + commentID + "\"></A>");
        }
        if ((fieldType = fieldAPI.type_).compareTo("void") == 0) {
            fieldType = "";
        }
        String shortFieldType = HTMLReportGenerator.simpleName(fieldType);
        if (linkType == 0) {
            if (oldDocPrefix == null) {
                reportFile.print("  ");
                this.emitType(shortFieldType);
                reportFile.println("&nbsp;" + fieldName);
            } else {
                this.writeFieldTableEntry(pkgName, className, fieldAPI, 1, possibleComment, true);
            }
        } else if (linkType == 1) {
            String memberRef = fqName.replace('.', '/');
            if (className.indexOf(46) != -1) {
                memberRef = pkgName + ".";
                memberRef = memberRef.replace('.', '/');
                memberRef = useOld ? oldDocPrefix + memberRef + className : newDocPrefix + memberRef + className;
            } else {
                memberRef = useOld ? oldDocPrefix + memberRef : newDocPrefix + memberRef;
            }
            reportFile.print("  <nobr>");
            this.emitType(shortFieldType);
            reportFile.println("&nbsp;<A HREF=\"" + memberRef + ".html#" + fieldName + "\" target=\"_top\"><tt>" + fieldName + "</tt></A></nobr>");
        }
        if (!useOld) {
            reportFile.println("  </TD>");
            this.emitComment(commentID, possibleComment, linkType);
            reportFile.println("</TR>");
        }
    }

    public void writeFieldChangedTableEntry(String pkgName, String className, MemberDiff memberDiff) {
        int parentIdx;
        String memberName = memberDiff.name_;
        String fqName = pkgName + "." + className;
        String commentID = fqName + "." + memberName;
        reportFile.println("<TR BGCOLOR=\"#FFFFFF\" CLASS=\"TableRowColor\">");
        reportFile.println("  <TD VALIGN=\"TOP\" WIDTH=\"25%\">");
        reportFile.println("  <A NAME=\"" + commentID + "\"></A>");
        String memberRef = fqName.replace('.', '/');
        if (className.indexOf(46) != -1) {
            memberRef = pkgName + ".";
            memberRef = memberRef.replace('.', '/');
            memberRef = newDocPrefix + memberRef + className;
        } else {
            memberRef = newDocPrefix + memberRef;
        }
        if (className.indexOf(46) == -1 && memberDiff.modifiersChange_ != null && memberDiff.modifiersChange_.indexOf("but is now inherited from") != -1) {
            memberRef = memberDiff.inheritedFrom_;
            memberRef = memberRef.replace('.', '/');
            memberRef = newDocPrefix + memberRef;
        }
        String newType = memberDiff.newType_;
        String shortNewType = HTMLReportGenerator.simpleName(newType);
        reportFile.print("  <nobr>");
        HTMLReportGenerator.emitTypeWithNoParens(shortNewType);
        reportFile.print("&nbsp;<A HREF=\"" + memberRef + ".html#" + memberName + "\" target=\"_top\"><tt>");
        reportFile.print(memberName);
        reportFile.print("</tt></A></nobr>");
        reportFile.println("  </TD>");
        if (reportDocChanges && memberDiff.documentationChange_ != null) {
            String oldMemberRef = null;
            if (oldDocPrefix != null) {
                oldMemberRef = pkgName + "." + className;
                oldMemberRef = oldMemberRef.replace('.', '/');
                if (className.indexOf(46) != -1) {
                    oldMemberRef = pkgName + ".";
                    oldMemberRef = oldMemberRef.replace('.', '/');
                    oldMemberRef = oldDocPrefix + oldMemberRef + className;
                } else {
                    oldMemberRef = oldDocPrefix + oldMemberRef;
                }
            }
            memberDiff.documentationChange_ = oldDocPrefix != null ? memberDiff.documentationChange_ + "<A HREF=\"" + oldMemberRef + ".html#" + memberName + "\" target=\"_self\"><tt>old</tt></A> to " : memberDiff.documentationChange_ + "<tt>old</tt> to ";
            memberDiff.documentationChange_ = memberDiff.documentationChange_ + "<A HREF=\"" + memberRef + ".html#" + memberName + "\" target=\"_self\"><tt>new</tt></A>.<br>";
        }
        this.emitChanges(memberDiff, 2);
        if (memberDiff.modifiersChange_ != null && (parentIdx = memberDiff.modifiersChange_.indexOf("now inherited from")) != -1) {
            commentID = memberDiff.inheritedFrom_ + "." + memberName;
        }
        this.emitComment(commentID, null, 2);
        reportFile.println("</TR>");
    }

    public void emitChanges(MemberDiff memberDiff, int memberType) {
        reportFile.println("  <TD VALIGN=\"TOP\" WIDTH=\"30%\">");
        boolean hasContent = false;
        if (memberDiff.oldType_.compareTo(memberDiff.newType_) != 0) {
            String shortOldType = HTMLReportGenerator.simpleName(memberDiff.oldType_);
            String shortNewType = HTMLReportGenerator.simpleName(memberDiff.newType_);
            if (memberType == 1) {
                reportFile.print("Change in return type from ");
            } else {
                reportFile.print("Change in type from ");
            }
            if (shortOldType.compareTo(shortNewType) == 0) {
                shortOldType = memberDiff.oldType_;
                shortNewType = memberDiff.newType_;
            }
            this.emitType(shortOldType);
            reportFile.print(" to ");
            this.emitType(shortNewType);
            reportFile.println(".<br>");
            hasContent = true;
        }
        if (memberType == 1 && memberDiff.oldSignature_ != null && memberDiff.newSignature_ != null && memberDiff.oldSignature_.compareTo(memberDiff.newSignature_) != 0) {
            String shortNewSignature;
            String shortOldSignature = HTMLReportGenerator.simpleName(memberDiff.oldSignature_);
            if (shortOldSignature.compareTo(shortNewSignature = HTMLReportGenerator.simpleName(memberDiff.newSignature_)) == 0) {
                shortOldSignature = memberDiff.oldSignature_;
                shortNewSignature = memberDiff.newSignature_;
            }
            if (hasContent) {
                reportFile.print(" ");
            }
            reportFile.print("Change in signature from ");
            if (shortOldSignature.compareTo("") == 0) {
                shortOldSignature = "void";
            }
            this.emitType(shortOldSignature);
            reportFile.print(" to ");
            if (shortNewSignature.compareTo("") == 0) {
                shortNewSignature = "void";
            }
            this.emitType(shortNewSignature);
            reportFile.println(".<br>");
            hasContent = true;
        }
        if (memberType != 2 && memberDiff.oldExceptions_ != null && memberDiff.newExceptions_ != null && memberDiff.oldExceptions_.compareTo(memberDiff.newExceptions_) != 0) {
            if (hasContent) {
                reportFile.print(" ");
            }
            int spaceInOld = memberDiff.oldExceptions_.indexOf(" ");
            if (memberDiff.oldExceptions_.compareTo("no exceptions") == 0) {
                spaceInOld = -1;
            }
            int spaceInNew = memberDiff.newExceptions_.indexOf(" ");
            if (memberDiff.newExceptions_.compareTo("no exceptions") == 0) {
                spaceInNew = -1;
            }
            if (spaceInOld == -1 || spaceInNew == -1) {
                reportFile.print("Change in exceptions thrown from ");
                this.emitException(memberDiff.oldExceptions_);
                reportFile.print(" to ");
                this.emitException(memberDiff.newExceptions_);
                reportFile.println(".<br>");
            } else {
                boolean firstChange = true;
                int numRemoved = 0;
                StringTokenizer stOld = new StringTokenizer(memberDiff.oldExceptions_, ", ");
                while (stOld.hasMoreTokens()) {
                    String oldException = stOld.nextToken();
                    if (memberDiff.newExceptions_.startsWith(oldException) || memberDiff.newExceptions_.indexOf(", " + oldException) != -1) continue;
                    if (firstChange) {
                        reportFile.print("Change in exceptions: ");
                        firstChange = false;
                    }
                    if (numRemoved != 0) {
                        reportFile.print(", ");
                    }
                    this.emitException(oldException);
                    ++numRemoved;
                }
                if (numRemoved == 1) {
                    reportFile.print(" was removed.");
                } else if (numRemoved > 1) {
                    reportFile.print(" were removed.");
                }
                int numAdded = 0;
                StringTokenizer stNew = new StringTokenizer(memberDiff.newExceptions_, ", ");
                while (stNew.hasMoreTokens()) {
                    String newException = stNew.nextToken();
                    if (memberDiff.oldExceptions_.startsWith(newException) || memberDiff.oldExceptions_.indexOf(", " + newException) != -1) continue;
                    if (firstChange) {
                        reportFile.print("Change in exceptions: ");
                        firstChange = false;
                    }
                    if (numAdded != 0) {
                        reportFile.println(", ");
                    } else {
                        reportFile.println(" ");
                    }
                    this.emitException(newException);
                    ++numAdded;
                }
                if (numAdded == 1) {
                    reportFile.print(" was added");
                } else if (numAdded > 1) {
                    reportFile.print(" were added");
                } else if (numAdded == 0 && numRemoved == 0 && firstChange) {
                    reportFile.print("Exceptions were reordered");
                }
                reportFile.println(".<br>");
            }
            hasContent = true;
        }
        if (memberDiff.documentationChange_ != null) {
            if (hasContent) {
                reportFile.print(" ");
            }
            reportFile.print(memberDiff.documentationChange_);
            hasContent = true;
        }
        if (memberDiff.modifiersChange_ != null) {
            if (hasContent) {
                reportFile.print(" ");
            }
            reportFile.println(memberDiff.modifiersChange_);
            hasContent = true;
        }
        reportFile.println("  </TD>");
    }

    public void emitException(String ex) {
        if (ex.compareTo("no exceptions") == 0) {
            reportFile.print(ex);
        } else if (ex.indexOf(32) != -1) {
            reportFile.print("(<code>" + ex + "</code>)");
        } else {
            reportFile.print("<code>" + ex + "</code>");
        }
    }

    public void emitType(String type) {
        if (type.compareTo("") == 0) {
            return;
        }
        if (type.indexOf(32) != -1) {
            reportFile.print("(<code>" + type + "</code>)");
        } else {
            reportFile.print("<code>" + type + "</code>");
        }
    }

    public static void emitTypeWithParens(String type) {
        HTMLReportGenerator.emitTypeWithParens(type, true);
    }

    public static void emitTypeWithParens(String type, boolean addBreaks) {
        if (type.compareTo("") == 0) {
            reportFile.print("()");
        } else {
            int idx = type.indexOf(", ");
            if (!addBreaks || idx == -1) {
                reportFile.print("(<code>" + type + "</code>)");
            } else {
                String sepType = null;
                StringTokenizer st = new StringTokenizer(type, ", ");
                while (st.hasMoreTokens()) {
                    String p = st.nextToken();
                    sepType = sepType == null ? p : sepType + ",</nobr> " + p + "<nobr>";
                }
                reportFile.print("(<code>" + sepType + "<nobr></code>)");
            }
        }
    }

    public static void emitTypeWithNoParens(String type) {
        if (type.compareTo("") != 0) {
            reportFile.print("<code>" + type + "</code>");
        }
    }

    public static String simpleName(String fqNames) {
        if (fqNames == null) {
            return null;
        }
        String res = "";
        boolean hasContent = false;
        StringTokenizer st = new StringTokenizer(fqNames, ", ");
        while (st.hasMoreTokens()) {
            String fqName = st.nextToken();
            if (hasContent) {
                res = res + ", ";
            }
            hasContent = true;
            int lastDot = fqName.lastIndexOf(46);
            res = lastDot < 0 ? res + fqName : res + fqName.substring(lastDot + 1);
        }
        return res;
    }

    public void emitComment(String commentID, String possibleComment, int linkType) {
        String comment;
        int fsidx;
        if (noCommentsOnRemovals && linkType == 0) {
            reportFile.println("  <TD>&nbsp;</TD>");
            return;
        }
        if (noCommentsOnAdditions && linkType == 1) {
            reportFile.println("  <TD>&nbsp;</TD>");
            return;
        }
        if (noCommentsOnChanges && linkType == 2) {
            reportFile.println("  <TD>&nbsp;</TD>");
            return;
        }
        if (!noCommentsOnChanges && possibleComment == null) {
            possibleComment = (String)Comments.allPossibleComments.get(commentID);
        }
        if (possibleComment != null && (fsidx = RootDocToXML.endOfFirstSentence(possibleComment, false)) != -1 && fsidx != 0) {
            possibleComment = possibleComment.substring(0, fsidx + 1);
        }
        if ((comment = Comments.getComment(this.existingComments_, commentID)).compareTo("InsertCommentsHere") == 0) {
            if (possibleComment != null && possibleComment.indexOf("InsertOtherCommentsHere") == -1) {
                reportFile.println("  <TD VALIGN=\"TOP\">" + possibleComment + "</TD>");
            } else {
                reportFile.println("  <TD>&nbsp;</TD>");
            }
        } else {
            int idx = comment.indexOf("@first");
            if (idx == -1) {
                reportFile.println("  <TD VALIGN=\"TOP\">" + comment + "</TD>");
            } else {
                reportFile.print("  <TD VALIGN=\"TOP\">" + comment.substring(0, idx));
                if (possibleComment != null && possibleComment.indexOf("InsertOtherCommentsHere") == -1) {
                    reportFile.print(possibleComment);
                }
                reportFile.println(comment.substring(idx + 6) + "</TD>");
            }
        }
        SingleComment newComment = new SingleComment(commentID, comment);
        this.newComments_.addComment(newComment);
    }

    public void writeTableEnd() {
        reportFile.println("</TABLE>");
        reportFile.println("&nbsp;");
    }

    public void writeText() {
        reportFile.println();
    }

    public void writeText(String text) {
        reportFile.println(text);
    }

    public void indent(int indent) {
        int i = 0;
        while (i < indent) {
            reportFile.print("&nbsp;");
            ++i;
        }
    }
}

