/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.coding;

import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.Utils;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FallThroughCheck
extends Check {
    private boolean mCheckLastGroup;
    private String mReliefPattern = "fallthru|falls? ?through";
    private Pattern mRegExp;

    @Override
    public int[] getDefaultTokens() {
        return new int[]{34};
    }

    @Override
    public int[] getRequiredTokens() {
        return this.getDefaultTokens();
    }

    public void setReliefPattern(String aPattern) {
        this.mReliefPattern = aPattern;
    }

    public void setCheckLastCaseGroup(boolean aValue) {
        this.mCheckLastGroup = aValue;
    }

    @Override
    public void init() {
        super.init();
        this.mRegExp = Utils.getPattern(this.mReliefPattern);
    }

    @Override
    public void visitToken(DetailAST aAST) {
        boolean isLastGroup;
        DetailAST nextGroup = aAST.getNextSibling();
        boolean bl = isLastGroup = nextGroup == null || nextGroup.getType() != 34;
        if (isLastGroup && !this.mCheckLastGroup) {
            return;
        }
        DetailAST slist = aAST.findFirstToken(7);
        if (slist != null && !this.isTerminated(slist, true, true) && !this.hasFallTruComment(aAST, nextGroup)) {
            if (!isLastGroup) {
                this.log(nextGroup, "fall.through", new Object[0]);
            } else {
                this.log(aAST, "fall.through.last", new Object[0]);
            }
        }
    }

    private boolean isTerminated(DetailAST aAST, boolean aUseBreak, boolean aUseContinue) {
        switch (aAST.getType()) {
            case 90: 
            case 92: {
                return true;
            }
            case 88: {
                return aUseBreak;
            }
            case 89: {
                return aUseContinue;
            }
            case 7: {
                return this.checkSlist(aAST, aUseBreak, aUseContinue);
            }
            case 85: {
                return this.checkIf(aAST, aUseBreak, aUseContinue);
            }
            case 86: 
            case 87: 
            case 93: {
                return this.checkLoop(aAST);
            }
            case 97: {
                return this.checkTry(aAST, aUseBreak, aUseContinue);
            }
            case 91: {
                return this.checkSwitch(aAST, aUseContinue);
            }
        }
        return false;
    }

    private boolean checkSlist(DetailAST aAST, boolean aUseBreak, boolean aUseContinue) {
        DetailAST lastStmt = aAST.getLastChild();
        if (lastStmt == null) {
            return true;
        }
        if (lastStmt.getType() == 74) {
            lastStmt = lastStmt.getPreviousSibling();
        }
        return lastStmt != null && this.isTerminated(lastStmt, aUseBreak, aUseContinue);
    }

    private boolean checkIf(DetailAST aAST, boolean aUseBreak, boolean aUseContinue) {
        DetailAST thenStmt = aAST.findFirstToken(78).getNextSibling();
        DetailAST elseStmt = thenStmt.getNextSibling();
        boolean isTerminated = this.isTerminated(thenStmt, aUseBreak, aUseContinue);
        if (isTerminated && elseStmt != null) {
            isTerminated = this.isTerminated(elseStmt.getFirstChild(), aUseBreak, aUseContinue);
        }
        return isTerminated;
    }

    private boolean checkLoop(DetailAST aAST) {
        DetailAST loopBody = null;
        if (aAST.getType() == 87) {
            DetailAST lparen = aAST.findFirstToken(179);
            loopBody = lparen.getPreviousSibling();
        } else {
            DetailAST rparen = aAST.findFirstToken(78);
            loopBody = rparen.getNextSibling();
        }
        return this.isTerminated(loopBody, false, false);
    }

    private boolean checkTry(DetailAST aAST, boolean aUseBreak, boolean aUseContinue) {
        DetailAST catchBody;
        DetailAST finalStmt = aAST.getLastChild();
        if (finalStmt.getType() == 99) {
            return this.isTerminated(finalStmt.findFirstToken(7), aUseBreak, aUseContinue);
        }
        boolean isTerminated = this.isTerminated(aAST.getFirstChild(), aUseBreak, aUseContinue);
        for (DetailAST catchStmt = aAST.findFirstToken(98); catchStmt != null && isTerminated; isTerminated &= this.isTerminated(catchBody, aUseBreak, aUseContinue), catchStmt = catchStmt.getNextSibling()) {
            catchBody = catchStmt.findFirstToken(7);
        }
        return isTerminated;
    }

    private boolean checkSwitch(DetailAST aAST, boolean aUseContinue) {
        boolean isTerminated;
        DetailAST caseGroup = aAST.findFirstToken(34);
        boolean bl = isTerminated = caseGroup != null;
        while (isTerminated && caseGroup != null && caseGroup.getType() != 74) {
            DetailAST caseBody = caseGroup.findFirstToken(7);
            isTerminated &= this.isTerminated(caseBody, false, aUseContinue);
            caseGroup = caseGroup.getNextSibling();
        }
        return isTerminated;
    }

    private boolean hasFallTruComment(DetailAST aCurrentCase, DetailAST aNextCase) {
        int startLineNo = aCurrentCase.getLineNo();
        int endLineNo = aNextCase.getLineNo();
        int endColNo = aNextCase.getColumnNo();
        String[] lines = this.getLines();
        String linepart = lines[endLineNo - 1].substring(0, endColNo);
        if (this.commentMatch(this.mRegExp, linepart, endLineNo)) {
            return true;
        }
        for (int i = endLineNo - 2; i > startLineNo - 1; --i) {
            if (lines[i].trim().length() == 0) continue;
            return this.commentMatch(this.mRegExp, lines[i], i + 1);
        }
        return false;
    }

    private boolean commentMatch(Pattern aPattern, String aLine, int aLineNo) {
        Matcher matcher = aPattern.matcher(aLine);
        boolean hit = matcher.find();
        if (hit) {
            int startMatch = matcher.start();
            int endMatch = matcher.end() - 1;
            return this.getFileContents().hasIntersectionWithComment(aLineNo, startMatch, aLineNo, endMatch);
        }
        return false;
    }
}

