/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.indentation;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.checks.indentation.IndentationCheck;
import java.util.Collection;
import java.util.Iterator;
import java.util.NavigableMap;
import java.util.TreeMap;

public class LineWrappingHandler {
    private final IndentationCheck mIndentCheck;
    private DetailAST mFirstNode;
    private DetailAST mLastNode;
    private int mIndentLevel;

    public LineWrappingHandler(IndentationCheck aInstance, DetailAST aFirstNode) {
        this.mIndentCheck = aInstance;
        this.mFirstNode = aFirstNode;
        this.mLastNode = this.findLastNode(this.mFirstNode);
        this.mIndentLevel = this.mIndentCheck.getLineWrappingIndentation();
    }

    public DetailAST findLastNode(DetailAST aFirstNode) {
        return aFirstNode.getLastChild().getPreviousSibling();
    }

    public int getCurrentIndentation() {
        return this.mFirstNode.getColumnNo() + this.mIndentLevel;
    }

    public final DetailAST getFirstNode() {
        return this.mFirstNode;
    }

    public final DetailAST getLastNode() {
        return this.mLastNode;
    }

    public final int getIndentLevel() {
        return this.mIndentLevel;
    }

    public void checkIndentation() {
        NavigableMap<Integer, DetailAST> firstNodesOnLines = this.collectFirstNodes();
        DetailAST firstNode = (DetailAST)((Object)firstNodesOnLines.get(firstNodesOnLines.firstKey()));
        if (firstNode.getType() == 174) {
            this.checkAnnotationIndentation(firstNode, firstNodesOnLines);
        }
        firstNodesOnLines.remove(firstNodesOnLines.firstKey());
        int firstNodeIndent = this.getFirstNodeIndent(firstNode);
        int currentIndent = firstNodeIndent + this.mIndentLevel;
        for (DetailAST node : firstNodesOnLines.values()) {
            int currentType = node.getType();
            if (currentType == 74 || currentType == 78 || currentType == 30) {
                this.logWarningMessage(node, firstNodeIndent);
                continue;
            }
            if (currentType == 85) {
                DetailAST parent = node.getParent();
                if (parent.getType() != 94) continue;
                this.logWarningMessage(parent, currentIndent);
                continue;
            }
            this.logWarningMessage(node, currentIndent);
        }
    }

    private int getFirstNodeIndent(DetailAST aNode) {
        int indentLevel = aNode.getColumnNo();
        if (aNode.getType() == 85 && aNode.getParent().getType() == 94) {
            DetailAST lcurly = aNode.getParent().getPreviousSibling();
            DetailAST rcurly = lcurly.getLastChild();
            indentLevel = lcurly.getType() == 7 && rcurly.getLineNo() == aNode.getLineNo() ? rcurly.getColumnNo() : aNode.getParent().getColumnNo();
        }
        return indentLevel;
    }

    private NavigableMap<Integer, DetailAST> collectFirstNodes() {
        TreeMap<Integer, DetailAST> result = new TreeMap<Integer, DetailAST>();
        result.put(this.mFirstNode.getLineNo(), this.mFirstNode);
        DetailAST curNode = this.mFirstNode.getFirstChild();
        while (curNode != null && curNode != this.mLastNode) {
            if (curNode.getType() == 6) {
                curNode = curNode.getNextSibling();
            }
            if (curNode == null) continue;
            DetailAST firstTokenOnLine = (DetailAST)((Object)result.get(curNode.getLineNo()));
            if (firstTokenOnLine == null || firstTokenOnLine != null && firstTokenOnLine.getColumnNo() >= curNode.getColumnNo()) {
                result.put(curNode.getLineNo(), curNode);
            }
            curNode = this.getNextCurNode(curNode);
        }
        return result;
    }

    private DetailAST getNextCurNode(DetailAST aCurNode) {
        DetailAST nodeToVisit = aCurNode.getFirstChild();
        DetailAST currentNode = aCurNode;
        while (currentNode != null && nodeToVisit == null) {
            nodeToVisit = currentNode.getNextSibling();
            if (nodeToVisit != null) continue;
            currentNode = currentNode.getParent();
        }
        return nodeToVisit;
    }

    private void checkAnnotationIndentation(DetailAST aModifiersNode, NavigableMap<Integer, DetailAST> aFirstNodesOnLines) {
        int currentIndent = aModifiersNode.getColumnNo() + this.mIndentLevel;
        int firstNodeIndent = aModifiersNode.getColumnNo();
        Collection values = aFirstNodesOnLines.values();
        Iterator itr = values.iterator();
        while (itr.hasNext() && aFirstNodesOnLines.size() > 1) {
            DetailAST node = (DetailAST)((Object)itr.next());
            int parentType = node.getParent().getType();
            if (node.getType() == 174) {
                if (!this.isAnnotationAloneOnLine(node.getParent())) continue;
                this.logWarningMessage(node, firstNodeIndent);
                itr.remove();
                continue;
            }
            if (parentType == 5 || this.hasTypeNodeAsParent(node) || parentType == 158 || parentType == 8 || node.getType() == 70) continue;
            this.logWarningMessage(node, currentIndent);
            itr.remove();
        }
    }

    private boolean isAnnotationAloneOnLine(DetailAST aAnnotationNode) {
        DetailAST nextSibling = aAnnotationNode.getNextSibling();
        if (nextSibling == null) {
            DetailAST typeNode = aAnnotationNode.getParent().getNextSibling();
            return aAnnotationNode.getLineNo() != typeNode.getLineNo();
        }
        return nextSibling.getType() == 163 || aAnnotationNode.getLineNo() != nextSibling.getLineNo();
    }

    private boolean hasTypeNodeAsParent(DetailAST aCurrentNode) {
        boolean result = false;
        for (DetailAST typeNode = aCurrentNode; typeNode != null && typeNode.getType() != 7 && typeNode.getType() != 6; typeNode = typeNode.getParent()) {
            if (typeNode.getType() != 13 && typeNode.getType() != 169) continue;
            result = true;
        }
        return result;
    }

    private void logWarningMessage(DetailAST aCurrentNode, int aCurrentIndent) {
        if (aCurrentNode.getColumnNo() < aCurrentIndent) {
            this.mIndentCheck.indentationLog(aCurrentNode.getLineNo(), "indentation.error", aCurrentNode.getText(), aCurrentNode.getColumnNo(), aCurrentIndent);
        }
    }
}

