/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.coding;

import com.google.common.collect.Sets;
import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.ScopeUtils;
import com.puppycrawl.tools.checkstyle.api.Utils;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.beanutils.ConversionException;

public class HiddenFieldCheck
extends Check {
    private FieldFrame mCurrentFrame;
    private Pattern mRegexp;
    private boolean mIgnoreSetter;
    private boolean mIgnoreConstructorParameter;
    private boolean mIgnoreAbstractMethods;

    @Override
    public int[] getDefaultTokens() {
        return new int[]{10, 21, 14, 158, 159};
    }

    @Override
    public int[] getAcceptableTokens() {
        return new int[]{10, 21};
    }

    @Override
    public int[] getRequiredTokens() {
        return new int[]{14, 158, 159};
    }

    @Override
    public void beginTree(DetailAST aRootAST) {
        this.mCurrentFrame = new FieldFrame(null, true);
    }

    @Override
    public void visitToken(DetailAST aAST) {
        if (aAST.getType() == 10 || aAST.getType() == 21) {
            this.processVariable(aAST);
            return;
        }
        DetailAST typeMods = aAST.findFirstToken(5);
        boolean isStaticInnerType = typeMods != null && typeMods.branchContains(65);
        FieldFrame frame = new FieldFrame(this.mCurrentFrame, isStaticInnerType);
        DetailAST objBlock = aAST.findFirstToken(6);
        if (objBlock != null) {
            for (DetailAST child = objBlock.getFirstChild(); child != null; child = child.getNextSibling()) {
                if (child.getType() != 10) continue;
                String name = child.findFirstToken(59).getText();
                DetailAST mods = child.findFirstToken(5);
                if (mods.branchContains(65)) {
                    frame.addStaticField(name);
                    continue;
                }
                frame.addInstanceField(name);
            }
        }
        this.mCurrentFrame = frame;
    }

    @Override
    public void leaveToken(DetailAST aAST) {
        if (aAST.getType() == 14 || aAST.getType() == 158 || aAST.getType() == 159) {
            this.mCurrentFrame = this.mCurrentFrame.getParent();
        }
    }

    private void processVariable(DetailAST aAST) {
        if (ScopeUtils.inInterfaceOrAnnotationBlock(aAST) || !ScopeUtils.isLocalVariableDef(aAST) && aAST.getType() != 21) {
            return;
        }
        DetailAST nameAST = aAST.findFirstToken(59);
        String name = nameAST.getText();
        if (!(!this.mCurrentFrame.containsStaticField(name) && (HiddenFieldCheck.inStatic(aAST) || !this.mCurrentFrame.containsInstanceField(name)) || this.mRegexp != null && this.getRegexp().matcher(name).find() || this.isIgnoredSetterParam(aAST, name) || this.isIgnoredConstructorParam(aAST) || this.isIgnoredParamOfAbstractMethod(aAST))) {
            this.log(nameAST, "hidden.field", name);
        }
    }

    private static boolean inStatic(DetailAST aAST) {
        for (DetailAST parent = aAST.getParent(); parent != null; parent = parent.getParent()) {
            switch (parent.getType()) {
                case 12: {
                    return true;
                }
                case 9: {
                    DetailAST mods = parent.findFirstToken(5);
                    return mods.branchContains(65);
                }
            }
        }
        return false;
    }

    private boolean isIgnoredSetterParam(DetailAST aAST, String aName) {
        if (aAST.getType() != 21 || !this.mIgnoreSetter) {
            return false;
        }
        DetailAST parametersAST = aAST.getParent();
        if (parametersAST.getChildCount() != 1) {
            return false;
        }
        DetailAST methodAST = parametersAST.getParent();
        if (methodAST.getType() != 9) {
            return false;
        }
        DetailAST typeAST = methodAST.findFirstToken(13);
        if (!typeAST.branchContains(50)) {
            return false;
        }
        String methodName = methodAST.findFirstToken(59).getText();
        String expectedName = "set" + HiddenFieldCheck.capitalize(aName);
        return methodName.equals(expectedName);
    }

    private static String capitalize(String aName) {
        if (aName == null || aName.length() == 0) {
            return aName;
        }
        if (aName.length() > 1 && Character.isUpperCase(aName.charAt(1))) {
            return aName;
        }
        return aName.substring(0, 1).toUpperCase() + aName.substring(1);
    }

    private boolean isIgnoredConstructorParam(DetailAST aAST) {
        if (aAST.getType() != 21 || !this.mIgnoreConstructorParameter) {
            return false;
        }
        DetailAST parametersAST = aAST.getParent();
        DetailAST constructorAST = parametersAST.getParent();
        return constructorAST.getType() == 8;
    }

    private boolean isIgnoredParamOfAbstractMethod(DetailAST aAST) {
        if (aAST.getType() != 21 || !this.mIgnoreAbstractMethods) {
            return false;
        }
        DetailAST method = aAST.getParent().getParent();
        if (method.getType() != 9) {
            return false;
        }
        DetailAST mods = method.findFirstToken(5);
        return mods != null && mods.branchContains(41);
    }

    public void setIgnoreFormat(String aFormat) throws ConversionException {
        try {
            this.mRegexp = Utils.getPattern(aFormat);
        }
        catch (PatternSyntaxException e) {
            throw new ConversionException("unable to parse " + aFormat, (Throwable)e);
        }
    }

    public void setIgnoreSetter(boolean aIgnoreSetter) {
        this.mIgnoreSetter = aIgnoreSetter;
    }

    public void setIgnoreConstructorParameter(boolean aIgnoreConstructorParameter) {
        this.mIgnoreConstructorParameter = aIgnoreConstructorParameter;
    }

    public void setIgnoreAbstractMethods(boolean aIgnoreAbstractMethods) {
        this.mIgnoreAbstractMethods = aIgnoreAbstractMethods;
    }

    public Pattern getRegexp() {
        return this.mRegexp;
    }

    private static class FieldFrame {
        private final boolean mStaticType;
        private final FieldFrame mParent;
        private final Set<String> mInstanceFields = Sets.newHashSet();
        private final Set<String> mStaticFields = Sets.newHashSet();

        public FieldFrame(FieldFrame aParent, boolean aStaticType) {
            this.mParent = aParent;
            this.mStaticType = aStaticType;
        }

        boolean isStaticType() {
            return this.mStaticType;
        }

        public void addInstanceField(String aField) {
            this.mInstanceFields.add(aField);
        }

        public void addStaticField(String aField) {
            this.mStaticFields.add(aField);
        }

        public boolean containsInstanceField(String aField) {
            return this.mInstanceFields.contains(aField) || !this.isStaticType() && this.mParent != null && this.mParent.containsInstanceField(aField);
        }

        public boolean containsStaticField(String aField) {
            return this.mStaticFields.contains(aField) || this.mParent != null && this.mParent.containsStaticField(aField);
        }

        public FieldFrame getParent() {
            return this.mParent;
        }
    }
}

