/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.extras.extended.ads_impl.pwdModify;

import java.nio.ByteBuffer;
import org.apache.directory.api.asn1.AbstractAsn1Object;
import org.apache.directory.api.asn1.EncoderException;
import org.apache.directory.api.asn1.ber.tlv.BerValue;
import org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.directory.api.asn1.ber.tlv.UniversalTag;
import org.apache.directory.api.ldap.extras.extended.PwdModifyResponse;

public class PasswordModifyResponse
extends AbstractAsn1Object {
    private PwdModifyResponse pwdModifyResponse;
    private int requestLength = 0;

    public PasswordModifyResponse(PwdModifyResponse pwdModifyResponse) {
        this.pwdModifyResponse = pwdModifyResponse;
    }

    @Override
    public int computeLength() {
        this.requestLength = 0;
        if (this.pwdModifyResponse.getGenPassword() != null) {
            int len = this.pwdModifyResponse.getGenPassword().length;
            this.requestLength = 1 + BerValue.getNbBytes(len) + len;
        }
        return 1 + BerValue.getNbBytes(this.requestLength) + this.requestLength;
    }

    public ByteBuffer encode() throws EncoderException {
        ByteBuffer bb = ByteBuffer.allocate(this.computeLength());
        bb.put(UniversalTag.SEQUENCE.getValue());
        bb.put(BerValue.getBytes(this.requestLength));
        if (this.pwdModifyResponse.getGenPassword() != null) {
            byte[] userIdentity = this.pwdModifyResponse.getGenPassword();
            bb.put((byte)-128);
            bb.put(TLV.getBytes(userIdentity.length));
            bb.put(userIdentity);
        }
        return bb;
    }

    public PwdModifyResponse getPwdModifyResponse() {
        return this.pwdModifyResponse;
    }

    public String toString() {
        return this.pwdModifyResponse.toString();
    }
}

