/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.schemaloader;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.ldif.LdifEntry;
import org.apache.directory.api.ldap.model.ldif.LdifReader;
import org.apache.directory.api.ldap.model.schema.registries.AbstractSchemaLoader;
import org.apache.directory.api.ldap.model.schema.registries.Schema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SingleLdifSchemaLoader
extends AbstractSchemaLoader {
    private static final Pattern SCHEMA_START_PATTERN = Pattern.compile("cn\\s*=\\s*[a-z0-9-_]*\\s*,\\s*ou\\s*=\\s*schema");
    private static final Logger LOG = LoggerFactory.getLogger(SingleLdifSchemaLoader.class);
    private String[] schemaObjectTypeRdns = new String[]{"attributetypes", "comparators", "ditContentRules", "ditStructureRules", "matchingRules", "matchingRuleUse", "nameForms", "normalizers", "objectClasses", "syntaxes", "syntaxCheckers"};
    private Map<String, Map<String, List<Entry>>> scObjEntryMap = new HashMap<String, Map<String, List<Entry>>>();

    public SingleLdifSchemaLoader() {
        try {
            URL resource = this.getClass().getClassLoader().getResource("schema-all.ldif");
            LOG.debug("URL of the all schema ldif file {}", (Object)resource);
            for (String s : this.schemaObjectTypeRdns) {
                this.scObjEntryMap.put(s, new HashMap());
            }
            InputStream in = resource.openStream();
            this.initializeSchemas(in);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void initializeSchemas(InputStream in) throws Exception {
        LdifReader ldifReader = new LdifReader(in);
        Schema currentSchema = null;
        while (ldifReader.hasNext()) {
            LdifEntry ldifEntry = ldifReader.next();
            String dn = ldifEntry.getDn().getName();
            if (SCHEMA_START_PATTERN.matcher(dn).matches()) {
                Schema schema = this.getSchema(ldifEntry.getEntry());
                this.schemaMap.put(schema.getSchemaName(), schema);
                currentSchema = schema;
                continue;
            }
            this.loadSchemaObject(currentSchema.getSchemaName(), ldifEntry);
        }
        ldifReader.close();
    }

    private void loadSchemaObject(String schemaName, LdifEntry ldifEntry) throws Exception {
        for (String scObjTypeRdn : this.schemaObjectTypeRdns) {
            String dn;
            Pattern regex = Pattern.compile("m-oid\\s*=\\s*[0-9\\.]*\\s*,\\s*ou\\s*=\\s*" + scObjTypeRdn + "\\s*,\\s*cn\\s*=\\s*" + schemaName + "\\s*,\\s*ou=schema\\s*", 2);
            if (!regex.matcher(dn = ldifEntry.getDn().getName()).matches()) continue;
            Map<String, List<Entry>> m = this.scObjEntryMap.get(scObjTypeRdn);
            List<Entry> entryList = m.get(schemaName);
            if (entryList == null) {
                entryList = new ArrayList<Entry>();
                entryList.add(ldifEntry.getEntry());
                m.put(schemaName, entryList);
                break;
            }
            entryList.add(ldifEntry.getEntry());
            break;
        }
    }

    private List<Entry> loadSchemaObjects(String schemaObjectType, Schema ... schemas) throws LdapException, IOException {
        Map<String, List<Entry>> m = this.scObjEntryMap.get(schemaObjectType);
        ArrayList<Entry> atList = new ArrayList<Entry>();
        for (Schema s : schemas) {
            List<Entry> preLoaded = m.get(s.getSchemaName());
            if (preLoaded == null) continue;
            atList.addAll(preLoaded);
        }
        return atList;
    }

    @Override
    public List<Entry> loadAttributeTypes(Schema ... schemas) throws LdapException, IOException {
        return this.loadSchemaObjects("attributetypes", schemas);
    }

    @Override
    public List<Entry> loadComparators(Schema ... schemas) throws LdapException, IOException {
        return this.loadSchemaObjects("comparators", schemas);
    }

    @Override
    public List<Entry> loadDitContentRules(Schema ... schemas) throws LdapException, IOException {
        return this.loadSchemaObjects("ditContentRules", schemas);
    }

    @Override
    public List<Entry> loadDitStructureRules(Schema ... schemas) throws LdapException, IOException {
        return this.loadSchemaObjects("ditStructureRules", schemas);
    }

    @Override
    public List<Entry> loadMatchingRules(Schema ... schemas) throws LdapException, IOException {
        return this.loadSchemaObjects("matchingRules", schemas);
    }

    @Override
    public List<Entry> loadMatchingRuleUses(Schema ... schemas) throws LdapException, IOException {
        return this.loadSchemaObjects("matchingRuleUse", schemas);
    }

    @Override
    public List<Entry> loadNameForms(Schema ... schemas) throws LdapException, IOException {
        return this.loadSchemaObjects("nameForms", schemas);
    }

    @Override
    public List<Entry> loadNormalizers(Schema ... schemas) throws LdapException, IOException {
        return this.loadSchemaObjects("normalizers", schemas);
    }

    @Override
    public List<Entry> loadObjectClasses(Schema ... schemas) throws LdapException, IOException {
        return this.loadSchemaObjects("objectClasses", schemas);
    }

    @Override
    public List<Entry> loadSyntaxes(Schema ... schemas) throws LdapException, IOException {
        return this.loadSchemaObjects("syntaxes", schemas);
    }

    @Override
    public List<Entry> loadSyntaxCheckers(Schema ... schemas) throws LdapException, IOException {
        return this.loadSchemaObjects("syntaxCheckers", schemas);
    }
}

