/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.io.IOException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import org.eclipse.jetty.io.ByteArrayBuffer;
import org.eclipse.jetty.io.ByteArrayEndPoint;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.UpgradeConnectionException;
import org.eclipse.jetty.server.AbstractConnector;
import org.eclipse.jetty.server.HttpConnection;
import org.eclipse.jetty.util.log.Log;

public class LocalConnector
extends AbstractConnector {
    private final BlockingQueue<Request> requests = new LinkedBlockingQueue<Request>();

    public Object getConnection() {
        return this;
    }

    @Deprecated
    public void reopen() {
    }

    public String getResponses(String requests) throws Exception {
        return this.getResponses(requests, false);
    }

    public String getResponses(String requests, boolean keepOpen) throws Exception {
        ByteArrayBuffer result = this.getResponses(new ByteArrayBuffer(requests, "ISO-8859-1"), keepOpen);
        return result.toString("ISO-8859-1");
    }

    public ByteArrayBuffer getResponses(ByteArrayBuffer requestsBuffer, boolean keepOpen) throws Exception {
        CountDownLatch latch = new CountDownLatch(1);
        Request request = new Request(requestsBuffer, keepOpen, latch);
        this.requests.add(request);
        latch.await();
        return request.getResponsesBuffer();
    }

    protected void accept(int acceptorID) throws IOException, InterruptedException {
        Request request = this.requests.take();
        this.getThreadPool().dispatch((Runnable)request);
    }

    public void open() throws IOException {
    }

    public void close() throws IOException {
    }

    public int getLocalPort() {
        return -1;
    }

    public void executeRequest(String rawRequest) throws IOException {
        Request request = new Request(new ByteArrayBuffer(rawRequest, "UTF-8"), true, null);
        this.requests.add(request);
    }

    private class Request
    implements Runnable {
        private final ByteArrayBuffer requestsBuffer;
        private final boolean keepOpen;
        private final CountDownLatch latch;
        private volatile ByteArrayBuffer responsesBuffer;

        private Request(ByteArrayBuffer requestsBuffer, boolean keepOpen, CountDownLatch latch) {
            this.requestsBuffer = requestsBuffer;
            this.keepOpen = keepOpen;
            this.latch = latch;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            ByteArrayEndPoint endPoint = new ByteArrayEndPoint(this.requestsBuffer.asArray(), 1024){

                public void setConnection(Connection connection) {
                    LocalConnector.this.connectionUpgraded(this.getConnection(), connection);
                    super.setConnection(connection);
                }
            };
            endPoint.setGrowOutput(true);
            HttpConnection connection = new HttpConnection(LocalConnector.this, (EndPoint)endPoint, LocalConnector.this.getServer());
            endPoint.setConnection((Connection)connection);
            LocalConnector.this.connectionOpened(connection);
            boolean leaveOpen = this.keepOpen;
            try {
                block7: while (endPoint.getIn().length() > 0) {
                    while (true) {
                        try {
                            endPoint.getConnection().handle();
                            continue block7;
                        }
                        catch (UpgradeConnectionException e) {
                            Log.debug((String)e.toString());
                            Log.ignore((Throwable)e);
                            endPoint.setConnection(e.getConnection());
                            continue;
                        }
                        break;
                    }
                }
            }
            catch (Exception x) {
                leaveOpen = false;
            }
            finally {
                if (!leaveOpen) {
                    LocalConnector.this.connectionClosed(connection);
                }
                this.responsesBuffer = endPoint.getOut();
                if (this.latch != null) {
                    this.latch.countDown();
                }
            }
        }

        public ByteArrayBuffer getResponsesBuffer() {
            return this.responsesBuffer;
        }
    }
}

