/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.hat.internal.model;

import com.sun.tools.hat.internal.model.AbstractJavaHeapObjectVisitor;
import com.sun.tools.hat.internal.model.HackJavaValue;
import com.sun.tools.hat.internal.model.JavaClass;
import com.sun.tools.hat.internal.model.JavaField;
import com.sun.tools.hat.internal.model.JavaHeapObject;
import com.sun.tools.hat.internal.model.JavaObject;
import com.sun.tools.hat.internal.model.JavaStatic;
import com.sun.tools.hat.internal.model.JavaThing;
import com.sun.tools.hat.internal.model.ReachableExcludes;
import com.sun.tools.hat.internal.model.ReferenceChain;
import com.sun.tools.hat.internal.model.Root;
import com.sun.tools.hat.internal.model.StackTrace;
import com.sun.tools.hat.internal.parser.ReadBuffer;
import com.sun.tools.hat.internal.util.Misc;
import java.lang.ref.SoftReference;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Snapshot {
    public static long SMALL_ID_MASK = 0xFFFFFFFFL;
    public static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    private static final JavaField[] EMPTY_FIELD_ARRAY = new JavaField[0];
    private static final JavaStatic[] EMPTY_STATIC_ARRAY = new JavaStatic[0];
    private Hashtable<Number, JavaHeapObject> heapObjects = new Hashtable();
    private Hashtable<Number, JavaClass> fakeClasses = new Hashtable();
    private Vector<Root> roots = new Vector();
    private Map<String, JavaClass> classes = new TreeMap<String, JavaClass>();
    private volatile Map<JavaHeapObject, Boolean> newObjects;
    private volatile Map<JavaHeapObject, StackTrace> siteTraces;
    private Map<JavaHeapObject, Root> rootsMap = new HashMap<JavaHeapObject, Root>();
    private SoftReference<Vector> finalizablesCache;
    private JavaThing nullThing = new HackJavaValue("<null>", 0);
    private JavaClass weakReferenceClass;
    private int referentFieldIndex;
    private JavaClass javaLangClass;
    private JavaClass javaLangString;
    private JavaClass javaLangClassLoader;
    private volatile JavaClass otherArrayType;
    private ReachableExcludes reachableExcludes;
    private ReadBuffer readBuf;
    private boolean hasNewSet;
    private boolean unresolvedObjectsOK;
    private boolean newStyleArrayClass;
    private int identifierSize = 4;
    private int minimumObjectSize;
    private static final int DOT_LIMIT = 5000;

    public Snapshot(ReadBuffer readBuffer) {
        this.readBuf = readBuffer;
    }

    public void setSiteTrace(JavaHeapObject javaHeapObject, StackTrace stackTrace) {
        if (stackTrace != null && stackTrace.getFrames().length != 0) {
            this.initSiteTraces();
            this.siteTraces.put(javaHeapObject, stackTrace);
        }
    }

    public StackTrace getSiteTrace(JavaHeapObject javaHeapObject) {
        if (this.siteTraces != null) {
            return this.siteTraces.get(javaHeapObject);
        }
        return null;
    }

    public void setNewStyleArrayClass(boolean bl) {
        this.newStyleArrayClass = bl;
    }

    public boolean isNewStyleArrayClass() {
        return this.newStyleArrayClass;
    }

    public void setIdentifierSize(int n) {
        this.identifierSize = n;
        this.minimumObjectSize = 2 * n;
    }

    public int getIdentifierSize() {
        return this.identifierSize;
    }

    public int getMinimumObjectSize() {
        return this.minimumObjectSize;
    }

    public void addHeapObject(long l, JavaHeapObject javaHeapObject) {
        this.heapObjects.put(this.makeId(l), javaHeapObject);
    }

    public void addRoot(Root root) {
        root.setIndex(this.roots.size());
        this.roots.addElement(root);
    }

    public void addClass(long l, JavaClass javaClass) {
        this.addHeapObject(l, javaClass);
        this.putInClassesMap(javaClass);
    }

    JavaClass addFakeInstanceClass(long l, int n) {
        int n2;
        String string = "unknown-class<@" + Misc.toHex(l) + ">";
        int n3 = n / 4;
        int n4 = n % 4;
        JavaField[] javaFieldArray = new JavaField[n3 + n4];
        for (n2 = 0; n2 < n3; ++n2) {
            javaFieldArray[n2] = new JavaField("unknown-field-" + n2, "I");
        }
        for (n2 = 0; n2 < n4; ++n2) {
            javaFieldArray[n2 + n3] = new JavaField("unknown-field-" + n2 + n3, "B");
        }
        JavaClass javaClass = new JavaClass(string, 0L, 0L, 0L, 0L, javaFieldArray, EMPTY_STATIC_ARRAY, n);
        this.addFakeClass(this.makeId(l), javaClass);
        return javaClass;
    }

    public boolean getHasNewSet() {
        return this.hasNewSet;
    }

    public void resolve(boolean bl) {
        System.out.println("Resolving " + this.heapObjects.size() + " objects...");
        this.javaLangClass = this.findClass("java.lang.Class");
        if (this.javaLangClass == null) {
            System.out.println("WARNING:  hprof file does not include java.lang.Class!");
            this.javaLangClass = new JavaClass("java.lang.Class", 0L, 0L, 0L, 0L, EMPTY_FIELD_ARRAY, EMPTY_STATIC_ARRAY, 0);
            this.addFakeClass(this.javaLangClass);
        }
        this.javaLangString = this.findClass("java.lang.String");
        if (this.javaLangString == null) {
            System.out.println("WARNING:  hprof file does not include java.lang.String!");
            this.javaLangString = new JavaClass("java.lang.String", 0L, 0L, 0L, 0L, EMPTY_FIELD_ARRAY, EMPTY_STATIC_ARRAY, 0);
            this.addFakeClass(this.javaLangString);
        }
        this.javaLangClassLoader = this.findClass("java.lang.ClassLoader");
        if (this.javaLangClassLoader == null) {
            System.out.println("WARNING:  hprof file does not include java.lang.ClassLoader!");
            this.javaLangClassLoader = new JavaClass("java.lang.ClassLoader", 0L, 0L, 0L, 0L, EMPTY_FIELD_ARRAY, EMPTY_STATIC_ARRAY, 0);
            this.addFakeClass(this.javaLangClassLoader);
        }
        for (JavaHeapObject javaHeapObject : this.heapObjects.values()) {
            if (!(javaHeapObject instanceof JavaClass)) continue;
            javaHeapObject.resolve(this);
        }
        for (JavaHeapObject javaHeapObject : this.heapObjects.values()) {
            if (javaHeapObject instanceof JavaClass) continue;
            javaHeapObject.resolve(this);
        }
        this.heapObjects.putAll(this.fakeClasses);
        this.fakeClasses.clear();
        this.weakReferenceClass = this.findClass("java.lang.ref.Reference");
        if (this.weakReferenceClass == null) {
            this.weakReferenceClass = this.findClass("sun.misc.Ref");
            this.referentFieldIndex = 0;
        } else {
            JavaField[] javaFieldArray = this.weakReferenceClass.getFieldsForInstance();
            for (int i = 0; i < javaFieldArray.length; ++i) {
                if (!"referent".equals(javaFieldArray[i].getName())) continue;
                this.referentFieldIndex = i;
                break;
            }
        }
        if (bl) {
            this.calculateReferencesToObjects();
            System.out.print("Eliminating duplicate references");
            System.out.flush();
        }
        int n = 0;
        for (JavaHeapObject javaHeapObject : this.heapObjects.values()) {
            javaHeapObject.setupReferers();
            if (!bl || ++n % 5000 != 0) continue;
            System.out.print(".");
            System.out.flush();
        }
        if (bl) {
            System.out.println("");
        }
        this.classes = Collections.unmodifiableMap(this.classes);
    }

    private void calculateReferencesToObjects() {
        System.out.print("Chasing references, expect " + this.heapObjects.size() / 5000 + " dots");
        System.out.flush();
        int n = 0;
        MyVisitor myVisitor = new MyVisitor();
        Iterator<Object> iterator = this.heapObjects.values().iterator();
        while (iterator.hasNext()) {
            JavaHeapObject object;
            myVisitor.t = object = iterator.next();
            object.visitReferencedObjects(myVisitor);
            if (++n % 5000 != 0) continue;
            System.out.print(".");
            System.out.flush();
        }
        System.out.println();
        for (Root root : this.roots) {
            root.resolve(this);
            JavaHeapObject javaHeapObject = this.findThing(root.getId());
            if (javaHeapObject == null) continue;
            javaHeapObject.addReferenceFromRoot(root);
        }
    }

    public void markNewRelativeTo(Snapshot snapshot) {
        this.hasNewSet = true;
        for (JavaHeapObject javaHeapObject : this.heapObjects.values()) {
            JavaHeapObject javaHeapObject2;
            long l = javaHeapObject.getId();
            boolean bl = l == 0L || l == -1L ? false : ((javaHeapObject2 = snapshot.findThing(javaHeapObject.getId())) == null ? true : !javaHeapObject.isSameTypeAs(javaHeapObject2));
            javaHeapObject.setNew(bl);
        }
    }

    public Enumeration<JavaHeapObject> getThings() {
        return this.heapObjects.elements();
    }

    public JavaHeapObject findThing(long l) {
        Number number = this.makeId(l);
        JavaHeapObject javaHeapObject = this.heapObjects.get(number);
        return javaHeapObject != null ? javaHeapObject : (JavaHeapObject)this.fakeClasses.get(number);
    }

    public JavaHeapObject findThing(String string) {
        return this.findThing(Misc.parseHex(string));
    }

    public JavaClass findClass(String string) {
        if (string.startsWith("0x")) {
            return (JavaClass)this.findThing(string);
        }
        return this.classes.get(string);
    }

    public Iterator getClasses() {
        return this.classes.values().iterator();
    }

    public JavaClass[] getClassesArray() {
        JavaClass[] javaClassArray = new JavaClass[this.classes.size()];
        this.classes.values().toArray(javaClassArray);
        return javaClassArray;
    }

    public synchronized Enumeration getFinalizerObjects() {
        Vector vector;
        if (this.finalizablesCache != null && (vector = this.finalizablesCache.get()) != null) {
            return vector.elements();
        }
        JavaClass javaClass = this.findClass("java.lang.ref.Finalizer");
        JavaObject javaObject = (JavaObject)javaClass.getStaticField("queue");
        JavaThing javaThing = javaObject.getField("head");
        Vector<JavaHeapObject> vector2 = new Vector<JavaHeapObject>();
        if (javaThing != this.getNullThing()) {
            JavaObject javaObject2 = (JavaObject)javaThing;
            while (true) {
                JavaHeapObject javaHeapObject = (JavaHeapObject)javaObject2.getField("referent");
                JavaThing javaThing2 = javaObject2.getField("next");
                if (javaThing2 == this.getNullThing() || javaThing2.equals(javaObject2)) break;
                javaObject2 = (JavaObject)javaThing2;
                vector2.add(javaHeapObject);
            }
        }
        this.finalizablesCache = new SoftReference(vector2);
        return vector2.elements();
    }

    public Enumeration<Root> getRoots() {
        return this.roots.elements();
    }

    public Root[] getRootsArray() {
        Root[] rootArray = new Root[this.roots.size()];
        this.roots.toArray(rootArray);
        return rootArray;
    }

    public Root getRootAt(int n) {
        return this.roots.elementAt(n);
    }

    public ReferenceChain[] rootsetReferencesTo(JavaHeapObject javaHeapObject, boolean bl) {
        Object object;
        Vector<ReferenceChain> vector = new Vector<ReferenceChain>();
        Hashtable<JavaHeapObject, JavaHeapObject> hashtable = new Hashtable<JavaHeapObject, JavaHeapObject>();
        Vector<Object> vector2 = new Vector<Object>();
        hashtable.put(javaHeapObject, javaHeapObject);
        vector.addElement(new ReferenceChain(javaHeapObject, null));
        while (vector.size() > 0) {
            object = (ReferenceChain)vector.elementAt(0);
            vector.removeElementAt(0);
            JavaHeapObject javaHeapObject2 = ((ReferenceChain)object).getObj();
            if (javaHeapObject2.getRoot() != null) {
                vector2.addElement(object);
            }
            Enumeration enumeration = javaHeapObject2.getReferers();
            while (enumeration.hasMoreElements()) {
                JavaHeapObject javaHeapObject3 = (JavaHeapObject)enumeration.nextElement();
                if (javaHeapObject3 == null || hashtable.containsKey(javaHeapObject3) || !bl && javaHeapObject3.refersOnlyWeaklyTo(this, javaHeapObject2)) continue;
                hashtable.put(javaHeapObject3, javaHeapObject3);
                vector.addElement(new ReferenceChain(javaHeapObject3, (ReferenceChain)object));
            }
        }
        object = new ReferenceChain[vector2.size()];
        for (int i = 0; i < vector2.size(); ++i) {
            object[i] = (ReferenceChain)vector2.elementAt(i);
        }
        return object;
    }

    public boolean getUnresolvedObjectsOK() {
        return this.unresolvedObjectsOK;
    }

    public void setUnresolvedObjectsOK(boolean bl) {
        this.unresolvedObjectsOK = bl;
    }

    public JavaClass getWeakReferenceClass() {
        return this.weakReferenceClass;
    }

    public int getReferentFieldIndex() {
        return this.referentFieldIndex;
    }

    public JavaThing getNullThing() {
        return this.nullThing;
    }

    public void setReachableExcludes(ReachableExcludes reachableExcludes) {
        this.reachableExcludes = reachableExcludes;
    }

    public ReachableExcludes getReachableExcludes() {
        return this.reachableExcludes;
    }

    void addReferenceFromRoot(Root root, JavaHeapObject javaHeapObject) {
        Root root2 = this.rootsMap.get(javaHeapObject);
        if (root2 == null) {
            this.rootsMap.put(javaHeapObject, root);
        } else {
            this.rootsMap.put(javaHeapObject, root2.mostInteresting(root));
        }
    }

    Root getRoot(JavaHeapObject javaHeapObject) {
        return this.rootsMap.get(javaHeapObject);
    }

    JavaClass getJavaLangClass() {
        return this.javaLangClass;
    }

    JavaClass getJavaLangString() {
        return this.javaLangString;
    }

    JavaClass getJavaLangClassLoader() {
        return this.javaLangClassLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    JavaClass getOtherArrayType() {
        if (this.otherArrayType == null) {
            Snapshot snapshot = this;
            synchronized (snapshot) {
                if (this.otherArrayType == null) {
                    this.addFakeClass(new JavaClass("[<other>", 0L, 0L, 0L, 0L, EMPTY_FIELD_ARRAY, EMPTY_STATIC_ARRAY, 0));
                    this.otherArrayType = this.findClass("[<other>");
                }
            }
        }
        return this.otherArrayType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    JavaClass getArrayClass(String string) {
        JavaClass javaClass;
        Map<String, JavaClass> map = this.classes;
        synchronized (map) {
            javaClass = this.findClass("[" + string);
            if (javaClass == null) {
                javaClass = new JavaClass("[" + string, 0L, 0L, 0L, 0L, EMPTY_FIELD_ARRAY, EMPTY_STATIC_ARRAY, 0);
                this.addFakeClass(javaClass);
            }
        }
        return javaClass;
    }

    ReadBuffer getReadBuffer() {
        return this.readBuf;
    }

    void setNew(JavaHeapObject javaHeapObject, boolean bl) {
        this.initNewObjects();
        if (bl) {
            this.newObjects.put(javaHeapObject, Boolean.TRUE);
        }
    }

    boolean isNew(JavaHeapObject javaHeapObject) {
        if (this.newObjects != null) {
            return this.newObjects.get(javaHeapObject) != null;
        }
        return false;
    }

    private Number makeId(long l) {
        if (this.identifierSize == 4) {
            return new Integer((int)l);
        }
        return new Long(l);
    }

    private void putInClassesMap(JavaClass javaClass) {
        String string = javaClass.getName();
        if (this.classes.containsKey(string)) {
            string = string + "-" + javaClass.getIdString();
        }
        this.classes.put(javaClass.getName(), javaClass);
    }

    private void addFakeClass(JavaClass javaClass) {
        this.putInClassesMap(javaClass);
        javaClass.resolve(this);
    }

    private void addFakeClass(Number number, JavaClass javaClass) {
        this.fakeClasses.put(number, javaClass);
        this.addFakeClass(javaClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void initNewObjects() {
        if (this.newObjects == null) {
            Snapshot snapshot = this;
            synchronized (snapshot) {
                if (this.newObjects == null) {
                    this.newObjects = new HashMap<JavaHeapObject, Boolean>();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void initSiteTraces() {
        if (this.siteTraces == null) {
            Snapshot snapshot = this;
            synchronized (snapshot) {
                if (this.siteTraces == null) {
                    this.siteTraces = new HashMap<JavaHeapObject, StackTrace>();
                }
            }
        }
    }

    private static class MyVisitor
    extends AbstractJavaHeapObjectVisitor {
        JavaHeapObject t;

        private MyVisitor() {
        }

        public void visit(JavaHeapObject javaHeapObject) {
            javaHeapObject.addReferenceFrom(this.t);
        }
    }
}

