/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.internal.jxc.apt;

import com.sun.mirror.apt.AnnotationProcessorEnvironment;
import com.sun.mirror.apt.Messager;
import com.sun.tools.internal.xjc.ErrorReceiver;
import org.xml.sax.SAXParseException;

final class ErrorReceiverImpl
extends ErrorReceiver {
    private final Messager messager;
    private final boolean debug;

    public ErrorReceiverImpl(Messager messager, boolean bl) {
        this.messager = messager;
        this.debug = bl;
    }

    public ErrorReceiverImpl(Messager messager) {
        this(messager, false);
    }

    public ErrorReceiverImpl(AnnotationProcessorEnvironment annotationProcessorEnvironment) {
        this(annotationProcessorEnvironment.getMessager());
    }

    public void error(SAXParseException sAXParseException) {
        this.messager.printError(sAXParseException.getMessage());
        this.messager.printError(this.getLocation(sAXParseException));
        this.printDetail(sAXParseException);
    }

    public void fatalError(SAXParseException sAXParseException) {
        this.messager.printError(sAXParseException.getMessage());
        this.messager.printError(this.getLocation(sAXParseException));
        this.printDetail(sAXParseException);
    }

    public void warning(SAXParseException sAXParseException) {
        this.messager.printWarning(sAXParseException.getMessage());
        this.messager.printWarning(this.getLocation(sAXParseException));
        this.printDetail(sAXParseException);
    }

    public void info(SAXParseException sAXParseException) {
        this.printDetail(sAXParseException);
    }

    private String getLocation(SAXParseException sAXParseException) {
        return "";
    }

    private void printDetail(SAXParseException sAXParseException) {
        if (this.debug) {
            sAXParseException.printStackTrace(System.out);
        }
    }
}

