/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.internal.ws.processor.util;

import com.sun.tools.internal.ws.processor.ProcessorNotificationListener;
import com.sun.tools.internal.ws.processor.generator.Names;
import com.sun.tools.internal.ws.processor.util.GeneratedFileInfo;
import com.sun.tools.internal.ws.processor.util.ProcessorEnvironment;
import com.sun.tools.internal.ws.processor.util.ProcessorEnvironmentBase;
import com.sun.tools.internal.ws.util.JAXWSClassFactory;
import com.sun.xml.internal.ws.util.localization.Localizable;
import java.io.File;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ClientProcessorEnvironment
extends ProcessorEnvironmentBase
implements ProcessorEnvironment {
    private OutputStream out;
    private PrintStream outprintstream;
    private ProcessorNotificationListener listener;
    private String classPath;
    private List generatedFiles = new ArrayList();
    private int nwarnings;
    private int nerrors;
    private int flags;
    private Names names;

    public ClientProcessorEnvironment(OutputStream outputStream, String string, ProcessorNotificationListener processorNotificationListener) {
        this.out = outputStream;
        this.classPath = string;
        this.listener = processorNotificationListener;
        this.flags = 0;
        this.names = JAXWSClassFactory.newInstance().createNames();
    }

    public void setFlags(int n) {
        this.flags = n;
    }

    public int getFlags() {
        return this.flags;
    }

    public String getClassPath() {
        return this.classPath;
    }

    public boolean verbose() {
        return (this.flags & 1) != 0;
    }

    public void addGeneratedFile(GeneratedFileInfo generatedFileInfo) {
        this.generatedFiles.add(generatedFileInfo);
    }

    public Iterator getGeneratedFiles() {
        return this.generatedFiles.iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteGeneratedFiles() {
        List list = this.generatedFiles;
        synchronized (list) {
            Iterator iterator = this.generatedFiles.iterator();
            while (iterator.hasNext()) {
                File file = ((GeneratedFileInfo)iterator.next()).getFile();
                if (!file.getName().endsWith(".java")) continue;
                file.delete();
            }
            this.generatedFiles.clear();
        }
    }

    public void shutdown() {
        this.listener = null;
        this.generatedFiles = null;
    }

    public void error(Localizable localizable) {
        if (this.listener != null) {
            this.listener.onError(localizable);
        }
        ++this.nerrors;
    }

    public void warn(Localizable localizable) {
        if (this.warnings()) {
            ++this.nwarnings;
            if (this.listener != null) {
                this.listener.onWarning(localizable);
            }
        }
    }

    public void info(Localizable localizable) {
        if (this.listener != null) {
            this.listener.onInfo(localizable);
        }
    }

    public void printStackTrace(Throwable throwable) {
        if (this.outprintstream == null) {
            this.outprintstream = new PrintStream(this.out);
        }
        throwable.printStackTrace(this.outprintstream);
    }

    public Names getNames() {
        return this.names;
    }

    public int getErrorCount() {
        return this.nerrors;
    }

    public int getWarningCount() {
        return this.nwarnings;
    }

    private boolean warnings() {
        return (this.flags & 2) != 0;
    }

    public void setNames(Names names) {
        this.names = names;
    }
}

