/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.internal.xjc.util;

import com.sun.codemodel.internal.ClassType;
import com.sun.codemodel.internal.JClassAlreadyExistsException;
import com.sun.codemodel.internal.JClassContainer;
import com.sun.codemodel.internal.JDefinedClass;
import com.sun.codemodel.internal.JJavaName;
import com.sun.tools.internal.xjc.ErrorReceiver;
import com.sun.tools.internal.xjc.util.Messages;
import org.xml.sax.Locator;
import org.xml.sax.SAXParseException;

public final class CodeModelClassFactory {
    private ErrorReceiver errorReceiver;
    private int ticketMaster = 0;

    public CodeModelClassFactory(ErrorReceiver errorReceiver) {
        this.errorReceiver = errorReceiver;
    }

    public JDefinedClass createClass(JClassContainer jClassContainer, String string, Locator locator) {
        return this.createClass(jClassContainer, 1, string, locator);
    }

    public JDefinedClass createClass(JClassContainer jClassContainer, int n, String string, Locator locator) {
        return this.createClass(jClassContainer, n, string, locator, ClassType.CLASS);
    }

    public JDefinedClass createInterface(JClassContainer jClassContainer, String string, Locator locator) {
        return this.createInterface(jClassContainer, 1, string, locator);
    }

    public JDefinedClass createInterface(JClassContainer jClassContainer, int n, String string, Locator locator) {
        return this.createClass(jClassContainer, n, string, locator, ClassType.INTERFACE);
    }

    public JDefinedClass createClass(JClassContainer jClassContainer, String string, Locator locator, ClassType classType) {
        return this.createClass(jClassContainer, 1, string, locator, classType);
    }

    public JDefinedClass createClass(JClassContainer jClassContainer, int n, String string, Locator locator, ClassType classType) {
        if (!JJavaName.isJavaIdentifier(string)) {
            this.errorReceiver.error(new SAXParseException(Messages.format("ERR_INVALID_CLASSNAME", string), locator));
            return this.createDummyClass(jClassContainer);
        }
        try {
            if (jClassContainer.isClass() && classType == ClassType.CLASS) {
                n |= 0x10;
            }
            JDefinedClass jDefinedClass = jClassContainer._class(n, string, classType);
            jDefinedClass.metadata = locator;
            return jDefinedClass;
        }
        catch (JClassAlreadyExistsException jClassAlreadyExistsException) {
            JDefinedClass jDefinedClass = jClassAlreadyExistsException.getExistingClass();
            this.errorReceiver.error(new SAXParseException(Messages.format("CodeModelClassFactory.ClassNameCollision", jDefinedClass.fullName()), (Locator)jDefinedClass.metadata));
            this.errorReceiver.error(new SAXParseException(Messages.format("CodeModelClassFactory.ClassNameCollision.Source", string), locator));
            if (!string.equals(jDefinedClass.name())) {
                this.errorReceiver.error(new SAXParseException(Messages.format("CodeModelClassFactory.CaseSensitivityCollision", string, jDefinedClass.name()), null));
            }
            return this.createDummyClass(jClassContainer);
        }
    }

    private JDefinedClass createDummyClass(JClassContainer jClassContainer) {
        try {
            return jClassContainer._class("$$$garbage$$$" + this.ticketMaster++);
        }
        catch (JClassAlreadyExistsException jClassAlreadyExistsException) {
            return jClassAlreadyExistsException.getExistingClass();
        }
    }
}

