/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.jdi;

import com.sun.jdi.connect.spi.ClosedConnectionException;
import com.sun.jdi.connect.spi.Connection;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;

class SocketConnection
extends Connection {
    private Socket socket;
    private boolean closed = false;
    private OutputStream socketOutput;
    private InputStream socketInput;
    private Object receiveLock = new Object();
    private Object sendLock = new Object();
    private Object closeLock = new Object();

    SocketConnection(Socket socket) throws IOException {
        this.socket = socket;
        socket.setTcpNoDelay(true);
        this.socketInput = socket.getInputStream();
        this.socketOutput = socket.getOutputStream();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        Object object = this.closeLock;
        synchronized (object) {
            if (this.closed) {
                return;
            }
            this.socketOutput.close();
            this.socketInput.close();
            this.socket.close();
            this.closed = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isOpen() {
        Object object = this.closeLock;
        synchronized (object) {
            return !this.closed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] readPacket() throws IOException {
        if (!this.isOpen()) {
            throw new ClosedConnectionException("connection is closed");
        }
        Object object = this.receiveLock;
        synchronized (object) {
            int n;
            int n2;
            int n3;
            int n4;
            try {
                n4 = this.socketInput.read();
                n3 = this.socketInput.read();
                n2 = this.socketInput.read();
                n = this.socketInput.read();
            }
            catch (IOException iOException) {
                if (!this.isOpen()) {
                    throw new ClosedConnectionException("connection is closed");
                }
                throw iOException;
            }
            if (n4 < 0) {
                return new byte[0];
            }
            if (n3 < 0 || n2 < 0 || n < 0) {
                throw new IOException("protocol error - premature EOF");
            }
            int n5 = n4 << 24 | n3 << 16 | n2 << 8 | n << 0;
            if (n5 < 0) {
                throw new IOException("protocol error - invalid length");
            }
            byte[] byArray = new byte[n5];
            byArray[0] = (byte)n4;
            byArray[1] = (byte)n3;
            byArray[2] = (byte)n2;
            byArray[3] = (byte)n;
            int n6 = 4;
            n5 -= n6;
            while (n5 > 0) {
                int n7;
                try {
                    n7 = this.socketInput.read(byArray, n6, n5);
                }
                catch (IOException iOException) {
                    if (!this.isOpen()) {
                        throw new ClosedConnectionException("connection is closed");
                    }
                    throw iOException;
                }
                if (n7 < 0) {
                    throw new IOException("protocol error - premature EOF");
                }
                n5 -= n7;
                n6 += n7;
            }
            return byArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writePacket(byte[] byArray) throws IOException {
        if (!this.isOpen()) {
            throw new ClosedConnectionException("connection is closed");
        }
        if (byArray.length < 11) {
            throw new IllegalArgumentException("packet is insufficient size");
        }
        int n = byArray[0] & 0xFF;
        int n2 = byArray[1] & 0xFF;
        int n3 = byArray[2] & 0xFF;
        int n4 = byArray[3] & 0xFF;
        int n5 = n << 24 | n2 << 16 | n3 << 8 | n4 << 0;
        if (n5 < 11) {
            throw new IllegalArgumentException("packet is insufficient size");
        }
        if (n5 > byArray.length) {
            throw new IllegalArgumentException("length mis-match");
        }
        Object object = this.sendLock;
        synchronized (object) {
            try {
                this.socketOutput.write(byArray, 0, n5);
            }
            catch (IOException iOException) {
                if (!this.isOpen()) {
                    throw new ClosedConnectionException("connection is closed");
                }
                throw iOException;
            }
        }
    }
}

