/*
 * Decompiled with CFR 0.152.
 */
package sun.jvmstat.monitor;

import java.net.URI;
import java.net.URISyntaxException;
import sun.jvmstat.monitor.MonitorException;
import sun.jvmstat.monitor.VmIdentifier;

public class HostIdentifier {
    private URI uri;

    private URI canonicalize(String string) throws URISyntaxException {
        if (string == null || string.compareTo("localhost") == 0) {
            string = "//localhost";
            return new URI(string);
        }
        URI uRI = new URI(string);
        if (uRI.isAbsolute()) {
            if (uRI.isOpaque()) {
                String string2 = uRI.getScheme();
                String string3 = uRI.getSchemeSpecificPart();
                String string4 = uRI.getFragment();
                URI uRI2 = null;
                int n = string.indexOf(":");
                int n2 = string.lastIndexOf(":");
                if (n2 != n) {
                    uRI2 = string4 == null ? new URI(string2 + "://" + string3) : new URI(string2 + "://" + string3 + "#" + string4);
                    return uRI2;
                }
                uRI2 = new URI("//" + string);
                return uRI2;
            }
            return uRI;
        }
        String string5 = uRI.getSchemeSpecificPart();
        if (string5.startsWith("//")) {
            return uRI;
        }
        return new URI("//" + string);
    }

    public HostIdentifier(String string) throws URISyntaxException {
        this.uri = this.canonicalize(string);
    }

    public HostIdentifier(String string, String string2, String string3, String string4, String string5) throws URISyntaxException {
        this.uri = new URI(string, string2, string3, string4, string5);
    }

    public HostIdentifier(VmIdentifier vmIdentifier) {
        String string;
        String string2;
        String string3;
        StringBuilder stringBuilder = new StringBuilder();
        String string4 = vmIdentifier.getScheme();
        String string5 = vmIdentifier.getHost();
        String string6 = vmIdentifier.getAuthority();
        if (string4 != null && string4.compareTo("file") == 0) {
            try {
                this.uri = new URI("file://localhost");
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
            return;
        }
        if (string5 != null && string5.compareTo(string6) == 0) {
            string5 = null;
        }
        if (string4 == null) {
            string4 = string5 == null ? "local" : "rmi";
        }
        stringBuilder.append(string4).append("://");
        if (string5 == null) {
            stringBuilder.append("localhost");
        } else {
            stringBuilder.append(string5);
        }
        int n = vmIdentifier.getPort();
        if (n != -1) {
            stringBuilder.append(":").append(n);
        }
        if ((string3 = vmIdentifier.getPath()) != null && string3.length() != 0) {
            stringBuilder.append(string3);
        }
        if ((string2 = vmIdentifier.getQuery()) != null) {
            stringBuilder.append("?").append(string2);
        }
        if ((string = vmIdentifier.getFragment()) != null) {
            stringBuilder.append("#").append(string);
        }
        try {
            this.uri = new URI(stringBuilder.toString());
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new RuntimeException("Internal Error", uRISyntaxException);
        }
    }

    public VmIdentifier resolve(VmIdentifier vmIdentifier) throws URISyntaxException, MonitorException {
        String string;
        String string2;
        String string3;
        String string4 = vmIdentifier.getScheme();
        String string5 = vmIdentifier.getHost();
        String string6 = vmIdentifier.getAuthority();
        if (string4 != null && string4.compareTo("file") == 0) {
            return vmIdentifier;
        }
        if (string5 != null && string5.compareTo(string6) == 0) {
            string5 = null;
        }
        if (string4 == null) {
            string4 = this.getScheme();
        }
        Object var5_5 = null;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string4).append("://");
        String string7 = vmIdentifier.getUserInfo();
        if (string7 != null) {
            stringBuffer.append(string7);
        } else {
            stringBuffer.append(vmIdentifier.getAuthority());
        }
        if (string5 == null) {
            string5 = this.getHost();
        }
        stringBuffer.append("@").append(string5);
        int n = vmIdentifier.getPort();
        if (n == -1) {
            n = this.getPort();
        }
        if (n != -1) {
            stringBuffer.append(":").append(n);
        }
        if ((string3 = vmIdentifier.getPath()) == null || string3.length() == 0) {
            string3 = this.getPath();
        }
        if (string3 != null && string3.length() > 0) {
            stringBuffer.append(string3);
        }
        if ((string2 = vmIdentifier.getQuery()) == null) {
            string2 = this.getQuery();
        }
        if (string2 != null) {
            stringBuffer.append("?").append(string2);
        }
        if ((string = vmIdentifier.getFragment()) == null) {
            string = this.getFragment();
        }
        if (string != null) {
            stringBuffer.append("#").append(string);
        }
        String string8 = stringBuffer.toString();
        return new VmIdentifier(string8);
    }

    public String getScheme() {
        return this.uri.isAbsolute() ? this.uri.getScheme() : null;
    }

    public String getSchemeSpecificPart() {
        return this.uri.getSchemeSpecificPart();
    }

    public String getUserInfo() {
        return this.uri.getUserInfo();
    }

    public String getHost() {
        return this.uri.getHost() == null ? "localhost" : this.uri.getHost();
    }

    public int getPort() {
        return this.uri.getPort();
    }

    public String getPath() {
        return this.uri.getPath();
    }

    public String getQuery() {
        return this.uri.getQuery();
    }

    public String getFragment() {
        return this.uri.getFragment();
    }

    public String getMode() {
        String string = this.getQuery();
        if (string != null) {
            String[] stringArray = string.split("\\+");
            for (int i = 0; i < stringArray.length; ++i) {
                if (!stringArray[i].startsWith("mode=")) continue;
                int n = stringArray[i].indexOf(61);
                return stringArray[i].substring(n + 1);
            }
        }
        return "r";
    }

    public URI getURI() {
        return this.uri;
    }

    public int hashCode() {
        return this.uri.hashCode();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof HostIdentifier)) {
            return false;
        }
        return this.uri.equals(((HostIdentifier)object).uri);
    }

    public String toString() {
        return this.uri.toString();
    }
}

