/*
 * Decompiled with CFR 0.152.
 */
package sun.jvmstat.perfdata.monitor;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StreamTokenizer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Map;
import sun.jvmstat.perfdata.monitor.SyntaxException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AliasFileParser {
    private static final String ALIAS = "alias";
    private static final boolean DEBUG = false;
    private URL inputfile;
    private StreamTokenizer st;
    private Token currentToken;

    AliasFileParser(URL uRL) {
        this.inputfile = uRL;
    }

    private void logln(String string) {
    }

    private void nextToken() throws IOException {
        this.st.nextToken();
        this.currentToken = new Token(this.st.ttype, this.st.sval);
        this.logln("Read token: type = " + this.currentToken.ttype + " string = " + this.currentToken.sval);
    }

    private void match(int n, String string) throws IOException, SyntaxException {
        if (this.currentToken.ttype != n || this.currentToken.sval.compareTo(string) != 0) {
            throw new SyntaxException(this.st.lineno());
        }
        this.logln("matched type: " + n + " and token = " + this.currentToken.sval);
        this.nextToken();
    }

    private void match(int n) throws IOException, SyntaxException {
        if (this.currentToken.ttype != n) {
            throw new SyntaxException(this.st.lineno());
        }
        this.logln("matched type: " + n + ", token = " + this.currentToken.sval);
        this.nextToken();
    }

    private void match(String string) throws IOException, SyntaxException {
        this.match(-3, string);
    }

    public void parse(Map<String, ArrayList<String>> map) throws SyntaxException, IOException {
        if (this.inputfile == null) {
            return;
        }
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.inputfile.openStream()));
        this.st = new StreamTokenizer(bufferedReader);
        this.st.slashSlashComments(true);
        this.st.slashStarComments(true);
        this.st.wordChars(95, 95);
        this.nextToken();
        while (this.currentToken.ttype != -1) {
            if (this.currentToken.ttype != -3 || this.currentToken.sval.compareTo(ALIAS) != 0) {
                this.nextToken();
                continue;
            }
            this.match(ALIAS);
            String string = this.currentToken.sval;
            this.match(-3);
            ArrayList<String> arrayList = new ArrayList<String>();
            do {
                arrayList.add(this.currentToken.sval);
                this.match(-3);
            } while (this.currentToken.ttype != -1 && this.currentToken.sval.compareTo(ALIAS) != 0);
            this.logln("adding map entry for " + string + " values = " + arrayList);
            map.put(string, arrayList);
        }
    }

    private class Token {
        public String sval;
        public int ttype;

        public Token(int n, String string) {
            this.ttype = n;
            this.sval = string;
        }
    }
}

