/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.jstatd;

import java.net.URISyntaxException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.Set;
import sun.jvmstat.monitor.MonitorException;
import sun.jvmstat.monitor.MonitoredHost;
import sun.jvmstat.monitor.MonitoredVm;
import sun.jvmstat.monitor.VmIdentifier;
import sun.jvmstat.monitor.event.HostEvent;
import sun.jvmstat.monitor.event.HostListener;
import sun.jvmstat.monitor.event.VmStatusChangeEvent;
import sun.jvmstat.monitor.remote.BufferedMonitoredVm;
import sun.jvmstat.monitor.remote.RemoteHost;
import sun.jvmstat.monitor.remote.RemoteVm;
import sun.tools.jstatd.RemoteVmImpl;

public class RemoteHostImpl
implements RemoteHost,
HostListener {
    private MonitoredHost monitoredHost;
    private Set<Integer> activeVms;

    public RemoteHostImpl() throws MonitorException {
        try {
            this.monitoredHost = MonitoredHost.getMonitoredHost("localhost");
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        this.activeVms = this.monitoredHost.activeVms();
        this.monitoredHost.addHostListener(this);
    }

    public RemoteVm attachVm(int n, String string) throws RemoteException, MonitorException {
        Integer n2 = new Integer(n);
        RemoteVm remoteVm = null;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("local://").append(n).append("@localhost");
        if (string != null) {
            stringBuffer.append("?mode=" + string);
        }
        String string2 = stringBuffer.toString();
        try {
            VmIdentifier vmIdentifier = new VmIdentifier(string2);
            MonitoredVm monitoredVm = this.monitoredHost.getMonitoredVm(vmIdentifier);
            RemoteVmImpl remoteVmImpl = new RemoteVmImpl((BufferedMonitoredVm)monitoredVm);
            remoteVm = (RemoteVm)UnicastRemoteObject.exportObject((Remote)remoteVmImpl, 0);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new RuntimeException("Malformed VmIdentifier URI: " + string2, uRISyntaxException);
        }
        return remoteVm;
    }

    public void detachVm(RemoteVm remoteVm) throws RemoteException {
        remoteVm.detach();
    }

    public int[] activeVms() throws MonitorException {
        Object[] objectArray = null;
        int[] nArray = null;
        objectArray = this.monitoredHost.activeVms().toArray();
        nArray = new int[objectArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = (Integer)objectArray[i];
        }
        return nArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void vmStatusChanged(VmStatusChangeEvent vmStatusChangeEvent) {
        Set<Integer> set = this.activeVms;
        synchronized (set) {
            this.activeVms.retainAll(vmStatusChangeEvent.getActive());
        }
    }

    public void disconnected(HostEvent hostEvent) {
    }
}

