/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JInternalFrame;

class DesktopIconMover
implements ComponentListener,
PropertyChangeListener {
    private Component parent;
    private JInternalFrame frame;
    private JInternalFrame.JDesktopIcon icon;
    private Rectangle parentBounds;
    private boolean componentListenerAdded = false;

    public DesktopIconMover(JInternalFrame jInternalFrame) {
        if (jInternalFrame == null) {
            throw new NullPointerException("Frame cannot be null");
        }
        this.frame = jInternalFrame;
        this.icon = jInternalFrame.getDesktopIcon();
        if (this.icon == null) {
            throw new NullPointerException("frame.getDesktopIcon() cannot be null");
        }
        this.parent = jInternalFrame.getParent();
        if (this.parent != null) {
            this.parentBounds = this.parent.getBounds();
        }
    }

    public DesktopIconMover(JInternalFrame.JDesktopIcon jDesktopIcon) {
        if (jDesktopIcon == null) {
            throw new NullPointerException("Icon cannot be null");
        }
        this.icon = jDesktopIcon;
        this.parent = jDesktopIcon.getParent();
        if (this.parent != null) {
            this.parentBounds = this.parent.getBounds();
        }
    }

    public void installListeners() {
        if (this.frame != null) {
            this.frame.addPropertyChangeListener(this);
        } else {
            this.icon.addPropertyChangeListener(this);
        }
        this.addComponentListener();
    }

    public void uninstallListeners() {
        if (this.frame != null) {
            this.frame.removePropertyChangeListener(this);
        } else {
            this.icon.removePropertyChangeListener(this);
        }
        this.removeComponentListener();
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if ("ancestor".equals(string)) {
            Component component = (Component)propertyChangeEvent.getNewValue();
            Component component2 = this.getCurrentParent();
            if (component2 != null && !component2.equals(this.parent)) {
                this.removeComponentListener();
                this.parent = component2;
            }
            if (component == null) {
                this.removeComponentListener();
            } else {
                this.addComponentListener();
            }
            this.parentBounds = this.parent != null ? this.parent.getBounds() : null;
        } else if ("closed".equals(string)) {
            this.removeComponentListener();
        }
    }

    private void addComponentListener() {
        if (!this.componentListenerAdded && this.parent != null) {
            this.parent.addComponentListener(this);
            this.componentListenerAdded = true;
        }
    }

    private void removeComponentListener() {
        if (this.parent != null && this.componentListenerAdded) {
            this.parent.removeComponentListener(this);
            this.componentListenerAdded = false;
        }
    }

    private Component getCurrentParent() {
        if (this.frame != null) {
            return this.frame.getParent();
        }
        return this.icon.getParent();
    }

    public void componentResized(ComponentEvent componentEvent) {
        if (this.parent == null || this.parentBounds == null) {
            return;
        }
        Rectangle rectangle = this.parent.getBounds();
        if (rectangle == null || rectangle.equals(this.parentBounds)) {
            return;
        }
        int n = this.icon.getLocation().y + (rectangle.height - this.parentBounds.height);
        this.icon.setLocation(this.icon.getLocation().x, n);
        this.parentBounds = rectangle;
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }

    public void componentShown(ComponentEvent componentEvent) {
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }
}

