/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.pipe;

import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import sun.java2d.pipe.RegionClipSpanIterator;
import sun.java2d.pipe.RegionIterator;
import sun.java2d.pipe.RegionSpanIterator;
import sun.java2d.pipe.ShapeSpanIterator;
import sun.java2d.pipe.SpanIterator;

public class Region {
    static final int INIT_SIZE = 50;
    static final int GROW_SIZE = 50;
    static final Region EMPTY_REGION = new Region(0, 0, 0, 0);
    static final Region WHOLE_REGION = new Region(Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE);
    int lox;
    int loy;
    int hix;
    int hiy;
    int endIndex;
    int[] bands;
    static final int INCLUDE_A = 1;
    static final int INCLUDE_B = 2;
    static final int INCLUDE_COMMON = 4;

    private static native void initIDs();

    public static int dimAdd(int n, int n2) {
        if (n2 <= 0) {
            return n;
        }
        if ((n2 += n) < n) {
            return Integer.MAX_VALUE;
        }
        return n2;
    }

    public static int clipAdd(int n, int n2) {
        int n3 = n + n2;
        if (n3 > n != n2 > 0) {
            n3 = n2 < 0 ? Integer.MIN_VALUE : Integer.MAX_VALUE;
        }
        return n3;
    }

    private Region(int n, int n2, int n3, int n4) {
        this.lox = n;
        this.loy = n2;
        this.hix = n3;
        this.hiy = n4;
    }

    public static Region getInstance(Shape shape, AffineTransform affineTransform) {
        return Region.getInstance(WHOLE_REGION, false, shape, affineTransform);
    }

    public static Region getInstance(Region region, Shape shape, AffineTransform affineTransform) {
        return Region.getInstance(region, false, shape, affineTransform);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Region getInstance(Region region, boolean bl, Shape shape, AffineTransform affineTransform) {
        int[] nArray = new int[4];
        ShapeSpanIterator shapeSpanIterator = new ShapeSpanIterator(bl);
        try {
            shapeSpanIterator.setOutputArea(region);
            shapeSpanIterator.appendPath(shape.getPathIterator(affineTransform));
            shapeSpanIterator.getPathBox(nArray);
            Region region2 = Region.getInstance(nArray);
            region2.appendSpans(shapeSpanIterator);
            Region region3 = region2;
            Object var9_8 = null;
            shapeSpanIterator.dispose();
            return region3;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            shapeSpanIterator.dispose();
            throw throwable;
        }
    }

    public static Region getInstance(Rectangle rectangle) {
        return Region.getInstanceXYWH(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public static Region getInstanceXYWH(int n, int n2, int n3, int n4) {
        return Region.getInstanceXYXY(n, n2, Region.dimAdd(n, n3), Region.dimAdd(n2, n4));
    }

    public static Region getInstance(int[] nArray) {
        return new Region(nArray[0], nArray[1], nArray[2], nArray[3]);
    }

    public static Region getInstanceXYXY(int n, int n2, int n3, int n4) {
        return new Region(n, n2, n3, n4);
    }

    public void setOutputArea(Rectangle rectangle) {
        this.setOutputAreaXYWH(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public void setOutputAreaXYWH(int n, int n2, int n3, int n4) {
        this.setOutputAreaXYXY(n, n2, Region.dimAdd(n, n3), Region.dimAdd(n2, n4));
    }

    public void setOutputArea(int[] nArray) {
        this.lox = nArray[0];
        this.loy = nArray[1];
        this.hix = nArray[2];
        this.hiy = nArray[3];
    }

    public void setOutputAreaXYXY(int n, int n2, int n3, int n4) {
        this.lox = n;
        this.loy = n2;
        this.hix = n3;
        this.hiy = n4;
    }

    public void appendSpans(SpanIterator spanIterator) {
        int[] nArray = new int[6];
        while (spanIterator.nextSpan(nArray)) {
            this.appendSpan(nArray);
        }
        this.endRow(nArray);
        this.calcBBox();
    }

    public Region getTranslatedRegion(int n, int n2) {
        if ((n | n2) == 0) {
            return this;
        }
        int n3 = this.lox + n;
        int n4 = this.loy + n2;
        int n5 = this.hix + n;
        int n6 = this.hiy + n2;
        if (n3 > this.lox != n > 0 || n4 > this.loy != n2 > 0 || n5 > this.hix != n > 0 || n6 > this.hiy != n2 > 0) {
            return this.getSafeTranslatedRegion(n, n2);
        }
        Region region = new Region(n3, n4, n5, n6);
        int[] nArray = this.bands;
        if (nArray != null) {
            int n7;
            region.endIndex = n7 = this.endIndex;
            int[] nArray2 = new int[n7];
            region.bands = nArray2;
            int n8 = 0;
            while (n8 < n7) {
                int n9;
                nArray2[n8] = nArray[n8] + n2;
                nArray2[++n8] = nArray[n8] + n2;
                nArray2[++n8] = n9 = nArray[n8];
                ++n8;
                while (--n9 >= 0) {
                    nArray2[n8] = nArray[n8] + n;
                    nArray2[++n8] = nArray[n8] + n;
                    ++n8;
                }
            }
        }
        return region;
    }

    private Region getSafeTranslatedRegion(int n, int n2) {
        int n3 = Region.clipAdd(this.lox, n);
        int n4 = Region.clipAdd(this.loy, n2);
        int n5 = Region.clipAdd(this.hix, n);
        int n6 = Region.clipAdd(this.hiy, n2);
        Region region = new Region(n3, n4, n5, n6);
        int[] nArray = this.bands;
        if (nArray != null) {
            int n7 = this.endIndex;
            int[] nArray2 = new int[n7];
            int n8 = 0;
            int n9 = 0;
            while (n8 < n7) {
                int n10;
                int n11;
                int n12;
                nArray2[n9++] = n12 = Region.clipAdd(nArray[n8++], n2);
                nArray2[n9++] = n11 = Region.clipAdd(nArray[n8++], n2);
                nArray2[n9++] = n10 = nArray[n8++];
                int n13 = n9;
                if (n12 < n11) {
                    while (--n10 >= 0) {
                        int n14;
                        int n15;
                        if ((n15 = Region.clipAdd(nArray[n8++], n)) >= (n14 = Region.clipAdd(nArray[n8++], n))) continue;
                        nArray2[n9++] = n15;
                        nArray2[n9++] = n14;
                    }
                } else {
                    n8 += n10 * 2;
                }
                if (n9 > n13) {
                    nArray2[n13 - 1] = (n9 - n13) / 2;
                    continue;
                }
                n9 = n13 - 3;
            }
            if (n9 <= 5) {
                if (n9 < 5) {
                    region.hiy = 0;
                    region.hix = 0;
                    region.loy = 0;
                    region.lox = 0;
                } else {
                    region.loy = nArray2[0];
                    region.hiy = nArray2[1];
                    region.lox = nArray2[3];
                    region.hix = nArray2[4];
                }
            } else {
                region.endIndex = n9;
                region.bands = nArray2;
            }
        }
        return region;
    }

    public Region getIntersection(Rectangle rectangle) {
        return this.getIntersectionXYWH(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public Region getIntersectionXYWH(int n, int n2, int n3, int n4) {
        return this.getIntersectionXYXY(n, n2, Region.dimAdd(n, n3), Region.dimAdd(n2, n4));
    }

    public Region getIntersectionXYXY(int n, int n2, int n3, int n4) {
        if (this.isInsideXYXY(n, n2, n3, n4)) {
            return this;
        }
        Region region = new Region(n < this.lox ? this.lox : n, n2 < this.loy ? this.loy : n2, n3 > this.hix ? this.hix : n3, n4 > this.hiy ? this.hiy : n4);
        if (this.bands != null) {
            region.appendSpans(this.getSpanIterator());
        }
        return region;
    }

    public Region getIntersection(Region region) {
        if (this.isInsideQuickCheck(region)) {
            return this;
        }
        if (region.isInsideQuickCheck(this)) {
            return region;
        }
        Region region2 = new Region(region.lox < this.lox ? this.lox : region.lox, region.loy < this.loy ? this.loy : region.loy, region.hix > this.hix ? this.hix : region.hix, region.hiy > this.hiy ? this.hiy : region.hiy);
        if (!region2.isEmpty()) {
            region2.filterSpans(this, region, 4);
        }
        return region2;
    }

    public Region getUnion(Region region) {
        if (region.isEmpty() || region.isInsideQuickCheck(this)) {
            return this;
        }
        if (this.isEmpty() || this.isInsideQuickCheck(region)) {
            return region;
        }
        Region region2 = new Region(region.lox > this.lox ? this.lox : region.lox, region.loy > this.loy ? this.loy : region.loy, region.hix < this.hix ? this.hix : region.hix, region.hiy < this.hiy ? this.hiy : region.hiy);
        region2.filterSpans(this, region, 7);
        return region2;
    }

    public Region getDifference(Region region) {
        if (!region.intersectsQuickCheck(this)) {
            return this;
        }
        if (this.isInsideQuickCheck(region)) {
            return EMPTY_REGION;
        }
        Region region2 = new Region(this.lox, this.loy, this.hix, this.hiy);
        region2.filterSpans(this, region, 1);
        return region2;
    }

    public Region getExclusiveOr(Region region) {
        if (region.isEmpty()) {
            return this;
        }
        if (this.isEmpty()) {
            return region;
        }
        Region region2 = new Region(region.lox > this.lox ? this.lox : region.lox, region.loy > this.loy ? this.loy : region.loy, region.hix < this.hix ? this.hix : region.hix, region.hiy < this.hiy ? this.hiy : region.hiy);
        region2.filterSpans(this, region, 3);
        return region2;
    }

    private void filterSpans(Region region, Region region2, int n) {
        int[] nArray = region.bands;
        int[] nArray2 = region2.bands;
        if (nArray == null) {
            nArray = new int[]{region.loy, region.hiy, 1, region.lox, region.hix};
        }
        if (nArray2 == null) {
            nArray2 = new int[]{region2.loy, region2.hiy, 1, region2.lox, region2.hix};
        }
        int[] nArray3 = new int[6];
        int n2 = 0;
        int n3 = nArray[n2++];
        int n4 = nArray[n2++];
        int n5 = nArray[n2++];
        n5 = n2 + 2 * n5;
        int n6 = 0;
        int n7 = nArray2[n6++];
        int n8 = nArray2[n6++];
        int n9 = nArray2[n6++];
        n9 = n6 + 2 * n9;
        int n10 = this.loy;
        while (n10 < this.hiy) {
            int n11;
            int n12;
            if (n10 >= n4) {
                if (n5 < region.endIndex) {
                    n2 = n5;
                    n3 = nArray[n2++];
                    n4 = nArray[n2++];
                    n5 = nArray[n2++];
                    n5 = n2 + 2 * n5;
                    continue;
                }
                if ((n & 2) == 0) break;
                n3 = n4 = this.hiy;
                continue;
            }
            if (n10 >= n8) {
                if (n9 < region2.endIndex) {
                    n6 = n9;
                    n7 = nArray2[n6++];
                    n8 = nArray2[n6++];
                    n9 = nArray2[n6++];
                    n9 = n6 + 2 * n9;
                    continue;
                }
                if ((n & 1) == 0) break;
                n7 = n8 = this.hiy;
                continue;
            }
            if (n10 < n7) {
                if (n10 < n3) {
                    n10 = Math.min(n3, n7);
                    continue;
                }
                n12 = Math.min(n4, n7);
                if ((n & 1) != 0) {
                    nArray3[1] = n10;
                    nArray3[3] = n12;
                    n11 = n2;
                    while (n11 < n5) {
                        nArray3[0] = nArray[n11++];
                        nArray3[2] = nArray[n11++];
                        this.appendSpan(nArray3);
                    }
                }
            } else if (n10 < n3) {
                n12 = Math.min(n8, n3);
                if ((n & 2) != 0) {
                    nArray3[1] = n10;
                    nArray3[3] = n12;
                    n11 = n6;
                    while (n11 < n9) {
                        nArray3[0] = nArray2[n11++];
                        nArray3[2] = nArray2[n11++];
                        this.appendSpan(nArray3);
                    }
                }
            } else {
                n12 = Math.min(n4, n8);
                nArray3[1] = n10;
                nArray3[3] = n12;
                n11 = n2;
                int n13 = n6;
                int n14 = nArray[n11++];
                int n15 = nArray[n11++];
                int n16 = nArray2[n13++];
                int n17 = nArray2[n13++];
                int n18 = Math.min(n14, n16);
                if (n18 < this.lox) {
                    n18 = this.lox;
                }
                while (n18 < this.hix) {
                    boolean bl;
                    int n19;
                    if (n18 >= n15) {
                        if (n11 < n5) {
                            n14 = nArray[n11++];
                            n15 = nArray[n11++];
                            continue;
                        }
                        if ((n & 2) != 0) {
                            n14 = n15 = this.hix;
                            continue;
                        }
                        break;
                    }
                    if (n18 >= n17) {
                        if (n13 < n9) {
                            n16 = nArray2[n13++];
                            n17 = nArray2[n13++];
                            continue;
                        }
                        if ((n & 1) != 0) {
                            n16 = n17 = this.hix;
                            continue;
                        }
                        break;
                    }
                    if (n18 < n16) {
                        if (n18 < n14) {
                            n19 = Math.min(n14, n16);
                            bl = false;
                        } else {
                            n19 = Math.min(n15, n16);
                            bl = (n & 1) != 0;
                        }
                    } else if (n18 < n14) {
                        n19 = Math.min(n14, n17);
                        bl = (n & 2) != 0;
                    } else {
                        n19 = Math.min(n15, n17);
                        boolean bl2 = bl = (n & 4) != 0;
                    }
                    if (bl) {
                        nArray3[0] = n18;
                        nArray3[2] = n19;
                        this.appendSpan(nArray3);
                    }
                    n18 = n19;
                }
            }
            n10 = n12;
        }
        this.endRow(nArray3);
        this.calcBBox();
    }

    public Region getBoundsIntersection(Rectangle rectangle) {
        return this.getBoundsIntersectionXYWH(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public Region getBoundsIntersectionXYWH(int n, int n2, int n3, int n4) {
        return this.getBoundsIntersectionXYXY(n, n2, Region.dimAdd(n, n3), Region.dimAdd(n2, n4));
    }

    public Region getBoundsIntersectionXYXY(int n, int n2, int n3, int n4) {
        if (this.bands == null && this.lox >= n && this.loy >= n2 && this.hix <= n3 && this.hiy <= n4) {
            return this;
        }
        return new Region(n < this.lox ? this.lox : n, n2 < this.loy ? this.loy : n2, n3 > this.hix ? this.hix : n3, n4 > this.hiy ? this.hiy : n4);
    }

    public Region getBoundsIntersection(Region region) {
        if (this.encompasses(region)) {
            return region;
        }
        if (region.encompasses(this)) {
            return this;
        }
        return new Region(region.lox < this.lox ? this.lox : region.lox, region.loy < this.loy ? this.loy : region.loy, region.hix > this.hix ? this.hix : region.hix, region.hiy > this.hiy ? this.hiy : region.hiy);
    }

    private void appendSpan(int[] nArray) {
        int n;
        int n2;
        int n3;
        int n4 = nArray[0];
        if (n4 < this.lox) {
            n4 = this.lox;
        }
        if ((n3 = nArray[1]) < this.loy) {
            n3 = this.loy;
        }
        if ((n2 = nArray[2]) > this.hix) {
            n2 = this.hix;
        }
        if ((n = nArray[3]) > this.hiy) {
            n = this.hiy;
        }
        if (n2 <= n4 || n <= n3) {
            return;
        }
        int n5 = nArray[4];
        if (this.endIndex == 0 || n3 >= this.bands[n5 + 1]) {
            if (this.bands == null) {
                this.bands = new int[50];
            } else {
                this.needSpace(5);
                this.endRow(nArray);
                n5 = nArray[4];
            }
            this.bands[this.endIndex++] = n3;
            this.bands[this.endIndex++] = n;
            this.bands[this.endIndex++] = 0;
        } else if (n3 == this.bands[n5] && n == this.bands[n5 + 1] && n4 >= this.bands[this.endIndex - 1]) {
            if (n4 == this.bands[this.endIndex - 1]) {
                this.bands[this.endIndex - 1] = n2;
                return;
            }
            this.needSpace(2);
        } else {
            throw new InternalError("bad span");
        }
        this.bands[this.endIndex++] = n4;
        this.bands[this.endIndex++] = n2;
        int n6 = n5 + 2;
        this.bands[n6] = this.bands[n6] + 1;
    }

    private void needSpace(int n) {
        if (this.endIndex + n >= this.bands.length) {
            int[] nArray = new int[this.bands.length + 50];
            System.arraycopy(this.bands, 0, nArray, 0, this.endIndex);
            this.bands = nArray;
        }
    }

    private void endRow(int[] nArray) {
        int[] nArray2;
        int n = nArray[4];
        int n2 = nArray[5];
        if (n > n2 && (nArray2 = this.bands)[n2 + 1] == nArray2[n] && nArray2[n2 + 2] == nArray2[n + 2]) {
            int n3 = nArray2[n + 2] * 2;
            n += 3;
            n2 += 3;
            while (n3 > 0 && nArray2[n++] == nArray2[n2++]) {
                --n3;
            }
            if (n3 == 0) {
                nArray2[nArray[5] + 1] = nArray2[n2 + 1];
                this.endIndex = n2;
                return;
            }
        }
        nArray[5] = nArray[4];
        nArray[4] = this.endIndex;
    }

    private void calcBBox() {
        int[] nArray = this.bands;
        if (this.endIndex <= 5) {
            if (this.endIndex == 0) {
                this.hiy = 0;
                this.hix = 0;
                this.loy = 0;
                this.lox = 0;
            } else {
                this.loy = nArray[0];
                this.hiy = nArray[1];
                this.lox = nArray[3];
                this.hix = nArray[4];
                this.endIndex = 0;
            }
            this.bands = null;
            return;
        }
        int n = this.hix;
        int n2 = this.lox;
        int n3 = 0;
        int n4 = 0;
        while (n4 < this.endIndex) {
            n3 = n4;
            int n5 = nArray[n4 + 2];
            if (n > nArray[n4 += 3]) {
                n = nArray[n4];
            }
            if (n2 >= nArray[(n4 += n5 * 2) - 1]) continue;
            n2 = nArray[n4 - 1];
        }
        this.lox = n;
        this.loy = nArray[0];
        this.hix = n2;
        this.hiy = nArray[n3 + 1];
    }

    public final int getLoX() {
        return this.lox;
    }

    public final int getLoY() {
        return this.loy;
    }

    public final int getHiX() {
        return this.hix;
    }

    public final int getHiY() {
        return this.hiy;
    }

    public final int getWidth() {
        if (this.hix < this.lox) {
            return 0;
        }
        int n = this.hix - this.lox;
        if (n < 0) {
            n = Integer.MAX_VALUE;
        }
        return n;
    }

    public final int getHeight() {
        if (this.hiy < this.loy) {
            return 0;
        }
        int n = this.hiy - this.loy;
        if (n < 0) {
            n = Integer.MAX_VALUE;
        }
        return n;
    }

    public boolean isEmpty() {
        return this.hix <= this.lox || this.hiy <= this.loy;
    }

    public boolean isRectangular() {
        return this.bands == null;
    }

    public boolean contains(int n, int n2) {
        int n3;
        if (n < this.lox || n >= this.hix || n2 < this.loy || n2 >= this.hiy) {
            return false;
        }
        if (this.bands == null) {
            return true;
        }
        for (int i = 0; i < this.endIndex; i += n3 * 2) {
            if (n2 < this.bands[i++]) {
                return false;
            }
            if (n2 >= this.bands[i++]) {
                n3 = this.bands[i++];
                continue;
            }
            n3 = this.bands[i++];
            n3 = i + n3 * 2;
            while (i < n3) {
                if (n < this.bands[i++]) {
                    return false;
                }
                if (n >= this.bands[i++]) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    public boolean isInsideXYWH(int n, int n2, int n3, int n4) {
        return this.isInsideXYXY(n, n2, Region.dimAdd(n, n3), Region.dimAdd(n2, n4));
    }

    public boolean isInsideXYXY(int n, int n2, int n3, int n4) {
        return this.lox >= n && this.loy >= n2 && this.hix <= n3 && this.hiy <= n4;
    }

    public boolean isInsideQuickCheck(Region region) {
        return region.bands == null && region.lox <= this.lox && region.loy <= this.loy && region.hix >= this.hix && region.hiy >= this.hiy;
    }

    public boolean intersectsQuickCheckXYXY(int n, int n2, int n3, int n4) {
        return n3 > this.lox && n < this.hix && n4 > this.loy && n2 < this.hiy;
    }

    public boolean intersectsQuickCheck(Region region) {
        return region.hix > this.lox && region.lox < this.hix && region.hiy > this.loy && region.loy < this.hiy;
    }

    public boolean encompasses(Region region) {
        return this.bands == null && this.lox <= region.lox && this.loy <= region.loy && this.hix >= region.hix && this.hiy >= region.hiy;
    }

    public boolean encompassesXYWH(int n, int n2, int n3, int n4) {
        return this.encompassesXYXY(n, n2, Region.dimAdd(n, n3), Region.dimAdd(n2, n4));
    }

    public boolean encompassesXYXY(int n, int n2, int n3, int n4) {
        return this.bands == null && this.lox <= n && this.loy <= n2 && this.hix >= n3 && this.hiy >= n4;
    }

    public void getBounds(int[] nArray) {
        nArray[0] = this.lox;
        nArray[1] = this.loy;
        nArray[2] = this.hix;
        nArray[3] = this.hiy;
    }

    public void clipBoxToBounds(int[] nArray) {
        if (nArray[0] < this.lox) {
            nArray[0] = this.lox;
        }
        if (nArray[1] < this.loy) {
            nArray[1] = this.loy;
        }
        if (nArray[2] > this.hix) {
            nArray[2] = this.hix;
        }
        if (nArray[3] > this.hiy) {
            nArray[3] = this.hiy;
        }
    }

    public RegionIterator getIterator() {
        return new RegionIterator(this);
    }

    public SpanIterator getSpanIterator() {
        return new RegionSpanIterator(this);
    }

    public SpanIterator getSpanIterator(int[] nArray) {
        SpanIterator spanIterator = this.getSpanIterator();
        spanIterator.intersectClipBox(nArray[0], nArray[1], nArray[2], nArray[3]);
        return spanIterator;
    }

    public SpanIterator filter(SpanIterator spanIterator) {
        if (this.bands == null) {
            spanIterator.intersectClipBox(this.lox, this.loy, this.hix, this.hiy);
        } else {
            spanIterator = new RegionClipSpanIterator(this, spanIterator);
        }
        return spanIterator;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Region[[");
        stringBuffer.append(this.lox);
        stringBuffer.append(", ");
        stringBuffer.append(this.loy);
        stringBuffer.append(" => ");
        stringBuffer.append(this.hix);
        stringBuffer.append(", ");
        stringBuffer.append(this.hiy);
        stringBuffer.append("]");
        if (this.bands != null) {
            int n = 0;
            while (n < this.endIndex) {
                stringBuffer.append("y{");
                stringBuffer.append(this.bands[n++]);
                stringBuffer.append(",");
                stringBuffer.append(this.bands[n++]);
                stringBuffer.append("}[");
                int n2 = this.bands[n++];
                n2 = n + n2 * 2;
                while (n < n2) {
                    stringBuffer.append("x(");
                    stringBuffer.append(this.bands[n++]);
                    stringBuffer.append(", ");
                    stringBuffer.append(this.bands[n++]);
                    stringBuffer.append(")");
                }
                stringBuffer.append("]");
            }
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public int hashCode() {
        return this.isEmpty() ? 0 : this.lox * 3 + this.loy * 5 + this.hix * 7 + this.hiy * 9;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Region)) {
            return false;
        }
        Region region = (Region)object;
        if (this.isEmpty()) {
            return region.isEmpty();
        }
        if (region.isEmpty()) {
            return false;
        }
        if (region.lox != this.lox || region.loy != this.loy || region.hiy != this.hiy || region.hiy != this.hiy) {
            return false;
        }
        if (this.bands == null) {
            return region.bands == null;
        }
        if (region.bands == null) {
            return false;
        }
        if (this.endIndex != region.endIndex) {
            return false;
        }
        int[] nArray = this.bands;
        int[] nArray2 = region.bands;
        for (int i = 0; i < this.endIndex; ++i) {
            if (nArray[i] == nArray2[i]) continue;
            return false;
        }
        return true;
    }

    static {
        Region.initIDs();
    }
}

