/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.encoding.soap.server;

import com.sun.xml.internal.bind.api.BridgeContext;
import com.sun.xml.internal.ws.encoding.JAXWSAttachmentMarshaller;
import com.sun.xml.internal.ws.encoding.jaxb.JAXBBridgeInfo;
import com.sun.xml.internal.ws.encoding.soap.SOAPConstants;
import com.sun.xml.internal.ws.encoding.soap.SOAPEncoder;
import com.sun.xml.internal.ws.encoding.soap.internal.InternalMessage;
import com.sun.xml.internal.ws.encoding.soap.message.SOAPFaultInfo;
import com.sun.xml.internal.ws.handler.MessageContextUtil;
import com.sun.xml.internal.ws.pept.ept.MessageInfo;
import com.sun.xml.internal.ws.server.RuntimeContext;
import com.sun.xml.internal.ws.server.ServerRtException;
import com.sun.xml.internal.ws.streaming.DOMStreamReader;
import com.sun.xml.internal.ws.streaming.XMLStreamWriterFactory;
import com.sun.xml.internal.ws.util.ByteArrayBuffer;
import com.sun.xml.internal.ws.util.MessageInfoUtil;
import com.sun.xml.internal.ws.util.SOAPUtil;
import javax.xml.namespace.QName;
import javax.xml.soap.Detail;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPMessage;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.ws.handler.MessageContext;

public class SOAPXMLEncoder
extends SOAPEncoder {
    protected static final String FAULTCODE_NAME = "faultcode";
    protected static final String FAULTSTRING_NAME = "faultstring";
    protected static final String FAULTACTOR_NAME = "faultactor";
    protected static final String DETAIL_NAME = "detail";

    public SOAPMessage toSOAPMessage(InternalMessage internalMessage, MessageInfo messageInfo) {
        XMLStreamWriter xMLStreamWriter = null;
        JAXWSAttachmentMarshaller jAXWSAttachmentMarshaller = null;
        boolean bl = false;
        try {
            this.setAttachmentsMap(messageInfo, internalMessage);
            ByteArrayBuffer byteArrayBuffer = new ByteArrayBuffer();
            if (messageInfo.getMetaData("com.sun.xml.ws.client.ContentNegotiation") == "optimistic") {
                xMLStreamWriter = XMLStreamWriterFactory.createFIStreamWriter(byteArrayBuffer);
                jAXWSAttachmentMarshaller = this.getAttachmentMarshaller(messageInfo);
                if (jAXWSAttachmentMarshaller != null) {
                    bl = jAXWSAttachmentMarshaller.isXOPPackage();
                    jAXWSAttachmentMarshaller.setXOPPackage(false);
                }
            } else {
                messageInfo.setMetaData("com.sun.xml.internal.bind.api.Bridge.outputStream", byteArrayBuffer);
                xMLStreamWriter = XMLStreamWriterFactory.createXMLStreamWriter(byteArrayBuffer);
            }
            xMLStreamWriter.writeStartDocument();
            this.startEnvelope(xMLStreamWriter);
            this.writeEnvelopeNamespaces(xMLStreamWriter, messageInfo);
            this.writeHeaders(xMLStreamWriter, internalMessage, messageInfo);
            this.writeBody(xMLStreamWriter, internalMessage, messageInfo);
            this.endEnvelope(xMLStreamWriter);
            xMLStreamWriter.writeEndDocument();
            xMLStreamWriter.close();
            MimeHeaders mimeHeaders = new MimeHeaders();
            mimeHeaders.addHeader("Content-Type", this.getContentType(messageInfo, jAXWSAttachmentMarshaller));
            SOAPMessage sOAPMessage = SOAPUtil.createMessage(mimeHeaders, byteArrayBuffer.newInputStream(), this.getBindingId());
            this.processAttachments(internalMessage, sOAPMessage);
            if (jAXWSAttachmentMarshaller != null) {
                jAXWSAttachmentMarshaller.setXOPPackage(bl);
            }
            SOAPMessage sOAPMessage2 = sOAPMessage;
            return sOAPMessage2;
        }
        catch (Exception exception) {
            throw new ServerRtException("soapencoder.err", new Object[]{exception});
        }
        finally {
            if (xMLStreamWriter != null) {
                try {
                    xMLStreamWriter.close();
                }
                catch (XMLStreamException xMLStreamException) {
                    throw new ServerRtException(xMLStreamException);
                }
            }
        }
    }

    protected JAXWSAttachmentMarshaller getAttachmentMarshaller(MessageInfo messageInfo) {
        BridgeContext bridgeContext;
        Object object = messageInfo.getMetaData("com.sun.xml.internal.ws.runtime.context");
        if (object != null && (bridgeContext = ((RuntimeContext)object).getBridgeContext()) != null) {
            return (JAXWSAttachmentMarshaller)bridgeContext.getAttachmentMarshaller();
        }
        return null;
    }

    protected String getContentType(MessageInfo messageInfo, JAXWSAttachmentMarshaller jAXWSAttachmentMarshaller) {
        String string = (String)messageInfo.getMetaData("com.sun.xml.ws.client.ContentNegotiation");
        if (jAXWSAttachmentMarshaller == null) {
            jAXWSAttachmentMarshaller = this.getAttachmentMarshaller(messageInfo);
        }
        if (jAXWSAttachmentMarshaller != null && jAXWSAttachmentMarshaller.isXopped()) {
            return "application/xop+xml;type=\"text/xml\"";
        }
        return string == "optimistic" ? "application/fastinfoset" : "text/xml";
    }

    protected void writeFault(SOAPFaultInfo sOAPFaultInfo, MessageInfo messageInfo, XMLStreamWriter xMLStreamWriter) {
        try {
            Object object;
            MessageContext messageContext = MessageInfoUtil.getMessageContext(messageInfo);
            if (MessageContextUtil.getHttpStatusCode(messageContext) == null) {
                MessageContextUtil.setHttpStatusCode(messageContext, 500);
            }
            xMLStreamWriter.writeStartElement("soapenv", SOAPConstants.QNAME_SOAP_FAULT.getLocalPart(), SOAPConstants.QNAME_SOAP_FAULT.getNamespaceURI());
            xMLStreamWriter.writeNamespace("soapenv", SOAPConstants.QNAME_SOAP_FAULT.getNamespaceURI());
            xMLStreamWriter.writeStartElement(FAULTCODE_NAME);
            String string = "soapenv";
            QName qName = sOAPFaultInfo.getCode();
            String string2 = qName.getNamespaceURI();
            if (!string2.equals("http://schemas.xmlsoap.org/soap/envelope/")) {
                if (string2.equals("")) {
                    string = "";
                } else {
                    string = qName.getPrefix();
                    if (string.equals("")) {
                        string = "ans";
                    }
                    xMLStreamWriter.setPrefix(string, string2);
                    xMLStreamWriter.writeNamespace(string, string2);
                }
            }
            if (string.equals("")) {
                xMLStreamWriter.writeCharacters(sOAPFaultInfo.getCode().getLocalPart());
            } else {
                xMLStreamWriter.writeCharacters(string + ":" + sOAPFaultInfo.getCode().getLocalPart());
            }
            xMLStreamWriter.writeEndElement();
            xMLStreamWriter.writeStartElement(FAULTSTRING_NAME);
            xMLStreamWriter.writeCharacters(sOAPFaultInfo.getString());
            xMLStreamWriter.writeEndElement();
            if (sOAPFaultInfo.getActor() != null) {
                xMLStreamWriter.writeStartElement(FAULTACTOR_NAME);
                xMLStreamWriter.writeCharacters(sOAPFaultInfo.getActor());
                xMLStreamWriter.writeEndElement();
            }
            if ((object = sOAPFaultInfo.getDetail()) != null) {
                if (object instanceof Detail) {
                    this.encodeDetail((Detail)object, xMLStreamWriter);
                } else if (object instanceof JAXBBridgeInfo) {
                    xMLStreamWriter.writeStartElement(DETAIL_NAME);
                    this.writeJAXBBridgeInfo((JAXBBridgeInfo)object, messageInfo, xMLStreamWriter);
                    xMLStreamWriter.writeEndElement();
                }
            }
            xMLStreamWriter.writeEndElement();
        }
        catch (XMLStreamException xMLStreamException) {
            throw new ServerRtException(xMLStreamException);
        }
    }

    protected void encodeDetail(Detail detail, XMLStreamWriter xMLStreamWriter) {
        SOAPXMLEncoder.serializeReader(new DOMStreamReader(detail), xMLStreamWriter);
    }

    protected String getBindingId() {
        return "http://schemas.xmlsoap.org/wsdl/soap/http";
    }
}

