/*
 * Decompiled with CFR 0.152.
 */
package sun.misc;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilePermission;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.SocketPermission;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.CodeSigner;
import java.security.Permission;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import sun.misc.ExtensionDependency;
import sun.misc.FileURLMapper;
import sun.misc.InvalidJarIndexException;
import sun.misc.JarIndex;
import sun.misc.MetaIndex;
import sun.misc.Resource;
import sun.misc.SharedSecrets;
import sun.net.www.ParseUtil;
import sun.security.action.GetPropertyAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class URLClassPath {
    static final String USER_AGENT_JAVA_VERSION = "UA-Java-Version";
    static final String JAVA_VERSION = AccessController.doPrivileged(new GetPropertyAction("java.version"));
    private static final boolean DEBUG = AccessController.doPrivileged(new GetPropertyAction("sun.misc.URLClassPath.debug")) != null;
    private ArrayList<URL> path = new ArrayList();
    Stack<URL> urls = new Stack();
    ArrayList<Loader> loaders = new ArrayList();
    HashMap<URL, Loader> lmap = new HashMap();
    private URLStreamHandler jarHandler;

    public URLClassPath(URL[] uRLArray, URLStreamHandlerFactory uRLStreamHandlerFactory) {
        for (int i = 0; i < uRLArray.length; ++i) {
            this.path.add(uRLArray[i]);
        }
        this.push(uRLArray);
        if (uRLStreamHandlerFactory != null) {
            this.jarHandler = uRLStreamHandlerFactory.createURLStreamHandler("jar");
        }
    }

    public URLClassPath(URL[] uRLArray) {
        this(uRLArray, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addURL(URL uRL) {
        Stack<URL> stack = this.urls;
        synchronized (stack) {
            if (uRL == null || this.path.contains(uRL)) {
                return;
            }
            this.urls.add(0, uRL);
            this.path.add(uRL);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URL[] getURLs() {
        Stack<URL> stack = this.urls;
        synchronized (stack) {
            return this.path.toArray(new URL[this.path.size()]);
        }
    }

    public URL findResource(String string, boolean bl) {
        Loader loader;
        int n = 0;
        while ((loader = this.getLoader(n)) != null) {
            URL uRL = loader.findResource(string, bl);
            if (uRL != null) {
                return uRL;
            }
            ++n;
        }
        return null;
    }

    public Resource getResource(String string, boolean bl) {
        Loader loader;
        if (DEBUG) {
            System.err.println("URLClassPath.getResource(\"" + string + "\")");
        }
        int n = 0;
        while ((loader = this.getLoader(n)) != null) {
            Resource resource = loader.getResource(string, bl);
            if (resource != null) {
                return resource;
            }
            ++n;
        }
        return null;
    }

    public Enumeration<URL> findResources(final String string, final boolean bl) {
        return new Enumeration<URL>(){
            private int index = 0;
            private URL url = null;

            private boolean next() {
                Loader loader;
                if (this.url != null) {
                    return true;
                }
                while ((loader = URLClassPath.this.getLoader(this.index++)) != null) {
                    this.url = loader.findResource(string, bl);
                    if (this.url == null) continue;
                    return true;
                }
                return false;
            }

            @Override
            public boolean hasMoreElements() {
                return this.next();
            }

            @Override
            public URL nextElement() {
                if (!this.next()) {
                    throw new NoSuchElementException();
                }
                URL uRL = this.url;
                this.url = null;
                return uRL;
            }
        };
    }

    public Resource getResource(String string) {
        return this.getResource(string, true);
    }

    public Enumeration<Resource> getResources(final String string, final boolean bl) {
        return new Enumeration<Resource>(){
            private int index = 0;
            private Resource res = null;

            private boolean next() {
                Loader loader;
                if (this.res != null) {
                    return true;
                }
                while ((loader = URLClassPath.this.getLoader(this.index++)) != null) {
                    this.res = loader.getResource(string, bl);
                    if (this.res == null) continue;
                    return true;
                }
                return false;
            }

            @Override
            public boolean hasMoreElements() {
                return this.next();
            }

            @Override
            public Resource nextElement() {
                if (!this.next()) {
                    throw new NoSuchElementException();
                }
                Resource resource = this.res;
                this.res = null;
                return resource;
            }
        };
    }

    public Enumeration<Resource> getResources(String string) {
        return this.getResources(string, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized Loader getLoader(int n) {
        while (this.loaders.size() < n + 1) {
            URL uRL;
            Object object;
            block7: {
                object = this.urls;
                synchronized (object) {
                    if (this.urls.empty()) {
                        return null;
                    }
                    uRL = this.urls.pop();
                }
                if (this.lmap.containsKey(uRL)) continue;
                try {
                    object = this.getLoader(uRL);
                    URL[] uRLArray = ((Loader)object).getClassPath();
                    if (uRLArray == null) break block7;
                    this.push(uRLArray);
                }
                catch (IOException iOException) {
                    continue;
                }
            }
            this.loaders.add((Loader)object);
            this.lmap.put(uRL, (Loader)object);
        }
        return this.loaders.get(n);
    }

    private Loader getLoader(final URL uRL) throws IOException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Loader>(){

                @Override
                public Loader run() throws IOException {
                    String string = uRL.getFile();
                    if (string != null && string.endsWith("/")) {
                        if ("file".equals(uRL.getProtocol())) {
                            return new FileLoader(uRL);
                        }
                        return new Loader(uRL);
                    }
                    return new JarLoader(uRL, URLClassPath.this.jarHandler, URLClassPath.this.lmap);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (IOException)privilegedActionException.getException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void push(URL[] uRLArray) {
        Stack<URL> stack = this.urls;
        synchronized (stack) {
            for (int i = uRLArray.length - 1; i >= 0; --i) {
                this.urls.push(uRLArray[i]);
            }
        }
    }

    public static URL[] pathToURLs(String string) {
        Object object;
        StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
        URL[] uRLArray = new URL[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            object = new File(stringTokenizer.nextToken());
            try {
                object = new File(object.getCanonicalPath());
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                uRLArray[n++] = ParseUtil.fileToEncodedURL((File)object);
            }
            catch (IOException iOException) {}
        }
        if (uRLArray.length != n) {
            object = new URL[n];
            System.arraycopy(uRLArray, 0, object, 0, n);
            uRLArray = object;
        }
        return uRLArray;
    }

    public URL checkURL(URL uRL) {
        try {
            URLClassPath.check(uRL);
        }
        catch (Exception exception) {
            return null;
        }
        return uRL;
    }

    static void check(URL uRL) throws IOException {
        URLConnection uRLConnection;
        Permission permission;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null && (permission = (uRLConnection = uRL.openConnection()).getPermission()) != null) {
            try {
                securityManager.checkPermission(permission);
            }
            catch (SecurityException securityException) {
                if (permission instanceof FilePermission && permission.getActions().indexOf("read") != -1) {
                    securityManager.checkRead(permission.getName());
                }
                if (permission instanceof SocketPermission && permission.getActions().indexOf("connect") != -1) {
                    URL uRL2 = uRL;
                    if (uRLConnection instanceof JarURLConnection) {
                        uRL2 = ((JarURLConnection)uRLConnection).getJarFileURL();
                    }
                    securityManager.checkConnect(uRL2.getHost(), uRL2.getPort());
                }
                throw securityException;
            }
        }
    }

    private static class FileLoader
    extends Loader {
        private File dir;

        FileLoader(URL uRL) throws IOException {
            super(uRL);
            if (!"file".equals(uRL.getProtocol())) {
                throw new IllegalArgumentException("url");
            }
            String string = uRL.getFile().replace('/', File.separatorChar);
            string = ParseUtil.decode(string);
            this.dir = new File(string).getCanonicalFile();
        }

        URL findResource(String string, boolean bl) {
            Resource resource = this.getResource(string, bl);
            if (resource != null) {
                return resource.getURL();
            }
            return null;
        }

        Resource getResource(final String string, boolean bl) {
            try {
                File file;
                URL uRL = new URL(this.getBaseURL(), ".");
                final URL uRL2 = new URL(this.getBaseURL(), ParseUtil.encodePath(string, false));
                if (!uRL2.getFile().startsWith(uRL.getFile())) {
                    return null;
                }
                if (bl) {
                    URLClassPath.check(uRL2);
                }
                if (string.indexOf("..") != -1) {
                    file = new File(this.dir, string.replace('/', File.separatorChar)).getCanonicalFile();
                    if (!file.getPath().startsWith(this.dir.getPath())) {
                        return null;
                    }
                } else {
                    file = new File(this.dir, string.replace('/', File.separatorChar));
                }
                if (file.exists()) {
                    return new Resource(){

                        public String getName() {
                            return string;
                        }

                        public URL getURL() {
                            return uRL2;
                        }

                        public URL getCodeSourceURL() {
                            return FileLoader.this.getBaseURL();
                        }

                        public InputStream getInputStream() throws IOException {
                            return new FileInputStream(file);
                        }

                        public int getContentLength() throws IOException {
                            return (int)file.length();
                        }
                    };
                }
            }
            catch (Exception exception) {
                return null;
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class JarLoader
    extends Loader {
        private JarFile jar;
        private URL csu;
        private JarIndex index;
        private MetaIndex metaIndex;
        private URLStreamHandler handler;
        private HashMap<URL, Loader> lmap;

        JarLoader(URL uRL, URLStreamHandler uRLStreamHandler, HashMap<URL, Loader> hashMap) throws IOException {
            super(new URL("jar", "", -1, uRL + "!/", uRLStreamHandler));
            this.csu = uRL;
            this.handler = uRLStreamHandler;
            this.lmap = hashMap;
            if (!this.isOptimizable(uRL)) {
                this.ensureOpen();
            } else {
                String string = uRL.getFile();
                if (string != null) {
                    string = ParseUtil.decode(string);
                    File file = new File(string);
                    this.metaIndex = MetaIndex.forJar(file);
                    if (this.metaIndex != null && !file.exists()) {
                        this.metaIndex = null;
                    }
                }
                if (this.metaIndex == null) {
                    this.ensureOpen();
                }
            }
        }

        JarFile getJarFile() {
            return this.jar;
        }

        private boolean isOptimizable(URL uRL) {
            return "file".equals(uRL.getProtocol());
        }

        private void ensureOpen() throws IOException {
            if (this.jar == null) {
                try {
                    AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                        @Override
                        public Void run() throws IOException {
                            if (DEBUG) {
                                System.err.println("Opening " + JarLoader.this.csu);
                                Thread.dumpStack();
                            }
                            JarLoader.this.jar = JarLoader.this.getJarFile(JarLoader.this.csu);
                            JarLoader.this.index = JarIndex.getJarIndex(JarLoader.this.jar, JarLoader.this.metaIndex);
                            if (JarLoader.this.index != null) {
                                String[] stringArray = JarLoader.this.index.getJarFiles();
                                for (int i = 0; i < stringArray.length; ++i) {
                                    try {
                                        URL uRL = new URL(JarLoader.this.csu, stringArray[i]);
                                        if (JarLoader.this.lmap.containsKey(uRL)) continue;
                                        JarLoader.this.lmap.put(uRL, null);
                                        continue;
                                    }
                                    catch (MalformedURLException malformedURLException) {
                                        // empty catch block
                                    }
                                }
                            }
                            return null;
                        }
                    });
                }
                catch (PrivilegedActionException privilegedActionException) {
                    throw (IOException)privilegedActionException.getException();
                }
            }
        }

        private JarFile getJarFile(URL uRL) throws IOException {
            if (this.isOptimizable(uRL)) {
                FileURLMapper fileURLMapper = new FileURLMapper(uRL);
                if (!fileURLMapper.exists()) {
                    throw new FileNotFoundException(fileURLMapper.getPath());
                }
                return new JarFile(fileURLMapper.getPath());
            }
            URLConnection uRLConnection = this.getBaseURL().openConnection();
            uRLConnection.setRequestProperty(URLClassPath.USER_AGENT_JAVA_VERSION, JAVA_VERSION);
            return ((JarURLConnection)uRLConnection).getJarFile();
        }

        JarIndex getIndex() {
            try {
                this.ensureOpen();
            }
            catch (IOException iOException) {
                throw (InternalError)new InternalError().initCause(iOException);
            }
            return this.index;
        }

        Resource checkResource(final String string, boolean bl, final JarEntry jarEntry) {
            URL uRL;
            try {
                uRL = new URL(this.getBaseURL(), ParseUtil.encodePath(string, false));
                if (bl) {
                    URLClassPath.check(uRL);
                }
            }
            catch (MalformedURLException malformedURLException) {
                return null;
            }
            catch (IOException iOException) {
                return null;
            }
            catch (AccessControlException accessControlException) {
                return null;
            }
            return new Resource(){

                public String getName() {
                    return string;
                }

                public URL getURL() {
                    return uRL;
                }

                public URL getCodeSourceURL() {
                    return JarLoader.this.csu;
                }

                public InputStream getInputStream() throws IOException {
                    return JarLoader.this.jar.getInputStream(jarEntry);
                }

                public int getContentLength() {
                    return (int)jarEntry.getSize();
                }

                public Manifest getManifest() throws IOException {
                    return JarLoader.this.jar.getManifest();
                }

                public Certificate[] getCertificates() {
                    return jarEntry.getCertificates();
                }

                public CodeSigner[] getCodeSigners() {
                    return jarEntry.getCodeSigners();
                }
            };
        }

        boolean validIndex(String string) {
            String string2 = string;
            int n = string.lastIndexOf("/");
            if (n != -1) {
                string2 = string.substring(0, n);
            }
            Enumeration<JarEntry> enumeration = this.jar.entries();
            while (enumeration.hasMoreElements()) {
                ZipEntry zipEntry = enumeration.nextElement();
                String string3 = zipEntry.getName();
                n = string3.lastIndexOf("/");
                if (n != -1) {
                    string3 = string3.substring(0, n);
                }
                if (!string3.equals(string2)) continue;
                return true;
            }
            return false;
        }

        @Override
        URL findResource(String string, boolean bl) {
            Resource resource = this.getResource(string, bl);
            if (resource != null) {
                return resource.getURL();
            }
            return null;
        }

        @Override
        Resource getResource(String string, boolean bl) {
            if (this.metaIndex != null && !this.metaIndex.mayContain(string)) {
                return null;
            }
            try {
                this.ensureOpen();
            }
            catch (IOException iOException) {
                throw (InternalError)new InternalError().initCause(iOException);
            }
            JarEntry jarEntry = this.jar.getJarEntry(string);
            if (jarEntry != null) {
                return this.checkResource(string, bl, jarEntry);
            }
            if (this.index == null) {
                return null;
            }
            HashSet<URL> hashSet = new HashSet<URL>();
            return this.getResource(string, bl, hashSet);
        }

        Resource getResource(String string, boolean bl, Set<URL> set) {
            boolean bl2 = false;
            int n = 0;
            LinkedList linkedList = null;
            linkedList = this.index.get(string);
            if (linkedList == null) {
                return null;
            }
            do {
                Object[] objectArray = linkedList.toArray();
                int n2 = linkedList.size();
                while (n < n2) {
                    Resource resource;
                    boolean bl3;
                    JarLoader jarLoader;
                    URL uRL;
                    block12: {
                        String string2 = (String)objectArray[n++];
                        try {
                            uRL = new URL(this.csu, string2);
                            jarLoader = (JarLoader)this.lmap.get(uRL);
                            if (jarLoader != null) break block12;
                            jarLoader = AccessController.doPrivileged(new PrivilegedExceptionAction<JarLoader>(){

                                @Override
                                public JarLoader run() throws IOException {
                                    return new JarLoader(uRL, JarLoader.this.handler, JarLoader.this.lmap);
                                }
                            });
                            JarIndex jarIndex = jarLoader.getIndex();
                            if (jarIndex != null) {
                                int n3 = string2.lastIndexOf("/");
                                jarIndex.merge(this.index, n3 == -1 ? null : string2.substring(0, n3 + 1));
                            }
                            this.lmap.put(uRL, jarLoader);
                        }
                        catch (PrivilegedActionException privilegedActionException) {
                            continue;
                        }
                        catch (MalformedURLException malformedURLException) {
                            continue;
                        }
                    }
                    boolean bl4 = bl3 = !set.add(uRL);
                    if (!bl3) {
                        try {
                            jarLoader.ensureOpen();
                        }
                        catch (IOException iOException) {
                            throw (InternalError)new InternalError().initCause(iOException);
                        }
                        JarEntry jarEntry = jarLoader.jar.getJarEntry(string);
                        if (jarEntry != null) {
                            return jarLoader.checkResource(string, bl, jarEntry);
                        }
                        if (!jarLoader.validIndex(string)) {
                            throw new InvalidJarIndexException("Invalid index");
                        }
                    }
                    if (bl3 || jarLoader == this || jarLoader.getIndex() == null || (resource = jarLoader.getResource(string, bl, set)) == null) continue;
                    return resource;
                }
            } while (n < (linkedList = this.index.get(string)).size());
            return null;
        }

        @Override
        URL[] getClassPath() throws IOException {
            String string;
            Attributes attributes;
            Manifest manifest;
            if (this.index != null) {
                return null;
            }
            if (this.metaIndex != null) {
                return null;
            }
            this.ensureOpen();
            this.parseExtensionsDependencies();
            if (SharedSecrets.javaUtilJarAccess().jarFileHasClassPathAttribute(this.jar) && (manifest = this.jar.getManifest()) != null && (attributes = manifest.getMainAttributes()) != null && (string = attributes.getValue(Attributes.Name.CLASS_PATH)) != null) {
                return this.parseClassPath(this.csu, string);
            }
            return null;
        }

        private void parseExtensionsDependencies() throws IOException {
            ExtensionDependency.checkExtensionsDependencies(this.jar);
        }

        private URL[] parseClassPath(URL uRL, String string) throws MalformedURLException {
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            URL[] uRLArray = new URL[stringTokenizer.countTokens()];
            int n = 0;
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                uRLArray[n] = new URL(uRL, string2);
                ++n;
            }
            return uRLArray;
        }
    }

    private static class Loader {
        private final URL base;

        Loader(URL uRL) {
            this.base = uRL;
        }

        URL getBaseURL() {
            return this.base;
        }

        URL findResource(String string, boolean bl) {
            URL uRL;
            try {
                uRL = new URL(this.base, ParseUtil.encodePath(string, false));
            }
            catch (MalformedURLException malformedURLException) {
                throw new IllegalArgumentException("name");
            }
            try {
                URLConnection uRLConnection;
                if (bl) {
                    URLClassPath.check(uRL);
                }
                if ((uRLConnection = uRL.openConnection()) instanceof HttpURLConnection) {
                    HttpURLConnection httpURLConnection = (HttpURLConnection)uRLConnection;
                    httpURLConnection.setRequestMethod("HEAD");
                    if (httpURLConnection.getResponseCode() >= 400) {
                        return null;
                    }
                } else {
                    InputStream inputStream = uRL.openStream();
                    inputStream.close();
                }
                return uRL;
            }
            catch (Exception exception) {
                return null;
            }
        }

        Resource getResource(final String string, boolean bl) {
            URLConnection uRLConnection;
            URL uRL;
            try {
                uRL = new URL(this.base, ParseUtil.encodePath(string, false));
            }
            catch (MalformedURLException malformedURLException) {
                throw new IllegalArgumentException("name");
            }
            try {
                if (bl) {
                    URLClassPath.check(uRL);
                }
                uRLConnection = uRL.openConnection();
                InputStream inputStream = uRLConnection.getInputStream();
            }
            catch (Exception exception) {
                return null;
            }
            return new Resource(){

                public String getName() {
                    return string;
                }

                public URL getURL() {
                    return uRL;
                }

                public URL getCodeSourceURL() {
                    return Loader.this.base;
                }

                public InputStream getInputStream() throws IOException {
                    return uRLConnection.getInputStream();
                }

                public int getContentLength() throws IOException {
                    return uRLConnection.getContentLength();
                }
            };
        }

        Resource getResource(String string) {
            return this.getResource(string, true);
        }

        URL[] getClassPath() throws IOException {
            return null;
        }
    }
}

