/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.gtk;

import java.awt.AWTKeyStroke;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListSelectionModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileSystemView;
import javax.swing.filechooser.FileView;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicDirectoryModel;
import javax.swing.plaf.basic.BasicFileChooserUI;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import sun.awt.shell.ShellFolder;
import sun.swing.SwingUtilities2;
import sun.swing.plaf.synth.SynthFileChooserUI;

class GTKFileChooserUI
extends SynthFileChooserUI {
    private JPanel accessoryPanel = null;
    private String newFolderButtonText = null;
    private String newFolderErrorSeparator = null;
    private String newFolderErrorText = null;
    private String newFolderDialogText = null;
    private String newFolderNoDirectoryErrorTitleText = null;
    private String newFolderNoDirectoryErrorText = null;
    private String deleteFileButtonText = null;
    private String renameFileButtonText = null;
    private String newFolderButtonToolTipText = null;
    private String deleteFileButtonToolTipText = null;
    private String renameFileButtonToolTipText = null;
    private int newFolderButtonMnemonic = 0;
    private int deleteFileButtonMnemonic = 0;
    private int renameFileButtonMnemonic = 0;
    private int foldersLabelMnemonic = 0;
    private int filesLabelMnemonic = 0;
    private String renameFileDialogText = null;
    private String renameFileErrorTitle = null;
    private String renameFileErrorText = null;
    private JComboBox filterComboBox;
    private FilterComboBoxModel filterComboBoxModel;
    private JPanel rightPanel;
    private JList directoryList;
    private JList fileList;
    private JLabel pathField;
    private JTextField fileNameTextField;
    private static final Dimension hstrut3 = new Dimension(3, 1);
    private static final Dimension vstrut10 = new Dimension(1, 10);
    private static Dimension prefListSize = new Dimension(75, 150);
    private static Dimension PREF_SIZE = new Dimension(435, 360);
    private static Dimension MIN_SIZE = new Dimension(200, 300);
    private static Dimension ZERO_ACC_SIZE = new Dimension(1, 1);
    private static Dimension MAX_SIZE = new Dimension(Short.MAX_VALUE, Short.MAX_VALUE);
    private static final Insets buttonMargin = new Insets(3, 3, 3, 3);
    private String filesLabelText = null;
    private String foldersLabelText = null;
    private String pathLabelText = null;
    private String filterLabelText = null;
    private int pathLabelMnemonic = 0;
    private int filterLabelMnemonic = 0;
    private JComboBox directoryComboBox;
    private DirectoryComboBoxModel directoryComboBoxModel;
    private Action directoryComboBoxAction = new DirectoryComboBoxAction();
    private JPanel bottomButtonPanel;
    private GTKDirectoryModel model = null;
    private Action newFolderAction;
    private boolean readOnly;
    private boolean showDirectoryIcons;
    private boolean showFileIcons;
    private GTKFileView fileView = new GTKFileView();
    private PropertyChangeListener gtkFCPropertyChangeListener;
    private Action approveSelectionAction = new GTKApproveSelectionAction();
    private GTKDirectoryListModel directoryListModel;

    public GTKFileChooserUI(JFileChooser jFileChooser) {
        super(jFileChooser);
    }

    public String getFileName() {
        String string;
        JFileChooser jFileChooser = this.getFileChooser();
        String string2 = string = this.fileNameTextField != null ? this.fileNameTextField.getText() : null;
        if (!jFileChooser.isMultiSelectionEnabled()) {
            return string;
        }
        int n = jFileChooser.getFileSelectionMode();
        JList jList = n == 1 ? this.directoryList : this.fileList;
        Object[] objectArray = jList.getSelectedValues();
        int n2 = objectArray.length;
        Vector<String> vector = new Vector<String>(n2 + 1);
        for (int i = 0; i < n2; ++i) {
            File file = (File)objectArray[i];
            vector.add(file.getName());
        }
        if (string != null && !vector.contains(string)) {
            vector.add(string);
        }
        StringBuffer stringBuffer = new StringBuffer();
        n2 = vector.size();
        for (int i = 0; i < n2; ++i) {
            if (n2 > 1) {
                stringBuffer.append(" \"");
            }
            stringBuffer.append((String)vector.get(i));
            if (n2 <= 1) continue;
            stringBuffer.append("\"");
        }
        return stringBuffer.toString();
    }

    public void setFileName(String string) {
        if (this.fileNameTextField != null) {
            this.fileNameTextField.setText(string);
        }
    }

    public void setDirectoryName(String string) {
        this.pathField.setText(string);
    }

    public void ensureFileIsVisible(JFileChooser jFileChooser, File file) {
    }

    public void rescanCurrentDirectory(JFileChooser jFileChooser) {
        this.getModel().validateFileCache();
    }

    public JPanel getAccessoryPanel() {
        return this.accessoryPanel;
    }

    public FileView getFileView(JFileChooser jFileChooser) {
        return this.fileView;
    }

    private void updateDefaultButton() {
        JFileChooser jFileChooser = this.getFileChooser();
        JRootPane jRootPane = SwingUtilities.getRootPane(jFileChooser);
        if (jRootPane == null) {
            return;
        }
        if (jFileChooser.getControlButtonsAreShown()) {
            if (jRootPane.getDefaultButton() == null) {
                jRootPane.setDefaultButton(this.getApproveButton(jFileChooser));
                this.getCancelButton(jFileChooser).setDefaultCapable(false);
            }
        } else if (jRootPane.getDefaultButton() == this.getApproveButton(jFileChooser)) {
            jRootPane.setDefaultButton(null);
        }
    }

    protected void doSelectedFileChanged(PropertyChangeEvent propertyChangeEvent) {
        super.doSelectedFileChanged(propertyChangeEvent);
        File file = (File)propertyChangeEvent.getNewValue();
        if (file != null) {
            this.setFileName(this.getFileChooser().getName(file));
        }
    }

    protected void doDirectoryChanged(PropertyChangeEvent propertyChangeEvent) {
        File file;
        this.directoryList.clearSelection();
        ListSelectionModel listSelectionModel = this.directoryList.getSelectionModel();
        if (listSelectionModel instanceof DefaultListSelectionModel) {
            ((DefaultListSelectionModel)listSelectionModel).moveLeadSelectionIndex(0);
            listSelectionModel.setAnchorSelectionIndex(0);
        }
        this.fileList.clearSelection();
        listSelectionModel = this.fileList.getSelectionModel();
        if (listSelectionModel instanceof DefaultListSelectionModel) {
            ((DefaultListSelectionModel)listSelectionModel).moveLeadSelectionIndex(0);
            listSelectionModel.setAnchorSelectionIndex(0);
        }
        if ((file = this.getFileChooser().getCurrentDirectory()) != null) {
            try {
                this.setDirectoryName(ShellFolder.getNormalizedFile((File)propertyChangeEvent.getNewValue()).getPath());
            }
            catch (IOException iOException) {
                this.setDirectoryName(((File)propertyChangeEvent.getNewValue()).getAbsolutePath());
            }
            if (this.getFileChooser().getFileSelectionMode() == 1 && !this.getFileChooser().isMultiSelectionEnabled()) {
                this.setFileName(this.pathField.getText());
            }
            this.directoryComboBoxModel.addItem(file);
            this.directoryListModel.directoryChanged();
        }
        super.doDirectoryChanged(propertyChangeEvent);
    }

    protected void doAccessoryChanged(PropertyChangeEvent propertyChangeEvent) {
        if (this.getAccessoryPanel() != null) {
            JComponent jComponent;
            if (propertyChangeEvent.getOldValue() != null) {
                this.getAccessoryPanel().remove((JComponent)propertyChangeEvent.getOldValue());
            }
            if ((jComponent = (JComponent)propertyChangeEvent.getNewValue()) != null) {
                this.getAccessoryPanel().add((Component)jComponent, "Center");
                this.getAccessoryPanel().setPreferredSize(jComponent.getPreferredSize());
                this.getAccessoryPanel().setMaximumSize(MAX_SIZE);
            } else {
                this.getAccessoryPanel().setPreferredSize(ZERO_ACC_SIZE);
                this.getAccessoryPanel().setMaximumSize(ZERO_ACC_SIZE);
            }
        }
    }

    protected void doFileSelectionModeChanged(PropertyChangeEvent propertyChangeEvent) {
        this.directoryList.clearSelection();
        this.rightPanel.setVisible((Integer)propertyChangeEvent.getNewValue() != 1);
        super.doFileSelectionModeChanged(propertyChangeEvent);
    }

    protected void doMultiSelectionChanged(PropertyChangeEvent propertyChangeEvent) {
        if (this.getFileChooser().isMultiSelectionEnabled()) {
            this.fileList.setSelectionMode(2);
        } else {
            this.fileList.setSelectionMode(0);
            this.fileList.clearSelection();
        }
        super.doMultiSelectionChanged(propertyChangeEvent);
    }

    protected void doControlButtonsChanged(PropertyChangeEvent propertyChangeEvent) {
        super.doControlButtonsChanged(propertyChangeEvent);
        JFileChooser jFileChooser = this.getFileChooser();
        if (jFileChooser.getControlButtonsAreShown()) {
            jFileChooser.add((Component)this.bottomButtonPanel, "South");
        } else {
            jFileChooser.remove(this.bottomButtonPanel);
        }
        this.updateDefaultButton();
    }

    protected void doAncestorChanged(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getOldValue() == null && propertyChangeEvent.getNewValue() != null) {
            this.fileNameTextField.selectAll();
            this.fileNameTextField.requestFocus();
            this.updateDefaultButton();
        }
        super.doAncestorChanged(propertyChangeEvent);
    }

    public ListSelectionListener createListSelectionListener(JFileChooser jFileChooser) {
        return new SelectionListener();
    }

    protected MouseListener createDoubleClickListener(JFileChooser jFileChooser, JList jList) {
        return new DoubleClickListener(jList);
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new GTKFileChooserUI((JFileChooser)jComponent);
    }

    public void installUI(JComponent jComponent) {
        this.accessoryPanel = new JPanel(new BorderLayout(10, 10));
        this.accessoryPanel.setName("GTKFileChooser.accessoryPanel");
        super.installUI(jComponent);
    }

    public void uninstallUI(JComponent jComponent) {
        jComponent.removePropertyChangeListener(this.filterComboBoxModel);
        super.uninstallUI(jComponent);
        if (this.accessoryPanel != null) {
            this.accessoryPanel.removeAll();
        }
        this.accessoryPanel = null;
        this.getFileChooser().removeAll();
    }

    public void installComponents(JFileChooser jFileChooser) {
        JButton jButton;
        super.installComponents(jFileChooser);
        boolean bl = jFileChooser.getComponentOrientation().isLeftToRight();
        jFileChooser.setLayout(new BorderLayout());
        jFileChooser.setAlignmentX(0.5f);
        JPanel jPanel = new JPanel(new FlowLayout(3, 0, 0));
        jPanel.setBorder(new EmptyBorder(10, 10, 0, 10));
        jPanel.setName("GTKFileChooser.topButtonPanel");
        if (!UIManager.getBoolean("FileChooser.readOnly")) {
            jButton = new JButton(this.getNewFolderAction());
            jButton.setName("GTKFileChooser.newFolderButton");
            jButton.setMnemonic(this.newFolderButtonMnemonic);
            jButton.setToolTipText(this.newFolderButtonToolTipText);
            jButton.setText(this.newFolderButtonText);
            jPanel.add(jButton);
        }
        jButton = new JButton(this.deleteFileButtonText);
        jButton.setName("GTKFileChooser.deleteFileButton");
        jButton.setMnemonic(this.deleteFileButtonMnemonic);
        jButton.setToolTipText(this.deleteFileButtonToolTipText);
        jButton.setEnabled(false);
        jPanel.add(jButton);
        RenameFileAction renameFileAction = new RenameFileAction();
        JButton jButton2 = new JButton(renameFileAction);
        if (this.readOnly) {
            renameFileAction.setEnabled(false);
        }
        jButton2.setText(this.renameFileButtonText);
        jButton2.setName("GTKFileChooser.renameFileButton");
        jButton2.setMnemonic(this.renameFileButtonMnemonic);
        jButton2.setToolTipText(this.renameFileButtonToolTipText);
        jPanel.add(jButton2);
        jFileChooser.add((Component)jPanel, "North");
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(new EmptyBorder(0, 10, 10, 10));
        jPanel2.setName("GTKFileChooser.interiorPanel");
        this.align(jPanel2);
        jPanel2.setLayout(new BoxLayout(jPanel2, 3));
        jFileChooser.add((Component)jPanel2, "Center");
        JPanel jPanel3 = new JPanel(new FlowLayout(1, 0, 0){

            public void layoutContainer(Container container) {
                super.layoutContainer(container);
                JComboBox jComboBox = GTKFileChooserUI.this.directoryComboBox;
                if (jComboBox.getWidth() > container.getWidth()) {
                    jComboBox.setBounds(0, jComboBox.getY(), container.getWidth(), jComboBox.getHeight());
                }
            }
        });
        jPanel3.setBorder(new EmptyBorder(0, 0, 4, 0));
        jPanel3.setName("GTKFileChooser.directoryComboBoxPanel");
        this.directoryComboBoxModel = this.createDirectoryComboBoxModel(jFileChooser);
        this.directoryComboBox = new JComboBox(this.directoryComboBoxModel);
        this.directoryComboBox.setName("GTKFileChooser.directoryComboBox");
        this.directoryComboBox.putClientProperty("JComboBox.lightweightKeyboardNavigation", "Lightweight");
        this.directoryComboBox.addActionListener(this.directoryComboBoxAction);
        this.directoryComboBox.setMaximumRowCount(8);
        jPanel3.add(this.directoryComboBox);
        jPanel2.add(jPanel3);
        JPanel jPanel4 = new JPanel(new BorderLayout());
        jPanel4.setName("GTKFileChooser.centerPanel");
        JSplitPane jSplitPane = new JSplitPane();
        jSplitPane.setName("GTKFileChooser.splitPanel");
        jSplitPane.setDividerLocation((GTKFileChooserUI.PREF_SIZE.width - 8) / 2);
        JPanel jPanel5 = new JPanel(new GridBagLayout());
        jPanel5.setName("GTKFileChooser.directoryListPanel");
        TableCellRenderer tableCellRenderer = new JTableHeader().getDefaultRenderer();
        JLabel jLabel = (JLabel)tableCellRenderer.getTableCellRendererComponent(null, this.foldersLabelText, false, false, 0, 0);
        jLabel.setName("GTKFileChooser.directoryListLabel");
        jPanel5.add((Component)jLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        jPanel5.add((Component)this.createDirectoryList(), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 13, 1, new Insets(0, 0, 0, 0), 0, 0));
        jLabel.setDisplayedMnemonic(this.foldersLabelMnemonic);
        jLabel.setLabelFor(this.directoryList);
        this.rightPanel = new JPanel(new GridBagLayout());
        this.rightPanel.setName("GTKFileChooser.fileListPanel");
        tableCellRenderer = new JTableHeader().getDefaultRenderer();
        JLabel jLabel2 = (JLabel)tableCellRenderer.getTableCellRendererComponent(null, this.filesLabelText, false, false, 0, 0);
        jLabel2.setName("GTKFileChooser.fileListLabel");
        this.rightPanel.add((Component)jLabel2, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.rightPanel.add((Component)this.createFilesList(), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 13, 1, new Insets(0, 0, 0, 0), 0, 0));
        jLabel2.setDisplayedMnemonic(this.filesLabelMnemonic);
        jLabel2.setLabelFor(this.fileList);
        jSplitPane.add((Component)jPanel5, bl ? "left" : "right");
        jSplitPane.add((Component)this.rightPanel, bl ? "right" : "left");
        jPanel4.add((Component)jSplitPane, "Center");
        JPanel jPanel6 = this.getAccessoryPanel();
        JComponent jComponent = jFileChooser.getAccessory();
        if (jPanel6 != null) {
            if (jComponent == null) {
                jPanel6.setPreferredSize(ZERO_ACC_SIZE);
                jPanel6.setMaximumSize(ZERO_ACC_SIZE);
            } else {
                this.getAccessoryPanel().add((Component)jComponent, "Center");
                jPanel6.setPreferredSize(jComponent.getPreferredSize());
                jPanel6.setMaximumSize(MAX_SIZE);
            }
            this.align(jPanel6);
            jPanel4.add((Component)jPanel6, "After");
        }
        jPanel2.add(jPanel4);
        jPanel2.add(Box.createRigidArea(vstrut10));
        JPanel jPanel7 = new JPanel(new FlowLayout(3, 0, 0));
        jPanel7.setBorder(new EmptyBorder(0, 0, 4, 0));
        JLabel jLabel3 = new JLabel(this.pathLabelText);
        jLabel3.setName("GTKFileChooser.pathFieldLabel");
        jLabel3.setDisplayedMnemonic(this.pathLabelMnemonic);
        this.align(jLabel3);
        jPanel7.add(jLabel3);
        jPanel7.add(Box.createRigidArea(hstrut3));
        File file = jFileChooser.getCurrentDirectory();
        String string = null;
        if (file != null) {
            string = file.getPath();
        }
        this.pathField = new JLabel(string){

            public Dimension getMaximumSize() {
                Dimension dimension = super.getMaximumSize();
                dimension.height = this.getPreferredSize().height;
                return dimension;
            }
        };
        this.pathField.setName("GTKFileChooser.pathField");
        this.align(this.pathField);
        jPanel7.add(this.pathField);
        jPanel2.add(jPanel7);
        this.fileNameTextField = new JTextField(){

            public Dimension getMaximumSize() {
                Dimension dimension = super.getMaximumSize();
                dimension.height = this.getPreferredSize().height;
                return dimension;
            }
        };
        jLabel3.setLabelFor(this.fileNameTextField);
        Set<AWTKeyStroke> set = this.fileNameTextField.getFocusTraversalKeys(0);
        set = new HashSet<AWTKeyStroke>(set);
        set.remove(KeyStroke.getKeyStroke(9, 0));
        this.fileNameTextField.setFocusTraversalKeys(0, set);
        this.fileNameTextField.setName("GTKFileChooser.fileNameTextField");
        this.fileNameTextField.getActionMap().put("fileNameCompletionAction", this.getFileNameCompletionAction());
        this.fileNameTextField.getInputMap().put(KeyStroke.getKeyStroke(9, 0), "fileNameCompletionAction");
        jPanel2.add(this.fileNameTextField);
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout(new FlowLayout(3, 0, 0));
        jPanel8.setBorder(new EmptyBorder(0, 0, 4, 0));
        JLabel jLabel4 = new JLabel(this.filterLabelText);
        jLabel4.setName("GTKFileChooser.filterLabel");
        jLabel4.setDisplayedMnemonic(this.filterLabelMnemonic);
        jPanel8.add(jLabel4);
        this.filterComboBoxModel = this.createFilterComboBoxModel();
        jFileChooser.addPropertyChangeListener(this.filterComboBoxModel);
        this.filterComboBox = new JComboBox(this.filterComboBoxModel);
        this.filterComboBox.setRenderer(this.createFilterComboBoxRenderer());
        jLabel4.setLabelFor(this.filterComboBox);
        jPanel2.add(Box.createRigidArea(vstrut10));
        jPanel2.add(jPanel8);
        jPanel2.add(this.filterComboBox);
        this.bottomButtonPanel = new JPanel(new FlowLayout(4));
        this.bottomButtonPanel.setName("GTKFileChooser.bottomButtonPanel");
        this.align(this.bottomButtonPanel);
        JPanel jPanel9 = new JPanel(new GridLayout(1, 2, 5, 0));
        JButton jButton3 = this.getCancelButton(jFileChooser);
        this.align(jButton3);
        jButton3.setMargin(buttonMargin);
        jPanel9.add(jButton3);
        JButton jButton4 = this.getApproveButton(jFileChooser);
        this.align(jButton4);
        jButton4.setMargin(buttonMargin);
        jPanel9.add(jButton4);
        this.bottomButtonPanel.add(jPanel9);
        if (jFileChooser.getControlButtonsAreShown()) {
            jFileChooser.add((Component)this.bottomButtonPanel, "South");
        }
    }

    protected void installListeners(JFileChooser jFileChooser) {
        super.installListeners(jFileChooser);
        this.gtkFCPropertyChangeListener = new GTKFCPropertyChangeListener();
        jFileChooser.addPropertyChangeListener(this.gtkFCPropertyChangeListener);
    }

    private int getMnemonic(String string, Locale locale) {
        return SwingUtilities2.getUIDefaultsInt((Object)string, locale);
    }

    protected void uninstallListeners(JFileChooser jFileChooser) {
        super.uninstallListeners(jFileChooser);
        if (this.gtkFCPropertyChangeListener != null) {
            jFileChooser.removePropertyChangeListener(this.gtkFCPropertyChangeListener);
        }
    }

    protected void installDefaults(JFileChooser jFileChooser) {
        super.installDefaults(jFileChooser);
        this.readOnly = UIManager.getBoolean("FileChooser.readOnly");
        this.showDirectoryIcons = Boolean.TRUE.equals(jFileChooser.getClientProperty("GTKFileChooser.showDirectoryIcons"));
        this.showFileIcons = Boolean.TRUE.equals(jFileChooser.getClientProperty("GTKFileChooser.showFileIcons"));
    }

    protected void installIcons(JFileChooser jFileChooser) {
        this.directoryIcon = UIManager.getIcon("FileView.directoryIcon");
        this.fileIcon = UIManager.getIcon("FileView.fileIcon");
    }

    protected void installStrings(JFileChooser jFileChooser) {
        super.installStrings(jFileChooser);
        Locale locale = jFileChooser.getLocale();
        this.newFolderDialogText = UIManager.getString((Object)"FileChooser.newFolderDialogText", locale);
        this.newFolderErrorText = UIManager.getString((Object)"FileChooser.newFolderErrorText", locale);
        this.newFolderErrorSeparator = UIManager.getString((Object)"FileChooser.newFolderErrorSeparator", locale);
        this.newFolderButtonText = UIManager.getString((Object)"FileChooser.newFolderButtonText", locale);
        this.newFolderNoDirectoryErrorTitleText = UIManager.getString((Object)"FileChooser.newFolderNoDirectoryErrorTitleText", locale);
        this.newFolderNoDirectoryErrorText = UIManager.getString((Object)"FileChooser.newFolderNoDirectoryErrorText", locale);
        this.deleteFileButtonText = UIManager.getString((Object)"FileChooser.deleteFileButtonText", locale);
        this.renameFileButtonText = UIManager.getString((Object)"FileChooser.renameFileButtonText", locale);
        this.newFolderButtonMnemonic = this.getMnemonic("FileChooser.newFolderButtonMnemonic", locale);
        this.deleteFileButtonMnemonic = this.getMnemonic("FileChooser.deleteFileButtonMnemonic", locale);
        this.renameFileButtonMnemonic = this.getMnemonic("FileChooser.renameFileButtonMnemonic", locale);
        this.newFolderButtonToolTipText = UIManager.getString((Object)"FileChooser.newFolderButtonToolTipText", locale);
        this.deleteFileButtonToolTipText = UIManager.getString((Object)"FileChooser.deleteFileButtonToolTipText", locale);
        this.renameFileButtonToolTipText = UIManager.getString((Object)"FileChooser.renameFileButtonToolTipText", locale);
        this.renameFileDialogText = UIManager.getString((Object)"FileChooser.renameFileDialogText", locale);
        this.renameFileErrorTitle = UIManager.getString((Object)"FileChooser.renameFileErrorTitle", locale);
        this.renameFileErrorText = UIManager.getString((Object)"FileChooser.renameFileErrorText", locale);
        this.foldersLabelText = UIManager.getString((Object)"FileChooser.foldersLabelText", locale);
        this.foldersLabelMnemonic = this.getMnemonic("FileChooser.foldersLabelMnemonic", locale);
        this.filesLabelText = UIManager.getString((Object)"FileChooser.filesLabelText", locale);
        this.filesLabelMnemonic = this.getMnemonic("FileChooser.filesLabelMnemonic", locale);
        this.pathLabelText = UIManager.getString((Object)"FileChooser.pathLabelText", locale);
        this.pathLabelMnemonic = this.getMnemonic("FileChooser.pathLabelMnemonic", locale);
        this.filterLabelText = UIManager.getString((Object)"FileChooser.filterLabelText", locale);
        this.filterLabelMnemonic = UIManager.getInt("FileChooser.filterLabelMnemonic");
    }

    protected void uninstallStrings(JFileChooser jFileChooser) {
        super.uninstallStrings(jFileChooser);
        this.newFolderButtonText = null;
        this.deleteFileButtonText = null;
        this.renameFileButtonText = null;
        this.newFolderButtonToolTipText = null;
        this.deleteFileButtonToolTipText = null;
        this.renameFileButtonToolTipText = null;
        this.renameFileDialogText = null;
        this.renameFileErrorTitle = null;
        this.renameFileErrorText = null;
        this.foldersLabelText = null;
        this.filesLabelText = null;
        this.pathLabelText = null;
        this.newFolderDialogText = null;
        this.newFolderErrorText = null;
        this.newFolderErrorSeparator = null;
    }

    protected JScrollPane createFilesList() {
        this.fileList = new JList();
        this.fileList.setName("GTKFileChooser.fileList");
        this.fileList.putClientProperty("AccessibleName", this.filesLabelText);
        if (this.getFileChooser().isMultiSelectionEnabled()) {
            this.fileList.setSelectionMode(2);
        } else {
            this.fileList.setSelectionMode(0);
        }
        this.fileList.setModel(new GTKFileListModel());
        this.fileList.getSelectionModel().removeSelectionInterval(0, 0);
        this.fileList.setCellRenderer(new FileCellRenderer());
        this.fileList.addListSelectionListener(this.createListSelectionListener(this.getFileChooser()));
        this.fileList.addMouseListener(this.createDoubleClickListener(this.getFileChooser(), this.fileList));
        this.align(this.fileList);
        JScrollPane jScrollPane = new JScrollPane(this.fileList);
        jScrollPane.setVerticalScrollBarPolicy(22);
        jScrollPane.setName("GTKFileChooser.fileListScrollPane");
        jScrollPane.setPreferredSize(prefListSize);
        jScrollPane.setMaximumSize(MAX_SIZE);
        this.align(jScrollPane);
        return jScrollPane;
    }

    protected JScrollPane createDirectoryList() {
        this.directoryList = new JList();
        this.directoryList.setName("GTKFileChooser.directoryList");
        this.directoryList.putClientProperty("AccessibleName", this.foldersLabelText);
        this.align(this.directoryList);
        this.directoryList.setCellRenderer(new DirectoryCellRenderer());
        this.directoryListModel = new GTKDirectoryListModel();
        this.directoryList.getSelectionModel().removeSelectionInterval(0, 0);
        this.directoryList.setModel(this.directoryListModel);
        this.directoryList.addMouseListener(this.createDoubleClickListener(this.getFileChooser(), this.directoryList));
        this.directoryList.addListSelectionListener(this.createListSelectionListener(this.getFileChooser()));
        JScrollPane jScrollPane = new JScrollPane(this.directoryList);
        jScrollPane.setVerticalScrollBarPolicy(22);
        jScrollPane.setName("GTKFileChooser.directoryListScrollPane");
        jScrollPane.setMaximumSize(MAX_SIZE);
        jScrollPane.setPreferredSize(prefListSize);
        this.align(jScrollPane);
        return jScrollPane;
    }

    protected void createModel() {
        this.model = new GTKDirectoryModel();
    }

    public BasicDirectoryModel getModel() {
        return this.model;
    }

    public Action getApproveSelectionAction() {
        return this.approveSelectionAction;
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        Dimension dimension;
        Dimension dimension2 = new Dimension(PREF_SIZE);
        JComponent jComponent2 = this.getFileChooser().getAccessory();
        if (jComponent2 != null) {
            dimension2.width += jComponent2.getPreferredSize().width + 20;
        }
        if ((dimension = jComponent.getLayout().preferredLayoutSize(jComponent)) != null) {
            return new Dimension(dimension.width < dimension2.width ? dimension2.width : dimension.width, dimension.height < dimension2.height ? dimension2.height : dimension.height);
        }
        return dimension2;
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        return new Dimension(MIN_SIZE);
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    protected void align(JComponent jComponent) {
        jComponent.setAlignmentX(0.0f);
        jComponent.setAlignmentY(0.0f);
    }

    public Action getNewFolderAction() {
        if (this.newFolderAction == null) {
            this.newFolderAction = new NewFolderAction();
            this.newFolderAction.setEnabled(!this.readOnly);
        }
        return this.newFolderAction;
    }

    protected DirectoryComboBoxModel createDirectoryComboBoxModel(JFileChooser jFileChooser) {
        return new DirectoryComboBoxModel();
    }

    protected FilterComboBoxRenderer createFilterComboBoxRenderer() {
        return new FilterComboBoxRenderer();
    }

    protected FilterComboBoxModel createFilterComboBoxModel() {
        return new FilterComboBoxModel();
    }

    static /* synthetic */ void access$500(GTKFileChooserUI gTKFileChooserUI, boolean bl) {
        gTKFileChooserUI.setDirectorySelected(bl);
    }

    static /* synthetic */ void access$600(GTKFileChooserUI gTKFileChooserUI, File file) {
        gTKFileChooserUI.setDirectory(file);
    }

    static /* synthetic */ void access$700(GTKFileChooserUI gTKFileChooserUI, boolean bl) {
        gTKFileChooserUI.setDirectorySelected(bl);
    }

    static /* synthetic */ void access$800(GTKFileChooserUI gTKFileChooserUI, boolean bl) {
        gTKFileChooserUI.setDirectorySelected(bl);
    }

    static /* synthetic */ void access$900(GTKFileChooserUI gTKFileChooserUI, File file) {
        gTKFileChooserUI.setDirectory(file);
    }

    static /* synthetic */ void access$1000(GTKFileChooserUI gTKFileChooserUI, boolean bl) {
        gTKFileChooserUI.setDirectorySelected(bl);
    }

    protected class FilterComboBoxModel
    extends AbstractListModel
    implements ComboBoxModel,
    PropertyChangeListener {
        protected FileFilter[] filters;

        protected FilterComboBoxModel() {
            this.filters = GTKFileChooserUI.this.getFileChooser().getChoosableFileFilters();
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string == "ChoosableFileFilterChangedProperty") {
                this.filters = (FileFilter[])propertyChangeEvent.getNewValue();
                this.fireContentsChanged(this, -1, -1);
            } else if (string == "fileFilterChanged") {
                this.fireContentsChanged(this, -1, -1);
            }
        }

        public void setSelectedItem(Object object) {
            if (object != null) {
                GTKFileChooserUI.this.getFileChooser().setFileFilter((FileFilter)object);
                this.fireContentsChanged(this, -1, -1);
            }
        }

        public Object getSelectedItem() {
            FileFilter fileFilter = GTKFileChooserUI.this.getFileChooser().getFileFilter();
            boolean bl = false;
            if (fileFilter != null) {
                for (FileFilter fileFilter2 : this.filters) {
                    if (fileFilter2 != fileFilter) continue;
                    bl = true;
                }
                if (!bl) {
                    GTKFileChooserUI.this.getFileChooser().addChoosableFileFilter(fileFilter);
                }
            }
            return GTKFileChooserUI.this.getFileChooser().getFileFilter();
        }

        public int getSize() {
            if (this.filters != null) {
                return this.filters.length;
            }
            return 0;
        }

        public Object getElementAt(int n) {
            if (n > this.getSize() - 1) {
                return GTKFileChooserUI.this.getFileChooser().getFileFilter();
            }
            if (this.filters != null) {
                return this.filters[n];
            }
            return null;
        }
    }

    public class FilterComboBoxRenderer
    extends DefaultListCellRenderer
    implements UIResource {
        public String getName() {
            String string = super.getName();
            if (string == null) {
                return "ComboBox.renderer";
            }
            return string;
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            super.getListCellRendererComponent(jList, object, n, bl, bl2);
            this.setName("ComboBox.listRenderer");
            if (object != null) {
                if (object instanceof FileFilter) {
                    this.setText(((FileFilter)object).getDescription());
                }
            } else {
                this.setText("");
            }
            return this;
        }
    }

    private class RenameFileAction
    extends AbstractAction {
        protected RenameFileAction() {
            super("editFileName");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (GTKFileChooserUI.this.getFileName().equals("")) {
                return;
            }
            JFileChooser jFileChooser = GTKFileChooserUI.this.getFileChooser();
            File file = jFileChooser.getCurrentDirectory();
            String string = (String)JOptionPane.showInputDialog(jFileChooser, new MessageFormat(GTKFileChooserUI.this.renameFileDialogText).format(new Object[]{GTKFileChooserUI.this.getFileName()}), GTKFileChooserUI.this.renameFileButtonText, -1, null, null, GTKFileChooserUI.this.getFileName());
            if (string != null) {
                File file2 = jFileChooser.getFileSystemView().createFileObject(file, GTKFileChooserUI.this.getFileName());
                File file3 = jFileChooser.getFileSystemView().createFileObject(file, string);
                if (file2 == null || file3 == null || !GTKFileChooserUI.this.getModel().renameFile(file2, file3)) {
                    JOptionPane.showMessageDialog(jFileChooser, new MessageFormat(GTKFileChooserUI.this.renameFileErrorText).format(new Object[]{GTKFileChooserUI.this.getFileName(), string}), GTKFileChooserUI.this.renameFileErrorTitle, 0);
                } else {
                    GTKFileChooserUI.this.setFileName(GTKFileChooserUI.this.getFileChooser().getName(file3));
                    jFileChooser.rescanCurrentDirectory();
                }
            }
        }
    }

    private class GTKApproveSelectionAction
    extends BasicFileChooserUI.ApproveSelectionAction {
        private GTKApproveSelectionAction() {
            super(GTKFileChooserUI.this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (GTKFileChooserUI.this.isDirectorySelected()) {
                File file = GTKFileChooserUI.this.getDirectory();
                try {
                    if (file != null) {
                        file = ShellFolder.getNormalizedFile(file);
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (GTKFileChooserUI.this.getFileChooser().getCurrentDirectory().equals(file)) {
                    GTKFileChooserUI.this.directoryList.clearSelection();
                    GTKFileChooserUI.this.fileList.clearSelection();
                    ListSelectionModel listSelectionModel = GTKFileChooserUI.this.fileList.getSelectionModel();
                    if (listSelectionModel instanceof DefaultListSelectionModel) {
                        ((DefaultListSelectionModel)listSelectionModel).moveLeadSelectionIndex(0);
                        listSelectionModel.setAnchorSelectionIndex(0);
                    }
                    GTKFileChooserUI.this.rescanCurrentDirectory(GTKFileChooserUI.this.getFileChooser());
                    return;
                }
            }
            super.actionPerformed(actionEvent);
        }
    }

    private class NewFolderAction
    extends AbstractAction {
        protected NewFolderAction() {
            super("New Folder");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (GTKFileChooserUI.this.readOnly) {
                return;
            }
            JFileChooser jFileChooser = GTKFileChooserUI.this.getFileChooser();
            File file = jFileChooser.getCurrentDirectory();
            String string = JOptionPane.showInputDialog(jFileChooser, GTKFileChooserUI.this.newFolderDialogText, GTKFileChooserUI.this.newFolderButtonText, -1);
            if (string != null) {
                if (!file.exists()) {
                    JOptionPane.showMessageDialog(jFileChooser, MessageFormat.format(GTKFileChooserUI.this.newFolderNoDirectoryErrorText, string), GTKFileChooserUI.this.newFolderNoDirectoryErrorTitleText, 0);
                    return;
                }
                File file2 = jFileChooser.getFileSystemView().createFileObject(file, string);
                if (file2 == null || !file2.mkdir()) {
                    JOptionPane.showMessageDialog(jFileChooser, GTKFileChooserUI.this.newFolderErrorText + GTKFileChooserUI.this.newFolderErrorSeparator + " \"" + string + "\"", GTKFileChooserUI.this.newFolderErrorText, 0);
                }
                jFileChooser.rescanCurrentDirectory();
            }
        }
    }

    protected class DirectoryComboBoxAction
    extends AbstractAction {
        protected DirectoryComboBoxAction() {
            super("DirectoryComboBoxAction");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            File file = (File)GTKFileChooserUI.this.directoryComboBox.getSelectedItem();
            GTKFileChooserUI.this.getFileChooser().setCurrentDirectory(file);
        }
    }

    protected class DirectoryComboBoxModel
    extends AbstractListModel
    implements ComboBoxModel {
        Vector<File> directories = new Vector();
        File selectedDirectory = null;
        JFileChooser chooser = GTKFileChooserUI.this.getFileChooser();
        FileSystemView fsv = this.chooser.getFileSystemView();

        public DirectoryComboBoxModel() {
            File file = GTKFileChooserUI.this.getFileChooser().getCurrentDirectory();
            if (file != null) {
                this.addItem(file);
            }
        }

        private void addItem(File file) {
            File file2;
            if (file == null) {
                return;
            }
            int n = this.directories.size();
            this.directories.clear();
            if (n > 0) {
                this.fireIntervalRemoved(this, 0, n);
            }
            try {
                file2 = this.fsv.createFileObject(ShellFolder.getNormalizedFile(file).getPath());
            }
            catch (IOException iOException) {
                file2 = file;
            }
            File file3 = file2;
            do {
                this.directories.add(file3);
            } while ((file3 = file3.getParentFile()) != null);
            int n2 = this.directories.size();
            if (n2 > 0) {
                this.fireIntervalAdded(this, 0, n2);
            }
            this.setSelectedItem(file2);
        }

        public void setSelectedItem(Object object) {
            this.selectedDirectory = (File)object;
            this.fireContentsChanged(this, -1, -1);
        }

        public Object getSelectedItem() {
            return this.selectedDirectory;
        }

        public int getSize() {
            return this.directories.size();
        }

        public Object getElementAt(int n) {
            return this.directories.elementAt(n);
        }
    }

    protected class DirectoryCellRenderer
    extends DefaultListCellRenderer {
        protected DirectoryCellRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            super.getListCellRendererComponent(jList, object, n, bl, bl2);
            if (GTKFileChooserUI.this.showDirectoryIcons) {
                this.setIcon(GTKFileChooserUI.this.getFileChooser().getIcon((File)object));
                this.setText(GTKFileChooserUI.this.getFileChooser().getName((File)object));
            } else {
                this.setText(GTKFileChooserUI.this.getFileChooser().getName((File)object) + "/");
            }
            return this;
        }
    }

    protected class FileCellRenderer
    extends DefaultListCellRenderer {
        protected FileCellRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            super.getListCellRendererComponent(jList, object, n, bl, bl2);
            this.setText(GTKFileChooserUI.this.getFileChooser().getName((File)object));
            if (GTKFileChooserUI.this.showFileIcons) {
                this.setIcon(GTKFileChooserUI.this.getFileChooser().getIcon((File)object));
            }
            return this;
        }
    }

    protected class GTKFileListModel
    extends AbstractListModel
    implements ListDataListener {
        public GTKFileListModel() {
            GTKFileChooserUI.this.getModel().addListDataListener(this);
        }

        public int getSize() {
            return GTKFileChooserUI.this.getModel().getFiles().size();
        }

        public boolean contains(Object object) {
            return GTKFileChooserUI.this.getModel().getFiles().contains(object);
        }

        public int indexOf(Object object) {
            return GTKFileChooserUI.this.getModel().getFiles().indexOf(object);
        }

        public Object getElementAt(int n) {
            return GTKFileChooserUI.this.getModel().getFiles().elementAt(n);
        }

        public void intervalAdded(ListDataEvent listDataEvent) {
            this.fireIntervalAdded(this, listDataEvent.getIndex0(), listDataEvent.getIndex1());
        }

        public void intervalRemoved(ListDataEvent listDataEvent) {
            this.fireIntervalRemoved(this, listDataEvent.getIndex0(), listDataEvent.getIndex1());
        }

        public void fireContentsChanged() {
            this.fireContentsChanged(this, 0, GTKFileChooserUI.this.getModel().getFiles().size() - 1);
        }

        public void contentsChanged(ListDataEvent listDataEvent) {
            this.fireContentsChanged();
        }
    }

    protected class GTKDirectoryListModel
    extends AbstractListModel
    implements ListDataListener {
        File curDir;

        public GTKDirectoryListModel() {
            GTKFileChooserUI.this.getModel().addListDataListener(this);
            this.directoryChanged();
        }

        public int getSize() {
            return GTKFileChooserUI.this.getModel().getDirectories().size() + 1;
        }

        public Object getElementAt(int n) {
            return n > 0 ? GTKFileChooserUI.this.getModel().getDirectories().elementAt(n - 1) : this.curDir;
        }

        public void intervalAdded(ListDataEvent listDataEvent) {
            this.fireIntervalAdded(this, listDataEvent.getIndex0(), listDataEvent.getIndex1());
        }

        public void intervalRemoved(ListDataEvent listDataEvent) {
            this.fireIntervalRemoved(this, listDataEvent.getIndex0(), listDataEvent.getIndex1());
        }

        public void fireContentsChanged() {
            this.fireContentsChanged(this, 0, GTKFileChooserUI.this.getModel().getDirectories().size() - 1);
        }

        public void contentsChanged(ListDataEvent listDataEvent) {
            this.fireContentsChanged();
        }

        private void directoryChanged() {
            this.curDir = GTKFileChooserUI.this.getFileChooser().getFileSystemView().createFileObject(GTKFileChooserUI.this.getFileChooser().getCurrentDirectory(), ".");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class GTKDirectoryModel
    extends BasicDirectoryModel {
        FileSystemView fsv;
        private Comparator<File> fileComparator;

        public GTKDirectoryModel() {
            super(GTKFileChooserUI.this.getFileChooser());
            this.fileComparator = new Comparator<File>(){

                @Override
                public int compare(File file, File file2) {
                    return GTKDirectoryModel.this.fsv.getSystemDisplayName(file).compareTo(GTKDirectoryModel.this.fsv.getSystemDisplayName(file2));
                }
            };
        }

        @Override
        protected void sort(Vector<? extends File> vector) {
            this.fsv = GTKFileChooserUI.this.getFileChooser().getFileSystemView();
            Collections.sort(vector, this.fileComparator);
        }
    }

    private class GTKFCPropertyChangeListener
    implements PropertyChangeListener {
        private GTKFCPropertyChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string.equals("GTKFileChooser.showDirectoryIcons")) {
                GTKFileChooserUI.this.showDirectoryIcons = Boolean.TRUE.equals(propertyChangeEvent.getNewValue());
            } else if (string.equals("GTKFileChooser.showFileIcons")) {
                GTKFileChooserUI.this.showFileIcons = Boolean.TRUE.equals(propertyChangeEvent.getNewValue());
            }
        }
    }

    protected class SelectionListener
    implements ListSelectionListener {
        protected SelectionListener() {
        }

        /*
         * Unable to fully structure code
         */
        public void valueChanged(ListSelectionEvent var1_1) {
            block7: {
                block8: {
                    block9: {
                        if (var1_1.getValueIsAdjusting()) break block7;
                        var2_2 = GTKFileChooserUI.this.getFileChooser();
                        var3_3 = (JList)var1_1.getSource();
                        if (!var2_2.isMultiSelectionEnabled()) break block8;
                        var4_4 = null;
                        var5_6 = var3_3.getSelectedValues();
                        if (var5_6 == null) break block9;
                        if (var5_6.length != 1 || !((File)var5_6[0]).isDirectory() || !var2_2.isTraversable((File)var5_6[0])) ** GOTO lbl-1000
                        if (var2_2.getFileSelectionMode() != 1 || !var2_2.getFileSystemView().isFileSystem((File)var5_6[0])) {
                            GTKFileChooserUI.access$500(GTKFileChooserUI.this, true);
                            GTKFileChooserUI.access$600(GTKFileChooserUI.this, (File)var5_6[0]);
                        } else lbl-1000:
                        // 2 sources

                        {
                            var6_7 = new ArrayList<File>(var5_6.length);
                            for (Object var10_11 : var5_6) {
                                var11_12 = (File)var10_11;
                                if ((!var2_2.isFileSelectionEnabled() || !var11_12.isFile()) && (!var2_2.isDirectorySelectionEnabled() || !var11_12.isDirectory())) continue;
                                var6_7.add(var11_12);
                            }
                            if (var6_7.size() > 0) {
                                var4_4 = var6_7.toArray(new File[var6_7.size()]);
                            }
                            GTKFileChooserUI.access$700(GTKFileChooserUI.this, false);
                        }
                    }
                    var2_2.setSelectedFiles(var4_4);
                    break block7;
                }
                var4_5 = (File)var3_3.getSelectedValue();
                if (var4_5 == null || !var4_5.isDirectory() || !var2_2.isTraversable(var4_5)) ** GOTO lbl-1000
                if (var2_2.getFileSelectionMode() == 0 || !var2_2.getFileSystemView().isFileSystem(var4_5)) {
                    GTKFileChooserUI.access$800(GTKFileChooserUI.this, true);
                    GTKFileChooserUI.access$900(GTKFileChooserUI.this, var4_5);
                } else lbl-1000:
                // 2 sources

                {
                    GTKFileChooserUI.access$1000(GTKFileChooserUI.this, false);
                    if (var4_5 != null) {
                        var2_2.setSelectedFile(var4_5);
                    }
                }
            }
        }
    }

    class DoubleClickListener
    extends MouseAdapter {
        JList list;

        public DoubleClickListener(JList jList) {
            this.list = jList;
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            int n;
            if (SwingUtilities.isLeftMouseButton(mouseEvent) && mouseEvent.getClickCount() == 2 && (n = this.list.locationToIndex(mouseEvent.getPoint())) >= 0) {
                File file = (File)this.list.getModel().getElementAt(n);
                try {
                    file = ShellFolder.getNormalizedFile(file);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (GTKFileChooserUI.this.getFileChooser().isTraversable(file)) {
                    this.list.clearSelection();
                    if (GTKFileChooserUI.this.getFileChooser().getCurrentDirectory().equals(file)) {
                        GTKFileChooserUI.this.rescanCurrentDirectory(GTKFileChooserUI.this.getFileChooser());
                    } else {
                        GTKFileChooserUI.this.getFileChooser().setCurrentDirectory(file);
                    }
                } else {
                    GTKFileChooserUI.this.getFileChooser().approveSelection();
                }
            }
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            if (this.list != null) {
                TransferHandler transferHandler;
                TransferHandler transferHandler2 = GTKFileChooserUI.this.getFileChooser().getTransferHandler();
                if (transferHandler2 != (transferHandler = this.list.getTransferHandler())) {
                    this.list.setTransferHandler(transferHandler2);
                }
                if (GTKFileChooserUI.this.getFileChooser().getDragEnabled() != this.list.getDragEnabled()) {
                    this.list.setDragEnabled(GTKFileChooserUI.this.getFileChooser().getDragEnabled());
                }
            }
        }
    }

    private class GTKFileView
    extends BasicFileChooserUI.BasicFileView {
        public GTKFileView() {
            super(GTKFileChooserUI.this);
            this.iconCache = null;
        }

        public void clearIconCache() {
        }

        public Icon getCachedIcon(File file) {
            return null;
        }

        public void cacheIcon(File file, Icon icon) {
        }

        public Icon getIcon(File file) {
            return file != null && file.isDirectory() ? GTKFileChooserUI.this.directoryIcon : GTKFileChooserUI.this.fileIcon;
        }
    }
}

