/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.stream.events;

import com.sun.org.apache.xerces.internal.util.NamespaceContextWrapper;
import com.sun.org.apache.xerces.internal.util.NamespaceSupport;
import com.sun.xml.internal.stream.events.AttributeImpl;
import com.sun.xml.internal.stream.events.CharacterEvent;
import com.sun.xml.internal.stream.events.CommentEvent;
import com.sun.xml.internal.stream.events.DTDEvent;
import com.sun.xml.internal.stream.events.DummyEvent;
import com.sun.xml.internal.stream.events.EndDocumentEvent;
import com.sun.xml.internal.stream.events.EndElementEvent;
import com.sun.xml.internal.stream.events.EntityDeclarationImpl;
import com.sun.xml.internal.stream.events.EntityReferenceEvent;
import com.sun.xml.internal.stream.events.NamespaceImpl;
import com.sun.xml.internal.stream.events.ProcessingInstructionEvent;
import com.sun.xml.internal.stream.events.StartDocumentEvent;
import com.sun.xml.internal.stream.events.StartElementEvent;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.events.XMLEvent;
import javax.xml.stream.util.XMLEventAllocator;
import javax.xml.stream.util.XMLEventConsumer;

public class XMLEventAllocatorImpl
implements XMLEventAllocator {
    public XMLEvent allocate(XMLStreamReader xMLStreamReader) throws XMLStreamException {
        if (xMLStreamReader == null) {
            throw new XMLStreamException("Reader cannot be null");
        }
        return this.getXMLEvent(xMLStreamReader);
    }

    public void allocate(XMLStreamReader xMLStreamReader, XMLEventConsumer xMLEventConsumer) throws XMLStreamException {
        XMLEvent xMLEvent = this.getXMLEvent(xMLStreamReader);
        if (xMLEvent != null) {
            xMLEventConsumer.add(xMLEvent);
        }
    }

    public XMLEventAllocator newInstance() {
        return new XMLEventAllocatorImpl();
    }

    XMLEvent getXMLEvent(XMLStreamReader xMLStreamReader) {
        DummyEvent dummyEvent = null;
        int n = xMLStreamReader.getEventType();
        switch (n) {
            case 1: {
                StartElementEvent startElementEvent = new StartElementEvent(this.getQName(xMLStreamReader));
                this.fillAttributes(startElementEvent, xMLStreamReader);
                if (((Boolean)xMLStreamReader.getProperty("javax.xml.stream.isNamespaceAware")).booleanValue()) {
                    this.fillNamespaceAttributes(startElementEvent, xMLStreamReader);
                    this.setNamespaceContext(startElementEvent, xMLStreamReader);
                }
                startElementEvent.setLocation(xMLStreamReader.getLocation());
                dummyEvent = startElementEvent;
                break;
            }
            case 2: {
                EndElementEvent endElementEvent = new EndElementEvent(this.getQName(xMLStreamReader));
                endElementEvent.setLocation(xMLStreamReader.getLocation());
                if (((Boolean)xMLStreamReader.getProperty("javax.xml.stream.isNamespaceAware")).booleanValue()) {
                    this.fillNamespaceAttributes(endElementEvent, xMLStreamReader);
                }
                dummyEvent = endElementEvent;
                break;
            }
            case 3: {
                ProcessingInstructionEvent processingInstructionEvent = new ProcessingInstructionEvent(xMLStreamReader.getPITarget(), xMLStreamReader.getPIData());
                processingInstructionEvent.setLocation(xMLStreamReader.getLocation());
                dummyEvent = processingInstructionEvent;
                break;
            }
            case 4: {
                CharacterEvent characterEvent = new CharacterEvent(xMLStreamReader.getText());
                characterEvent.setLocation(xMLStreamReader.getLocation());
                dummyEvent = characterEvent;
                break;
            }
            case 5: {
                CommentEvent commentEvent = new CommentEvent(xMLStreamReader.getText());
                commentEvent.setLocation(xMLStreamReader.getLocation());
                dummyEvent = commentEvent;
                break;
            }
            case 7: {
                StartDocumentEvent startDocumentEvent = new StartDocumentEvent();
                startDocumentEvent.setVersion(xMLStreamReader.getVersion());
                startDocumentEvent.setEncoding(xMLStreamReader.getEncoding());
                if (xMLStreamReader.getCharacterEncodingScheme() != null) {
                    startDocumentEvent.setDeclaredEncoding(true);
                } else {
                    startDocumentEvent.setDeclaredEncoding(false);
                }
                startDocumentEvent.setStandalone(xMLStreamReader.isStandalone());
                startDocumentEvent.setLocation(xMLStreamReader.getLocation());
                dummyEvent = startDocumentEvent;
                break;
            }
            case 8: {
                EndDocumentEvent endDocumentEvent = new EndDocumentEvent();
                endDocumentEvent.setLocation(xMLStreamReader.getLocation());
                dummyEvent = endDocumentEvent;
                break;
            }
            case 9: {
                EntityReferenceEvent entityReferenceEvent = new EntityReferenceEvent(xMLStreamReader.getLocalName(), new EntityDeclarationImpl(xMLStreamReader.getLocalName(), xMLStreamReader.getText()));
                entityReferenceEvent.setLocation(xMLStreamReader.getLocation());
                dummyEvent = entityReferenceEvent;
                break;
            }
            case 10: {
                dummyEvent = null;
                break;
            }
            case 11: {
                dummyEvent = new DTDEvent(xMLStreamReader.getText());
                break;
            }
            case 12: {
                CharacterEvent characterEvent = new CharacterEvent(xMLStreamReader.getText(), true);
                characterEvent.setLocation(xMLStreamReader.getLocation());
                dummyEvent = characterEvent;
                break;
            }
            case 6: {
                CharacterEvent characterEvent = new CharacterEvent(xMLStreamReader.getText(), false, true);
                characterEvent.setLocation(xMLStreamReader.getLocation());
                dummyEvent = characterEvent;
                break;
            }
        }
        return dummyEvent;
    }

    protected XMLEvent getNextEvent(XMLStreamReader xMLStreamReader) throws XMLStreamException {
        xMLStreamReader.next();
        return this.getXMLEvent(xMLStreamReader);
    }

    protected void fillAttributes(StartElementEvent startElementEvent, XMLStreamReader xMLStreamReader) {
        int n = xMLStreamReader.getAttributeCount();
        QName qName = null;
        AttributeImpl attributeImpl = null;
        Object var6_6 = null;
        for (int i = 0; i < n; ++i) {
            qName = xMLStreamReader.getAttributeName(i);
            attributeImpl = new AttributeImpl();
            attributeImpl.setName(qName);
            attributeImpl.setAttributeType(xMLStreamReader.getAttributeType(i));
            attributeImpl.setSpecified(xMLStreamReader.isAttributeSpecified(i));
            attributeImpl.setValue(xMLStreamReader.getAttributeValue(i));
            startElementEvent.addAttribute(attributeImpl);
        }
    }

    protected void fillNamespaceAttributes(StartElementEvent startElementEvent, XMLStreamReader xMLStreamReader) {
        int n = xMLStreamReader.getNamespaceCount();
        String string = null;
        String string2 = null;
        NamespaceImpl namespaceImpl = null;
        for (int i = 0; i < n; ++i) {
            string = xMLStreamReader.getNamespaceURI(i);
            string2 = xMLStreamReader.getNamespacePrefix(i);
            if (string2 == null) {
                string2 = "";
            }
            namespaceImpl = new NamespaceImpl(string2, string);
            startElementEvent.addNamespaceAttribute(namespaceImpl);
        }
    }

    protected void fillNamespaceAttributes(EndElementEvent endElementEvent, XMLStreamReader xMLStreamReader) {
        int n = xMLStreamReader.getNamespaceCount();
        String string = null;
        String string2 = null;
        NamespaceImpl namespaceImpl = null;
        for (int i = 0; i < n; ++i) {
            string = xMLStreamReader.getNamespaceURI(i);
            string2 = xMLStreamReader.getNamespacePrefix(i);
            if (string2 == null) {
                string2 = "";
            }
            namespaceImpl = new NamespaceImpl(string2, string);
            endElementEvent.addNamespace(namespaceImpl);
        }
    }

    private void setNamespaceContext(StartElementEvent startElementEvent, XMLStreamReader xMLStreamReader) {
        NamespaceContextWrapper namespaceContextWrapper = (NamespaceContextWrapper)xMLStreamReader.getNamespaceContext();
        NamespaceSupport namespaceSupport = new NamespaceSupport(namespaceContextWrapper.getNamespaceContext());
        startElementEvent.setNamespaceContext(new NamespaceContextWrapper(namespaceSupport));
    }

    private QName getQName(XMLStreamReader xMLStreamReader) {
        return new QName(xMLStreamReader.getNamespaceURI(), xMLStreamReader.getLocalName(), xMLStreamReader.getPrefix());
    }
}

