/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.security.AccessController;
import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.PropertyPermission;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.spi.LocaleNameProvider;
import sun.security.action.GetPropertyAction;
import sun.util.LocaleServiceProviderPool;
import sun.util.resources.LocaleData;
import sun.util.resources.OpenListResourceBundle;

public final class Locale
implements Cloneable,
Serializable {
    private static final ConcurrentHashMap<String, Locale> cache = new ConcurrentHashMap(32);
    public static final Locale ENGLISH = Locale.createSingleton("en__", "en", "");
    public static final Locale FRENCH = Locale.createSingleton("fr__", "fr", "");
    public static final Locale GERMAN = Locale.createSingleton("de__", "de", "");
    public static final Locale ITALIAN = Locale.createSingleton("it__", "it", "");
    public static final Locale JAPANESE = Locale.createSingleton("ja__", "ja", "");
    public static final Locale KOREAN = Locale.createSingleton("ko__", "ko", "");
    public static final Locale CHINESE = Locale.createSingleton("zh__", "zh", "");
    public static final Locale SIMPLIFIED_CHINESE = Locale.createSingleton("zh_CN_", "zh", "CN");
    public static final Locale TRADITIONAL_CHINESE = Locale.createSingleton("zh_TW_", "zh", "TW");
    public static final Locale FRANCE = Locale.createSingleton("fr_FR_", "fr", "FR");
    public static final Locale GERMANY = Locale.createSingleton("de_DE_", "de", "DE");
    public static final Locale ITALY = Locale.createSingleton("it_IT_", "it", "IT");
    public static final Locale JAPAN = Locale.createSingleton("ja_JP_", "ja", "JP");
    public static final Locale KOREA = Locale.createSingleton("ko_KR_", "ko", "KR");
    public static final Locale CHINA = SIMPLIFIED_CHINESE;
    public static final Locale PRC = SIMPLIFIED_CHINESE;
    public static final Locale TAIWAN = TRADITIONAL_CHINESE;
    public static final Locale UK = Locale.createSingleton("en_GB_", "en", "GB");
    public static final Locale US = Locale.createSingleton("en_US_", "en", "US");
    public static final Locale CANADA = Locale.createSingleton("en_CA_", "en", "CA");
    public static final Locale CANADA_FRENCH = Locale.createSingleton("fr_CA_", "fr", "CA");
    public static final Locale ROOT = Locale.createSingleton("__", "", "");
    static final long serialVersionUID = 9149081749638150636L;
    private static final int DISPLAY_LANGUAGE = 0;
    private static final int DISPLAY_COUNTRY = 1;
    private static final int DISPLAY_VARIANT = 2;
    private final String language;
    private final String country;
    private final String variant;
    private volatile int hashcode = -1;
    private volatile transient int hashCodeValue = 0;
    private static Locale defaultLocale = null;
    private static volatile String[] isoLanguages = null;
    private static volatile String[] isoCountries = null;

    public Locale(String string, String string2, String string3) {
        this.language = this.convertOldISOCodes(string);
        this.country = this.toUpperCase(string2).intern();
        this.variant = string3.intern();
    }

    public Locale(String string, String string2) {
        this(string, string2, "");
    }

    public Locale(String string) {
        this(string, "", "");
    }

    private Locale(String string, String string2, boolean bl) {
        this.language = string;
        this.country = string2;
        this.variant = "";
    }

    private static Locale createSingleton(String string, String string2, String string3) {
        Locale locale = new Locale(string2, string3, false);
        cache.put(string, locale);
        return locale;
    }

    static Locale getInstance(String string, String string2, String string3) {
        Locale locale;
        if (string == null || string2 == null || string3 == null) {
            throw new NullPointerException();
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string).append('_').append(string2).append('_').append(string3);
        String string4 = stringBuilder.toString();
        Locale locale2 = cache.get(string4);
        if (locale2 == null && (locale = cache.putIfAbsent(string4, locale2 = new Locale(string, string2, string3))) != null) {
            locale2 = locale;
        }
        return locale2;
    }

    public static Locale getDefault() {
        if (defaultLocale == null) {
            String string;
            String string2;
            String string3 = AccessController.doPrivileged(new GetPropertyAction("user.language", "en"));
            String string4 = AccessController.doPrivileged(new GetPropertyAction("user.region"));
            if (string4 != null) {
                int n = string4.indexOf(95);
                if (n >= 0) {
                    string2 = string4.substring(0, n);
                    string = string4.substring(n + 1);
                } else {
                    string2 = string4;
                    string = "";
                }
            } else {
                string2 = AccessController.doPrivileged(new GetPropertyAction("user.country", ""));
                string = AccessController.doPrivileged(new GetPropertyAction("user.variant", ""));
            }
            defaultLocale = Locale.getInstance(string3, string2, string);
        }
        return defaultLocale;
    }

    public static synchronized void setDefault(Locale locale) {
        if (locale == null) {
            throw new NullPointerException("Can't set default locale to NULL");
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new PropertyPermission("user.language", "write"));
        }
        defaultLocale = locale;
    }

    public static Locale[] getAvailableLocales() {
        return LocaleServiceProviderPool.getAllAvailableLocales();
    }

    public static String[] getISOCountries() {
        if (isoCountries == null) {
            isoCountries = Locale.getISO2Table("ADANDAEAREAFAFGAGATGAIAIAALALBAMARMANANTAOAGOAQATAARARGASASMATAUTAUAUSAWABWAXALAAZAZEBABIHBBBRBBDBGDBEBELBFBFABGBGRBHBHRBIBDIBJBENBLBLMBMBMUBNBRNBOBOLBRBRABSBHSBTBTNBVBVTBWBWABYBLRBZBLZCACANCCCCKCDCODCFCAFCGCOGCHCHECICIVCKCOKCLCHLCMCMRCNCHNCOCOLCRCRICUCUBCVCPVCXCXRCYCYPCZCZEDEDEUDJDJIDKDNKDMDMADODOMDZDZAECECUEEESTEGEGYEHESHERERIESESPETETHFIFINFJFJIFKFLKFMFSMFOFROFRFRAGAGABGBGBRGDGRDGEGEOGFGUFGGGGYGHGHAGIGIBGLGRLGMGMBGNGINGPGLPGQGNQGRGRCGSSGSGTGTMGUGUMGWGNBGYGUYHKHKGHMHMDHNHNDHRHRVHTHTIHUHUNIDIDNIEIRLILISRIMIMNININDIOIOTIQIRQIRIRNISISLITITAJEJEYJMJAMJOJORJPJPNKEKENKGKGZKHKHMKIKIRKMCOMKNKNAKPPRKKRKORKWKWTKYCYMKZKAZLALAOLBLBNLCLCALILIELKLKALRLBRLSLSOLTLTULULUXLVLVALYLBYMAMARMCMCOMDMDAMEMNEMFMAFMGMDGMHMHLMKMKDMLMLIMMMMRMNMNGMOMACMPMNPMQMTQMRMRTMSMSRMTMLTMUMUSMVMDVMWMWIMXMEXMYMYSMZMOZNANAMNCNCLNENERNFNFKNGNGANINICNLNLDNONORNPNPLNRNRUNUNIUNZNZLOMOMNPAPANPEPERPFPYFPGPNGPHPHLPKPAKPLPOLPMSPMPNPCNPRPRIPSPSEPTPRTPWPLWPYPRYQAQATREREUROROURSSRBRURUSRWRWASASAUSBSLBSCSYCSDSDNSESWESGSGPSHSHNSISVNSJSJMSKSVKSLSLESMSMRSNSENSOSOMSRSURSTSTPSVSLVSYSYRSZSWZTCTCATDTCDTFATFTGTGOTHTHATJTJKTKTKLTLTLSTMTKMTNTUNTOTONTRTURTTTTOTVTUVTWTWNTZTZAUAUKRUGUGAUMUMIUSUSAUYURYUZUZBVAVATVCVCTVEVENVGVGBVIVIRVNVNMVUVUTWFWLFWSWSMYEYEMYTMYTZAZAFZMZMBZWZWE");
        }
        String[] stringArray = new String[isoCountries.length];
        System.arraycopy(isoCountries, 0, stringArray, 0, isoCountries.length);
        return stringArray;
    }

    public static String[] getISOLanguages() {
        if (isoLanguages == null) {
            isoLanguages = Locale.getISO2Table("aaaarababkaeaveafafrakakaamamhanargararaasasmavavaayaymazazebabakbebelbgbulbhbihbibisbmbambnbenbobodbrbrebsboscacatcechechchacocoscrcrecscescuchucvchvcycymdadandedeudvdivdzdzoeeeweelellenengeoepoesspaetesteueusfafasfffulfifinfjfijfofaofrfrafyfrygaglegdglaglglggngrngugujgvglvhahauhehebhihinhohmohrhrvhthathuhunhyhyehzheriainaidindieileigiboiiiiiikipkinindioidoisislititaiuikuiwhebjajpnjiyidjvjavkakatkgkonkikikkjkuakkkazklkalkmkhmknkankokorkrkaukskaskukurkvkomkwcorkykirlalatlbltzlgluglilimlnlinlolaoltlitlulublvlavmgmlgmhmahmimrimkmkdmlmalmnmonmomolmrmarmsmsamtmltmymyananaunbnobndndenenepngndonlnldnnnnononornrnblnvnavnynyaocociojojiomormororiososspapanpipliplpolpspusptporququermrohrnrunroronrurusrwkinsasanscsrdsdsndsesmesgsagsisinskslkslslvsmsmosnsnasosomsqsqisrsrpsssswstsotsusunsvsweswswatatamteteltgtgkththatitirtktuktltgltntsntotontrturtstsotttattwtwitytahuguigukukrururduzuzbvevenvivievovolwawlnwowolxhxhoyiyidyoyorzazhazhzhozuzul");
        }
        String[] stringArray = new String[isoLanguages.length];
        System.arraycopy(isoLanguages, 0, stringArray, 0, isoLanguages.length);
        return stringArray;
    }

    private static final String[] getISO2Table(String string) {
        int n = string.length() / 5;
        String[] stringArray = new String[n];
        int n2 = 0;
        int n3 = 0;
        while (n2 < n) {
            stringArray[n2] = string.substring(n3, n3 + 2);
            ++n2;
            n3 += 5;
        }
        return stringArray;
    }

    public String getLanguage() {
        return this.language;
    }

    public String getCountry() {
        return this.country;
    }

    public String getVariant() {
        return this.variant;
    }

    public final String toString() {
        boolean bl = this.language.length() != 0;
        boolean bl2 = this.country.length() != 0;
        boolean bl3 = this.variant.length() != 0;
        StringBuilder stringBuilder = new StringBuilder(this.language);
        if (bl2 || bl && bl3) {
            stringBuilder.append('_').append(this.country);
        }
        if (bl3 && (bl || bl2)) {
            stringBuilder.append('_').append(this.variant);
        }
        return stringBuilder.toString();
    }

    public String getISO3Language() throws MissingResourceException {
        String string = Locale.getISO3Code(this.language, "aaaarababkaeaveafafrakakaamamhanargararaasasmavavaayaymazazebabakbebelbgbulbhbihbibisbmbambnbenbobodbrbrebsboscacatcechechchacocoscrcrecscescuchucvchvcycymdadandedeudvdivdzdzoeeeweelellenengeoepoesspaetesteueusfafasfffulfifinfjfijfofaofrfrafyfrygaglegdglaglglggngrngugujgvglvhahauhehebhihinhohmohrhrvhthathuhunhyhyehzheriainaidindieileigiboiiiiiikipkinindioidoisislititaiuikuiwhebjajpnjiyidjvjavkakatkgkonkikikkjkuakkkazklkalkmkhmknkankokorkrkaukskaskukurkvkomkwcorkykirlalatlbltzlgluglilimlnlinlolaoltlitlulublvlavmgmlgmhmahmimrimkmkdmlmalmnmonmomolmrmarmsmsamtmltmymyananaunbnobndndenenepngndonlnldnnnnononornrnblnvnavnynyaocociojojiomormororiososspapanpipliplpolpspusptporququermrohrnrunroronrurusrwkinsasanscsrdsdsndsesmesgsagsisinskslkslslvsmsmosnsnasosomsqsqisrsrpsssswstsotsusunsvsweswswatatamteteltgtgkththatitirtktuktltgltntsntotontrturtstsotttattwtwitytahuguigukukrururduzuzbvevenvivievovolwawlnwowolxhxhoyiyidyoyorzazhazhzhozuzul");
        if (string == null) {
            throw new MissingResourceException("Couldn't find 3-letter language code for " + this.language, "FormatData_" + this.toString(), "ShortLanguage");
        }
        return string;
    }

    public String getISO3Country() throws MissingResourceException {
        String string = Locale.getISO3Code(this.country, "ADANDAEAREAFAFGAGATGAIAIAALALBAMARMANANTAOAGOAQATAARARGASASMATAUTAUAUSAWABWAXALAAZAZEBABIHBBBRBBDBGDBEBELBFBFABGBGRBHBHRBIBDIBJBENBLBLMBMBMUBNBRNBOBOLBRBRABSBHSBTBTNBVBVTBWBWABYBLRBZBLZCACANCCCCKCDCODCFCAFCGCOGCHCHECICIVCKCOKCLCHLCMCMRCNCHNCOCOLCRCRICUCUBCVCPVCXCXRCYCYPCZCZEDEDEUDJDJIDKDNKDMDMADODOMDZDZAECECUEEESTEGEGYEHESHERERIESESPETETHFIFINFJFJIFKFLKFMFSMFOFROFRFRAGAGABGBGBRGDGRDGEGEOGFGUFGGGGYGHGHAGIGIBGLGRLGMGMBGNGINGPGLPGQGNQGRGRCGSSGSGTGTMGUGUMGWGNBGYGUYHKHKGHMHMDHNHNDHRHRVHTHTIHUHUNIDIDNIEIRLILISRIMIMNININDIOIOTIQIRQIRIRNISISLITITAJEJEYJMJAMJOJORJPJPNKEKENKGKGZKHKHMKIKIRKMCOMKNKNAKPPRKKRKORKWKWTKYCYMKZKAZLALAOLBLBNLCLCALILIELKLKALRLBRLSLSOLTLTULULUXLVLVALYLBYMAMARMCMCOMDMDAMEMNEMFMAFMGMDGMHMHLMKMKDMLMLIMMMMRMNMNGMOMACMPMNPMQMTQMRMRTMSMSRMTMLTMUMUSMVMDVMWMWIMXMEXMYMYSMZMOZNANAMNCNCLNENERNFNFKNGNGANINICNLNLDNONORNPNPLNRNRUNUNIUNZNZLOMOMNPAPANPEPERPFPYFPGPNGPHPHLPKPAKPLPOLPMSPMPNPCNPRPRIPSPSEPTPRTPWPLWPYPRYQAQATREREUROROURSSRBRURUSRWRWASASAUSBSLBSCSYCSDSDNSESWESGSGPSHSHNSISVNSJSJMSKSVKSLSLESMSMRSNSENSOSOMSRSURSTSTPSVSLVSYSYRSZSWZTCTCATDTCDTFATFTGTGOTHTHATJTJKTKTKLTLTLSTMTKMTNTUNTOTONTRTURTTTTOTVTUVTWTWNTZTZAUAUKRUGUGAUMUMIUSUSAUYURYUZUZBVAVATVCVCTVEVENVGVGBVIVIRVNVNMVUVUTWFWLFWSWSMYEYEMYTMYTZAZAFZMZMBZWZWE");
        if (string == null) {
            throw new MissingResourceException("Couldn't find 3-letter country code for " + this.country, "FormatData_" + this.toString(), "ShortCountry");
        }
        return string;
    }

    private static final String getISO3Code(String string, String string2) {
        int n;
        int n2 = string.length();
        if (n2 == 0) {
            return "";
        }
        int n3 = n = string2.length();
        if (n2 == 2) {
            char c = string.charAt(0);
            char c2 = string.charAt(1);
            for (n3 = 0; n3 < n && (string2.charAt(n3) != c || string2.charAt(n3 + 1) != c2); n3 += 5) {
            }
        }
        return n3 < n ? string2.substring(n3 + 2, n3 + 5) : null;
    }

    public final String getDisplayLanguage() {
        return this.getDisplayLanguage(Locale.getDefault());
    }

    public String getDisplayLanguage(Locale locale) {
        return this.getDisplayString(this.language, locale, 0);
    }

    public final String getDisplayCountry() {
        return this.getDisplayCountry(Locale.getDefault());
    }

    public String getDisplayCountry(Locale locale) {
        return this.getDisplayString(this.country, locale, 1);
    }

    private String getDisplayString(String string, Locale locale, int n) {
        if (string.length() == 0) {
            return "";
        }
        if (locale == null) {
            throw new NullPointerException();
        }
        try {
            OpenListResourceBundle openListResourceBundle = LocaleData.getLocaleNames(locale);
            String string2 = n == 2 ? "%%" + string : string;
            String string3 = null;
            LocaleServiceProviderPool localeServiceProviderPool = LocaleServiceProviderPool.getPool(LocaleNameProvider.class);
            if (localeServiceProviderPool.hasProviders()) {
                string3 = localeServiceProviderPool.getLocalizedObject(LocaleNameGetter.INSTANCE, locale, openListResourceBundle, string2, n, string);
            }
            if (string3 == null) {
                string3 = openListResourceBundle.getString(string2);
            }
            if (string3 != null) {
                return string3;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }

    public final String getDisplayVariant() {
        return this.getDisplayVariant(Locale.getDefault());
    }

    public String getDisplayVariant(Locale locale) {
        if (this.variant.length() == 0) {
            return "";
        }
        OpenListResourceBundle openListResourceBundle = LocaleData.getLocaleNames(locale);
        String[] stringArray = this.getDisplayVariantArray(openListResourceBundle, locale);
        String string = null;
        String string2 = null;
        try {
            string = openListResourceBundle.getString("ListPattern");
            string2 = openListResourceBundle.getString("ListCompositionPattern");
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        return Locale.formatList(stringArray, string, string2);
    }

    public final String getDisplayName() {
        return this.getDisplayName(Locale.getDefault());
    }

    public String getDisplayName(Locale locale) {
        OpenListResourceBundle openListResourceBundle = LocaleData.getLocaleNames(locale);
        String string = this.getDisplayLanguage(locale);
        String string2 = this.getDisplayCountry(locale);
        String[] stringArray = this.getDisplayVariantArray(openListResourceBundle, locale);
        String string3 = null;
        String string4 = null;
        String string5 = null;
        try {
            string3 = openListResourceBundle.getString("DisplayNamePattern");
            string4 = openListResourceBundle.getString("ListPattern");
            string5 = openListResourceBundle.getString("ListCompositionPattern");
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        String string6 = null;
        String[] stringArray2 = null;
        if (string.length() != 0) {
            string6 = string;
            if (string2.length() != 0) {
                stringArray2 = new String[stringArray.length + 1];
                System.arraycopy(stringArray, 0, stringArray2, 1, stringArray.length);
                stringArray2[0] = string2;
            } else {
                stringArray2 = stringArray;
            }
        } else if (string2.length() != 0) {
            string6 = string2;
            stringArray2 = stringArray;
        } else {
            return Locale.formatList(stringArray, string4, string5);
        }
        Object[] objectArray = new Object[]{new Integer(stringArray2.length != 0 ? 2 : 1), string6, stringArray2.length != 0 ? Locale.formatList(stringArray2, string4, string5) : null};
        if (string3 != null) {
            return new MessageFormat(string3).format(objectArray);
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append((String)objectArray[1]);
        if (objectArray.length > 2) {
            stringBuilder.append(" (");
            stringBuilder.append((String)objectArray[2]);
            stringBuilder.append(')');
        }
        return stringBuilder.toString();
    }

    public Object clone() {
        try {
            Locale locale = (Locale)super.clone();
            return locale;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public int hashCode() {
        int n = this.hashCodeValue;
        if (n == 0) {
            this.hashCodeValue = n = this.language.hashCode() << 8 ^ this.country.hashCode() ^ this.variant.hashCode() << 4;
        }
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Locale)) {
            return false;
        }
        Locale locale = (Locale)object;
        return this.language == locale.language && this.country == locale.country && this.variant == locale.variant;
    }

    private String[] getDisplayVariantArray(OpenListResourceBundle openListResourceBundle, Locale locale) {
        StringTokenizer stringTokenizer = new StringTokenizer(this.variant, "_");
        String[] stringArray = new String[stringTokenizer.countTokens()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = this.getDisplayString(stringTokenizer.nextToken(), locale, 2);
        }
        return stringArray;
    }

    private static String formatList(String[] stringArray, String string, String string2) {
        Object[] objectArray;
        if (string == null || string2 == null) {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < stringArray.length; ++i) {
                if (i > 0) {
                    stringBuffer.append(',');
                }
                stringBuffer.append(stringArray[i]);
            }
            return stringBuffer.toString();
        }
        if (stringArray.length > 3) {
            objectArray = new MessageFormat(string2);
            stringArray = Locale.composeList((MessageFormat)objectArray, stringArray);
        }
        objectArray = new Object[stringArray.length + 1];
        System.arraycopy(stringArray, 0, objectArray, 1, stringArray.length);
        objectArray[0] = new Integer(stringArray.length);
        MessageFormat messageFormat = new MessageFormat(string);
        return messageFormat.format(objectArray);
    }

    private static String[] composeList(MessageFormat messageFormat, String[] stringArray) {
        if (stringArray.length <= 3) {
            return stringArray;
        }
        String[] stringArray2 = new String[]{stringArray[0], stringArray[1]};
        String string = messageFormat.format(stringArray2);
        String[] stringArray3 = new String[stringArray.length - 1];
        System.arraycopy(stringArray, 2, stringArray3, 1, stringArray3.length - 1);
        stringArray3[0] = string;
        return Locale.composeList(messageFormat, stringArray3);
    }

    private Object readResolve() throws ObjectStreamException {
        return Locale.getInstance(this.language, this.country, this.variant);
    }

    private String toLowerCase(String string) {
        char[] cArray = new char[string.length()];
        for (int i = 0; i < cArray.length; ++i) {
            cArray[i] = Character.toLowerCase(string.charAt(i));
        }
        return new String(cArray);
    }

    private String toUpperCase(String string) {
        char[] cArray = new char[string.length()];
        for (int i = 0; i < cArray.length; ++i) {
            cArray[i] = Character.toUpperCase(string.charAt(i));
        }
        return new String(cArray);
    }

    private String convertOldISOCodes(String string) {
        if ((string = this.toLowerCase(string).intern()) == "he") {
            return "iw";
        }
        if (string == "yi") {
            return "ji";
        }
        if (string == "id") {
            return "in";
        }
        return string;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LocaleNameGetter
    implements LocaleServiceProviderPool.LocalizedObjectGetter<LocaleNameProvider, String> {
        private static final LocaleNameGetter INSTANCE = new LocaleNameGetter();

        private LocaleNameGetter() {
        }

        @Override
        public String getObject(LocaleNameProvider localeNameProvider, Locale locale, String string, Object ... objectArray) {
            assert (objectArray.length == 2);
            int n = (Integer)objectArray[0];
            String string2 = (String)objectArray[1];
            switch (n) {
                case 0: {
                    return localeNameProvider.getDisplayLanguage(string2, locale);
                }
                case 1: {
                    return localeNameProvider.getDisplayCountry(string2, locale);
                }
                case 2: {
                    return localeNameProvider.getDisplayVariant(string2, locale);
                }
            }
            assert (false);
            return null;
        }
    }
}

