/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.awt.Container;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.JPasswordField;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.FieldView;
import javax.swing.text.Position;
import javax.swing.text.Utilities;
import sun.swing.SwingUtilities2;

public class PasswordView
extends FieldView {
    static char[] ONE = new char[1];

    public PasswordView(Element element) {
        super(element);
    }

    protected int drawUnselectedText(Graphics graphics, int n, int n2, int n3, int n4) throws BadLocationException {
        Container container = this.getContainer();
        if (container instanceof JPasswordField) {
            JPasswordField jPasswordField = (JPasswordField)container;
            if (!jPasswordField.echoCharIsSet()) {
                return super.drawUnselectedText(graphics, n, n2, n3, n4);
            }
            if (jPasswordField.isEnabled()) {
                graphics.setColor(jPasswordField.getForeground());
            } else {
                graphics.setColor(jPasswordField.getDisabledTextColor());
            }
            char c = jPasswordField.getEchoChar();
            int n5 = n4 - n3;
            for (int i = 0; i < n5; ++i) {
                n = this.drawEchoCharacter(graphics, n, n2, c);
            }
        }
        return n;
    }

    protected int drawSelectedText(Graphics graphics, int n, int n2, int n3, int n4) throws BadLocationException {
        graphics.setColor(this.selected);
        Container container = this.getContainer();
        if (container instanceof JPasswordField) {
            JPasswordField jPasswordField = (JPasswordField)container;
            if (!jPasswordField.echoCharIsSet()) {
                return super.drawSelectedText(graphics, n, n2, n3, n4);
            }
            char c = jPasswordField.getEchoChar();
            int n5 = n4 - n3;
            for (int i = 0; i < n5; ++i) {
                n = this.drawEchoCharacter(graphics, n, n2, c);
            }
        }
        return n;
    }

    protected int drawEchoCharacter(Graphics graphics, int n, int n2, char c) {
        PasswordView.ONE[0] = c;
        SwingUtilities2.drawChars(Utilities.getJComponent(this), graphics, ONE, 0, 1, n, n2);
        return n + graphics.getFontMetrics().charWidth(c);
    }

    public Shape modelToView(int n, Shape shape, Position.Bias bias) throws BadLocationException {
        Container container = this.getContainer();
        if (container instanceof JPasswordField) {
            JPasswordField jPasswordField = (JPasswordField)container;
            if (!jPasswordField.echoCharIsSet()) {
                return super.modelToView(n, shape, bias);
            }
            char c = jPasswordField.getEchoChar();
            FontMetrics fontMetrics = jPasswordField.getFontMetrics(jPasswordField.getFont());
            Rectangle rectangle = this.adjustAllocation(shape).getBounds();
            int n2 = (n - this.getStartOffset()) * fontMetrics.charWidth(c);
            rectangle.x += n2;
            rectangle.width = 1;
            return rectangle;
        }
        return null;
    }

    public int viewToModel(float f, float f2, Shape shape, Position.Bias[] biasArray) {
        biasArray[0] = Position.Bias.Forward;
        int n = 0;
        Container container = this.getContainer();
        if (container instanceof JPasswordField) {
            JPasswordField jPasswordField = (JPasswordField)container;
            if (!jPasswordField.echoCharIsSet()) {
                return super.viewToModel(f, f2, shape, biasArray);
            }
            char c = jPasswordField.getEchoChar();
            int n2 = jPasswordField.getFontMetrics(jPasswordField.getFont()).charWidth(c);
            Rectangle rectangle = (shape = this.adjustAllocation(shape)) instanceof Rectangle ? (Rectangle)shape : shape.getBounds();
            int n3 = n = n2 > 0 ? ((int)f - rectangle.x) / n2 : Integer.MAX_VALUE;
            if (n < 0) {
                n = 0;
            } else if (n > this.getStartOffset() + this.getDocument().getLength()) {
                n = this.getDocument().getLength() - this.getStartOffset();
            }
        }
        return this.getStartOffset() + n;
    }

    public float getPreferredSpan(int n) {
        switch (n) {
            case 0: {
                JPasswordField jPasswordField;
                Container container = this.getContainer();
                if (!(container instanceof JPasswordField) || !(jPasswordField = (JPasswordField)container).echoCharIsSet()) break;
                char c = jPasswordField.getEchoChar();
                FontMetrics fontMetrics = jPasswordField.getFontMetrics(jPasswordField.getFont());
                Document document = this.getDocument();
                return fontMetrics.charWidth(c) * this.getDocument().getLength();
            }
        }
        return super.getPreferredSpan(n);
    }
}

