/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xerces.internal.jaxp.validation;

import com.sun.org.apache.xerces.internal.impl.XMLErrorReporter;
import com.sun.org.apache.xerces.internal.impl.msg.XMLMessageFormatter;
import com.sun.org.apache.xerces.internal.impl.xs.XMLSchemaValidator;
import com.sun.org.apache.xerces.internal.jaxp.validation.JAXPValidationMessageFormatter;
import com.sun.org.apache.xerces.internal.jaxp.validation.Util;
import com.sun.org.apache.xerces.internal.jaxp.validation.ValidatorHandlerImpl;
import com.sun.org.apache.xerces.internal.jaxp.validation.ValidatorHelper;
import com.sun.org.apache.xerces.internal.jaxp.validation.XMLSchemaValidatorComponentManager;
import com.sun.org.apache.xerces.internal.parsers.XML11Configuration;
import com.sun.org.apache.xerces.internal.xni.XNIException;
import com.sun.org.apache.xerces.internal.xni.parser.XMLInputSource;
import com.sun.org.apache.xerces.internal.xni.parser.XMLParseException;
import com.sun.org.apache.xerces.internal.xni.parser.XMLParserConfiguration;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.util.Locale;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.xml.sax.SAXException;

final class StreamValidatorHelper
implements ValidatorHelper {
    private static final String PARSER_SETTINGS = "http://apache.org/xml/features/internal/parser-settings";
    private static final String ENTITY_RESOLVER = "http://apache.org/xml/properties/internal/entity-resolver";
    private static final String ERROR_HANDLER = "http://apache.org/xml/properties/internal/error-handler";
    private static final String ERROR_REPORTER = "http://apache.org/xml/properties/internal/error-reporter";
    private static final String SCHEMA_VALIDATOR = "http://apache.org/xml/properties/internal/validator/schema";
    private static final String SYMBOL_TABLE = "http://apache.org/xml/properties/internal/symbol-table";
    private static final String VALIDATION_MANAGER = "http://apache.org/xml/properties/internal/validation-manager";
    private SoftReference fConfiguration = new SoftReference<Object>(null);
    private XMLSchemaValidator fSchemaValidator;
    private XMLSchemaValidatorComponentManager fComponentManager;
    private ValidatorHandlerImpl handler = null;

    public StreamValidatorHelper(XMLSchemaValidatorComponentManager xMLSchemaValidatorComponentManager) {
        this.fComponentManager = xMLSchemaValidatorComponentManager;
        this.fSchemaValidator = (XMLSchemaValidator)this.fComponentManager.getProperty(SCHEMA_VALIDATOR);
    }

    public void validate(Source source, Result result) throws SAXException, IOException {
        if (result == null || result instanceof StreamResult) {
            Object object;
            StreamSource streamSource = (StreamSource)source;
            if (result != null) {
                TransformerHandler transformerHandler;
                try {
                    object = (SAXTransformerFactory)SAXTransformerFactory.newInstance();
                    transformerHandler = ((SAXTransformerFactory)object).newTransformerHandler();
                }
                catch (TransformerConfigurationException transformerConfigurationException) {
                    throw new TransformerFactoryConfigurationError(transformerConfigurationException);
                }
                this.handler = new ValidatorHandlerImpl(this.fComponentManager);
                this.handler.setContentHandler(transformerHandler);
                transformerHandler.setResult(result);
            }
            object = new XMLInputSource(streamSource.getPublicId(), streamSource.getSystemId(), null);
            ((XMLInputSource)object).setByteStream(streamSource.getInputStream());
            ((XMLInputSource)object).setCharacterStream(streamSource.getReader());
            XMLParserConfiguration xMLParserConfiguration = (XMLParserConfiguration)this.fConfiguration.get();
            if (xMLParserConfiguration == null) {
                xMLParserConfiguration = this.initialize();
            } else if (this.fComponentManager.getFeature(PARSER_SETTINGS)) {
                xMLParserConfiguration.setProperty(ENTITY_RESOLVER, this.fComponentManager.getProperty(ENTITY_RESOLVER));
                xMLParserConfiguration.setProperty(ERROR_HANDLER, this.fComponentManager.getProperty(ERROR_HANDLER));
            }
            this.fComponentManager.reset();
            this.fSchemaValidator.setDocumentHandler(this.handler);
            try {
                xMLParserConfiguration.parse((XMLInputSource)object);
            }
            catch (XMLParseException xMLParseException) {
                throw Util.toSAXParseException(xMLParseException);
            }
            catch (XNIException xNIException) {
                throw Util.toSAXException(xNIException);
            }
            return;
        }
        throw new IllegalArgumentException(JAXPValidationMessageFormatter.formatMessage(Locale.getDefault(), "SourceResultMismatch", new Object[]{source.getClass().getName(), result.getClass().getName()}));
    }

    private XMLParserConfiguration initialize() {
        XML11Configuration xML11Configuration = new XML11Configuration();
        xML11Configuration.setProperty(ENTITY_RESOLVER, this.fComponentManager.getProperty(ENTITY_RESOLVER));
        xML11Configuration.setProperty(ERROR_HANDLER, this.fComponentManager.getProperty(ERROR_HANDLER));
        XMLErrorReporter xMLErrorReporter = (XMLErrorReporter)this.fComponentManager.getProperty(ERROR_REPORTER);
        xML11Configuration.setProperty(ERROR_REPORTER, xMLErrorReporter);
        if (xMLErrorReporter.getMessageFormatter("http://www.w3.org/TR/1998/REC-xml-19980210") == null) {
            XMLMessageFormatter xMLMessageFormatter = new XMLMessageFormatter();
            xMLErrorReporter.putMessageFormatter("http://www.w3.org/TR/1998/REC-xml-19980210", xMLMessageFormatter);
            xMLErrorReporter.putMessageFormatter("http://www.w3.org/TR/1999/REC-xml-names-19990114", xMLMessageFormatter);
        }
        xML11Configuration.setProperty(SYMBOL_TABLE, this.fComponentManager.getProperty(SYMBOL_TABLE));
        xML11Configuration.setProperty(VALIDATION_MANAGER, this.fComponentManager.getProperty(VALIDATION_MANAGER));
        xML11Configuration.setDocumentHandler(this.fSchemaValidator);
        xML11Configuration.setDTDHandler(null);
        xML11Configuration.setDTDContentModelHandler(null);
        this.fConfiguration = new SoftReference<XML11Configuration>(xML11Configuration);
        return xML11Configuration;
    }
}

