/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.streaming;

import com.sun.xml.internal.ws.streaming.XMLReaderException;
import com.sun.xml.internal.ws.streaming.XMLStreamWriterException;
import com.sun.xml.internal.ws.util.FastInfosetReflection;
import java.io.OutputStream;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamWriter;

public class XMLStreamWriterFactory {
    static XMLOutputFactory xmlOutputFactory;
    static ThreadLocal fiStreamWriter;

    public static XMLStreamWriter createXMLStreamWriter(OutputStream outputStream) {
        return XMLStreamWriterFactory.createXMLStreamWriter(outputStream, "UTF-8");
    }

    public static XMLStreamWriter createXMLStreamWriter(OutputStream outputStream, String string) {
        return XMLStreamWriterFactory.createXMLStreamWriter(outputStream, string, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static XMLStreamWriter createXMLStreamWriter(OutputStream outputStream, String string, boolean bl) {
        try {
            XMLOutputFactory xMLOutputFactory = xmlOutputFactory;
            synchronized (xMLOutputFactory) {
                return xmlOutputFactory.createXMLStreamWriter(outputStream, string);
            }
        }
        catch (Exception exception) {
            throw new XMLReaderException("stax.cantCreate", new Object[]{exception});
        }
    }

    public static XMLStreamWriter createFIStreamWriter(OutputStream outputStream) {
        return XMLStreamWriterFactory.createFIStreamWriter(outputStream, "UTF-8");
    }

    public static XMLStreamWriter createFIStreamWriter(OutputStream outputStream, String string) {
        return XMLStreamWriterFactory.createFIStreamWriter(outputStream, string, true);
    }

    public static XMLStreamWriter createFIStreamWriter(OutputStream outputStream, String string, boolean bl) {
        if (FastInfosetReflection.fiStAXDocumentSerializer_new == null) {
            throw new XMLReaderException("fastinfoset.noImplementation", new Object[0]);
        }
        try {
            Object t = fiStreamWriter.get();
            if (t == null) {
                t = FastInfosetReflection.fiStAXDocumentSerializer_new.newInstance(new Object[0]);
                fiStreamWriter.set(t);
            }
            FastInfosetReflection.fiStAXDocumentSerializer_setOutputStream.invoke(t, outputStream);
            FastInfosetReflection.fiStAXDocumentSerializer_setEncoding.invoke(t, string);
            return (XMLStreamWriter)t;
        }
        catch (Exception exception) {
            throw new XMLStreamWriterException(exception);
        }
    }

    static {
        fiStreamWriter = new ThreadLocal();
        xmlOutputFactory = XMLOutputFactory.newInstance();
    }
}

