/*
 * Decompiled with CFR 0.152.
 */
package javax.management.namespace;

import com.sun.jmx.defaults.JmxProperties;
import com.sun.jmx.mbeanserver.Util;
import java.io.ObjectInputStream;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.DynamicWrapperMBean;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.NotCompliantMBeanException;
import javax.management.NotificationBroadcaster;
import javax.management.NotificationEmitter;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.OperationsException;
import javax.management.QueryEval;
import javax.management.QueryExp;
import javax.management.ReflectionException;
import javax.management.RuntimeOperationsException;
import javax.management.loading.ClassLoaderRepository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MBeanServerSupport
implements MBeanServer {
    private static final Logger LOG = JmxProperties.NAMESPACE_LOGGER;

    protected MBeanServerSupport() {
    }

    public abstract DynamicMBean getDynamicMBeanFor(ObjectName var1) throws InstanceNotFoundException;

    protected abstract Set<ObjectName> getNames();

    protected Set<ObjectName> getMatchingNames(ObjectName objectName) {
        return Util.filterMatchingNames(objectName, this.getNames());
    }

    public NotificationEmitter getNotificationEmitterFor(ObjectName objectName) throws InstanceNotFoundException {
        DynamicMBean dynamicMBean = this.getDynamicMBeanFor(objectName);
        if (dynamicMBean instanceof NotificationEmitter) {
            return (NotificationEmitter)((Object)dynamicMBean);
        }
        return null;
    }

    private NotificationEmitter getNonNullNotificationEmitterFor(ObjectName objectName) throws InstanceNotFoundException {
        NotificationEmitter notificationEmitter = this.getNotificationEmitterFor(objectName);
        if (notificationEmitter == null) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Not a NotificationEmitter: " + objectName);
            throw new RuntimeOperationsException(illegalArgumentException);
        }
        return notificationEmitter;
    }

    public ObjectInstance createMBean(String string, ObjectName objectName, ObjectName objectName2, Object[] objectArray, String[] stringArray, boolean bl) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException {
        throw MBeanServerSupport.newUnsupportedException("createMBean");
    }

    @Override
    public boolean isInstanceOf(ObjectName objectName, String string) throws InstanceNotFoundException {
        DynamicMBean dynamicMBean = this.nonNullMBeanFor(objectName);
        try {
            ClassLoader classLoader;
            Object object;
            Object object2;
            String string2 = dynamicMBean.getMBeanInfo().getClassName();
            if (string2.equals(string)) {
                return true;
            }
            if (dynamicMBean instanceof DynamicWrapperMBean) {
                object2 = (DynamicWrapperMBean)dynamicMBean;
                object = object2.getWrappedObject();
                classLoader = object2.getWrappedClassLoader();
            } else {
                object = dynamicMBean;
                classLoader = dynamicMBean.getClass().getClassLoader();
            }
            object2 = Class.forName(string, false, classLoader);
            if (((Class)object2).isInstance(object)) {
                return true;
            }
            if (object2 == NotificationBroadcaster.class || object2 == NotificationEmitter.class) {
                try {
                    this.getNotificationEmitterFor(objectName);
                    return true;
                }
                catch (Exception exception) {
                    LOG.finest("MBean " + objectName + " is not a notification emitter. Ignoring: " + exception);
                    return false;
                }
            }
            Class<?> clazz = Class.forName(string2, false, classLoader);
            return ((Class)object2).isAssignableFrom(clazz);
        }
        catch (Exception exception) {
            LOG.logp(Level.FINEST, MBeanServerSupport.class.getName(), "isInstanceOf", "Exception calling isInstanceOf", exception);
            return false;
        }
    }

    @Override
    public String getDefaultDomain() {
        return "DefaultDomain";
    }

    @Override
    public Integer getMBeanCount() {
        return this.getNames().size();
    }

    @Override
    public String[] getDomains() {
        Set<ObjectName> set = this.getNames();
        TreeSet<String> treeSet = new TreeSet<String>();
        for (ObjectName objectName : set) {
            if (objectName == null) continue;
            treeSet.add(objectName.getDomain());
        }
        return treeSet.toArray(new String[treeSet.size()]);
    }

    @Override
    public Object getAttribute(ObjectName objectName, String string) throws MBeanException, AttributeNotFoundException, InstanceNotFoundException, ReflectionException {
        DynamicMBean dynamicMBean = this.nonNullMBeanFor(objectName);
        return dynamicMBean.getAttribute(string);
    }

    @Override
    public void setAttribute(ObjectName objectName, Attribute attribute) throws InstanceNotFoundException, AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        DynamicMBean dynamicMBean = this.nonNullMBeanFor(objectName);
        dynamicMBean.setAttribute(attribute);
    }

    @Override
    public AttributeList getAttributes(ObjectName objectName, String[] stringArray) throws InstanceNotFoundException, ReflectionException {
        DynamicMBean dynamicMBean = this.nonNullMBeanFor(objectName);
        return dynamicMBean.getAttributes(stringArray);
    }

    @Override
    public AttributeList setAttributes(ObjectName objectName, AttributeList attributeList) throws InstanceNotFoundException, ReflectionException {
        DynamicMBean dynamicMBean = this.nonNullMBeanFor(objectName);
        return dynamicMBean.setAttributes(attributeList);
    }

    @Override
    public Object invoke(ObjectName objectName, String string, Object[] objectArray, String[] stringArray) throws InstanceNotFoundException, MBeanException, ReflectionException {
        DynamicMBean dynamicMBean = this.nonNullMBeanFor(objectName);
        return dynamicMBean.invoke(string, objectArray, stringArray);
    }

    @Override
    public MBeanInfo getMBeanInfo(ObjectName objectName) throws InstanceNotFoundException, IntrospectionException, ReflectionException {
        DynamicMBean dynamicMBean = this.nonNullMBeanFor(objectName);
        return dynamicMBean.getMBeanInfo();
    }

    @Override
    public ObjectInstance getObjectInstance(ObjectName objectName) throws InstanceNotFoundException {
        DynamicMBean dynamicMBean = this.nonNullMBeanFor(objectName);
        String string = dynamicMBean.getMBeanInfo().getClassName();
        return new ObjectInstance(objectName, string);
    }

    @Override
    public boolean isRegistered(ObjectName objectName) {
        try {
            DynamicMBean dynamicMBean = this.getDynamicMBeanFor(objectName);
            return dynamicMBean != null;
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest("MBean " + objectName + " is not registered: " + instanceNotFoundException);
            }
            return false;
        }
    }

    @Override
    public Set<ObjectInstance> queryMBeans(ObjectName objectName, QueryExp queryExp) {
        Set<ObjectName> set = this.queryNames(objectName, queryExp);
        if (set.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<ObjectInstance> hashSet = new HashSet<ObjectInstance>();
        for (ObjectName objectName2 : set) {
            try {
                hashSet.add(this.getObjectInstance(objectName2));
            }
            catch (SecurityException securityException) {
            }
            catch (InstanceNotFoundException instanceNotFoundException) {}
        }
        return hashSet;
    }

    @Override
    public Set<ObjectName> queryNames(ObjectName objectName, QueryExp queryExp) {
        try {
            Set<ObjectName> set = this.getMatchingNames(objectName);
            return this.filterListOfObjectNames(set, queryExp);
        }
        catch (Exception exception) {
            LOG.fine("Unexpected exception raised in queryNames: " + exception);
            LOG.log(Level.FINEST, "Unexpected exception raised in queryNames", exception);
            return Collections.emptySet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final boolean apply(QueryExp queryExp, ObjectName objectName, MBeanServer mBeanServer) {
        boolean bl = false;
        MBeanServer mBeanServer2 = QueryEval.getMBeanServer();
        queryExp.setMBeanServer(mBeanServer);
        try {
            try {
                bl = queryExp.apply(objectName);
            }
            catch (Exception exception) {
                LOG.finest("QueryExp.apply threw exception, returning false. Cause: " + exception);
                bl = false;
                Object var7_6 = null;
                queryExp.setMBeanServer(mBeanServer2);
            }
            Object var7_5 = null;
            queryExp.setMBeanServer(mBeanServer2);
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            queryExp.setMBeanServer(mBeanServer2);
            throw throwable;
        }
        return bl;
    }

    Set<ObjectName> filterListOfObjectNames(Set<ObjectName> set, QueryExp queryExp) {
        if (set.isEmpty() || queryExp == null) {
            return set;
        }
        HashSet<ObjectName> hashSet = new HashSet<ObjectName>();
        for (ObjectName objectName : set) {
            if (!MBeanServerSupport.apply(queryExp, objectName, this)) continue;
            hashSet.add(objectName);
        }
        return hashSet;
    }

    @Override
    public void addNotificationListener(ObjectName objectName, NotificationListener notificationListener, NotificationFilter notificationFilter, Object object) throws InstanceNotFoundException {
        NotificationEmitter notificationEmitter = this.getNonNullNotificationEmitterFor(objectName);
        notificationEmitter.addNotificationListener(notificationListener, notificationFilter, object);
    }

    @Override
    public void removeNotificationListener(ObjectName objectName, NotificationListener notificationListener) throws InstanceNotFoundException, ListenerNotFoundException {
        NotificationEmitter notificationEmitter = this.getNonNullNotificationEmitterFor(objectName);
        notificationEmitter.removeNotificationListener(notificationListener);
    }

    @Override
    public void removeNotificationListener(ObjectName objectName, NotificationListener notificationListener, NotificationFilter notificationFilter, Object object) throws InstanceNotFoundException, ListenerNotFoundException {
        NotificationEmitter notificationEmitter = this.getNonNullNotificationEmitterFor(objectName);
        notificationEmitter.removeNotificationListener(notificationListener);
    }

    @Override
    public void addNotificationListener(ObjectName objectName, ObjectName objectName2, NotificationFilter notificationFilter, Object object) throws InstanceNotFoundException {
        NotificationListener notificationListener = this.getListenerMBean(objectName2);
        this.addNotificationListener(objectName, notificationListener, notificationFilter, object);
    }

    @Override
    public void removeNotificationListener(ObjectName objectName, ObjectName objectName2) throws InstanceNotFoundException, ListenerNotFoundException {
        NotificationListener notificationListener = this.getListenerMBean(objectName2);
        this.removeNotificationListener(objectName, notificationListener);
    }

    @Override
    public void removeNotificationListener(ObjectName objectName, ObjectName objectName2, NotificationFilter notificationFilter, Object object) throws InstanceNotFoundException, ListenerNotFoundException {
        NotificationListener notificationListener = this.getListenerMBean(objectName2);
        this.removeNotificationListener(objectName, notificationListener, notificationFilter, object);
    }

    private NotificationListener getListenerMBean(ObjectName objectName) throws InstanceNotFoundException {
        DynamicMBean dynamicMBean = this.getDynamicMBeanFor(objectName);
        if (dynamicMBean instanceof NotificationListener) {
            return (NotificationListener)((Object)dynamicMBean);
        }
        throw MBeanServerSupport.newIllegalArgumentException("MBean is not a NotificationListener: " + objectName);
    }

    @Override
    public ClassLoader getClassLoader(ObjectName objectName) throws InstanceNotFoundException {
        UnsupportedOperationException unsupportedOperationException = new UnsupportedOperationException("getClassLoader");
        InstanceNotFoundException instanceNotFoundException = new InstanceNotFoundException(String.valueOf(objectName));
        instanceNotFoundException.initCause(unsupportedOperationException);
        throw instanceNotFoundException;
    }

    @Override
    public ClassLoader getClassLoaderFor(ObjectName objectName) throws InstanceNotFoundException {
        DynamicMBean dynamicMBean = this.nonNullMBeanFor(objectName);
        if (dynamicMBean instanceof DynamicWrapperMBean) {
            return ((DynamicWrapperMBean)dynamicMBean).getWrappedClassLoader();
        }
        return dynamicMBean.getClass().getClassLoader();
    }

    @Override
    public ClassLoaderRepository getClassLoaderRepository() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        return Util.getSingleClassLoaderRepository(classLoader);
    }

    @Override
    public ObjectInstance registerMBean(Object object, ObjectName objectName) throws InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        throw MBeanServerSupport.newUnsupportedException("registerMBean");
    }

    @Override
    public void unregisterMBean(ObjectName objectName) throws InstanceNotFoundException, MBeanRegistrationException {
        throw MBeanServerSupport.newUnsupportedException("unregisterMBean");
    }

    @Override
    public final ObjectInstance createMBean(String string, ObjectName objectName, Object[] objectArray, String[] stringArray) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException {
        try {
            return this.createMBean(string, objectName, null, objectArray, stringArray, true);
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            throw new MBeanException(instanceNotFoundException, "Unexpected exception: " + instanceNotFoundException);
        }
    }

    @Override
    public final ObjectInstance createMBean(String string, ObjectName objectName, ObjectName objectName2, Object[] objectArray, String[] stringArray) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException {
        return this.createMBean(string, objectName, objectName2, objectArray, stringArray, false);
    }

    @Override
    public final ObjectInstance createMBean(String string, ObjectName objectName) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException {
        try {
            return this.createMBean(string, objectName, null, null, null, true);
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            throw new MBeanException(instanceNotFoundException, "Unexpected exception: " + instanceNotFoundException);
        }
    }

    @Override
    public final ObjectInstance createMBean(String string, ObjectName objectName, ObjectName objectName2) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException {
        return this.createMBean(string, objectName, objectName2, null, null, false);
    }

    @Override
    public Object instantiate(String string) throws ReflectionException, MBeanException {
        throw new UnsupportedOperationException("Not applicable.");
    }

    @Override
    public Object instantiate(String string, ObjectName objectName) throws ReflectionException, MBeanException, InstanceNotFoundException {
        throw new UnsupportedOperationException("Not applicable.");
    }

    @Override
    public Object instantiate(String string, Object[] objectArray, String[] stringArray) throws ReflectionException, MBeanException {
        throw new UnsupportedOperationException("Not applicable.");
    }

    @Override
    public Object instantiate(String string, ObjectName objectName, Object[] objectArray, String[] stringArray) throws ReflectionException, MBeanException, InstanceNotFoundException {
        throw new UnsupportedOperationException("Not applicable.");
    }

    @Override
    @Deprecated
    public ObjectInputStream deserialize(ObjectName objectName, byte[] byArray) throws InstanceNotFoundException, OperationsException {
        throw new UnsupportedOperationException("Not applicable.");
    }

    @Override
    @Deprecated
    public ObjectInputStream deserialize(String string, byte[] byArray) throws OperationsException, ReflectionException {
        throw new UnsupportedOperationException("Not applicable.");
    }

    @Override
    @Deprecated
    public ObjectInputStream deserialize(String string, ObjectName objectName, byte[] byArray) throws InstanceNotFoundException, OperationsException, ReflectionException {
        throw new UnsupportedOperationException("Not applicable.");
    }

    private DynamicMBean nonNullMBeanFor(ObjectName objectName) throws InstanceNotFoundException {
        Object object;
        if (objectName == null) {
            throw MBeanServerSupport.newIllegalArgumentException("Null ObjectName");
        }
        if (objectName.getDomain().equals("")) {
            object = this.getDefaultDomain();
            try {
                objectName = objectName.withDomain(this.getDefaultDomain());
            }
            catch (Exception exception) {
                throw MBeanServerSupport.newIllegalArgumentException("Illegal default domain: " + (String)object);
            }
        }
        if ((object = this.getDynamicMBeanFor(objectName)) != null) {
            return object;
        }
        throw new InstanceNotFoundException(String.valueOf(objectName));
    }

    static RuntimeException newUnsupportedException(String string) {
        return new RuntimeOperationsException(new UnsupportedOperationException(string + ": Not supported in this namespace"));
    }

    static RuntimeException newIllegalArgumentException(String string) {
        return new RuntimeOperationsException(new IllegalArgumentException(string));
    }
}

