/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.io.IOException;
import java.util.HashSet;
import java.util.LinkedList;
import sun.nio.ch.AllocatedNativeObject;
import sun.nio.ch.FileDispatcher;

class EPollArrayWrapper {
    static final int EPOLLIN = 1;
    static final int EPOLL_CTL_ADD = 1;
    static final int EPOLL_CTL_DEL = 2;
    static final int EPOLL_CTL_MOD = 3;
    static final int SIZE_EPOLLEVENT = EPollArrayWrapper.sizeofEPollEvent();
    static final int EVENT_OFFSET = 0;
    static final int DATA_OFFSET;
    static final int FD_OFFSET;
    static final int NUM_EPOLLEVENTS;
    private final long pollArrayAddress;
    private final HashSet<Integer> idleSet;
    private LinkedList<Updator> updateList = new LinkedList();
    private AllocatedNativeObject pollArray;
    final int epfd = this.epollCreate();
    int outgoingInterruptFD;
    int incomingInterruptFD;
    int interruptedIndex;
    int updated;
    boolean interrupted = false;

    EPollArrayWrapper() {
        int n = NUM_EPOLLEVENTS * SIZE_EPOLLEVENT;
        this.pollArray = new AllocatedNativeObject(n, true);
        this.pollArrayAddress = this.pollArray.address();
        for (int i = 0; i < NUM_EPOLLEVENTS; ++i) {
            this.putEventOps(i, 0);
            this.putData(i, 0L);
        }
        this.idleSet = new HashSet();
    }

    void initInterrupt(int n, int n2) {
        this.outgoingInterruptFD = n2;
        this.incomingInterruptFD = n;
        this.epollCtl(this.epfd, 1, n, 1);
    }

    void putEventOps(int n, int n2) {
        int n3 = SIZE_EPOLLEVENT * n + 0;
        this.pollArray.putInt(n3, n2);
    }

    void putData(int n, long l) {
        int n2 = SIZE_EPOLLEVENT * n + DATA_OFFSET;
        this.pollArray.putLong(n2, l);
    }

    void putDescriptor(int n, int n2) {
        int n3 = SIZE_EPOLLEVENT * n + FD_OFFSET;
        this.pollArray.putInt(n3, n2);
    }

    int getEventOps(int n) {
        int n2 = SIZE_EPOLLEVENT * n + 0;
        return this.pollArray.getInt(n2);
    }

    int getDescriptor(int n) {
        int n2 = SIZE_EPOLLEVENT * n + FD_OFFSET;
        return this.pollArray.getInt(n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setInterest(int n, int n2) {
        LinkedList<Updator> linkedList = this.updateList;
        synchronized (linkedList) {
            if (n2 == 0) {
                if (this.idleSet.add(n)) {
                    this.updateList.add(new Updator(2, n, 0));
                }
                return;
            }
            if (!this.idleSet.isEmpty() && this.idleSet.remove(n)) {
                this.updateList.add(new Updator(1, n, n2));
                return;
            }
            if (this.updateList.size() > 0) {
                Updator updator = this.updateList.getLast();
                if (updator.fd == n && updator.opcode == 1) {
                    updator.events = n2;
                    return;
                }
            }
            this.updateList.add(new Updator(3, n, n2));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void add(int n) {
        LinkedList<Updator> linkedList = this.updateList;
        synchronized (linkedList) {
            this.updateList.add(new Updator(1, n, 0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void release(int n) {
        LinkedList<Updator> linkedList = this.updateList;
        synchronized (linkedList) {
            if (!this.idleSet.remove(n)) {
                this.updateList.add(new Updator(2, n, 0));
            }
        }
    }

    void closeEPollFD() throws IOException {
        FileDispatcher.closeIntFD(this.epfd);
        this.pollArray.free();
    }

    int poll(long l) throws IOException {
        this.updateRegistrations();
        this.updated = this.epollWait(this.pollArrayAddress, NUM_EPOLLEVENTS, l, this.epfd);
        for (int i = 0; i < this.updated; ++i) {
            if (this.getDescriptor(i) != this.incomingInterruptFD) continue;
            this.interruptedIndex = i;
            this.interrupted = true;
            break;
        }
        return this.updated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateRegistrations() {
        LinkedList<Updator> linkedList = this.updateList;
        synchronized (linkedList) {
            Updator updator = null;
            while ((updator = this.updateList.poll()) != null) {
                this.epollCtl(this.epfd, updator.opcode, updator.fd, updator.events);
            }
        }
    }

    public void interrupt() {
        EPollArrayWrapper.interrupt(this.outgoingInterruptFD);
    }

    public int interruptedIndex() {
        return this.interruptedIndex;
    }

    boolean interrupted() {
        return this.interrupted;
    }

    void clearInterrupted() {
        this.interrupted = false;
    }

    private native int epollCreate();

    private native void epollCtl(int var1, int var2, int var3, int var4);

    private native int epollWait(long var1, int var3, long var4, int var6) throws IOException;

    private static native int sizeofEPollEvent();

    private static native int offsetofData();

    private static native int fdLimit();

    private static native void interrupt(int var0);

    private static native void init();

    static {
        FD_OFFSET = DATA_OFFSET = EPollArrayWrapper.offsetofData();
        NUM_EPOLLEVENTS = Math.min(EPollArrayWrapper.fdLimit(), 8192);
        EPollArrayWrapper.init();
    }

    private static class Updator {
        int opcode;
        int fd;
        int events;

        Updator(int n, int n2, int n3) {
            this.opcode = n;
            this.fd = n2;
            this.events = n3;
        }
    }
}

