/*
 * Decompiled with CFR 0.152.
 */
package com.sun.codemodel.internal;

import com.sun.codemodel.internal.JClass;
import com.sun.codemodel.internal.JCodeModel;
import com.sun.codemodel.internal.JCommentPart;
import com.sun.codemodel.internal.JFormatter;
import com.sun.codemodel.internal.JGenerable;
import com.sun.codemodel.internal.JVar;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDocComment
extends JCommentPart
implements JGenerable {
    private final Map<String, JCommentPart> atParams = new HashMap<String, JCommentPart>();
    private final Map<String, Map<String, String>> atXdoclets = new HashMap<String, Map<String, String>>();
    private final Map<JClass, JCommentPart> atThrows = new HashMap<JClass, JCommentPart>();
    private JCommentPart atReturn = null;
    private JCommentPart atDeprecated = null;
    private final JCodeModel owner;
    private static final String INDENT = " *     ";

    public JDocComment(JCodeModel jCodeModel) {
        this.owner = jCodeModel;
    }

    @Override
    public JDocComment append(Object object) {
        this.add(object);
        return this;
    }

    public JCommentPart addParam(String string) {
        JCommentPart jCommentPart = this.atParams.get(string);
        if (jCommentPart == null) {
            jCommentPart = new JCommentPart();
            this.atParams.put(string, jCommentPart);
        }
        return jCommentPart;
    }

    public JCommentPart addParam(JVar jVar) {
        return this.addParam(jVar.name());
    }

    public JCommentPart addThrows(Class clazz) {
        return this.addThrows(this.owner.ref(clazz));
    }

    public JCommentPart addThrows(JClass jClass) {
        JCommentPart jCommentPart = this.atThrows.get(jClass);
        if (jCommentPart == null) {
            jCommentPart = new JCommentPart();
            this.atThrows.put(jClass, jCommentPart);
        }
        return jCommentPart;
    }

    public JCommentPart addReturn() {
        if (this.atReturn == null) {
            this.atReturn = new JCommentPart();
        }
        return this.atReturn;
    }

    public JCommentPart addDeprecated() {
        if (this.atDeprecated == null) {
            this.atDeprecated = new JCommentPart();
        }
        return this.atDeprecated;
    }

    public Map<String, String> addXdoclet(String string) {
        Map<String, String> map = this.atXdoclets.get(string);
        if (map == null) {
            map = new HashMap<String, String>();
            this.atXdoclets.put(string, map);
        }
        return map;
    }

    public Map<String, String> addXdoclet(String string, Map<String, String> map) {
        Map<String, String> map2 = this.atXdoclets.get(string);
        if (map2 == null) {
            map2 = new HashMap<String, String>();
            this.atXdoclets.put(string, map2);
        }
        map2.putAll(map);
        return map2;
    }

    public Map<String, String> addXdoclet(String string, String string2, String string3) {
        Map<String, String> map = this.atXdoclets.get(string);
        if (map == null) {
            map = new HashMap<String, String>();
            this.atXdoclets.put(string, map);
        }
        map.put(string2, string3);
        return map;
    }

    @Override
    public void generate(JFormatter jFormatter) {
        jFormatter.p("/**").nl();
        this.format(jFormatter, " * ");
        jFormatter.p(" * ").nl();
        for (Map.Entry<String, JCommentPart> entry : this.atParams.entrySet()) {
            jFormatter.p(" * @param ").p(entry.getKey()).nl();
            entry.getValue().format(jFormatter, INDENT);
        }
        if (this.atReturn != null) {
            jFormatter.p(" * @return").nl();
            this.atReturn.format(jFormatter, INDENT);
        }
        for (Map.Entry<Object, JCommentPart> entry : this.atThrows.entrySet()) {
            jFormatter.p(" * @throws ").t((JClass)entry.getKey()).nl();
            entry.getValue().format(jFormatter, INDENT);
        }
        if (this.atDeprecated != null) {
            jFormatter.p(" * @deprecated").nl();
            this.atDeprecated.format(jFormatter, INDENT);
        }
        for (Map.Entry<Object, Object> entry : this.atXdoclets.entrySet()) {
            jFormatter.p(" * @").p((String)entry.getKey());
            if (entry.getValue() != null) {
                for (Map.Entry entry2 : ((Map)entry.getValue()).entrySet()) {
                    jFormatter.p(" ").p((String)entry2.getKey()).p("= \"").p((String)entry2.getValue()).p("\"");
                }
            }
            jFormatter.nl();
        }
        jFormatter.p(" */").nl();
    }
}

