/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.apt.mirror.declaration;

import com.sun.mirror.declaration.AnnotationValue;
import com.sun.mirror.util.SourcePosition;
import com.sun.tools.apt.mirror.AptEnv;
import com.sun.tools.apt.mirror.declaration.AnnotationMirrorImpl;
import com.sun.tools.apt.mirror.declaration.Constants;
import com.sun.tools.javac.code.Attribute;
import java.util.ArrayList;

public class AnnotationValueImpl
implements AnnotationValue {
    protected final AptEnv env;
    protected final Attribute attr;
    protected final AnnotationMirrorImpl annotation;

    AnnotationValueImpl(AptEnv aptEnv, Attribute attribute, AnnotationMirrorImpl annotationMirrorImpl) {
        this.env = aptEnv;
        this.attr = attribute;
        this.annotation = annotationMirrorImpl;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        Constants.Formatter formatter = Constants.getFormatter(stringBuilder);
        formatter.append(this.getValue());
        return formatter.toString();
    }

    public Object getValue() {
        ValueVisitor valueVisitor = new ValueVisitor();
        this.attr.accept(valueVisitor);
        return valueVisitor.value;
    }

    public SourcePosition getPosition() {
        return this.annotation == null ? null : this.annotation.getPosition();
    }

    private class ValueVisitor
    implements Attribute.Visitor {
        public Object value;

        private ValueVisitor() {
        }

        public void visitConstant(Attribute.Constant constant) {
            this.value = Constants.decodeConstant(constant.value, constant.type);
        }

        public void visitClass(Attribute.Class clazz) {
            this.value = AnnotationValueImpl.this.env.typeMaker.getType(AnnotationValueImpl.this.env.jctypes.erasure(clazz.type));
        }

        public void visitEnum(Attribute.Enum enum_) {
            this.value = AnnotationValueImpl.this.env.declMaker.getFieldDeclaration(enum_.value);
        }

        public void visitCompound(Attribute.Compound compound) {
            this.value = new AnnotationMirrorImpl(AnnotationValueImpl.this.env, compound, AnnotationValueImpl.this.annotation == null ? null : AnnotationValueImpl.this.annotation.getDeclaration());
        }

        public void visitArray(Attribute.Array array) {
            ArrayList<AnnotationValueImpl> arrayList = new ArrayList<AnnotationValueImpl>(array.values.length);
            for (Attribute attribute : array.values) {
                arrayList.add(new AnnotationValueImpl(AnnotationValueImpl.this.env, attribute, AnnotationValueImpl.this.annotation));
            }
            this.value = arrayList;
        }

        public void visitError(Attribute.Error error) {
            this.value = "<error>";
        }
    }
}

