/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.doclets.internal.toolkit.builders;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.ConstructorDoc;
import com.sun.javadoc.ProgramElementDoc;
import com.sun.tools.doclets.internal.toolkit.Configuration;
import com.sun.tools.doclets.internal.toolkit.ConstructorWriter;
import com.sun.tools.doclets.internal.toolkit.builders.AbstractMemberBuilder;
import com.sun.tools.doclets.internal.toolkit.util.VisibleMemberMap;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ConstructorBuilder
extends AbstractMemberBuilder {
    public static final String NAME = "ConstructorDetails";
    private int currentMethodIndex;
    private ClassDoc classDoc;
    private VisibleMemberMap visibleMemberMap;
    private ConstructorWriter writer;
    private List<ProgramElementDoc> constructors;

    private ConstructorBuilder(Configuration configuration) {
        super(configuration);
    }

    public static ConstructorBuilder getInstance(Configuration configuration, ClassDoc classDoc, ConstructorWriter constructorWriter) {
        ConstructorBuilder constructorBuilder = new ConstructorBuilder(configuration);
        constructorBuilder.classDoc = classDoc;
        constructorBuilder.writer = constructorWriter;
        constructorBuilder.visibleMemberMap = new VisibleMemberMap(classDoc, 3, configuration.nodeprecated);
        constructorBuilder.constructors = new ArrayList<ProgramElementDoc>(constructorBuilder.visibleMemberMap.getMembersFor(classDoc));
        for (int i = 0; i < constructorBuilder.constructors.size(); ++i) {
            if (!constructorBuilder.constructors.get(i).isProtected() && !constructorBuilder.constructors.get(i).isPrivate()) continue;
            constructorWriter.setFoundNonPubConstructor(true);
        }
        if (configuration.getMemberComparator() != null) {
            Collections.sort(constructorBuilder.constructors, configuration.getMemberComparator());
        }
        return constructorBuilder;
    }

    public String getName() {
        return NAME;
    }

    public boolean hasMembersToDocument() {
        return this.constructors.size() > 0;
    }

    public void invokeMethod(String string, Class[] classArray, Object[] objectArray) throws Exception {
        Method method = this.getClass().getMethod(string, classArray);
        method.invoke((Object)this, objectArray);
    }

    public List members(ClassDoc classDoc) {
        return this.visibleMemberMap.getMembersFor(classDoc);
    }

    public ConstructorWriter getWriter() {
        return this.writer;
    }

    public void buildConstructorDoc(List list) {
        if (this.writer == null) {
            return;
        }
        this.currentMethodIndex = 0;
        while (this.currentMethodIndex < this.constructors.size()) {
            this.build(list);
            ++this.currentMethodIndex;
        }
    }

    public void buildHeader() {
        this.writer.writeHeader(this.classDoc, this.configuration.getText("doclet.Constructor_Detail"));
    }

    public void buildConstructorHeader() {
        this.writer.writeConstructorHeader((ConstructorDoc)this.constructors.get(this.currentMethodIndex), this.currentMethodIndex == 0);
    }

    public void buildSignature() {
        this.writer.writeSignature((ConstructorDoc)this.constructors.get(this.currentMethodIndex));
    }

    public void buildDeprecationInfo() {
        this.writer.writeDeprecated((ConstructorDoc)this.constructors.get(this.currentMethodIndex));
    }

    public void buildConstructorComments() {
        if (!this.configuration.nocomment) {
            this.writer.writeComments((ConstructorDoc)this.constructors.get(this.currentMethodIndex));
        }
    }

    public void buildTagInfo() {
        this.writer.writeTags((ConstructorDoc)this.constructors.get(this.currentMethodIndex));
    }

    public void buildConstructorFooter() {
        this.writer.writeConstructorFooter();
    }

    public void buildFooter() {
        this.writer.writeFooter(this.classDoc);
    }
}

