/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.hat.internal.model;

import com.sun.tools.hat.internal.model.JavaClass;
import com.sun.tools.hat.internal.model.JavaHeapObjectVisitor;
import com.sun.tools.hat.internal.model.JavaThing;
import com.sun.tools.hat.internal.model.Root;
import com.sun.tools.hat.internal.model.Snapshot;
import com.sun.tools.hat.internal.model.StackTrace;
import com.sun.tools.hat.internal.util.Misc;
import java.util.Enumeration;
import java.util.HashMap;

public abstract class JavaHeapObject
extends JavaThing {
    private JavaThing[] referers = null;
    private int referersLen = 0;

    public abstract JavaClass getClazz();

    public abstract int getSize();

    public abstract long getId();

    public void resolve(Snapshot snapshot) {
        StackTrace stackTrace = snapshot.getSiteTrace(this);
        if (stackTrace != null) {
            stackTrace.resolve(snapshot);
        }
    }

    void setupReferers() {
        if (this.referersLen > 1) {
            HashMap<JavaThing, JavaThing> hashMap = new HashMap<JavaThing, JavaThing>();
            for (int i = 0; i < this.referersLen; ++i) {
                if (hashMap.get(this.referers[i]) != null) continue;
                hashMap.put(this.referers[i], this.referers[i]);
            }
            this.referers = new JavaThing[hashMap.size()];
            hashMap.keySet().toArray(this.referers);
        }
        this.referersLen = -1;
    }

    public String getIdString() {
        return Misc.toHex(this.getId());
    }

    public String toString() {
        return this.getClazz().getName() + "@" + this.getIdString();
    }

    public StackTrace getAllocatedFrom() {
        return this.getClazz().getSiteTrace(this);
    }

    public boolean isNew() {
        return this.getClazz().isNew(this);
    }

    void setNew(boolean bl) {
        this.getClazz().setNew(this, bl);
    }

    public void visitReferencedObjects(JavaHeapObjectVisitor javaHeapObjectVisitor) {
        javaHeapObjectVisitor.visit(this.getClazz());
    }

    void addReferenceFrom(JavaHeapObject javaHeapObject) {
        if (this.referersLen == 0) {
            this.referers = new JavaThing[1];
        } else if (this.referersLen == this.referers.length) {
            JavaThing[] javaThingArray = new JavaThing[3 * (this.referersLen + 1) / 2];
            System.arraycopy(this.referers, 0, javaThingArray, 0, this.referersLen);
            this.referers = javaThingArray;
        }
        this.referers[this.referersLen++] = javaHeapObject;
    }

    void addReferenceFromRoot(Root root) {
        this.getClazz().addReferenceFromRoot(root, this);
    }

    public Root getRoot() {
        return this.getClazz().getRoot(this);
    }

    public Enumeration getReferers() {
        if (this.referersLen != -1) {
            throw new RuntimeException("not resolved: " + this.getIdString());
        }
        return new Enumeration(){
            private int num = 0;

            public boolean hasMoreElements() {
                return JavaHeapObject.this.referers != null && this.num < JavaHeapObject.this.referers.length;
            }

            public Object nextElement() {
                return JavaHeapObject.this.referers[this.num++];
            }
        };
    }

    public boolean refersOnlyWeaklyTo(Snapshot snapshot, JavaThing javaThing) {
        return false;
    }

    public String describeReferenceTo(JavaThing javaThing, Snapshot snapshot) {
        return "??";
    }

    public boolean isHeapAllocated() {
        return true;
    }
}

