/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.internal.ws.processor;

import com.sun.tools.internal.ws.processor.ProcessorAction;
import com.sun.tools.internal.ws.processor.ProcessorException;
import com.sun.tools.internal.ws.processor.config.Configuration;
import com.sun.tools.internal.ws.processor.config.ModelInfo;
import com.sun.tools.internal.ws.processor.model.Model;
import com.sun.tools.internal.ws.processor.util.ProcessorEnvironment;
import com.sun.xml.internal.ws.util.exception.JAXWSExceptionBase;
import com.sun.xml.internal.ws.util.localization.Localizable;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class Processor {
    private final Properties _options;
    private final Configuration _configuration;
    private final List<ProcessorAction> _actions = new ArrayList<ProcessorAction>();
    private Model _model;
    private final boolean _printStackTrace;
    private final ProcessorEnvironment _env;

    public Processor(Configuration configuration, Properties properties, Model model) {
        this(configuration, properties);
        this._model = model;
    }

    public Processor(Configuration configuration, Properties properties) {
        this._configuration = configuration;
        this._options = properties;
        this._printStackTrace = Boolean.valueOf(this._options.getProperty("printStackTrace"));
        this._env = this._configuration.getEnvironment();
    }

    public void add(ProcessorAction processorAction) {
        this._actions.add(processorAction);
    }

    public Model getModel() {
        return this._model;
    }

    public void run() {
        this.runModeler();
        if (this._model != null) {
            this.runActions();
        }
    }

    public void runModeler() {
        try {
            ModelInfo modelInfo = this._configuration.getModelInfo();
            if (modelInfo == null) {
                throw new ProcessorException("processor.missing.model", new Object[0]);
            }
            this._model = modelInfo.buildModel(this._options);
        }
        catch (JAXWSExceptionBase jAXWSExceptionBase) {
            if (this._printStackTrace) {
                this._env.printStackTrace(jAXWSExceptionBase);
            }
            this._env.error((Localizable)jAXWSExceptionBase);
        }
    }

    public void runActions() {
        try {
            if (this._model == null) {
                return;
            }
            for (ProcessorAction processorAction : this._actions) {
                processorAction.perform(this._model, this._configuration, this._options);
            }
        }
        catch (JAXWSExceptionBase jAXWSExceptionBase) {
            if (this._printStackTrace || this._env.verbose()) {
                this._env.printStackTrace(jAXWSExceptionBase);
            }
            this._env.error((Localizable)jAXWSExceptionBase);
        }
    }
}

