/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.internal.ws.processor.generator;

import com.sun.tools.internal.ws.processor.generator.GeneratorConstants;
import com.sun.tools.internal.ws.processor.generator.Names;
import com.sun.tools.internal.ws.processor.model.Block;
import com.sun.tools.internal.ws.processor.model.Fault;
import com.sun.tools.internal.ws.processor.model.Operation;
import com.sun.tools.internal.ws.processor.model.java.JavaStructureType;
import com.sun.tools.internal.ws.processor.util.IndentingWriter;
import com.sun.tools.internal.ws.processor.util.ProcessorEnvironment;
import java.io.IOException;
import java.util.Comparator;
import javax.xml.namespace.QName;

public class GeneratorUtil
implements GeneratorConstants {
    public static void writeNewQName(IndentingWriter indentingWriter, QName qName) throws IOException {
        indentingWriter.p("new QName(\"" + qName.getNamespaceURI() + "\", \"" + qName.getLocalPart() + "\")");
    }

    public static void writeBlockQNameDeclaration(IndentingWriter indentingWriter, Operation operation, Block block, Names names) throws IOException {
        String string = names.getBlockQNameName(operation, block);
        indentingWriter.p("private static final QName ");
        indentingWriter.p(string + " = ");
        GeneratorUtil.writeNewQName(indentingWriter, block.getName());
        indentingWriter.pln(";");
    }

    public static void writeQNameDeclaration(IndentingWriter indentingWriter, QName qName, Names names) throws IOException {
        String string = names.getQNameName(qName);
        indentingWriter.p("private static final QName ");
        indentingWriter.p(string + " = ");
        GeneratorUtil.writeNewQName(indentingWriter, qName);
        indentingWriter.pln(";");
    }

    public static void writeQNameTypeDeclaration(IndentingWriter indentingWriter, QName qName, Names names) throws IOException {
        String string = names.getTypeQName(qName);
        indentingWriter.p("private static final QName ");
        indentingWriter.p(string + " = ");
        GeneratorUtil.writeNewQName(indentingWriter, qName);
        indentingWriter.pln(";");
    }

    public static boolean classExists(ProcessorEnvironment processorEnvironment, String string) {
        try {
            GeneratorUtil.getLoadableClassName(string, processorEnvironment.getClassLoader());
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    public static String getLoadableClassName(String string, ClassLoader classLoader) throws ClassNotFoundException {
        try {
            Class.forName(string, true, classLoader);
        }
        catch (ClassNotFoundException classNotFoundException) {
            int n = string.lastIndexOf(46);
            if (n > -1) {
                String string2 = string.substring(0, n) + "$";
                string2 = string2 + string.substring(n + 1);
                return GeneratorUtil.getLoadableClassName(string2, classLoader);
            }
            throw classNotFoundException;
        }
        return string;
    }

    public static class FaultComparator
    implements Comparator {
        private boolean sortName = false;

        public FaultComparator() {
        }

        public FaultComparator(boolean bl) {
            this.sortName = bl;
        }

        public int compare(Object object, Object object2) {
            Object object3;
            Object object4;
            if (this.sortName && !((QName)(object4 = ((Fault)object).getBlock().getName())).equals(object3 = ((Fault)object2).getBlock().getName())) {
                return ((QName)object4).toString().compareTo(((QName)object3).toString());
            }
            object4 = ((Fault)object).getJavaException();
            object3 = ((Fault)object2).getJavaException();
            int n = this.sort((JavaStructureType)object4, (JavaStructureType)object3);
            return n;
        }

        protected int sort(JavaStructureType javaStructureType, JavaStructureType javaStructureType2) {
            JavaStructureType javaStructureType3;
            if (javaStructureType.getName().equals(javaStructureType2.getName())) {
                return 0;
            }
            for (javaStructureType3 = javaStructureType.getSuperclass(); javaStructureType3 != null; javaStructureType3 = javaStructureType3.getSuperclass()) {
                if (!javaStructureType3.equals(javaStructureType2)) continue;
                return -1;
            }
            for (javaStructureType3 = javaStructureType2.getSuperclass(); javaStructureType3 != null; javaStructureType3 = javaStructureType3.getSuperclass()) {
                if (!javaStructureType3.equals(javaStructureType)) continue;
                return 1;
            }
            if (javaStructureType.getSubclasses() == null && javaStructureType2.getSubclasses() != null) {
                return -1;
            }
            if (javaStructureType.getSubclasses() != null && javaStructureType2.getSubclasses() == null) {
                return 1;
            }
            if (javaStructureType.getSuperclass() != null && javaStructureType2.getSuperclass() == null) {
                return 1;
            }
            if (javaStructureType.getSuperclass() == null && javaStructureType2.getSuperclass() != null) {
                return -1;
            }
            return javaStructureType.getName().compareTo(javaStructureType2.getName());
        }
    }
}

