/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.internal.ws.processor.generator;

import com.sun.codemodel.internal.ClassType;
import com.sun.codemodel.internal.CodeWriter;
import com.sun.codemodel.internal.JAnnotationUse;
import com.sun.codemodel.internal.JBlock;
import com.sun.codemodel.internal.JCatchBlock;
import com.sun.codemodel.internal.JClass;
import com.sun.codemodel.internal.JClassAlreadyExistsException;
import com.sun.codemodel.internal.JCommentPart;
import com.sun.codemodel.internal.JDefinedClass;
import com.sun.codemodel.internal.JDocComment;
import com.sun.codemodel.internal.JExpr;
import com.sun.codemodel.internal.JFieldVar;
import com.sun.codemodel.internal.JInvocation;
import com.sun.codemodel.internal.JMethod;
import com.sun.codemodel.internal.JTryBlock;
import com.sun.codemodel.internal.JType;
import com.sun.codemodel.internal.JVar;
import com.sun.codemodel.internal.writer.ProgressCodeWriter;
import com.sun.tools.internal.ws.processor.ProcessorAction;
import com.sun.tools.internal.ws.processor.config.Configuration;
import com.sun.tools.internal.ws.processor.config.WSDLModelInfo;
import com.sun.tools.internal.ws.processor.generator.GeneratorBase;
import com.sun.tools.internal.ws.processor.generator.GeneratorException;
import com.sun.tools.internal.ws.processor.generator.GeneratorUtil;
import com.sun.tools.internal.ws.processor.model.Model;
import com.sun.tools.internal.ws.processor.model.Port;
import com.sun.tools.internal.ws.processor.model.Service;
import com.sun.tools.internal.ws.processor.model.java.JavaInterface;
import com.sun.tools.internal.ws.wscompile.WSCodeWriter;
import com.sun.xml.internal.bind.api.JAXBRIContext;
import com.sun.xml.internal.ws.encoding.soap.SOAPVersion;
import com.sun.xml.internal.ws.util.JAXWSUtils;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import javax.xml.namespace.QName;
import javax.xml.ws.WebEndpoint;
import javax.xml.ws.WebServiceClient;

public class ServiceGenerator
extends GeneratorBase
implements ProcessorAction {
    private String serviceNS;
    private WSDLModelInfo wsdlModelInfo;

    public ServiceGenerator() {
    }

    private ServiceGenerator(Model model, Configuration configuration, Properties properties) {
        super(model, configuration, properties);
        this.wsdlModelInfo = (WSDLModelInfo)configuration.getModelInfo();
    }

    public GeneratorBase getGenerator(Model model, Configuration configuration, Properties properties) {
        return new ServiceGenerator(model, configuration, properties);
    }

    public GeneratorBase getGenerator(Model model, Configuration configuration, Properties properties, SOAPVersion sOAPVersion) {
        return new ServiceGenerator(model, configuration, properties);
    }

    private JInvocation createQName(QName qName) {
        return JExpr._new(this.cm.ref(QName.class)).arg(qName.getNamespaceURI()).arg(qName.getLocalPart());
    }

    private JInvocation createURL(URL uRL) {
        return JExpr._new(this.cm.ref(URL.class)).arg(uRL.toExternalForm());
    }

    protected void visitService(Service service) {
        try {
            JavaInterface javaInterface = service.getJavaInterface();
            String string = this.env.getNames().customJavaTypeClassName(javaInterface);
            if (this.donotOverride && GeneratorUtil.classExists(this.env, string)) {
                this.log("Class " + string + " exists. Not overriding.");
                return;
            }
            JDefinedClass jDefinedClass = this.getClass(string, ClassType.CLASS);
            jDefinedClass._extends(javax.xml.ws.Service.class);
            String string2 = JAXBRIContext.mangleNameToClassName((String)service.getName().getLocalPart()).toUpperCase();
            String string3 = string2 + "_WSDL_LOCATION";
            JFieldVar jFieldVar = jDefinedClass.field(28, URL.class, string3);
            JClass jClass = this.cm.ref(QName.class);
            JInvocation jInvocation = JExpr._new(jClass);
            jInvocation.arg("namespace");
            jInvocation.arg("localpart");
            JBlock jBlock = jDefinedClass.init();
            URL uRL = new URL(JAXWSUtils.absolutize((String)JAXWSUtils.getFileOrURLName((String)this.wsdlLocation)));
            JVar jVar = jBlock.decl(this.cm.ref(URL.class), "url", JExpr._null());
            JTryBlock jTryBlock = jBlock._try();
            jTryBlock.body().assign(jVar, this.createURL(uRL));
            JCatchBlock jCatchBlock = jTryBlock._catch(this.cm.ref(MalformedURLException.class));
            jCatchBlock.param("e");
            jCatchBlock.body().directStatement("e.printStackTrace();");
            jBlock.assign(jFieldVar, jVar);
            JDocComment jDocComment = jDefinedClass.javadoc();
            if (service.getJavaDoc() != null) {
                jDocComment.add(service.getJavaDoc());
                jDocComment.add("\n\n");
            }
            for (String object2 : this.getJAXWSClassComment()) {
                jDocComment.add(object2);
            }
            Object object3 = jDefinedClass.constructor(1);
            ((JMethod)object3).param(URL.class, "wsdlLocation");
            ((JMethod)object3).param(QName.class, "serviceName");
            ((JMethod)object3).body().directStatement("super(wsdlLocation, serviceName);");
            object3 = jDefinedClass.constructor(1);
            ((JMethod)object3).body().directStatement("super(" + string3 + ", new QName(\"" + service.getName().getNamespaceURI() + "\", \"" + service.getName().getLocalPart() + "\"));");
            JAnnotationUse jAnnotationUse = jDefinedClass.annotate(this.cm.ref(WebServiceClient.class));
            this.writeWebServiceClientAnnotation(service, jAnnotationUse);
            this.writeHandlerConfig(this.env.getNames().customJavaTypeClassName(service.getJavaInterface()), jDefinedClass, this.wsdlModelInfo);
            for (Port port : service.getPorts()) {
                if (port.isProvider()) continue;
                JMethod jMethod = null;
                JDocComment jDocComment2 = null;
                JDefinedClass jDefinedClass2 = this.getClass(port.getJavaInterface().getName(), ClassType.INTERFACE);
                jMethod = jDefinedClass.method(1, jDefinedClass2, port.getPortGetter());
                jDocComment2 = jMethod.javadoc();
                if (port.getJavaDoc() != null) {
                    jDocComment2.add(port.getJavaDoc());
                }
                JCommentPart jCommentPart = jDocComment2.addReturn();
                jCommentPart.add("returns " + ((JType)jDefinedClass2).name());
                JBlock jBlock2 = jMethod.body();
                StringBuffer stringBuffer = new StringBuffer("return (");
                stringBuffer.append(((JType)jDefinedClass2).name());
                stringBuffer.append(")super.getPort(new QName(\"" + port.getName().getNamespaceURI() + "\", \"" + port.getName().getLocalPart() + "\"), ");
                stringBuffer.append(((JType)jDefinedClass2).name());
                stringBuffer.append(".class);");
                jBlock2.directStatement(stringBuffer.toString());
                this.writeWebEndpoint(port, jMethod);
            }
            Object object = new WSCodeWriter(this.sourceDir, this.env);
            if (this.env.verbose()) {
                object = new ProgressCodeWriter((CodeWriter)object, System.out);
            }
            this.cm.build((CodeWriter)object);
        }
        catch (IOException iOException) {
            throw new GeneratorException("generator.nestedGeneratorError", iOException);
        }
    }

    protected JDefinedClass getClass(String string, ClassType classType) {
        JDefinedClass jDefinedClass = null;
        try {
            jDefinedClass = this.cm._class(string, classType);
        }
        catch (JClassAlreadyExistsException jClassAlreadyExistsException) {
            jDefinedClass = this.cm._getClass(string);
        }
        return jDefinedClass;
    }

    private void writeWebServiceClientAnnotation(Service service, JAnnotationUse jAnnotationUse) {
        String string = service.getName().getLocalPart();
        this.serviceNS = service.getName().getNamespaceURI();
        jAnnotationUse.param("name", string);
        jAnnotationUse.param("targetNamespace", this.serviceNS);
        jAnnotationUse.param("wsdlLocation", this.wsdlLocation);
    }

    private void writeWebEndpoint(Port port, JMethod jMethod) {
        JAnnotationUse jAnnotationUse = jMethod.annotate(this.cm.ref(WebEndpoint.class));
        jAnnotationUse.param("name", port.getName().getLocalPart());
    }
}

