/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.internal.ws.processor.model;

import com.sun.tools.internal.ws.processor.ProcessorActionVersion;
import com.sun.tools.internal.ws.processor.model.AbstractType;
import com.sun.tools.internal.ws.processor.model.ModelException;
import com.sun.tools.internal.ws.processor.model.ModelObject;
import com.sun.tools.internal.ws.processor.model.ModelVisitor;
import com.sun.tools.internal.ws.processor.model.Service;
import com.sun.tools.internal.ws.processor.model.jaxb.JAXBModel;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Model
extends ModelObject {
    private QName name;
    private String targetNamespace;
    private List<Service> services = new ArrayList<Service>();
    private Map<QName, Service> servicesByName = new HashMap<QName, Service>();
    private Set<AbstractType> extraTypes = new HashSet<AbstractType>();
    private String source;
    private JAXBModel jaxBModel = null;
    private ProcessorActionVersion processorActionVersion = ProcessorActionVersion.VERSION_20;

    public Model() {
    }

    public Model(QName qName) {
        this.name = qName;
    }

    public QName getName() {
        return this.name;
    }

    public void setName(QName qName) {
        this.name = qName;
    }

    public String getTargetNamespaceURI() {
        return this.targetNamespace;
    }

    public void setTargetNamespaceURI(String string) {
        this.targetNamespace = string;
    }

    public void addService(Service service) {
        if (this.servicesByName.containsKey(service.getName())) {
            throw new ModelException("model.uniqueness", new Object[0]);
        }
        this.services.add(service);
        this.servicesByName.put(service.getName(), service);
    }

    public Service getServiceByName(QName qName) {
        if (this.servicesByName.size() != this.services.size()) {
            this.initializeServicesByName();
        }
        return this.servicesByName.get(qName);
    }

    public List<Service> getServices() {
        return this.services;
    }

    public void setServices(List<Service> list) {
        this.services = list;
    }

    private void initializeServicesByName() {
        this.servicesByName = new HashMap<QName, Service>();
        if (this.services != null) {
            for (Service service : this.services) {
                if (service.getName() != null && this.servicesByName.containsKey(service.getName())) {
                    throw new ModelException("model.uniqueness", new Object[0]);
                }
                this.servicesByName.put(service.getName(), service);
            }
        }
    }

    public void addExtraType(AbstractType abstractType) {
        this.extraTypes.add(abstractType);
    }

    public Iterator getExtraTypes() {
        return this.extraTypes.iterator();
    }

    public Set<AbstractType> getExtraTypesSet() {
        return this.extraTypes;
    }

    public void setExtraTypesSet(Set<AbstractType> set) {
        this.extraTypes = set;
    }

    @Override
    public void accept(ModelVisitor modelVisitor) throws Exception {
        modelVisitor.visit(this);
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String string) {
        this.source = string;
    }

    public ProcessorActionVersion getProcessorActionVersion() {
        return this.processorActionVersion;
    }

    public void setProcessorActionVersion(ProcessorActionVersion processorActionVersion) {
        this.processorActionVersion = processorActionVersion;
    }

    public void setProcessorActionVersion(String string) {
        block4: for (ProcessorActionVersion processorActionVersion : EnumSet.allOf(ProcessorActionVersion.class)) {
            switch (processorActionVersion) {
                case PRE_20: {
                    if (!string.equals(ProcessorActionVersion.PRE_20.toString())) continue block4;
                    this.processorActionVersion = ProcessorActionVersion.PRE_20;
                    continue block4;
                }
                case VERSION_20: {
                    if (!string.equals(ProcessorActionVersion.VERSION_20.toString())) continue block4;
                    this.processorActionVersion = ProcessorActionVersion.VERSION_20;
                    continue block4;
                }
            }
            throw new ModelException("model.invalid.processorActionVersion", string);
        }
    }

    public void setJAXBModel(JAXBModel jAXBModel) {
        this.jaxBModel = jAXBModel;
    }

    public JAXBModel getJAXBModel() {
        return this.jaxBModel;
    }
}

