/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.internal.ws.util;

import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public abstract class MapBase
implements Map {
    volatile transient Set keySet = null;
    volatile transient Collection values = null;

    protected MapBase() {
    }

    public int size() {
        return this.entrySet().size();
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public boolean containsValue(Object object) {
        Iterator iterator = this.entrySet().iterator();
        if (object == null) {
            while (iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                if (entry.getValue() != null) continue;
                return true;
            }
        } else {
            while (iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                if (!object.equals(entry.getValue())) continue;
                return true;
            }
        }
        return false;
    }

    public boolean containsKey(Object object) {
        Iterator iterator = this.entrySet().iterator();
        if (object == null) {
            while (iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                if (entry.getKey() != null) continue;
                return true;
            }
        } else {
            while (iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                if (!object.equals(entry.getKey())) continue;
                return true;
            }
        }
        return false;
    }

    public Object get(Object object) {
        Iterator iterator = this.entrySet().iterator();
        if (object == null) {
            while (iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                if (entry.getKey() != null) continue;
                return entry.getValue();
            }
        } else {
            while (iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                if (!object.equals(entry.getKey())) continue;
                return entry.getValue();
            }
        }
        return null;
    }

    public Object put(Object object, Object object2) {
        throw new UnsupportedOperationException();
    }

    public Object remove(Object object) {
        Map.Entry entry;
        Iterator iterator = this.entrySet().iterator();
        Map.Entry entry2 = null;
        if (object == null) {
            while (entry2 == null && iterator.hasNext()) {
                entry = (Map.Entry)iterator.next();
                if (entry.getKey() != null) continue;
                entry2 = entry;
            }
        } else {
            while (entry2 == null && iterator.hasNext()) {
                entry = (Map.Entry)iterator.next();
                if (!object.equals(entry.getKey())) continue;
                entry2 = entry;
            }
        }
        entry = null;
        if (entry2 != null) {
            entry = entry2.getValue();
            iterator.remove();
        }
        return entry;
    }

    public void putAll(Map map) {
        for (Map.Entry entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public void clear() {
        this.entrySet().clear();
    }

    public Set keySet() {
        if (this.keySet == null) {
            this.keySet = new AbstractSet(){

                public Iterator iterator() {
                    return new Iterator(){
                        private Iterator i;
                        {
                            this.i = MapBase.this.entrySet().iterator();
                        }

                        public boolean hasNext() {
                            return this.i.hasNext();
                        }

                        public Object next() {
                            return ((Map.Entry)this.i.next()).getKey();
                        }

                        public void remove() {
                            this.i.remove();
                        }
                    };
                }

                public int size() {
                    return MapBase.this.size();
                }

                public boolean contains(Object object) {
                    return MapBase.this.containsKey(object);
                }
            };
        }
        return this.keySet;
    }

    public Collection values() {
        if (this.values == null) {
            this.values = new AbstractCollection(){

                public Iterator iterator() {
                    return new Iterator(){
                        private Iterator i;
                        {
                            this.i = MapBase.this.entrySet().iterator();
                        }

                        public boolean hasNext() {
                            return this.i.hasNext();
                        }

                        public Object next() {
                            return ((Map.Entry)this.i.next()).getValue();
                        }

                        public void remove() {
                            this.i.remove();
                        }
                    };
                }

                public int size() {
                    return MapBase.this.size();
                }

                public boolean contains(Object object) {
                    return MapBase.this.containsValue(object);
                }
            };
        }
        return this.values;
    }

    public abstract Set entrySet();

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Map)) {
            return false;
        }
        Map map = (Map)object;
        if (map.size() != this.size()) {
            return false;
        }
        try {
            for (Map.Entry entry : this.entrySet()) {
                Object k = entry.getKey();
                Object v = entry.getValue();
                if (!(v == null ? map.get(k) != null || !map.containsKey(k) : !v.equals(map.get(k)))) continue;
                return false;
            }
        }
        catch (ClassCastException classCastException) {
            return false;
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
        return true;
    }

    public int hashCode() {
        int n = 0;
        Iterator iterator = this.entrySet().iterator();
        while (iterator.hasNext()) {
            n += iterator.next().hashCode();
        }
        return n;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{");
        Iterator iterator = this.entrySet().iterator();
        boolean bl = iterator.hasNext();
        while (bl) {
            Map.Entry entry = (Map.Entry)iterator.next();
            Object k = entry.getKey();
            Object v = entry.getValue();
            stringBuffer.append((k == this ? "(this Map)" : k) + "=" + (v == this ? "(this Map)" : v));
            bl = iterator.hasNext();
            if (!bl) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    protected Object clone() throws CloneNotSupportedException {
        MapBase mapBase = (MapBase)super.clone();
        mapBase.keySet = null;
        mapBase.values = null;
        return mapBase;
    }

    static class SimpleEntry
    implements Map.Entry {
        Object key;
        Object value;

        public SimpleEntry(Object object, Object object2) {
            this.key = object;
            this.value = object2;
        }

        public SimpleEntry(Map.Entry entry) {
            this.key = entry.getKey();
            this.value = entry.getValue();
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public Object setValue(Object object) {
            Object object2 = this.value;
            this.value = object;
            return object2;
        }

        public boolean equals(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            return SimpleEntry.eq(this.key, entry.getKey()) && SimpleEntry.eq(this.value, entry.getValue());
        }

        public int hashCode() {
            return (this.key == null ? 0 : this.key.hashCode()) ^ (this.value == null ? 0 : this.value.hashCode());
        }

        public String toString() {
            return this.key + "=" + this.value;
        }

        private static boolean eq(Object object, Object object2) {
            return object == null ? object2 == null : object.equals(object2);
        }
    }
}

