/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.internal.ws.wsdl.parser;

import com.sun.tools.internal.ws.processor.util.ProcessorEnvironment;
import com.sun.tools.internal.ws.wsdl.parser.NamespaceContextImpl;
import com.sun.tools.internal.xjc.util.DOMUtils;
import com.sun.xml.internal.ws.util.JAXWSUtils;
import com.sun.xml.internal.ws.util.localization.Localizable;
import com.sun.xml.internal.ws.util.localization.LocalizableMessageFactory;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Internalizer {
    private Map<String, Document> wsdlDocuments;
    private Map<String, Document> jaxwsBindings;
    private static final XPathFactory xpf = XPathFactory.newInstance();
    private final XPath xpath = xpf.newXPath();
    private final LocalizableMessageFactory messageFactory = new LocalizableMessageFactory("com.sun.tools.internal.ws.resources.wsdl");
    private ProcessorEnvironment env;

    public void transform(Map<String, Document> map, Map<String, Document> map2, ProcessorEnvironment processorEnvironment) {
        Element element;
        if (map == null) {
            return;
        }
        this.env = processorEnvironment;
        this.wsdlDocuments = map2;
        this.jaxwsBindings = map;
        HashMap<Element, Node> hashMap = new HashMap<Element, Node>();
        for (Map.Entry<String, Document> entry : map.entrySet()) {
            element = entry.getValue().getDocumentElement();
            this.buildTargetNodeMap(element, element, hashMap);
        }
        for (Map.Entry<String, Document> entry : map.entrySet()) {
            element = entry.getValue().getDocumentElement();
            this.move(element, hashMap);
        }
    }

    private void validate(Element element) {
        NamedNodeMap namedNodeMap = element.getAttributes();
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            Attr attr = (Attr)namedNodeMap.item(i);
            if (attr.getNamespaceURI() == null && !attr.getLocalName().equals("node") && !attr.getLocalName().equals("wsdlLocation")) continue;
        }
    }

    public Document get(String string) {
        Document document = this.wsdlDocuments.get(string);
        if (document == null && string.startsWith("file:/") && !string.startsWith("file://")) {
            document = this.wsdlDocuments.get("file://" + string.substring(5));
        }
        if (document == null && string.startsWith("file:")) {
            String string2 = this.getPath(string);
            for (String string3 : this.wsdlDocuments.keySet()) {
                if (!string3.startsWith("file:") || !this.getPath(string3).equalsIgnoreCase(string2)) continue;
                document = this.wsdlDocuments.get(string3);
                break;
            }
        }
        return document;
    }

    private String getPath(String string) {
        string = string.substring(5);
        while (string.length() > 0 && string.charAt(0) == '/') {
            string = string.substring(1);
        }
        return string;
    }

    private void buildTargetNodeMap(Element element, Node node, Map<Element, Node> map) {
        Node node2 = node;
        this.validate(element);
        if (element.getAttributeNode("wsdlLocation") != null) {
            String string = element.getAttribute("wsdlLocation");
            try {
                string = new URL(new URL(this.getSystemId(element.getOwnerDocument())), string).toExternalForm();
            }
            catch (MalformedURLException malformedURLException) {
                string = JAXWSUtils.absolutize((String)JAXWSUtils.getFileOrURLName((String)string));
            }
            node2 = this.get(string);
            if (node2 == null) {
                this.error("internalizer.targetNotFound", new Object[]{string});
                return;
            }
        }
        boolean bl = true;
        if (this.isJAXWSBindings(element) && element.getAttributeNode("node") != null) {
            node2 = this.evaluateXPathNode(node2, element.getAttribute("node"), new NamespaceContextImpl(element));
        } else if (this.isJAXWSBindings(element) && element.getAttributeNode("node") == null && !this.isTopLevelBinding(element)) {
            bl = false;
        } else if (this.isGlobalBinding(element) && !this.isWSDLDefinition(node2) && this.isTopLevelBinding(element.getParentNode())) {
            node2 = this.getWSDLDefintionNode(node2);
        }
        if (node2 == null) {
            return;
        }
        if (bl) {
            map.put(element, node2);
        }
        Element[] elementArray = Internalizer.getChildElements(element, "http://java.sun.com/xml/ns/jaxws");
        for (int i = 0; i < elementArray.length; ++i) {
            this.buildTargetNodeMap(elementArray[i], node2, map);
        }
    }

    private Node getWSDLDefintionNode(Node node) {
        return this.evaluateXPathNode(node, "wsdl:definitions", new NamespaceContext(){

            public String getNamespaceURI(String string) {
                return "http://schemas.xmlsoap.org/wsdl/";
            }

            public String getPrefix(String string) {
                throw new UnsupportedOperationException();
            }

            public Iterator getPrefixes(String string) {
                throw new UnsupportedOperationException();
            }
        });
    }

    private boolean isWSDLDefinition(Node node) {
        if (node == null) {
            return false;
        }
        String string = node.getLocalName();
        String string2 = node.getNamespaceURI();
        return string != null && string.equals("definitions") && string2 != null && string2.equals("http://schemas.xmlsoap.org/wsdl/");
    }

    private boolean isTopLevelBinding(Node node) {
        if (node instanceof Document) {
            node = ((Document)node).getDocumentElement();
        }
        return node != null && ((Element)node).getAttributeNode("wsdlLocation") != null;
    }

    private boolean isJAXWSBindings(Node node) {
        return node.getNamespaceURI().equals("http://java.sun.com/xml/ns/jaxws") && node.getLocalName().equals("bindings");
    }

    private boolean isGlobalBinding(Node node) {
        if (node.getNamespaceURI() == null) {
            this.warn("invalid.customization.namespace", new Object[]{node.getLocalName()});
            return false;
        }
        return node.getNamespaceURI().equals("http://java.sun.com/xml/ns/jaxws") && (node.getLocalName().equals("package") || node.getLocalName().equals("enableAsyncMapping") || node.getLocalName().equals("enableAdditionalSOAPHeaderMapping") || node.getLocalName().equals("enableWrapperStyle") || node.getLocalName().equals("enableMIMEContent"));
    }

    private static Element[] getChildElements(Element element, String string) {
        ArrayList<Node> arrayList = new ArrayList<Node>();
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!(node instanceof Element) || !string.equals(node.getNamespaceURI())) continue;
            arrayList.add(node);
        }
        return arrayList.toArray(new Element[arrayList.size()]);
    }

    private Node evaluateXPathNode(Node node, String string, NamespaceContext namespaceContext) {
        NodeList nodeList;
        try {
            this.xpath.setNamespaceContext(namespaceContext);
            nodeList = (NodeList)this.xpath.evaluate(string, node, XPathConstants.NODESET);
        }
        catch (XPathExpressionException xPathExpressionException) {
            this.error("internalizer.XPathEvaluationError", new Object[]{xPathExpressionException.getMessage()});
            if (this.env.verbose()) {
                xPathExpressionException.printStackTrace();
            }
            return null;
        }
        if (nodeList.getLength() == 0) {
            this.error("internalizer.XPathEvaluatesToNoTarget", new Object[]{string});
            return null;
        }
        if (nodeList.getLength() != 1) {
            this.error("internalizer.XPathEvaulatesToTooManyTargets", new Object[]{string, nodeList.getLength()});
            return null;
        }
        Node node2 = nodeList.item(0);
        if (!(node2 instanceof Element)) {
            this.error("internalizer.XPathEvaluatesToNonElement", new Object[]{string});
            return null;
        }
        return (Element)node2;
    }

    private void move(Element element, Map<Element, Node> map) {
        Element[] elementArray;
        Node node = map.get(element);
        if (node == null) {
            return;
        }
        for (Element element2 : elementArray = DOMUtils.getChildElements(element)) {
            if ("bindings".equals(element2.getLocalName())) {
                this.move(element2, map);
                continue;
            }
            if (this.isGlobalBinding(element2)) {
                node = map.get(element2);
                this.moveUnder(element2, (Element)node);
                continue;
            }
            if (!(node instanceof Element)) {
                return;
            }
            this.moveUnder(element2, (Element)node);
        }
    }

    private boolean isJAXBBindingElement(Element element) {
        return element.getNamespaceURI() != null && element.getNamespaceURI().equals("http://java.sun.com/xml/ns/jaxb");
    }

    private boolean isJAXWSBindingElement(Element element) {
        return element.getNamespaceURI() != null && element.getNamespaceURI().equals("http://java.sun.com/xml/ns/jaxws");
    }

    private void moveUnder(Element element, Element element2) {
        if (this.isJAXBBindingElement(element)) {
            if (!element2.hasAttributeNS("http://www.w3.org/2000/xmlns/", "jaxb")) {
                element2.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:jaxb", "http://java.sun.com/xml/ns/jaxb");
            }
            if (!element2.hasAttributeNS("http://java.sun.com/xml/ns/jaxb", "version")) {
                element2.setAttributeNS("http://java.sun.com/xml/ns/jaxb", "jaxb:version", "1.0");
            }
            element2 = this.refineSchemaTarget(element2);
            this.copyInscopeNSAttributes(element);
        } else if (this.isJAXWSBindingElement(element)) {
            if (!element2.hasAttributeNS("http://www.w3.org/2000/xmlns/", "JAXWS")) {
                element2.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:JAXWS", "http://java.sun.com/xml/ns/jaxws");
            }
            element2 = this.refineWSDLTarget(element2);
            this.copyInscopeNSAttributes(element);
        } else {
            return;
        }
        if (element2.getOwnerDocument() != element.getOwnerDocument()) {
            Element element3 = element;
            element = (Element)element2.getOwnerDocument().importNode(element, true);
        }
        element2.appendChild(element);
    }

    private void copyInscopeNSAttributes(Element element) {
        Element element2 = element;
        HashSet<String> hashSet = new HashSet<String>();
        while (true) {
            NamedNodeMap namedNodeMap = element2.getAttributes();
            for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                String string;
                Attr attr = (Attr)namedNodeMap.item(i);
                if (!"http://www.w3.org/2000/xmlns/".equals(attr.getNamespaceURI()) || !hashSet.add(string = attr.getName().indexOf(58) == -1 ? "" : attr.getLocalName()) || element2 == element) continue;
                element.setAttributeNodeNS((Attr)attr.cloneNode(true));
            }
            if (element2.getParentNode() instanceof Document) break;
            element2 = (Element)element2.getParentNode();
        }
        if (!hashSet.contains("")) {
            element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "");
        }
    }

    public Element refineSchemaTarget(Element element) {
        Element element2;
        Element element3 = DOMUtils.getFirstChildElement(element, "http://www.w3.org/2001/XMLSchema", "annotation");
        if (element3 == null) {
            element3 = this.insertXMLSchemaElement(element, "annotation");
        }
        if ((element2 = DOMUtils.getFirstChildElement(element3, "http://www.w3.org/2001/XMLSchema", "appinfo")) == null) {
            element2 = this.insertXMLSchemaElement(element3, "appinfo");
        }
        return element2;
    }

    public Element refineWSDLTarget(Element element) {
        Element element2 = DOMUtils.getFirstChildElement(element, "http://java.sun.com/xml/ns/jaxws", "bindings");
        if (element2 == null) {
            element2 = this.insertJAXWSBindingsElement(element, "bindings");
        }
        return element2;
    }

    private Element insertXMLSchemaElement(Element element, String string) {
        String string2 = element.getTagName();
        int n = string2.indexOf(58);
        string2 = n == -1 ? string : string2.substring(0, n + 1) + string;
        Element element2 = element.getOwnerDocument().createElementNS("http://www.w3.org/2001/XMLSchema", string2);
        NodeList nodeList = element.getChildNodes();
        if (nodeList.getLength() == 0) {
            element.appendChild(element2);
        } else {
            element.insertBefore(element2, nodeList.item(0));
        }
        return element2;
    }

    private Element insertJAXWSBindingsElement(Element element, String string) {
        String string2 = "JAXWS:" + string;
        Element element2 = element.getOwnerDocument().createElementNS("http://java.sun.com/xml/ns/jaxws", string2);
        NodeList nodeList = element.getChildNodes();
        if (nodeList.getLength() == 0) {
            element.appendChild(element2);
        } else {
            element.insertBefore(element2, nodeList.item(0));
        }
        return element2;
    }

    private String getSystemId(Document document) {
        for (Map.Entry<String, Document> entry : this.jaxwsBindings.entrySet()) {
            if (entry.getValue() != document) continue;
            return entry.getKey();
        }
        return null;
    }

    protected void warn(Localizable localizable) {
        this.env.warn(localizable);
    }

    protected void error(String string, Object[] objectArray) {
        this.env.error(this.messageFactory.getMessage(string, objectArray));
    }

    protected void warn(String string) {
        this.env.warn(this.messageFactory.getMessage(string, new Object[0]));
    }

    protected void warn(String string, Object[] objectArray) {
        this.env.warn(this.messageFactory.getMessage(string, objectArray));
    }

    protected void info(String string) {
        this.env.info(this.messageFactory.getMessage(string, new Object[0]));
    }

    protected void info(String string, String string2) {
        this.env.info(this.messageFactory.getMessage(string, new Object[]{string2}));
    }
}

