/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.internal.xjc.generator.bean;

import com.sun.codemodel.internal.ClassType;
import com.sun.codemodel.internal.JAnnotatable;
import com.sun.codemodel.internal.JAssignmentTarget;
import com.sun.codemodel.internal.JClass;
import com.sun.codemodel.internal.JClassAlreadyExistsException;
import com.sun.codemodel.internal.JClassContainer;
import com.sun.codemodel.internal.JCodeModel;
import com.sun.codemodel.internal.JDefinedClass;
import com.sun.codemodel.internal.JEnumConstant;
import com.sun.codemodel.internal.JExpr;
import com.sun.codemodel.internal.JExpression;
import com.sun.codemodel.internal.JExpressionImpl;
import com.sun.codemodel.internal.JFieldVar;
import com.sun.codemodel.internal.JForEach;
import com.sun.codemodel.internal.JInvocation;
import com.sun.codemodel.internal.JJavaName;
import com.sun.codemodel.internal.JMethod;
import com.sun.codemodel.internal.JPackage;
import com.sun.codemodel.internal.JType;
import com.sun.codemodel.internal.JVar;
import com.sun.codemodel.internal.fmt.JStaticJavaFile;
import com.sun.tools.internal.xjc.AbortException;
import com.sun.tools.internal.xjc.ErrorReceiver;
import com.sun.tools.internal.xjc.generator.annotation.spec.XmlAnyAttributeWriter;
import com.sun.tools.internal.xjc.generator.annotation.spec.XmlEnumValueWriter;
import com.sun.tools.internal.xjc.generator.annotation.spec.XmlEnumWriter;
import com.sun.tools.internal.xjc.generator.annotation.spec.XmlJavaTypeAdapterWriter;
import com.sun.tools.internal.xjc.generator.annotation.spec.XmlMimeTypeWriter;
import com.sun.tools.internal.xjc.generator.annotation.spec.XmlRootElementWriter;
import com.sun.tools.internal.xjc.generator.annotation.spec.XmlTypeWriter;
import com.sun.tools.internal.xjc.generator.bean.ClassOutlineImpl;
import com.sun.tools.internal.xjc.generator.bean.ElementOutlineImpl;
import com.sun.tools.internal.xjc.generator.bean.ImplStructureStrategy;
import com.sun.tools.internal.xjc.generator.bean.Messages;
import com.sun.tools.internal.xjc.generator.bean.MethodWriter;
import com.sun.tools.internal.xjc.generator.bean.PackageOutlineImpl;
import com.sun.tools.internal.xjc.generator.bean.field.FieldRenderer;
import com.sun.tools.internal.xjc.model.CAdapter;
import com.sun.tools.internal.xjc.model.CAttributePropertyInfo;
import com.sun.tools.internal.xjc.model.CClassInfo;
import com.sun.tools.internal.xjc.model.CClassInfoParent;
import com.sun.tools.internal.xjc.model.CElementInfo;
import com.sun.tools.internal.xjc.model.CEnumConstant;
import com.sun.tools.internal.xjc.model.CEnumLeafInfo;
import com.sun.tools.internal.xjc.model.CPropertyInfo;
import com.sun.tools.internal.xjc.model.CTypeRef;
import com.sun.tools.internal.xjc.model.Model;
import com.sun.tools.internal.xjc.model.nav.NClass;
import com.sun.tools.internal.xjc.model.nav.NType;
import com.sun.tools.internal.xjc.outline.Aspect;
import com.sun.tools.internal.xjc.outline.EnumConstantOutline;
import com.sun.tools.internal.xjc.outline.EnumOutline;
import com.sun.tools.internal.xjc.outline.FieldOutline;
import com.sun.tools.internal.xjc.outline.Outline;
import com.sun.tools.internal.xjc.outline.PackageOutline;
import com.sun.tools.internal.xjc.util.CodeModelClassFactory;
import com.sun.xml.internal.bind.v2.runtime.SwaRefAdapter;
import com.sun.xml.internal.xsom.XmlString;
import java.io.Serializable;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.annotation.XmlAttachmentRef;
import javax.xml.bind.annotation.XmlID;
import javax.xml.bind.annotation.XmlIDREF;
import javax.xml.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BeanGenerator
implements Outline {
    private final CodeModelClassFactory codeModelClassFactory;
    private final ErrorReceiver errorReceiver;
    private final Map<JPackage, PackageOutlineImpl> packageContexts = new HashMap<JPackage, PackageOutlineImpl>();
    private final Map<CClassInfo, ClassOutlineImpl> classes = new HashMap<CClassInfo, ClassOutlineImpl>();
    private final Map<CEnumLeafInfo, EnumOutline> enums = new HashMap<CEnumLeafInfo, EnumOutline>();
    private final Map<Class, JClass> generatedRuntime = new HashMap<Class, JClass>();
    private final Model model;
    private final JCodeModel codeModel;
    private final Map<CPropertyInfo, FieldOutline> fields = new HashMap<CPropertyInfo, FieldOutline>();
    final Map<CElementInfo, ElementOutlineImpl> elements = new HashMap<CElementInfo, ElementOutlineImpl>();
    private final CClassInfoParent.Visitor<JClassContainer> exposedContainerBuilder = new CClassInfoParent.Visitor<JClassContainer>(){

        @Override
        public JClassContainer onBean(CClassInfo cClassInfo) {
            return BeanGenerator.this.getClazz((CClassInfo)cClassInfo).ref;
        }

        @Override
        public JClassContainer onElement(CElementInfo cElementInfo) {
            return BeanGenerator.this.getElement((CElementInfo)cElementInfo).implClass;
        }

        @Override
        public JClassContainer onPackage(JPackage jPackage) {
            return ((BeanGenerator)BeanGenerator.this).model.strategy.getPackage(jPackage, Aspect.EXPOSED);
        }
    };
    private final CClassInfoParent.Visitor<JClassContainer> implContainerBuilder = new CClassInfoParent.Visitor<JClassContainer>(){

        @Override
        public JClassContainer onBean(CClassInfo cClassInfo) {
            return BeanGenerator.this.getClazz((CClassInfo)cClassInfo).implClass;
        }

        @Override
        public JClassContainer onElement(CElementInfo cElementInfo) {
            return BeanGenerator.this.getElement((CElementInfo)cElementInfo).implClass;
        }

        @Override
        public JClassContainer onPackage(JPackage jPackage) {
            return ((BeanGenerator)BeanGenerator.this).model.strategy.getPackage(jPackage, Aspect.IMPLEMENTATION);
        }
    };

    public static Outline generate(Model model, ErrorReceiver errorReceiver) {
        try {
            return new BeanGenerator(model, errorReceiver);
        }
        catch (AbortException abortException) {
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    private BeanGenerator(Model model, ErrorReceiver errorReceiver) {
        void var6_14;
        this.model = model;
        this.codeModel = this.model.codeModel;
        this.errorReceiver = errorReceiver;
        this.codeModelClassFactory = new CodeModelClassFactory(this.errorReceiver);
        JPackage[] jPackageArray = this.model.enums().values().iterator();
        while (jPackageArray.hasNext()) {
            CEnumLeafInfo object2 = jPackageArray.next();
            this.enums.put(object2, this.generateEnum(object2));
        }
        JPackage[] jPackageArray2 = jPackageArray = this.getUsedPackages(Aspect.EXPOSED);
        int n = jPackageArray2.length;
        boolean bl = false;
        while (var6_14 < n) {
            JPackage jPackage = jPackageArray2[var6_14];
            this.getPackageContext(jPackage);
            ++var6_14;
        }
        for (CClassInfo cClassInfo : this.model.beans().values()) {
            this.getClazz(cClassInfo);
        }
        for (PackageOutlineImpl packageOutlineImpl : this.packageContexts.values()) {
            packageOutlineImpl.calcDefaultValues();
        }
        JClass jClass = this.codeModel.ref(Object.class);
        for (ClassOutlineImpl classOutlineImpl : this.getClasses()) {
            CClassInfo cClassInfo = classOutlineImpl.target.getBaseClass();
            if (cClassInfo != null) {
                this.model.strategy._extends(classOutlineImpl, this.getClazz(cClassInfo));
                continue;
            }
            if (this.model.rootClass != null && classOutlineImpl.implClass._extends().equals(jClass)) {
                classOutlineImpl.implClass._extends(this.model.rootClass);
            }
            if (this.model.rootInterface == null) continue;
            classOutlineImpl.ref._implements(this.model.rootInterface);
        }
        for (ClassOutlineImpl classOutlineImpl : this.getClasses()) {
            this.generateClassBody(classOutlineImpl);
        }
        for (CElementInfo cElementInfo : this.model.getAllElements()) {
            this.getPackageContext(cElementInfo._package()).objectFactoryGenerator().populate(cElementInfo);
        }
        if (this.model.options.debugMode) {
            this.generateClassList();
        }
    }

    private void generateClassList() {
        try {
            JDefinedClass jDefinedClass = this.codeModel.rootPackage()._class("JAXBDebug");
            JMethod jMethod = jDefinedClass.method(17, JAXBContext.class, "createContext");
            JVar jVar = jMethod.param(ClassLoader.class, "classLoader");
            jMethod._throws(JAXBException.class);
            JInvocation jInvocation = this.codeModel.ref(JAXBContext.class).staticInvoke("newInstance");
            jMethod.body()._return(jInvocation);
            switch (this.model.strategy) {
                case INTF_AND_IMPL: {
                    StringBuilder stringBuilder = new StringBuilder();
                    for (PackageOutlineImpl packageOutlineImpl : this.packageContexts.values()) {
                        if (stringBuilder.length() > 0) {
                            stringBuilder.append(':');
                        }
                        stringBuilder.append(packageOutlineImpl._package().name());
                    }
                    jInvocation.arg(stringBuilder.toString()).arg(jVar);
                    break;
                }
                case BEAN_ONLY: {
                    for (ClassOutlineImpl object : this.getClasses()) {
                        jInvocation.arg(object.implRef.dotclass());
                    }
                    for (PackageOutlineImpl packageOutlineImpl : this.packageContexts.values()) {
                        jInvocation.arg(packageOutlineImpl.objectFactory().dotclass());
                    }
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        catch (JClassAlreadyExistsException jClassAlreadyExistsException) {
            jClassAlreadyExistsException.printStackTrace();
        }
    }

    @Override
    public Model getModel() {
        return this.model;
    }

    @Override
    public JCodeModel getCodeModel() {
        return this.codeModel;
    }

    @Override
    public JClassContainer getContainer(CClassInfoParent cClassInfoParent, Aspect aspect) {
        CClassInfoParent.Visitor<JClassContainer> visitor;
        switch (aspect) {
            case EXPOSED: {
                visitor = this.exposedContainerBuilder;
                break;
            }
            case IMPLEMENTATION: {
                visitor = this.implContainerBuilder;
                break;
            }
            default: {
                assert (false);
                throw new IllegalStateException();
            }
        }
        return cClassInfoParent.accept(visitor);
    }

    @Override
    public final JType resolve(CTypeRef cTypeRef, Aspect aspect) {
        return ((NType)cTypeRef.getTarget().getType()).toType(this, aspect);
    }

    public final JPackage[] getUsedPackages(Aspect aspect) {
        TreeSet<JPackage> treeSet = new TreeSet<JPackage>();
        for (CClassInfo abstractCTypeInfoImpl : this.model.beans().values()) {
            JClassContainer jClassContainer = this.getContainer(abstractCTypeInfoImpl.parent(), aspect);
            if (!jClassContainer.isPackage()) continue;
            treeSet.add((JPackage)jClassContainer);
        }
        for (CElementInfo cElementInfo : this.model.getElementMappings(null).values()) {
            treeSet.add(cElementInfo._package());
        }
        return treeSet.toArray(new JPackage[treeSet.size()]);
    }

    @Override
    public ErrorReceiver getErrorReceiver() {
        return this.errorReceiver;
    }

    @Override
    public CodeModelClassFactory getClassFactory() {
        return this.codeModelClassFactory;
    }

    @Override
    public PackageOutlineImpl getPackageContext(JPackage jPackage) {
        PackageOutlineImpl packageOutlineImpl = this.packageContexts.get(jPackage);
        if (packageOutlineImpl == null) {
            packageOutlineImpl = new PackageOutlineImpl(this, this.model, jPackage);
            this.packageContexts.put(jPackage, packageOutlineImpl);
        }
        return packageOutlineImpl;
    }

    private ClassOutlineImpl generateClassDef(CClassInfo cClassInfo) {
        JDefinedClass jDefinedClass;
        ImplStructureStrategy.Result result = this.model.strategy.createClasses(this, cClassInfo);
        if (cClassInfo.getUserSpecifiedImplClass() != null) {
            JDefinedClass jDefinedClass2;
            try {
                jDefinedClass2 = this.codeModel._class(cClassInfo.getUserSpecifiedImplClass());
                jDefinedClass2.hide();
            }
            catch (JClassAlreadyExistsException jClassAlreadyExistsException) {
                jDefinedClass2 = jClassAlreadyExistsException.getExistingClass();
            }
            jDefinedClass2._extends(result.implementation);
            jDefinedClass = jDefinedClass2;
        } else {
            jDefinedClass = result.implementation;
        }
        return new ClassOutlineImpl(this, cClassInfo, result.exposed, result.implementation, jDefinedClass);
    }

    public Collection<ClassOutlineImpl> getClasses() {
        assert (this.model.beans().size() == this.classes.size());
        return this.classes.values();
    }

    @Override
    public ClassOutlineImpl getClazz(CClassInfo cClassInfo) {
        ClassOutlineImpl classOutlineImpl = this.classes.get(cClassInfo);
        if (classOutlineImpl == null) {
            classOutlineImpl = this.generateClassDef(cClassInfo);
            this.classes.put(cClassInfo, classOutlineImpl);
        }
        return classOutlineImpl;
    }

    @Override
    public ElementOutlineImpl getElement(CElementInfo cElementInfo) {
        ElementOutlineImpl elementOutlineImpl = this.elements.get(cElementInfo);
        if (elementOutlineImpl == null && cElementInfo.hasClass()) {
            elementOutlineImpl = new ElementOutlineImpl(this, cElementInfo);
        }
        return elementOutlineImpl;
    }

    @Override
    public EnumOutline getEnum(CEnumLeafInfo cEnumLeafInfo) {
        return this.enums.get(cEnumLeafInfo);
    }

    @Override
    public Collection<EnumOutline> getEnums() {
        return this.enums.values();
    }

    @Override
    public Iterable<? extends PackageOutline> getAllPackageContexts() {
        return this.packageContexts.values();
    }

    @Override
    public FieldOutline getField(CPropertyInfo cPropertyInfo) {
        return this.fields.get(cPropertyInfo);
    }

    private void generateClassBody(ClassOutlineImpl classOutlineImpl) {
        Iterator<CPropertyInfo> iterator;
        CClassInfo cClassInfo = classOutlineImpl.target;
        if (this.model.serializable) {
            classOutlineImpl.implClass._implements(Serializable.class);
            if (this.model.serialVersionUID != null) {
                classOutlineImpl.implClass.field(28, this.codeModel.LONG, "serialVersionUID", JExpr.lit(this.model.serialVersionUID));
            }
        }
        String string = classOutlineImpl._package().getMostUsedNamespaceURI();
        XmlTypeWriter xmlTypeWriter = classOutlineImpl.implClass.annotate2(XmlTypeWriter.class);
        QName qName = classOutlineImpl.target.getTypeName();
        if (qName == null) {
            xmlTypeWriter.name("");
        } else {
            xmlTypeWriter.name(qName.getLocalPart());
            iterator = qName.getNamespaceURI();
            if (!((String)((Object)iterator)).equals(string)) {
                xmlTypeWriter.namespace((String)((Object)iterator));
            }
        }
        if (cClassInfo.isElement()) {
            iterator = cClassInfo.getElementName().getNamespaceURI();
            String object = cClassInfo.getElementName().getLocalPart();
            XmlRootElementWriter xmlRootElementWriter = classOutlineImpl.implClass.annotate2(XmlRootElementWriter.class);
            xmlRootElementWriter.name(object);
            if (!((String)((Object)iterator)).equals(string)) {
                xmlRootElementWriter.namespace((String)((Object)iterator));
            }
        }
        if (cClassInfo.isOrdered()) {
            for (CPropertyInfo cPropertyInfo : cClassInfo.getProperties()) {
                if (cPropertyInfo instanceof CAttributePropertyInfo) continue;
                xmlTypeWriter.propOrder(cPropertyInfo.getName(false));
            }
        } else {
            xmlTypeWriter.getAnnotationUse().paramArray("propOrder");
        }
        for (CPropertyInfo cPropertyInfo : cClassInfo.getProperties()) {
            this.generateFieldDecl(classOutlineImpl, cPropertyInfo);
        }
        if (cClassInfo.declaresAttributeWildcard()) {
            this.generateAttributeWildcard(classOutlineImpl);
        }
        classOutlineImpl.ref.javadoc().append(cClassInfo.javadoc);
        classOutlineImpl._package().objectFactoryGenerator().populate(classOutlineImpl);
    }

    private void generateAttributeWildcard(ClassOutlineImpl classOutlineImpl) {
        String string = "otherAttributes";
        String string2 = this.model.getNameConverter().toClassName(string);
        JClass jClass = this.codeModel.ref(Map.class).narrow(QName.class, String.class);
        JClass jClass2 = this.codeModel.ref(HashMap.class).narrow(QName.class, String.class);
        JFieldVar jFieldVar = classOutlineImpl.implClass.field(4, jClass, string, (JExpression)JExpr._new(jClass2));
        jFieldVar.annotate2(XmlAnyAttributeWriter.class);
        MethodWriter methodWriter = classOutlineImpl.createMethodWriter();
        JMethod jMethod = methodWriter.declareMethod(jClass, "get" + string2);
        jMethod.javadoc().append("Gets a map that contains attributes that aren't bound to any typed property on this class.\n\n<p>\nthe map is keyed by the name of the attribute and \nthe value is the string value of the attribute.\n\nthe map returned by this method is live, and you can add new attribute\nby updating the map directly. Because of this design, there's no setter.\n");
        jMethod.javadoc().addReturn().append("always non-null");
        jMethod.body()._return(jFieldVar);
    }

    private EnumOutline generateEnum(CEnumLeafInfo cEnumLeafInfo) {
        Object object;
        Object object2;
        Object object3;
        JType jType = cEnumLeafInfo.base.toType(this, Aspect.EXPOSED).unboxify();
        JType jType2 = cEnumLeafInfo.base.toType(this, Aspect.IMPLEMENTATION).unboxify();
        JDefinedClass jDefinedClass = this.getClassFactory().createClass(this.getContainer(cEnumLeafInfo.parent, Aspect.EXPOSED), cEnumLeafInfo.shortName, cEnumLeafInfo.getLocator(), ClassType.ENUM);
        jDefinedClass.javadoc().append(cEnumLeafInfo.javadoc);
        XmlEnumWriter xmlEnumWriter = jDefinedClass.annotate2(XmlEnumWriter.class);
        xmlEnumWriter.value(jType);
        JCodeModel jCodeModel = this.model.codeModel;
        EnumOutline enumOutline = new EnumOutline(cEnumLeafInfo, jDefinedClass){};
        boolean bl = cEnumLeafInfo.needsValueField();
        HashSet<String> hashSet = new HashSet<String>();
        for (CEnumConstant object4 : cEnumLeafInfo.members) {
            object3 = object4.getName();
            if (!JJavaName.isJavaIdentifier((String)object3)) {
                this.getErrorReceiver().error(cEnumLeafInfo.getLocator(), Messages.ERR_UNUSABLE_NAME.format(object4.getLexicalValue(), object3));
            }
            if (!hashSet.add((String)object3)) {
                this.getErrorReceiver().error(cEnumLeafInfo.getLocator(), Messages.ERR_NAME_COLLISION.format(object3));
            }
            object2 = jDefinedClass.enumConstant((String)object3);
            if (bl) {
                ((JEnumConstant)object2).arg(cEnumLeafInfo.base.createConstant(this, new XmlString(object4.getLexicalValue())));
            }
            if (!object4.getLexicalValue().equals(object3)) {
                ((JEnumConstant)object2).annotate2(XmlEnumValueWriter.class).value(object4.getLexicalValue());
            }
            if (object4.javadoc != null) {
                ((JEnumConstant)object2).javadoc().append(object4.javadoc);
            }
            enumOutline.constants.add(new EnumConstantOutline(object4, (JEnumConstant)object2){});
        }
        if (bl) {
            object = jDefinedClass.field(12, jType, "value");
            jDefinedClass.method(1, jType, "value").body()._return((JExpression)object);
            JMethod jMethod = jDefinedClass.constructor(0);
            jMethod.body().assign((JAssignmentTarget)object, jMethod.param(jType2, "v"));
            JMethod jMethod2 = jDefinedClass.method(17, jDefinedClass, "fromValue");
            object3 = jMethod2.param(jType, "v");
            object2 = jMethod2.body().forEach(jDefinedClass, "c", jDefinedClass.staticInvoke("values"));
            JExpression jExpression = jType.isPrimitive() ? ((JForEach)object2).var().ref((JVar)object).eq((JExpression)object3) : ((JForEach)object2).var().ref((JVar)object).invoke("equals").arg((JExpression)object3);
            ((JForEach)object2).body()._if(jExpression)._then()._return(((JForEach)object2).var());
            JInvocation jInvocation = JExpr._new(jCodeModel.ref(IllegalArgumentException.class));
            if (jType.isPrimitive()) {
                jMethod2.body()._throw(jInvocation.arg(jCodeModel.ref(String.class).staticInvoke("valueOf").arg((JExpression)object3)));
            } else {
                jMethod2.body()._throw(jInvocation.arg(((JExpressionImpl)object3).invoke("toString")));
            }
        } else {
            jDefinedClass.method(1, String.class, "value").body()._return(JExpr.invoke("name"));
            object = jDefinedClass.method(17, jDefinedClass, "fromValue");
            ((JMethod)object).body()._return(JExpr.invoke("valueOf").arg(((JMethod)object).param(String.class, "v")));
        }
        return enumOutline;
    }

    private FieldOutline generateFieldDecl(ClassOutlineImpl classOutlineImpl, CPropertyInfo cPropertyInfo) {
        FieldRenderer fieldRenderer = cPropertyInfo.realization;
        if (fieldRenderer == null) {
            fieldRenderer = this.model.options.getFieldRendererFactory().getDefault();
        }
        FieldOutline fieldOutline = fieldRenderer.generate(classOutlineImpl, cPropertyInfo);
        this.fields.put(cPropertyInfo, fieldOutline);
        return fieldOutline;
    }

    public final void generateAdapterIfNecessary(CPropertyInfo cPropertyInfo, JAnnotatable jAnnotatable) {
        CAdapter cAdapter = cPropertyInfo.getAdapter();
        if (cAdapter != null) {
            if (cAdapter.getAdapterIfKnown() == SwaRefAdapter.class) {
                jAnnotatable.annotate(XmlAttachmentRef.class);
            } else {
                XmlJavaTypeAdapterWriter xmlJavaTypeAdapterWriter = jAnnotatable.annotate2(XmlJavaTypeAdapterWriter.class);
                xmlJavaTypeAdapterWriter.value(((NClass)cAdapter.adapterType).toType(this, Aspect.EXPOSED));
            }
        }
        switch (cPropertyInfo.id()) {
            case ID: {
                jAnnotatable.annotate(XmlID.class);
                break;
            }
            case IDREF: {
                jAnnotatable.annotate(XmlIDREF.class);
            }
        }
        if (cPropertyInfo.getExpectedMimeType() != null) {
            jAnnotatable.annotate2(XmlMimeTypeWriter.class).value(cPropertyInfo.getExpectedMimeType().toString());
        }
    }

    @Override
    public final JClass addRuntime(Class clazz) {
        JClass jClass = this.generatedRuntime.get(clazz);
        if (jClass == null) {
            JPackage jPackage = this.getUsedPackages(Aspect.IMPLEMENTATION)[0].subPackage("runtime");
            jClass = this.generateStaticClass(clazz, jPackage);
            this.generatedRuntime.put(clazz, jClass);
        }
        return jClass;
    }

    public JClass generateStaticClass(Class clazz, JPackage jPackage) {
        String string = this.getShortName(clazz.getName());
        URL uRL = clazz.getResource(string + ".java");
        if (uRL == null) {
            uRL = clazz.getResource(string + ".java_");
        }
        if (uRL == null) {
            throw new InternalError("Unable to load source code of " + clazz.getName() + " as a resource");
        }
        JStaticJavaFile jStaticJavaFile = new JStaticJavaFile(jPackage, string, uRL, null);
        jPackage.addResourceFile(jStaticJavaFile);
        return jStaticJavaFile.getJClass();
    }

    private String getShortName(String string) {
        return string.substring(string.lastIndexOf(46) + 1);
    }
}

