/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.internal.xjc.reader;

import com.sun.tools.internal.xjc.Options;
import com.sun.tools.internal.xjc.Plugin;
import com.sun.tools.internal.xjc.reader.Messages;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.NamespaceSupport;
import org.xml.sax.helpers.XMLFilterImpl;

public final class ExtensionBindingChecker
extends XMLFilterImpl {
    private final NamespaceSupport nsSupport = new NamespaceSupport();
    private int count = 0;
    private final Set<String> enabledExtensions = new HashSet<String>();
    private final Set<String> recognizableExtensions = new HashSet<String>();
    private Locator locator;
    private int cutDepth = 0;
    private static final ContentHandler stub = new DefaultHandler();
    private ContentHandler next;
    private final String schemaLanguage;
    private final boolean allowExtensions;
    private final Options options;

    public ExtensionBindingChecker(String string, Options options, ErrorHandler errorHandler) {
        this.schemaLanguage = string;
        this.allowExtensions = options.compatibilityMode != 1;
        this.options = options;
        this.setErrorHandler(errorHandler);
        for (Plugin plugin : options.getAllPlugins()) {
            this.recognizableExtensions.addAll(plugin.getCustomizationURIs());
        }
        this.recognizableExtensions.add("http://java.sun.com/xml/ns/jaxb/xjc");
    }

    private boolean isSupportedExtension(String string) {
        if (string.equals("http://java.sun.com/xml/ns/jaxb/xjc")) {
            return true;
        }
        return this.options.pluginURIs.contains(string);
    }

    private boolean isRecognizableExtension(String string) {
        return this.recognizableExtensions.contains(string);
    }

    private boolean needsToBePruned(String string) {
        if (string.equals(this.schemaLanguage)) {
            return false;
        }
        if (string.equals("http://java.sun.com/xml/ns/jaxb")) {
            return false;
        }
        if (this.enabledExtensions.contains(string)) {
            return false;
        }
        return this.isRecognizableExtension(string);
    }

    public void startDocument() throws SAXException {
        super.startDocument();
        this.count = 0;
        this.cutDepth = 0;
        this.nsSupport.reset();
        this.enabledExtensions.clear();
    }

    public void startPrefixMapping(String string, String string2) throws SAXException {
        super.startPrefixMapping(string, string2);
        this.nsSupport.pushContext();
        this.nsSupport.declarePrefix(string, string2);
    }

    public void endPrefixMapping(String string) throws SAXException {
        super.endPrefixMapping(string);
        this.nsSupport.popContext();
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (this.cutDepth == 0) {
            String string4 = attributes.getValue("http://java.sun.com/xml/ns/jaxb", "extensionBindingPrefixes");
            if (string4 != null) {
                if (this.count != 0) {
                    this.error(Messages.ERR_UNEXPECTED_EXTENSION_BINDING_PREFIXES.format(new Object[0]));
                }
                if (!this.allowExtensions) {
                    this.error(Messages.ERR_VENDOR_EXTENSION_DISALLOWED_IN_STRICT_MODE.format(new Object[0]));
                }
                StringTokenizer stringTokenizer = new StringTokenizer(string4);
                while (stringTokenizer.hasMoreTokens()) {
                    String string5 = stringTokenizer.nextToken();
                    String object = this.nsSupport.getURI(string5);
                    if (object == null) {
                        this.error(Messages.ERR_UNDECLARED_PREFIX.format(string5));
                        continue;
                    }
                    if (!this.isRecognizableExtension(object)) {
                        this.error(Messages.ERR_UNSUPPORTED_EXTENSION.format(string5));
                    } else if (!this.isSupportedExtension(object)) {
                        Plugin plugin = null;
                        for (Plugin plugin2 : this.options.getAllPlugins()) {
                            if (!plugin2.getCustomizationURIs().contains(object)) continue;
                            plugin = plugin2;
                            break;
                        }
                        if (plugin != null) {
                            this.error(Messages.ERR_PLUGIN_NOT_ENABLED.format(plugin.getOptionName(), object));
                        } else {
                            this.error(Messages.ERR_UNSUPPORTED_EXTENSION.format(string5));
                        }
                    }
                    this.enabledExtensions.add(object);
                }
            }
            if (this.needsToBePruned(string)) {
                if (this.isRecognizableExtension(string)) {
                    this.warning(Messages.ERR_SUPPORTED_EXTENSION_IGNORED.format(string));
                }
                super.setContentHandler(stub);
                this.cutDepth = 1;
            } else if (this.options.pluginURIs.contains(string)) {
                boolean bl = false;
                for (Plugin plugin : this.options.activePlugins) {
                    if (!plugin.isCustomizationTagName(string, string2)) continue;
                    bl = true;
                    break;
                }
                if (!bl) {
                    this.error(Messages.ERR_ILLEGAL_CUSTOMIZATION_TAGNAME.format(string3));
                    super.setContentHandler(stub);
                    this.cutDepth = 1;
                }
            }
        } else {
            ++this.cutDepth;
        }
        ++this.count;
        super.startElement(string, string2, string3, attributes);
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        super.endElement(string, string2, string3);
        if (this.cutDepth != 0) {
            --this.cutDepth;
            if (this.cutDepth == 0) {
                super.setContentHandler(this.next);
            }
        }
    }

    public void setDocumentLocator(Locator locator) {
        super.setDocumentLocator(locator);
        this.locator = locator;
    }

    public void setContentHandler(ContentHandler contentHandler) {
        this.next = contentHandler;
        if (this.getContentHandler() != stub) {
            super.setContentHandler(contentHandler);
        }
    }

    private SAXParseException error(String string) throws SAXException {
        SAXParseException sAXParseException = new SAXParseException(string, this.locator);
        this.getErrorHandler().error(sAXParseException);
        return sAXParseException;
    }

    private void warning(String string) throws SAXException {
        SAXParseException sAXParseException = new SAXParseException(string, this.locator);
        this.getErrorHandler().warning(sAXParseException);
    }
}

