/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.internal.xjc.reader.internalizer;

import com.sun.tools.internal.xjc.reader.internalizer.DOMForest;
import com.sun.xml.internal.bind.unmarshaller.DOMScanner;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.XMLFilterImpl;

public class DOMForestScanner {
    private final DOMForest forest;

    public DOMForestScanner(DOMForest dOMForest) {
        this.forest = dOMForest;
    }

    public void scan(Element element, ContentHandler contentHandler) throws SAXException {
        DOMScanner dOMScanner = new DOMScanner();
        LocationResolver locationResolver = new LocationResolver(dOMScanner);
        locationResolver.setContentHandler(contentHandler);
        dOMScanner.setContentHandler((ContentHandler)locationResolver);
        dOMScanner.scan(element);
    }

    public void scan(Document document, ContentHandler contentHandler) throws SAXException {
        this.scan(document.getDocumentElement(), contentHandler);
    }

    private class LocationResolver
    extends XMLFilterImpl
    implements Locator {
        private final DOMScanner parent;
        private boolean inStart = false;

        LocationResolver(DOMScanner dOMScanner) {
            this.parent = dOMScanner;
        }

        public void setDocumentLocator(Locator locator) {
            super.setDocumentLocator(this);
        }

        public void endElement(String string, String string2, String string3) throws SAXException {
            this.inStart = false;
            super.endElement(string, string2, string3);
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            this.inStart = true;
            super.startElement(string, string2, string3, attributes);
        }

        private Locator findLocator() {
            Node node = this.parent.getCurrentLocation();
            if (node instanceof Element) {
                Element element = (Element)node;
                if (this.inStart) {
                    return ((DOMForestScanner)DOMForestScanner.this).forest.locatorTable.getStartLocation(element);
                }
                return ((DOMForestScanner)DOMForestScanner.this).forest.locatorTable.getEndLocation(element);
            }
            return null;
        }

        public int getColumnNumber() {
            Locator locator = this.findLocator();
            if (locator != null) {
                return locator.getColumnNumber();
            }
            return -1;
        }

        public int getLineNumber() {
            Locator locator = this.findLocator();
            if (locator != null) {
                return locator.getLineNumber();
            }
            return -1;
        }

        public String getPublicId() {
            Locator locator = this.findLocator();
            if (locator != null) {
                return locator.getPublicId();
            }
            return null;
        }

        public String getSystemId() {
            Locator locator = this.findLocator();
            if (locator != null) {
                return locator.getSystemId();
            }
            return null;
        }
    }
}

