/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.rngom.binary;

import com.sun.xml.internal.rngom.binary.Alphabet;
import com.sun.xml.internal.rngom.binary.DuplicateAttributeDetector;
import com.sun.xml.internal.rngom.binary.Pattern;
import com.sun.xml.internal.rngom.binary.RestrictionViolationException;
import com.sun.xml.internal.rngom.binary.SchemaPatternBuilder;
import com.sun.xml.internal.rngom.binary.visitor.PatternFunction;
import com.sun.xml.internal.rngom.binary.visitor.PatternVisitor;
import com.sun.xml.internal.rngom.nc.NameClass;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public final class ElementPattern
extends Pattern {
    private Pattern p;
    private NameClass origNameClass;
    private NameClass nameClass;
    private boolean expanded = false;
    private boolean checkedRestrictions = false;
    private Locator loc;

    ElementPattern(NameClass nameClass, Pattern pattern, Locator locator) {
        super(false, 1, ElementPattern.combineHashCode(23, nameClass.hashCode(), pattern.hashCode()));
        this.nameClass = nameClass;
        this.origNameClass = nameClass;
        this.p = pattern;
        this.loc = locator;
    }

    void checkRestrictions(int n, DuplicateAttributeDetector duplicateAttributeDetector, Alphabet alphabet) throws RestrictionViolationException {
        if (alphabet != null) {
            alphabet.addElement(this.origNameClass);
        }
        if (this.checkedRestrictions) {
            return;
        }
        switch (n) {
            case 7: {
                throw new RestrictionViolationException("data_except_contains_element");
            }
            case 6: {
                throw new RestrictionViolationException("list_contains_element");
            }
            case 5: {
                throw new RestrictionViolationException("attribute_contains_element");
            }
        }
        this.checkedRestrictions = true;
        try {
            this.p.checkRestrictions(1, new DuplicateAttributeDetector(), null);
        }
        catch (RestrictionViolationException restrictionViolationException) {
            this.checkedRestrictions = false;
            restrictionViolationException.maybeSetLocator(this.loc);
            throw restrictionViolationException;
        }
    }

    Pattern expand(SchemaPatternBuilder schemaPatternBuilder) {
        if (!this.expanded) {
            this.expanded = true;
            this.p = this.p.expand(schemaPatternBuilder);
            if (this.p.isNotAllowed()) {
                this.nameClass = NameClass.NULL;
            }
        }
        return this;
    }

    boolean samePattern(Pattern pattern) {
        if (!(pattern instanceof ElementPattern)) {
            return false;
        }
        ElementPattern elementPattern = (ElementPattern)pattern;
        return this.nameClass.equals(elementPattern.nameClass) && this.p == elementPattern.p;
    }

    void checkRecursion(int n) throws SAXException {
        this.p.checkRecursion(n + 1);
    }

    public void accept(PatternVisitor patternVisitor) {
        patternVisitor.visitElement(this.nameClass, this.p);
    }

    public Object apply(PatternFunction patternFunction) {
        return patternFunction.caseElement(this);
    }

    void setContent(Pattern pattern) {
        this.p = pattern;
    }

    public Pattern getContent() {
        return this.p;
    }

    public NameClass getNameClass() {
        return this.nameClass;
    }

    public Locator getLocator() {
        return this.loc;
    }
}

