/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.jstat;

public class Token {
    public String sval;
    public double nval;
    public int ttype;

    public Token(int n, String string, double d) {
        this.ttype = n;
        this.sval = string;
        this.nval = d;
    }

    public Token(int n, String string) {
        this(n, string, 0.0);
    }

    public Token(int n) {
        this(n, null, 0.0);
    }

    public String toMessage() {
        switch (this.ttype) {
            case 10: {
                return "\"EOL\"";
            }
            case -1: {
                return "\"EOF\"";
            }
            case -2: {
                return "NUMBER";
            }
            case -3: {
                if (this.sval == null) {
                    return "IDENTIFIER";
                }
                return "IDENTIFIER " + this.sval;
            }
        }
        if (this.ttype == 34) {
            String string = "QUOTED STRING";
            if (this.sval != null) {
                string = string + " \"" + this.sval + "\"";
            }
            return string;
        }
        return "CHARACTER '" + (char)this.ttype + "'";
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        switch (this.ttype) {
            case 10: {
                stringBuilder.append("ttype=TT_EOL");
                break;
            }
            case -1: {
                stringBuilder.append("ttype=TT_EOF");
                break;
            }
            case -2: {
                stringBuilder.append("ttype=TT_NUM,").append("nval=" + this.nval);
                break;
            }
            case -3: {
                if (this.sval == null) {
                    stringBuilder.append("ttype=TT_WORD:IDENTIFIER");
                    break;
                }
                stringBuilder.append("ttype=TT_WORD:").append("sval=" + this.sval);
                break;
            }
            default: {
                if (this.ttype == 34) {
                    stringBuilder.append("ttype=TT_STRING:").append("sval=" + this.sval);
                    break;
                }
                stringBuilder.append("ttype=TT_CHAR:").append((char)this.ttype);
            }
        }
        return stringBuilder.toString();
    }
}

