/*
 * Decompiled with CFR 0.152.
 */
package sun.io;

import sun.io.CharToByteConverter;
import sun.io.ConversionBufferFullException;
import sun.io.MalformedInputException;
import sun.io.UnknownCharacterException;
import sun.nio.cs.ext.EUC_TW;

public class CharToByteEUC_TW
extends CharToByteConverter {
    private final byte MSB = (byte)-128;
    private final byte SS2 = (byte)-114;
    private final byte P2 = (byte)-94;
    private final byte P3 = (byte)-93;
    private static final EUC_TW nioCoder = new EUC_TW();
    private static String uniTab1 = nioCoder.getUniTab1();
    private static String uniTab2 = nioCoder.getUniTab2();
    private static String uniTab3 = nioCoder.getUniTab3();
    private static String cnsTab1 = nioCoder.getCNSTab1();
    private static String cnsTab2 = nioCoder.getCNSTab2();
    private static String cnsTab3 = nioCoder.getCNSTab3();
    private char[] UniTab1 = uniTab1.toCharArray();
    private char[] UniTab2 = uniTab2.toCharArray();
    private char[] UniTab3 = uniTab3.toCharArray();
    private char[] CNSTab1 = cnsTab1.toCharArray();
    private char[] CNSTab2 = cnsTab2.toCharArray();
    private char[] CNSTab3 = cnsTab3.toCharArray();

    public int flush(byte[] byArray, int n, int n2) throws MalformedInputException {
        this.reset();
        return 0;
    }

    public void reset() {
        this.charOff = 0;
        this.byteOff = 0;
    }

    public boolean canConvert(char c) {
        return (0xFF00 & c) != 0 && this.getNative(c) != -1;
    }

    public int convert(char[] cArray, int n, int n2, byte[] byArray, int n3, int n4) throws UnknownCharacterException, MalformedInputException, ConversionBufferFullException {
        byte[] byArray2 = new byte[4];
        this.byteOff = n3;
        this.charOff = n;
        while (this.charOff < n2) {
            int n5;
            byte[] byArray3 = byArray2;
            if (cArray[this.charOff] < '\u0080') {
                n5 = 1;
                byArray3[0] = (byte)(cArray[this.charOff] & 0x7F);
            } else {
                n5 = this.unicodeToEUC(cArray[this.charOff], byArray3);
            }
            if (n5 == -1) {
                if (this.subMode) {
                    byArray3 = this.subBytes;
                    n5 = this.subBytes.length;
                } else {
                    this.badInputLength = 1;
                    throw new UnknownCharacterException();
                }
            }
            if (n4 - this.byteOff < n5) {
                throw new ConversionBufferFullException();
            }
            for (int i = 0; i < n5; ++i) {
                byArray[this.byteOff++] = byArray3[i];
            }
            ++this.charOff;
        }
        return this.byteOff - n3;
    }

    public int getMaxBytesPerChar() {
        return 4;
    }

    public String getCharacterEncoding() {
        return "EUC_TW";
    }

    protected int getNative(char c) {
        if (c < this.UniTab2[0]) {
            int n = this.searchTab(c, this.UniTab1);
            if (n == -1) {
                return -1;
            }
            int n2 = (this.CNSTab1[2 * n] << 16) + this.CNSTab1[2 * n + 1];
            return n2;
        }
        if (c < this.UniTab3[0]) {
            int n = this.searchTab(c, this.UniTab2);
            if (n == -1) {
                return -1;
            }
            int n3 = (this.CNSTab2[2 * n] << 16) + this.CNSTab2[2 * n + 1];
            return n3;
        }
        int n = this.searchTab(c, this.UniTab3);
        if (n == -1) {
            return -1;
        }
        int n4 = (this.CNSTab3[2 * n] << 16) + this.CNSTab3[2 * n + 1];
        return n4;
    }

    protected int searchTab(char c, char[] cArray) {
        int n = 0;
        int n2 = 0;
        int n3 = cArray.length - 1;
        while (n2 < n3) {
            if (cArray[n2] == c) {
                n = n2;
                break;
            }
            if (cArray[n3] == c) {
                n = n3;
                break;
            }
            n = (n2 + n3) / 2;
            if (cArray[n] == c) break;
            if (cArray[n] < c) {
                n2 = n + 1;
                continue;
            }
            n3 = n - 1;
        }
        if (c == cArray[n]) {
            return n;
        }
        return -1;
    }

    private int unicodeToEUC(char c, byte[] byArray) {
        int n = this.getNative(c);
        if (n >> 16 == 1) {
            byArray[0] = (byte)((n & 0xFF00) >> 8 | 0xFFFFFF80);
            byArray[1] = (byte)(n & 0xFF | 0xFFFFFF80);
            return 2;
        }
        byte by = (byte)(n >> 16);
        if (by >= 2) {
            byArray[0] = -114;
            byArray[1] = (byte)(by | 0xFFFFFFA0);
            byArray[2] = (byte)((n & 0xFF00) >> 8 | 0xFFFFFF80);
            byArray[3] = (byte)(n & 0xFF | 0xFFFFFF80);
            return 4;
        }
        return -1;
    }

    protected int unicodeToEUC(char c) {
        if (c <= '\u007f') {
            return c;
        }
        int n = this.getNative(c);
        int n2 = n >> 16;
        int n3 = n & 0xFFFF | 0x8080;
        if (n2 == 1) {
            return n3;
        }
        if (n2 == 2) {
            return 0x8EA20000 | n3;
        }
        if (n2 == 3) {
            return 0x8EA30000 | n3;
        }
        return -1;
    }
}

