/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.security.keys.keyresolver.implementations;

import com.sun.org.apache.xml.internal.security.exceptions.XMLSecurityException;
import com.sun.org.apache.xml.internal.security.keys.content.keyvalues.RSAKeyValue;
import com.sun.org.apache.xml.internal.security.keys.keyresolver.KeyResolverSpi;
import com.sun.org.apache.xml.internal.security.keys.storage.StorageResolver;
import com.sun.org.apache.xml.internal.security.utils.XMLUtils;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.SecretKey;
import org.w3c.dom.Element;

public class RSAKeyValueResolver
extends KeyResolverSpi {
    static Logger log = Logger.getLogger(RSAKeyValueResolver.class.getName());

    public PublicKey engineLookupAndResolvePublicKey(Element element, String string, StorageResolver storageResolver) {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Can I resolve " + element.getTagName());
        }
        if (element == null) {
            return null;
        }
        boolean bl = XMLUtils.elementIsInSignatureSpace(element, "KeyValue");
        Element element2 = null;
        if (bl) {
            element2 = XMLUtils.selectDsNode(element.getFirstChild(), "RSAKeyValue", 0);
        } else if (XMLUtils.elementIsInSignatureSpace(element, "RSAKeyValue")) {
            element2 = element;
        }
        if (element2 == null) {
            return null;
        }
        try {
            RSAKeyValue rSAKeyValue = new RSAKeyValue(element2, string);
            return rSAKeyValue.getPublicKey();
        }
        catch (XMLSecurityException xMLSecurityException) {
            log.log(Level.FINE, "XMLSecurityException", xMLSecurityException);
            return null;
        }
    }

    public X509Certificate engineLookupResolveX509Certificate(Element element, String string, StorageResolver storageResolver) {
        return null;
    }

    public SecretKey engineLookupAndResolveSecretKey(Element element, String string, StorageResolver storageResolver) {
        return null;
    }
}

