/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.leaderboard;

import com.google.android.gms.common.data.d;
import com.google.android.gms.internal.dl;
import com.google.android.gms.internal.dm;
import com.google.android.gms.internal.ev;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SubmitScoreResult {
    private static final String[] nI = new String[]{"leaderboardId", "playerId", "timeSpan", "hasResult", "rawScore", "formattedScore", "newBest", "scoreTag"};
    private String nJ;
    private String mD;
    private int iC;
    private HashMap<Integer, Result> nK;

    public SubmitScoreResult(int statusCode, String leaderboardId, String playerId, HashMap<Integer, Result> results) {
        this.iC = statusCode;
        this.nJ = leaderboardId;
        this.mD = playerId;
        this.nK = results;
    }

    public SubmitScoreResult(int statusCode, String leaderboardId, String playerId) {
        this(statusCode, leaderboardId, playerId, new HashMap<Integer, Result>());
    }

    public SubmitScoreResult(d dataHolder) {
        this.iC = dataHolder.getStatusCode();
        this.nK = new HashMap();
        int n2 = dataHolder.getCount();
        dm.m(n2 == 3);
        for (int i2 = 0; i2 < n2; ++i2) {
            boolean bl2;
            int n3 = dataHolder.q(i2);
            if (i2 == 0) {
                this.nJ = dataHolder.c("leaderboardId", i2, n3);
                this.mD = dataHolder.c("playerId", i2, n3);
            }
            if (!(bl2 = dataHolder.d("hasResult", i2, n3))) continue;
            Result result = new Result(dataHolder.a("rawScore", i2, n3), dataHolder.c("formattedScore", i2, n3), dataHolder.c("scoreTag", i2, n3), dataHolder.d("newBest", i2, n3));
            this.a(result, dataHolder.b("timeSpan", i2, n3));
        }
    }

    public String getLeaderboardId() {
        return this.nJ;
    }

    public String getPlayerId() {
        return this.mD;
    }

    public int getStatusCode() {
        return this.iC;
    }

    public Result getScoreResult(int timeSpan) {
        return this.nK.get(timeSpan);
    }

    private void a(Result result, int n2) {
        this.nK.put(n2, result);
    }

    public String toString() {
        dl.a a2 = dl.d(this).a("PlayerId", this.mD).a("StatusCode", this.iC);
        for (int i2 = 0; i2 < 3; ++i2) {
            Result result = this.nK.get(i2);
            a2.a("TimesSpan", ev.R(i2));
            a2.a("Result", result == null ? "null" : result.toString());
        }
        return a2.toString();
    }

    public static final class Result {
        public final long rawScore;
        public final String formattedScore;
        public final String scoreTag;
        public final boolean newBest;

        public Result(long rawScore, String formattedScore, String scoreTag, boolean newBest) {
            this.rawScore = rawScore;
            this.formattedScore = formattedScore;
            this.scoreTag = scoreTag;
            this.newBest = newBest;
        }

        public String toString() {
            return dl.d(this).a("RawScore", this.rawScore).a("FormattedScore", this.formattedScore).a("ScoreTag", this.scoreTag).a("NewBest", this.newBest).toString();
        }
    }
}

