/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.configurator;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.update.configurator.IPlatformConfiguration;
import org.eclipse.update.internal.configurator.BundleManifest;
import org.eclipse.update.internal.configurator.Configuration;
import org.eclipse.update.internal.configurator.ConfigurationActivator;
import org.eclipse.update.internal.configurator.FeatureEntry;
import org.eclipse.update.internal.configurator.FeatureParser;
import org.eclipse.update.internal.configurator.IConfigurationConstants;
import org.eclipse.update.internal.configurator.Messages;
import org.eclipse.update.internal.configurator.PlatformConfiguration;
import org.eclipse.update.internal.configurator.PluginEntry;
import org.eclipse.update.internal.configurator.PluginParser;
import org.eclipse.update.internal.configurator.SitePolicy;
import org.eclipse.update.internal.configurator.Utils;
import org.eclipse.update.internal.configurator.VersionedIdentifier;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class SiteEntry
implements IPlatformConfiguration.ISiteEntry,
IConfigurationConstants {
    private URL url;
    private URL resolvedURL;
    private IPlatformConfiguration.ISitePolicy policy;
    private boolean updateable = true;
    private Map featureEntries;
    private ArrayList pluginEntries;
    private long changeStamp;
    private long featuresChangeStamp;
    private long pluginsChangeStamp;
    private String linkFileName;
    private boolean enabled = true;
    private Configuration config;
    private static FeatureParser featureParser = new FeatureParser();
    private static PluginParser pluginParser = new PluginParser();

    public SiteEntry(URL url) {
        this(url, null);
    }

    public SiteEntry(URL url, IPlatformConfiguration.ISitePolicy policy) {
        if (url == null) {
            try {
                url = new URL("platform:/base/");
            }
            catch (MalformedURLException e) {
                url = PlatformConfiguration.getInstallURL();
            }
        }
        if (policy == null) {
            policy = new SitePolicy(1, IConfigurationConstants.DEFAULT_POLICY_LIST);
        }
        if (url.getProtocol().equals("file")) {
            try {
                this.url = new File(url.getFile()).toURL();
            }
            catch (MalformedURLException e1) {
                this.url = url;
            }
        } else {
            this.url = url;
        }
        this.policy = policy;
        this.resolvedURL = this.url;
        if (url.getProtocol().equals("platform")) {
            try {
                this.resolvedURL = PlatformConfiguration.resolvePlatformURL(url);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void setConfig(Configuration config) {
        this.config = config;
    }

    public Configuration getConfig() {
        return this.config;
    }

    public URL getURL() {
        return this.url;
    }

    public IPlatformConfiguration.ISitePolicy getSitePolicy() {
        return this.policy;
    }

    public synchronized void setSitePolicy(IPlatformConfiguration.ISitePolicy policy) {
        if (policy == null) {
            throw new IllegalArgumentException();
        }
        this.policy = policy;
    }

    public String[] getFeatures() {
        return this.getDetectedFeatures();
    }

    public String[] getPlugins() {
        IPlatformConfiguration.ISitePolicy policy = this.getSitePolicy();
        if (policy.getType() == 0) {
            return policy.getList();
        }
        if (policy.getType() == 1) {
            ArrayList<String> detectedPlugins = new ArrayList<String>(Arrays.asList(this.getDetectedPlugins()));
            String[] excludedPlugins = policy.getList();
            for (int i = 0; i < excludedPlugins.length; ++i) {
                if (!detectedPlugins.contains(excludedPlugins[i])) continue;
                detectedPlugins.remove(excludedPlugins[i]);
            }
            return detectedPlugins.toArray(new String[0]);
        }
        return new String[0];
    }

    public PluginEntry[] getPluginEntries() {
        String[] pluginURLs = this.getPlugins();
        HashMap<String, String> map = new HashMap<String, String>(pluginURLs.length);
        for (int i = 0; i < pluginURLs.length; ++i) {
            map.put(pluginURLs[i], pluginURLs[i]);
        }
        if (this.pluginEntries == null) {
            this.detectPlugins();
        }
        ArrayList<PluginEntry> plugins = new ArrayList<PluginEntry>(pluginURLs.length);
        for (int i = 0; i < this.pluginEntries.size(); ++i) {
            PluginEntry p = (PluginEntry)this.pluginEntries.get(i);
            if (!map.containsKey(p.getURL())) continue;
            plugins.add(p);
        }
        return plugins.toArray(new PluginEntry[plugins.size()]);
    }

    public long getChangeStamp() {
        if (this.changeStamp == 0L) {
            this.computeChangeStamp();
        }
        return this.changeStamp;
    }

    public long getFeaturesChangeStamp() {
        if (this.featuresChangeStamp == 0L) {
            this.computeFeaturesChangeStamp();
        }
        return this.featuresChangeStamp;
    }

    public long getPluginsChangeStamp() {
        if (this.pluginsChangeStamp == 0L) {
            this.computePluginsChangeStamp();
        }
        return this.pluginsChangeStamp;
    }

    public boolean isUpdateable() {
        return this.updateable;
    }

    public void setUpdateable(boolean updateable) {
        this.updateable = updateable;
    }

    public boolean isNativelyLinked() {
        return this.isExternallyLinkedSite();
    }

    public URL getResolvedURL() {
        return this.resolvedURL;
    }

    private void detectFeatures() {
        if (this.featureEntries != null) {
            this.validateFeatureEntries();
        } else {
            this.featureEntries = new HashMap();
        }
        if (!PlatformConfiguration.supportsDetection(this.resolvedURL)) {
            return;
        }
        File siteRoot = new File(this.resolvedURL.getFile().replace('/', File.separatorChar));
        File featuresDir = new File(siteRoot, "features");
        if (featuresDir.exists()) {
            File[] dirs = featuresDir.listFiles(new FileFilter(){

                public boolean accept(File f) {
                    boolean valid;
                    boolean bl = valid = f.isDirectory() && new File(f, "feature.xml").exists();
                    if (!valid) {
                        Utils.log(Messages.getString("SiteEntry.cannotFindFeatureInDir", f.getAbsolutePath()));
                    }
                    return valid;
                }
            });
            for (int index = 0; index < dirs.length; ++index) {
                try {
                    URL featureURL;
                    FeatureEntry featureEntry;
                    File featureXML = new File(dirs[index], "feature.xml");
                    if (featureXML.lastModified() <= this.featuresChangeStamp && dirs[index].lastModified() <= this.featuresChangeStamp || (featureEntry = featureParser.parse(featureURL = featureXML.toURL())) == null) continue;
                    this.addFeatureEntry(featureEntry);
                    continue;
                }
                catch (MalformedURLException e) {
                    Utils.log(Messages.getString("InstalledSiteParser.UnableToCreateURLForFile", featuresDir.getAbsolutePath()));
                }
            }
        }
        Utils.debug(this.resolvedURL.toString() + " located  " + this.featureEntries.size() + " feature(s)");
    }

    private void detectPlugins() {
        boolean compareTimeStamps = false;
        if (this.pluginEntries != null) {
            this.validatePluginEntries();
            compareTimeStamps = true;
        } else {
            this.pluginEntries = new ArrayList();
        }
        if (!PlatformConfiguration.supportsDetection(this.resolvedURL)) {
            return;
        }
        File pluginsDir = new File(this.resolvedURL.getFile(), "plugins");
        if (pluginsDir.exists() && pluginsDir.isDirectory()) {
            File[] files = pluginsDir.listFiles();
            for (int i = 0; i < files.length; ++i) {
                if (files[i].isDirectory()) {
                    this.detectUnpackedPlugin(files[i], compareTimeStamps);
                    continue;
                }
                if (!files[i].getName().endsWith(".jar")) continue;
                this.detectPackedPlugin(files[i], compareTimeStamps);
            }
        }
        Utils.debug(this.resolvedURL.toString() + " located  " + this.pluginEntries.size() + " plugin(s)");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void detectPackedPlugin(File file, boolean compareTimeStamps) {
        block48: {
            block47: {
                block39: {
                    block46: {
                        block37: {
                            block38: {
                                if (compareTimeStamps && file.lastModified() <= this.pluginsChangeStamp) {
                                    return;
                                }
                                entryName = "META-INF/MANIFEST.MF";
                                z = null;
                                bundleManifestIn = null;
                                pluginManifestIn = null;
                                pluginURL = "plugins/" + file.getName();
                                try {
                                    try {
                                        z = new ZipFile(file);
                                        if (z.getEntry(entryName) != null && (manifest = new BundleManifest(bundleManifestIn = z.getInputStream(new ZipEntry(entryName)), pluginURL)).exists()) {
                                            this.addPluginEntry(manifest.getPluginEntry());
                                            var11_11 = null;
                                            if (bundleManifestIn == null) break block37;
                                            break block38;
                                        }
                                        entryName = "plugin.xml";
                                        if (z.getEntry(entryName) == null) {
                                            entryName = "fragment.xml";
                                        }
                                        if (z.getEntry(entryName) != null) {
                                            pluginManifestIn = z.getInputStream(new ZipEntry(entryName));
                                            entry1 = SiteEntry.pluginParser.parse(pluginManifestIn, pluginURL);
                                            this.addPluginEntry(entry1);
                                        }
                                        break block39;
                                    }
                                    catch (IOException e5) {
                                        pluginFileString2 = pluginURL + "!" + entryName;
                                        Utils.log(Messages.getString("InstalledSiteParser.ErrorAccessing", pluginFileString2));
                                        var11_13 = null;
                                        if (bundleManifestIn != null) {
                                            try {
                                                bundleManifestIn.close();
                                            }
                                            catch (IOException e4) {
                                                // empty catch block
                                            }
                                        }
                                        if (pluginManifestIn != null) {
                                            try {
                                                pluginManifestIn.close();
                                            }
                                            catch (IOException e2) {
                                                // empty catch block
                                            }
                                        }
                                        if (z == null) return;
                                        try {
                                            z.close();
                                            return;
                                        }
                                        catch (IOException e1) {
                                            return;
                                        }
                                    }
                                    catch (SAXException e3) {
                                        block43: {
                                            block42: {
                                                pluginFileString1 = pluginURL + "!" + entryName;
                                                Utils.log(Messages.getString("InstalledSiteParser.ErrorParsingFile", pluginFileString1));
                                                var11_14 = null;
                                                if (bundleManifestIn != null) {
                                                    ** try [egrp 2[TRYBLOCK] [9 : 287->295)] { 
lbl57:
                                                    // 1 sources

                                                    bundleManifestIn.close();
                                                    break block42;
lbl59:
                                                    // 1 sources

                                                    catch (IOException e4) {
                                                        // empty catch block
                                                    }
                                                }
                                            }
                                            if (pluginManifestIn != null) {
                                                ** try [egrp 3[TRYBLOCK] [10 : 302->310)] { 
lbl64:
                                                // 1 sources

                                                pluginManifestIn.close();
                                                break block43;
lbl66:
                                                // 1 sources

                                                catch (IOException e2) {
                                                    // empty catch block
                                                }
                                            }
                                        }
                                        if (z == null) return;
                                        try {}
                                        catch (IOException e1) {
                                            return;
                                        }
                                        z.close();
                                        return;
                                    }
                                }
                                catch (Throwable var10_23) {
                                    block45: {
                                        block44: {
                                            var11_15 = null;
                                            if (bundleManifestIn != null) {
                                                ** try [egrp 2[TRYBLOCK] [9 : 287->295)] { 
lbl80:
                                                // 1 sources

                                                bundleManifestIn.close();
                                                break block44;
lbl82:
                                                // 1 sources

                                                catch (IOException e4) {
                                                    // empty catch block
                                                }
                                            }
                                        }
                                        if (pluginManifestIn != null) {
                                            ** try [egrp 3[TRYBLOCK] [10 : 302->310)] { 
lbl87:
                                            // 1 sources

                                            pluginManifestIn.close();
                                            break block45;
lbl89:
                                            // 1 sources

                                            catch (IOException e2) {
                                                // empty catch block
                                            }
                                        }
                                    }
                                    if (z == null) throw var10_23;
                                    ** try [egrp 4[TRYBLOCK] [11 : 317->325)] { 
lbl94:
                                    // 1 sources

                                    z.close();
                                    throw var10_23;
lbl96:
                                    // 1 sources

                                    catch (IOException e1) {
                                        // empty catch block
                                    }
                                    throw var10_23;
                                }
                            }
                            ** try [egrp 2[TRYBLOCK] [9 : 287->295)] { 
lbl101:
                            // 1 sources

                            bundleManifestIn.close();
                            break block37;
lbl103:
                            // 1 sources

                            catch (IOException e4) {
                                // empty catch block
                            }
                        }
                        if (pluginManifestIn != null) {
                            ** try [egrp 3[TRYBLOCK] [10 : 302->310)] { 
lbl108:
                            // 1 sources

                            pluginManifestIn.close();
                            break block46;
lbl110:
                            // 1 sources

                            catch (IOException e2) {
                                // empty catch block
                            }
                        }
                    }
                    if (z == null) return;
                    ** try [egrp 4[TRYBLOCK] [11 : 317->325)] { 
lbl115:
                    // 1 sources

                    z.close();
                    return;
lbl117:
                    // 1 sources

                    catch (IOException e1) {
                        // empty catch block
                    }
                    return;
                }
                var11_12 = null;
                if (bundleManifestIn != null) {
                    ** try [egrp 2[TRYBLOCK] [9 : 287->295)] { 
lbl124:
                    // 1 sources

                    bundleManifestIn.close();
                    break block47;
lbl126:
                    // 1 sources

                    catch (IOException e4) {
                        // empty catch block
                    }
                }
            }
            if (pluginManifestIn != null) {
                ** try [egrp 3[TRYBLOCK] [10 : 302->310)] { 
lbl131:
                // 1 sources

                pluginManifestIn.close();
                break block48;
lbl133:
                // 1 sources

                catch (IOException e2) {
                    // empty catch block
                }
            }
        }
        if (z == null) return;
        try {}
        catch (IOException e1) {}
        z.close();
        return;
    }

    private void detectUnpackedPlugin(File file, boolean compareTimeStamps) {
        long dirTimestamp = file.lastModified();
        File pluginFile = new File(file, "META-INF/MANIFEST.MF");
        try {
            BundleManifest bundleManifest = new BundleManifest(pluginFile);
            if (bundleManifest.exists()) {
                if (compareTimeStamps && dirTimestamp <= this.pluginsChangeStamp && pluginFile.lastModified() <= this.pluginsChangeStamp) {
                    return;
                }
                PluginEntry entry = bundleManifest.getPluginEntry();
                this.addPluginEntry(entry);
            } else {
                pluginFile = new File(file, "plugin.xml");
                if (!pluginFile.exists()) {
                    pluginFile = new File(file, "fragment.xml");
                }
                if (pluginFile.exists() && !pluginFile.isDirectory()) {
                    if (compareTimeStamps && dirTimestamp <= this.pluginsChangeStamp && pluginFile.lastModified() <= this.pluginsChangeStamp) {
                        return;
                    }
                    PluginEntry entry = pluginParser.parse(pluginFile);
                    this.addPluginEntry(entry);
                }
            }
        }
        catch (IOException e) {
            String pluginFileString = pluginFile.getAbsolutePath();
            if (ConfigurationActivator.DEBUG) {
                Utils.log(Utils.newStatus(Messages.getString("InstalledSiteParser.ErrorParsingFile", pluginFileString), e));
            } else {
                Utils.log(Messages.getString("InstalledSiteParser.ErrorAccessing", pluginFileString));
            }
        }
        catch (SAXException e) {
            String pluginFileString = pluginFile.getAbsolutePath();
            Utils.log(Messages.getString("InstalledSiteParser.ErrorParsingFile", pluginFileString));
        }
    }

    private synchronized String[] getDetectedFeatures() {
        if (this.featureEntries == null) {
            this.detectFeatures();
        }
        String[] features = new String[this.featureEntries.size()];
        Iterator iterator = this.featureEntries.values().iterator();
        for (int i = 0; i < features.length; ++i) {
            features[i] = ((FeatureEntry)iterator.next()).getURL();
        }
        return features;
    }

    private synchronized String[] getDetectedPlugins() {
        if (this.pluginEntries == null) {
            this.detectPlugins();
        }
        String[] plugins = new String[this.pluginEntries.size()];
        for (int i = 0; i < plugins.length; ++i) {
            plugins[i] = ((PluginEntry)this.pluginEntries.get(i)).getURL();
        }
        return plugins;
    }

    private void computeChangeStamp() {
        this.changeStamp = Math.max(this.computeFeaturesChangeStamp(), this.computePluginsChangeStamp());
    }

    private synchronized long computeFeaturesChangeStamp() {
        if (this.featuresChangeStamp > 0L) {
            return this.featuresChangeStamp;
        }
        long start = 0L;
        if (ConfigurationActivator.DEBUG) {
            start = new Date().getTime();
        }
        String[] features = this.getFeatures();
        long dirStamp = 0L;
        if (PlatformConfiguration.supportsDetection(this.resolvedURL)) {
            File root = new File(this.resolvedURL.getFile().replace('/', File.separatorChar));
            File featuresDir = new File(root, "features");
            dirStamp = featuresDir.lastModified();
        }
        this.featuresChangeStamp = Math.max(dirStamp, this.computeStamp(features));
        if (ConfigurationActivator.DEBUG) {
            long end = new Date().getTime();
            Utils.debug(this.resolvedURL.toString() + " feature stamp: " + this.featuresChangeStamp + " in " + (end - start) + "ms");
        }
        return this.featuresChangeStamp;
    }

    private synchronized long computePluginsChangeStamp() {
        if (this.pluginsChangeStamp > 0L) {
            return this.pluginsChangeStamp;
        }
        if (!PlatformConfiguration.supportsDetection(this.resolvedURL)) {
            Utils.log(Messages.getString("SiteEntry.computePluginStamp", this.resolvedURL.toExternalForm()));
            return 0L;
        }
        File root = new File(this.resolvedURL.getFile().replace('/', File.separatorChar));
        File pluginsDir = new File(root, "plugins");
        if (!pluginsDir.exists() || !pluginsDir.isDirectory()) {
            Utils.log(Messages.getString("SiteEntry.pluginsDir", pluginsDir.getAbsolutePath()));
            return 0L;
        }
        this.pluginsChangeStamp = pluginsDir.lastModified();
        return this.pluginsChangeStamp;
    }

    private long computeStamp(String[] targets) {
        long result = 0L;
        if (!PlatformConfiguration.supportsDetection(this.resolvedURL)) {
            for (int i = 0; i < targets.length; ++i) {
                result ^= (long)targets[i].hashCode();
            }
            Utils.debug("*WARNING* computing stamp using URL hashcodes only");
        } else {
            File rootFile = new File(this.resolvedURL.getFile().replace('/', File.separatorChar));
            if (rootFile.exists()) {
                File f = null;
                for (int i = 0; i < targets.length; ++i) {
                    f = new File(rootFile, targets[i]);
                    if (!f.exists()) continue;
                    result = Math.max(result, f.lastModified());
                }
            }
        }
        return result;
    }

    public void setLinkFileName(String linkFileName) {
        this.linkFileName = linkFileName;
    }

    public String getLinkFileName() {
        return this.linkFileName;
    }

    public boolean isExternallyLinkedSite() {
        return this.linkFileName != null && !this.linkFileName.trim().equals("");
    }

    public synchronized void refresh() {
        this.featuresChangeStamp = 0L;
        this.pluginsChangeStamp = 0L;
        this.changeStamp = 0L;
        this.featureEntries = null;
        this.pluginEntries = null;
    }

    public void refreshPlugins() {
        this.pluginsChangeStamp = 0L;
        this.changeStamp = 0L;
        this.pluginEntries = null;
    }

    public void addFeatureEntry(IPlatformConfiguration.IFeatureEntry feature) {
        FeatureEntry existing;
        if (this.featureEntries == null) {
            this.featureEntries = new HashMap();
        }
        if ((existing = (FeatureEntry)this.featureEntries.get(feature.getFeatureIdentifier())) != null) {
            VersionedIdentifier newVersion;
            VersionedIdentifier existingVersion = new VersionedIdentifier(existing.getFeatureIdentifier(), existing.getFeatureVersion());
            if (existingVersion.compareVersion(newVersion = new VersionedIdentifier(feature.getFeatureIdentifier(), feature.getFeatureVersion())) == -1) {
                this.featureEntries.put(feature.getFeatureIdentifier(), feature);
                this.pluginsChangeStamp = 0L;
            } else if (existingVersion.equals(newVersion) && feature instanceof FeatureEntry && existing instanceof FeatureEntry && !((FeatureEntry)feature).getURL().equals(existing.getURL())) {
                Utils.log(Messages.getString("SiteEntry.duplicateFeature", this.getURL().toExternalForm(), existing.getFeatureIdentifier()));
            }
        } else {
            this.featureEntries.put(feature.getFeatureIdentifier(), feature);
            this.pluginsChangeStamp = 0L;
        }
        if (feature instanceof FeatureEntry) {
            ((FeatureEntry)feature).setSite(this);
        }
    }

    public FeatureEntry[] getFeatureEntries() {
        if (this.featureEntries == null) {
            this.detectFeatures();
        }
        if (this.featureEntries == null) {
            return new FeatureEntry[0];
        }
        return this.featureEntries.values().toArray(new FeatureEntry[this.featureEntries.size()]);
    }

    public void addPluginEntry(PluginEntry plugin) {
        if (this.pluginEntries == null) {
            this.pluginEntries = new ArrayList();
        }
        this.pluginEntries.add(plugin);
    }

    public PluginEntry[] getAllPluginEntries() {
        if (this.pluginEntries == null) {
            this.detectPlugins();
        }
        return this.pluginEntries.toArray(new PluginEntry[this.pluginEntries.size()]);
    }

    public void loadFromDisk(long lastChange) throws CoreException {
        this.featuresChangeStamp = lastChange;
        this.pluginsChangeStamp = lastChange;
        this.detectFeatures();
        this.detectPlugins();
    }

    public Element toXML(Document doc) {
        int i;
        Element siteElement = doc.createElement("site");
        if (this.getURL().toString() != null) {
            siteElement.setAttribute("url", this.getURL().toString());
        }
        siteElement.setAttribute("enabled", this.isEnabled() ? "true" : "false");
        siteElement.setAttribute("updateable", this.isUpdateable() ? "true" : "false");
        if (this.isExternallyLinkedSite()) {
            siteElement.setAttribute("linkfile", this.getLinkFileName().trim().replace(File.separatorChar, '/'));
        }
        int type = this.getSitePolicy().getType();
        String typeString = "UNKNOWN";
        try {
            typeString = IConfigurationConstants.CFG_POLICY_TYPE[type];
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        siteElement.setAttribute("policy", typeString);
        String[] list = this.getSitePolicy().getList();
        if (list.length > 0) {
            StringBuffer sb = new StringBuffer(256);
            for (i = 0; i < list.length - 1; ++i) {
                sb.append(list[i]);
                sb.append(',');
            }
            sb.append(list[list.length - 1]);
            siteElement.setAttribute("list", sb.toString());
        }
        FeatureEntry[] feats = this.getFeatureEntries();
        for (i = 0; i < feats.length; ++i) {
            Element featureElement = feats[i].toXML(doc);
            siteElement.appendChild(featureElement);
        }
        return siteElement;
    }

    private void validateFeatureEntries() {
        File root = new File(this.resolvedURL.getFile().replace('/', File.separatorChar));
        Iterator iterator = this.featureEntries.values().iterator();
        ArrayList<String> deletedFeatures = new ArrayList<String>();
        while (iterator.hasNext()) {
            FeatureEntry feature = (FeatureEntry)iterator.next();
            File featureXML = new File(root, feature.getURL());
            if (featureXML.exists()) continue;
            deletedFeatures.add(feature.getFeatureIdentifier());
        }
        Iterator it = deletedFeatures.iterator();
        while (it.hasNext()) {
            this.featureEntries.remove(it.next());
        }
    }

    private void validatePluginEntries() {
        File root = new File(this.resolvedURL.getFile().replace('/', File.separatorChar));
        ArrayList<PluginEntry> deletedPlugins = new ArrayList<PluginEntry>();
        for (int i = 0; i < this.pluginEntries.size(); ++i) {
            PluginEntry plugin = (PluginEntry)this.pluginEntries.get(i);
            File pluginLocation = new File(root, plugin.getURL());
            if (pluginLocation.exists()) continue;
            deletedPlugins.add(plugin);
        }
        Iterator it = deletedPlugins.iterator();
        while (it.hasNext()) {
            this.pluginEntries.remove(it.next());
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enable) {
        this.enabled = enable;
    }

    public FeatureEntry getFeatureEntry(String id) {
        FeatureEntry[] features = this.getFeatureEntries();
        for (int i = 0; i < features.length; ++i) {
            if (!features[i].getFeatureIdentifier().equals(id)) continue;
            return features[i];
        }
        return null;
    }

    public boolean unconfigureFeatureEntry(IPlatformConfiguration.IFeatureEntry feature) {
        FeatureEntry existingFeature = this.getFeatureEntry(feature.getFeatureIdentifier());
        if (existingFeature != null) {
            this.featureEntries.remove(existingFeature.getFeatureIdentifier());
        }
        return existingFeature != null;
    }

    void initialized() {
        if (this.featureEntries == null) {
            this.featureEntries = new HashMap();
        }
    }
}

