/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.presentations;

import java.text.MessageFormat;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.presentations.DefaultPartPresentation;
import org.eclipse.ui.internal.presentations.PaneFolder;
import org.eclipse.ui.internal.presentations.SystemMenuCloseAll;
import org.eclipse.ui.internal.presentations.SystemMenuCloseOthers;
import org.eclipse.ui.internal.presentations.UpdatingActionContributionItem;
import org.eclipse.ui.internal.util.PrefUtil;
import org.eclipse.ui.presentations.IPresentablePart;
import org.eclipse.ui.presentations.IPresentationSerializer;
import org.eclipse.ui.presentations.IStackPresentationSite;
import org.eclipse.ui.themes.ITheme;

public class DefaultEditorPresentation
extends DefaultPartPresentation {
    private IPreferenceStore preferenceStore = WorkbenchPlugin.getDefault().getPreferenceStore();
    private IPreferenceStore apiPreferenceStore = PrefUtil.getAPIPreferenceStore();
    public static String DIRTY_PREFIX = "*";
    private final IPropertyChangeListener propertyChangeListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (DefaultEditorPresentation.this.isDisposed()) {
                return;
            }
            if ("EDITOR_TAB_POSITION".equals(propertyChangeEvent.getProperty()) && !DefaultEditorPresentation.this.isDisposed()) {
                int tabLocation = DefaultEditorPresentation.this.preferenceStore.getInt("EDITOR_TAB_POSITION");
                DefaultEditorPresentation.this.getTabFolder().setTabPosition(tabLocation);
                DefaultEditorPresentation.this.layout(false);
            } else if ("SHOW_TRADITIONAL_STYLE_TABS".equals(propertyChangeEvent.getProperty()) && !DefaultEditorPresentation.this.isDisposed()) {
                boolean traditionalTab = DefaultEditorPresentation.this.apiPreferenceStore.getBoolean("SHOW_TRADITIONAL_STYLE_TABS");
                DefaultEditorPresentation.this.setTabStyle(traditionalTab);
            }
            boolean multiChanged = "SHOW_MULTIPLE_EDITOR_TABS".equals(propertyChangeEvent.getProperty());
            boolean styleChanged = "SHOW_TRADITIONAL_STYLE_TABS".equals(propertyChangeEvent.getProperty());
            PaneFolder tabFolder = DefaultEditorPresentation.this.getTabFolder();
            if ((multiChanged || styleChanged) && tabFolder != null) {
                if (multiChanged) {
                    boolean multi = DefaultEditorPresentation.this.preferenceStore.getBoolean("SHOW_MULTIPLE_EDITOR_TABS");
                    tabFolder.setSingleTab(!multi);
                } else {
                    boolean simple = DefaultEditorPresentation.this.apiPreferenceStore.getBoolean("SHOW_TRADITIONAL_STYLE_TABS");
                    tabFolder.setSimpleTab(simple);
                }
                CTabItem[] tabItems = tabFolder.getItems();
                for (int i = 0; i < tabItems.length; ++i) {
                    CTabItem tabItem = tabItems[i];
                    DefaultEditorPresentation.this.initTab(tabItem, DefaultEditorPresentation.this.getPartForTab(tabItem));
                }
            }
        }
    };

    public void restoreState(IPresentationSerializer serializer, IMemento savedState) {
        IMemento[] parts = savedState.getChildren("part");
        IPresentablePart currentPart = this.getCurrentPart();
        int insert = 0;
        for (int idx = 0; idx < parts.length; ++idx) {
            IPresentablePart part;
            String id = parts[idx].getString("id");
            IPresentablePart iPresentablePart = part = id == null ? null : serializer.getPart(id);
            if (part == null) continue;
            int partIndex = this.indexOf(part);
            if (partIndex == insert) {
                ++insert;
                continue;
            }
            this.removePart(part);
            this.addPart(part, partIndex < insert ? insert - 1 : insert++);
            if (part != currentPart) continue;
            this.selectPart(part);
        }
    }

    public DefaultEditorPresentation(Composite parent, IStackPresentationSite newSite) {
        super(new PaneFolder(parent, 2048), newSite);
        PaneFolder tabFolder = this.getTabFolder();
        this.preferenceStore.addPropertyChangeListener(this.propertyChangeListener);
        this.apiPreferenceStore.addPropertyChangeListener(this.propertyChangeListener);
        int tabLocation = this.preferenceStore.getInt("EDITOR_TAB_POSITION");
        tabFolder.setTabPosition(tabLocation);
        tabFolder.setSingleTab(!this.preferenceStore.getBoolean("SHOW_MULTIPLE_EDITOR_TABS"));
        this.setTabStyle(this.apiPreferenceStore.getBoolean("SHOW_TRADITIONAL_STYLE_TABS"));
        tabFolder.setUnselectedCloseVisible(true);
        tabFolder.setUnselectedImageVisible(true);
        this.getSystemMenuManager().add((IContributionItem)new UpdatingActionContributionItem(new SystemMenuCloseOthers(this)));
        this.getSystemMenuManager().add((IContributionItem)new UpdatingActionContributionItem(new SystemMenuCloseAll(this)));
        this.init();
    }

    protected void widgetDisposed() {
        this.preferenceStore.removePropertyChangeListener(this.propertyChangeListener);
        this.apiPreferenceStore.removePropertyChangeListener(this.propertyChangeListener);
        super.widgetDisposed();
    }

    protected void initTab(CTabItem tabItem, IPresentablePart part) {
        tabItem.setText(this.getLabelText(part, (this.getTabFolder().getControl().getStyle() & 2) == 0));
        tabItem.setImage(this.getLabelImage(part));
        String toolTipText = part.getTitleToolTip();
        if (!toolTipText.equals("")) {
            tabItem.setToolTipText(toolTipText);
        }
    }

    public void setActive(int newState) {
        super.setActive(newState);
        this.updateGradient();
    }

    protected void setTabStyle(boolean traditionalTab) {
        this.getTabFolder().setSimpleTab(traditionalTab);
    }

    protected String getCurrentTitle() {
        return "";
    }

    protected void updateGradient() {
        if (this.isDisposed()) {
            return;
        }
        ITheme theme = PlatformUI.getWorkbench().getThemeManager().getCurrentTheme();
        ColorRegistry colorRegistry = theme.getColorRegistry();
        if (this.getActive() == 1) {
            this.setActiveTabColors();
        } else if (this.getActive() == 2) {
            this.drawGradient(colorRegistry.get("org.eclipse.ui.workbench.INACTIVE_TAB_TEXT_COLOR"), new Color[]{colorRegistry.get("org.eclipse.ui.workbench.INACTIVE_TAB_BG_START")}, new int[0], true);
        } else {
            this.setInactiveTabColors();
        }
        boolean resizeNeeded = false;
        Font tabFont = theme.getFontRegistry().get("org.eclipse.ui.workbench.TAB_TEXT_FONT");
        Font oldTabFont = this.getTabFolder().getControl().getFont();
        if (!oldTabFont.equals((Object)tabFont)) {
            this.getTabFolder().getControl().setFont(tabFont);
            resizeNeeded = true;
        }
        super.updateGradient();
        if (resizeNeeded) {
            this.getTabFolder().setTabHeight(this.computeTabHeight());
            this.setControlSize();
        }
    }

    protected String getPaneName() {
        return WorkbenchMessages.getString("EditorPane.moveEditor");
    }

    String getLabelText(IPresentablePart presentablePart, boolean includePath) {
        String title;
        String text = title = super.getLabelText(presentablePart, includePath);
        if (includePath) {
            String contentDescription = presentablePart.getTitleStatus();
            if (contentDescription.equals("")) {
                String titleTooltip = presentablePart.getTitleToolTip().trim();
                if (titleTooltip.endsWith(title)) {
                    titleTooltip = titleTooltip.substring(0, titleTooltip.lastIndexOf(title)).trim();
                }
                if (titleTooltip.endsWith("\\")) {
                    titleTooltip = titleTooltip.substring(0, titleTooltip.lastIndexOf("\\")).trim();
                }
                if (titleTooltip.endsWith("/")) {
                    titleTooltip = titleTooltip.substring(0, titleTooltip.lastIndexOf("/")).trim();
                }
                contentDescription = titleTooltip;
            }
            if (!contentDescription.equals("")) {
                text = MessageFormat.format(WorkbenchMessages.getString("EditorPart.AutoTitleFormat"), text, contentDescription);
            }
        }
        if (presentablePart.isDirty()) {
            text = DIRTY_PREFIX + text;
        }
        return text;
    }
}

